package com.ptteng.controller;

import atg.taglib.json.util.JSONArray;
import atg.taglib.json.util.JSONObject;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.ClassTimetableService;
import com.ptteng.common.skill.service.DeepThinkService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.TaskService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * DeepThink  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DeepThinkController {
    private static final Log log = LogFactory.getLog(DeepThinkController.class);

    @Autowired
    private DeepThinkService deepThinkService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ClassTimetableService classTimetableService;


    /**
     * 把原来任务表里的深度思考的内容，复制到深度思考表里。只在上线时执行1次即可
     *
     * @Author ruanshaonan
     * @Description
     * @Date 18:09 2018/7/9
     */
    @RequestMapping(value = "/a/u/deepThink/list", method = RequestMethod.POST)
    public String copyExtendToDeepThink(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model) throws Exception {

        log.info("copyExtendToDeepThink==");

        //获取所有的职业
        //获取每个职业的所有任务
        //获取每个任务的所有深度思考
        //3层for循环插入数据
        List<Long> oids = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
        for (Long oid : oids) {
            List<Long> tids = taskService.getTaskIdsByOid(oid, 0, Integer.MAX_VALUE);
            for (Long tid : tids) {
                Task task = taskService.getObjectById(tid);
                String extend = task.getExtend();
                //用jackson把extend字段里的深度思考取出来
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree(extend);
                JsonNode thinkNode = rootNode.path("think");
                String think = mapper.writeValueAsString(thinkNode);
                //拿到深度思考字符串数组后，转成JSONArray，然后遍历它，获取到每个深度思考的题目
                List<DeepThink> deepThinks = new ArrayList<>();
                JSONArray myJsonArray = new JSONArray(think);
                for (int i = 0; i < myJsonArray.length(); i++) {
                    JSONObject deepThinkjObject = myJsonArray.getJSONObject(i);
                    String deepThinkName = deepThinkjObject.getString("question");
                    DeepThink deepThink = new DeepThink();
                    deepThink.setName(deepThinkName);
                    deepThink.setOid(oid);
                    deepThink.setTid(tid);
                    deepThinks.add(deepThink);
                }
                //循环完1条任务的深度思考后，插入一批数据
                List<DeepThink> result = deepThinkService.insertList(deepThinks);
                log.info("result==" + result.size());
            }
        }
        return "/common/success";
    }

    /**
     * 获取深度思考列表
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 17:24 2018/6/25
     * @Param oid：职业id
     * @Param tid：任务id
     * @Param deepThinkName：深度思考名称
     * @Param page：页码
     * @Param size：每页数据条数
     */
    @RequestMapping(value = "/a/u/think/list", method = RequestMethod.GET)
    public String getdeepThinkList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long oid,
                                   Long tid, String thinkName, Integer page, Integer size) throws Exception {

        log.info("getClassSubject =oid= " + oid + "=tid=" + tid + "=thinkName=" + thinkName
                + "=page=" + page + "=size=" + size);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;
        Object total = 0;

        Map<String, Object> deepThinkParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, false);
        log.info("deepThinkParam=" + deepThinkParam);
        List<Long> ids = deepThinkService.getIdsByDynamicCondition(DeepThink.class, deepThinkParam, start, size);
        log.info("ids=" + ids);
        if (CollectionUtils.isEmpty(ids)) {
            model.addAttribute("code", -80003);
            return "/common/success";
        }
        List<DeepThink> thinkList = deepThinkService.getObjectsByIds(ids);
        if (CollectionUtils.isNotEmpty(thinkList)) {
            List<Long> oids = new ArrayList<>();
            List<Long> tids = new ArrayList<>();
            for (DeepThink deepThink : thinkList) {
                oids.add(deepThink.getOid());
                tids.add(deepThink.getTid());
            }
            List<Occupation> occupationList = occupationService.getObjectsByIds(oids);
            model.addAttribute("occupationList", occupationList);
            log.info("occupationList"+occupationList.size());

            List<Task> taskList = taskService.getObjectsByIds(tids);
            model.addAttribute("taskList", taskList);
            log.info("taskList"+taskList.size());
        }

        Map<String, Object> totalParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, true);
        total = deepThinkService.getObjectByDynamicCondition(DeepThink.class, totalParam, 0, Integer.MAX_VALUE);
        log.info("total==" + total);
        model.addAttribute("code", 0);
        model.addAttribute("page", page);
        model.addAttribute("size", size);
        model.addAttribute("total", total);
        model.addAttribute("thinkList", thinkList);
        return "/common-skill-service/deepThink/json/deepThinkListJson";
    }

    /**
     * 获取深度思考详情
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 17:04 2018/6/25
     * @Param id：深度思考id
     */
    @RequestMapping(value = "/a/u/think/{id}", method = RequestMethod.GET)
    public String getDeepThink(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("getDeepThink : id= ==" + id);
        try {
            DeepThink deepThink = deepThinkService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(deepThink)) {
                model.addAttribute("code", -80001);
                return "/common/success";
            }

            log.info("get deepThink success " + deepThink.getName());
            Occupation occupation = occupationService.getObjectById(deepThink.getOid());
            Task task = taskService.getObjectById(deepThink.getTid());
            log.info("get occupation success==" + occupation.getName());
            log.info("get task success==" + task.getTitle());

            model.addAttribute("code", 0);
            model.addAttribute("occupation", occupation);
            model.addAttribute("task", task);
            model.addAttribute("deepThink", deepThink);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get deepThink error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common-skill-service/deepThink/json/deepThinkDetailJson";
    }

    /**
     * 新增深度思考
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 16:15 2018/6/25
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param subjectName:深度思考名称
     * @Param createId:创建人id
     */
    @RequestMapping(value = "/a/u/think", method = RequestMethod.POST)
    public String addClassSubjectJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long oid, Long tid,
                                      String thinkName) throws Exception {

        log.info("addClassSubjectJson= oid==" + oid + "=tid=" + tid + "=thinkName=" + thinkName);

        try {
            //判空
            if (DataUtils.isNullOrEmpty(oid)
                    || DataUtils.isNullOrEmpty(tid)
                    || DataUtils.isNullOrEmpty(thinkName)) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }
            //先判断深度思考是否已存在，如果已存在，就不能重复添加
            Map<String, Object> deepThinkParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, true);
            log.info("deepThinkParam=" + deepThinkParam);
            Object ids = deepThinkService.getObjectByDynamicCondition(DeepThink.class, deepThinkParam, 0, Integer.MAX_VALUE);
            log.info("ids=" + ids);
            if (DataUtils.isNotNullOrEmpty(ids) && Integer.parseInt(ids.toString()) > 0) {
                model.addAttribute("code", -80002);
                return "/common/success";
            }
            //插入数据
            DeepThink deepThink = new DeepThink();
            deepThink.setOid(oid);
            deepThink.setTid(tid);
            deepThink.setName(thinkName);
            deepThink.setCreateBy(Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID)));
            Long id = deepThinkService.insert(deepThink);
            model.addAttribute("data", id);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add deepThink error ");
            model.addAttribute("code", -100000);
        }
        return "/data/json";
    }

    /**
     * 删除深度思考
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 16:51 2018/6/25
     * @Param id：深度思考id
     */
    @RequestMapping(value = "/a/u/think/{id}", method = RequestMethod.DELETE)
    public String deleteDeepThink(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete deep think : id= " + id);

        try {
            //删除深度思考前，如果有对应的小课堂，则不能删除
            DeepThink deepThink = deepThinkService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(deepThink)) {
                model.addAttribute("code", -80001);
                return "/common/success";
            }
            Map<String, Object> timeTableSql = DynamicUtil.getClassTimetableParam(null, null, null,
                    null, null, null, null, deepThink.getName(), false);
            log.info("timeTableSql=" + timeTableSql);
            List<Long> classTimetableIds = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, timeTableSql, 0, Integer.MAX_VALUE);
            log.info("classTimetableIds==" + classTimetableIds.size());
            if (CollectionUtils.isNotEmpty(classTimetableIds)) {
                log.info("deep think has small classes==");
                model.addAttribute("code", -80004);
                return "/common/success";
            }
            //删除深度思考
            deepThinkService.delete(id);
            log.info("delete deep think success");
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete deep think error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    /**
     * 修改深度思考
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 16:51 2018/6/25
     * @Param id：深度思考id
     */
    @RequestMapping(value = "/a/u/think/{id}", method = RequestMethod.PUT)
    public String updateDeepThink(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                  @PathVariable Long id, String thinkName,Long oid, Long tid)
            throws Exception {

        log.info("delete deep think : id= " + id +"oid"+oid+"tid"+tid);

        try {
            DeepThink deepThink = deepThinkService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(deepThink)) {
                model.addAttribute("code", -80001);
                return "/common/success";
            }
            log.info("get deep think success==" + deepThink.getId());
            if (DataUtils.isNullOrEmpty(thinkName)) {
                model.addAttribute("code", -80005);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(oid)) {
                model.addAttribute("code", -80005);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(tid)) {
                model.addAttribute("code", -80005);
                return "/common/success";
            }
            //先判断深度思考是否已存在，如果已存在，就不能重复添加
            Map<String, Object> deepThinkParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, true);
            log.info("deepThinkParam=" + deepThinkParam);
            Object ids = deepThinkService.getObjectByDynamicCondition(DeepThink.class, deepThinkParam, 0, Integer.MAX_VALUE);
            log.info("ids=" + ids);
            if (DataUtils.isNotNullOrEmpty(ids) && Integer.parseInt(ids.toString()) > 0) {
                model.addAttribute("code", -80002);
                return "/common/success";
            }


            deepThink.setName(thinkName);
            deepThink.setOid(oid);
            deepThink.setTid(tid);
            deepThink.setUpdateBy(Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID)));
            deepThinkService.update(deepThink);
            model.addAttribute("code", 0);
            log.info("update deep think success==");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update deep think error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

}

