package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

import static com.ptteng.common.skill.model.ClassTimetable.NOT_PUBLISHED;

/**
 * 课堂（课表）管理
 *
 * @Author ruanshaonan
 * @Description
 * @Date 17:46 2018/6/27
 */
@Controller
public class ClassTimetableController {
    private static final Log log = LogFactory.getLog(ClassTimetableController.class);

    @Autowired
    private ClassTimetableService classTimetableService;

    @Autowired
    private UserScoreService userScoreService;

    @Autowired
    private DeepThinkService deepThinkService;

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private MessageService messageService;
    private Long currentTimeMillis;

    /**
     * 获取小课堂（课表）列表
     *
     * @Author ruanshaonan
     * @Description
     * @Date 19:48 2018/6/27
     * @Param oid：职业id
     * @Param tid：任务id
     * @Param level：评级
     * @Param classTeamName：小组名
     * @Param startTime：开始时间
     * @Param endTime：结束时间
     * @Param speakerName：主讲人姓名
     * @Param classSubjectName：课题名称
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/a/u/class/arrange/list", method = RequestMethod.GET)
    public String getClassTimetableList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                        Long oid, Long tid, Integer level, Long classTeamId, Long startTime,
                                        Long endTime, String speakerName, String thinkName, Integer page,
                                        Integer size,String classTeamName) throws Exception {


        log.info("getClassTimetableList=oid=" + oid + "=tid=" + tid + "=level=" + level + "=classTeamId="
                + classTeamId + "=startTime=" + startTime + "=endTime=" + endTime + "=speakerName="
                + speakerName + "=thinkName=" + thinkName + "=page=" + page + "=size=" + size+"=classTeamName="+classTeamName);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        List<Long> classArrangeIds = new ArrayList<>();
        List<ClassTimetable> classArrangeList = new ArrayList<>();
        Object total;

        try {
            Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParamAddGroupName(oid, tid, level, classTeamId,
                    startTime, endTime, speakerName, thinkName, classTeamName,false);
            log.info("classTimetableListParam=" + classTimetableListParam);
            classArrangeIds = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, classTimetableListParam, start, size);
            log.info("classArrangeIds==" + classArrangeIds.size());

            Map<String, Object> totalSql = DynamicUtil.getClassTimetableParamAddGroupName(oid, tid, level, classTeamId,
                    startTime, endTime, speakerName, thinkName, classTeamName,true);
            log.info("totalSql=" + totalSql);
            total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalSql, 0, Integer.MAX_VALUE);
            log.info("total==" + total);

            if (CollectionUtils.isEmpty(classArrangeIds)) {
                model.addAttribute("code", -70015);
                return "/common/success";
            }
            classArrangeList = classTimetableService.getObjectsByIds(classArrangeIds);
            log.info("getClassTimetableList success=" + classArrangeList.size());

            //主讲人信息
            List<Long> speakerIds = new ArrayList<>();
            List<User> speakerList = new ArrayList<>();
            //课题信息
            List<Long> thinkIds = new ArrayList<>();
            List<DeepThink> deepThinkList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(classArrangeList)) {
                for (ClassTimetable classTimetable : classArrangeList) {
                    speakerIds.add(classTimetable.getTeachUid());
                    thinkIds.add(classTimetable.getThinkId());
                    //小组总人数
                    Map<String, Object> groupUserIdsSql = DynamicUtil.getMemberByGroupId(classTimetable.getClassTeamId());
                    log.info("groupUserIdsSql=" + groupUserIdsSql);
                    List<Long> groupUserIds = userService.getIdsByDynamicCondition(User.class, groupUserIdsSql, 0, Integer.MAX_VALUE);
                    classTimetable.setGroupUserCount(groupUserIds.size());
                }
            }

            log.info("speakerIds=" + speakerIds.size());
            log.info("thinkIds=" + thinkIds.size());
            if (CollectionUtils.isNotEmpty(speakerIds)) {
                speakerList = userService.getObjectsByIds(speakerIds);
            }
            if (CollectionUtils.isNotEmpty(thinkIds)) {
                deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
            }
            log.info("speakerList=" + speakerList.size());
            log.info("deepThinkList=" + deepThinkList.size());

            //进后台的听课记录列表时，要先访问数据统计接口，那里返回了total，所以这里不用再重复调用service返回了
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("classArrangeList", classArrangeList);
            model.addAttribute("speakerList", speakerList);
            model.addAttribute("deepThinkList", deepThinkList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.info("getClassTimetableList error=" + t.getMessage());
            model.addAttribute("code", -100000);
            return "/common/success";
        }

        return "/common-skill-service/classTimetable/json/classTimetableList";
    }


    /**
     * 修改小课堂
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 19:10 2018/6/27
     * @Param id：课堂id
     * @Param arrangeTime：讲课时间
     * @Param speakerId：主讲人id
     * @Param thinkId：深度思考id
     * @Param status：上下架状态（是否精选）
     * @Param publishState：发布状态（1：不发布  2：发布）
     * @Param leaveIds：请假人id
     * @Param absentIds：旷课人id
     * @Param listenIds：听课人id
     */
    @RequestMapping(value = "/a/u/class/arrange/{id}", method = RequestMethod.PUT)
    public String updateClassTimetable(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       @PathVariable Long id, Long arrangeTime, Long speakerId, Long thinkId,
                                       Integer status, Integer publishState, String leaveIds, String absentIds,
                                       String listenIds) throws Exception {

        log.info("updateClassTimetable: id= " + id + "=arrangeTime=" + arrangeTime + "=speakerId="
                + speakerId + "=thinkId=" + thinkId + "=status=" + status + "=publishState=" + publishState
                + "=leaveIds=" + leaveIds + "=absentIds=" + absentIds + "=listenIds=" + listenIds);

        try {
            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            log.info("get class timetable success=publish state=" + classTimetable.getPublishState());
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -70015);
                return "/common/success";
            }
            if (DataUtils.isNotNullOrEmpty(arrangeTime)) {
                classTimetable.setArrangeDate(arrangeTime);
            }
            if (DataUtils.isNotNullOrEmpty(speakerId)) {
                classTimetable.setTeachUid(speakerId);
            }
            if (DataUtils.isNotNullOrEmpty(thinkId)) {
                classTimetable.setThinkId(thinkId);
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                if (status == ClassTimetable.ON_SHELF){
                    //判断是否上架数量超过规定数量
                    Map<String, Object> totalSql = DynamicUtil.getClassTimetableParamstatus();
                    log.info("totalSql=" + totalSql);
                    Object total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalSql, 0, Integer.MAX_VALUE);
                    log.info("total==" + total);
                    if(Integer.valueOf(total.toString())>=ClassTimetable.MAX_STATUS){
                        model.addAttribute("code", -70024);
                        return "/common/success";
                    }
                }
                classTimetable.setStatus(status);
            }
            if (DataUtils.isNotNullOrEmpty(publishState)) {
                if (classTimetable.getPublishState() == NOT_PUBLISHED) {
                    log.info("not published=");
                    classTimetable.setPublishState(publishState);
                    if (DataUtils.isNotNullOrEmpty(leaveIds)) {
                        log.info("leaveIds==" + leaveIds);
                        classTimetable.setLeaveUid(leaveIds);
                        //发送消息给请假人
                        String leaveIdsub = leaveIds;
                        log.info(leaveIdsub);
                        String leaveIdsArray[] = leaveIdsub.split(",");
                        log.info(leaveIdsArray[0]);
                        List<String> leaveIdList = Arrays.asList(leaveIdsArray);

                        for (int i = 0; i < leaveIdList.size(); i++) {
                            User user = userService.getObjectById(Long.valueOf(leaveIdList.get(i)));
                            sendMessageToabscent(user, id, arrangeTime, Message.TEMPLATE_5, false);
                        }
                    }
                    log.info("is null?==" + DataUtils.isNotNullOrEmpty(absentIds));
                    if (DataUtils.isNotNullOrEmpty(absentIds)) {
                        log.info("absentIds==" + absentIds);
                        classTimetable.setAbsentUid(absentIds);
                        //要给对应的人发消息，扣学分
                        //发送消息给旷课人并扣除学分
                        //遍历absentIds，给每一个人发送消息并扣除相应学分
                        String absentIdsub = absentIds.substring(0, absentIds.length() - 1);
                        log.info(absentIdsub);
                        String absentIdsArray[] = absentIdsub.split(",");
                        List<String> absentIdList = Arrays.asList(absentIdsArray);
                        log.info(absentIdList);
                        for (int i = 0; i < absentIdList.size(); i++) {
                            User user = userService.getObjectById(Long.valueOf(absentIdList.get(i)));
                            sendMessageToabscent(user, id, arrangeTime, Message.TEMPLATE_NONE, true);
                        }
                    }
                } else {
                    model.addAttribute("code", -70016);
                    return "/common/success";
                }
            }
            classTimetable.setUpdateBy(Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID)));
            classTimetableService.update(classTimetable);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update classTimetable error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }


    /**
     * 新增小课堂（课表）
     *
     * @Author ruanshaonan
     * @Description
     * @Date 17:59 2018/6/27
     * @Param arrangeTime：讲课时间
     * @Param speakerId：主讲人id
     * @Param subjectId：演讲课题id
     * @Param teamId:小组id
     */
    @RequestMapping(value = "/a/u/class/arrange", method = RequestMethod.POST)
    public String addClassTimetable(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                    Long arrangeTime, Long speakerId, Long thinkId, Long teamId) throws Exception {

        log.info("addClassTimetable= arrangeTime+" + arrangeTime + "=speakerId=" + speakerId
                + "=thinkId=" + thinkId + "=teamId=" + teamId);

        try {
            if (DataUtils.isNullOrEmpty(arrangeTime)
                    || DataUtils.isNullOrEmpty(speakerId)
                    || DataUtils.isNullOrEmpty(thinkId)
                    || DataUtils.isNullOrEmpty(teamId)) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }

            //排课日期0点的时间戳
            long arrangeTimeZero = arrangeTime / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            //排课日期24点的时间戳
            long arrangeTime24 = arrangeTimeZero + 24 * 60 * 60 * 1000 - 1;
            //排课日期0点的时间戳-7天
            long arrangeTimeZeroReduce7Day = arrangeTimeZero - 24 * 60 * 60 * 1000 * 7 + 1;
            //排课日期0点的时间戳+7天
            long arrangeTimeZeroAdd7Day = arrangeTimeZero + 24 * 60 * 60 * 1000 * 7 - 1;

            //添加课表时，不能在距当天7天以内
            //获取当日零点时间戳  + 7天时间戳  <  arrangeTime 才能排课
            long current = System.currentTimeMillis();
            long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            long add7Day = zero + 7 * (1000 * 3600 * 24);
            if (add7Day > arrangeTime) {
                model.addAttribute("code", -70012);
                return "/common/success";
            }

            //排课那天不能已排课
            Map<String, Object> sqlMap = DynamicUtil.getTimeTables(teamId, null, arrangeTimeZero, arrangeTime24);
            log.info("sqlMap==" + sqlMap);
            List<Long> timetableIds = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, sqlMap, 0, Integer.MAX_VALUE);
            log.info("timetableIds==" + timetableIds.size());
            if (CollectionUtils.isNotEmpty(timetableIds)) {
                model.addAttribute("code", -70013);
                return "/common/success";
            }

            //同一个人不能在7天内重复排课
            Map<String, Object> sqlMap1 = DynamicUtil.getTimeTables(teamId, speakerId, arrangeTimeZeroReduce7Day, arrangeTimeZero);
            log.info("sqlMap1==" + sqlMap1);
            List<Long> timetableIds1 = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, sqlMap1, 0, Integer.MAX_VALUE);
            log.info("timetableIds1==" + timetableIds1.size());
            Map<String, Object> sqlMap2 = DynamicUtil.getTimeTables(teamId, speakerId, arrangeTimeZero, arrangeTimeZeroAdd7Day);
            log.info("sqlMap2==" + sqlMap2);
            List<Long> timetableIds2 = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, sqlMap2, 0, Integer.MAX_VALUE);
            log.info("timetableIds2==" + timetableIds2.size());
            if (CollectionUtils.isNotEmpty(timetableIds1)
                    || CollectionUtils.isNotEmpty(timetableIds2)) {
                model.addAttribute("code", -70014);
                return "/common/success";
            }

            ClassTimetable classTimetable = new ClassTimetable();
            classTimetable.setArrangeDate(arrangeTime);
            classTimetable.setTeachUid(speakerId);
            classTimetable.setThinkId(thinkId);
            classTimetable.setClassTeamId(teamId);
            //添加时，小课堂的状态是预告
            classTimetable.setSpeakStatus(ClassTimetable.APPOINT_NOT_PUBLISH);
            //添加时，小课堂的发布状态是未发布
            classTimetable.setPublishState(ClassTimetable.NOT_PUBLISHED);
            //添加时，小课堂的发布状态是未上架精选
            classTimetable.setStatus(ClassTimetable.OFF_SHELF);
            classTimetable.setCreateBy(Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID)));
            //添加时，小课堂的回复数是0
            classTimetable.setReply(Long.valueOf(0));
            //小组总人数
            Map<String, Object> groupUserIdsSql = DynamicUtil.getMemberByGroupId(teamId);
            log.info("groupUserIdsSql=" + groupUserIdsSql);
            List<Long> groupUserIds = userService.getIdsByDynamicCondition(User.class, groupUserIdsSql, 0, Integer.MAX_VALUE);
            classTimetable.setGroupUserCount(groupUserIds.size());

            Long id = classTimetableService.insert(classTimetable);
            log.info("add class timetable success id is=" + id);
            model.addAttribute("code", 0);
            model.addAttribute("id", id);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add classTimetable error ");
            model.addAttribute("code", -100000);
        }
        return "/data/json";
    }

    /**
     * 删除课表
     *
     * @Author ruanshaonan
     * @Description
     * @Date 18:58 2018/6/27
     * @Param id:课表id
     */
    @RequestMapping(value = "/a/u/class/arrange/{id}", method = RequestMethod.DELETE)
    public String deleteClassTimetable(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("deleteClassTimetable : id= " + id);
        try {
            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            log.info("get class timetable success==" + classTimetable.getId());
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -70015);
                return "/common/success";
            }
            //这里要做假删除，课表删除后，相关的小课堂信息不能删除
            classTimetable.setStatus(ClassTimetable.TIMETABLE_DELETED);
            classTimetable.setUpdateBy(Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID)));
            classTimetableService.update(classTimetable);
            log.info("delete ClassTimetable success");
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete classTimetable error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    /**
     * 获取请假人、旷课人信息
     *
     * @Description
     * @Param id:课表id
     */
    @RequestMapping(value = "/a/u/class/detail/{id}", method = RequestMethod.GET)
    public String getClassDetail(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("getClassTimetableDetail : id= " + id);
        try {
            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            log.info("get class timetable success==" + classTimetable.getId());
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -70015);
                return "/common/success";
            }
            if (classTimetable.getPublishState() == ClassTimetable.NOT_PUBLISHED) {
                model.addAttribute("code", -70019);
                return "/common/success";
            }
            String leaveIds = classTimetable.getLeaveUid();
            String abscentIds = classTimetable.getAbsentUid();
            log.info("get ClassDetail success leaveIds=" + leaveIds + "==abscentIds==" + abscentIds);
            if (DataUtils.isNotNullOrEmpty(leaveIds)) {
                List<String> leaveIdsStrList = StringUtil.convertSplitString2List(leaveIds, ",");
                log.info("leaveIdsStrList==" + leaveIdsStrList);
                if (CollectionUtils.isNotEmpty(leaveIdsStrList)) {
                    List<Long> leaveIdsList = new ArrayList<>();
                    for (String leaveId : leaveIdsStrList) {
                        leaveIdsList.add(Long.parseLong(leaveId));
                    }
                    List<User> leaves = userService.getObjectsByIds(leaveIdsList);
                    log.info("get leaves success==" + leaves.size());
                    model.addAttribute("leaves", leaves);
                }
            }
            if (DataUtils.isNotNullOrEmpty(abscentIds)) {
                List<String> abscentIdsStrList = StringUtil.convertSplitString2List(abscentIds, ",");
                log.info("==abscentIdsStrList==" + abscentIdsStrList);
                if (CollectionUtils.isNotEmpty(abscentIdsStrList)) {
                    List<Long> abscentIdsList = new ArrayList<>();
                    for (String abscentId : abscentIdsStrList) {
                        abscentIdsList.add(Long.parseLong(abscentId));
                    }
                    List<User> abscents = userService.getObjectsByIds(abscentIdsList);
                    log.info("get abscents success==" + abscents.size());
                    model.addAttribute("abscents", abscents);
                }
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ClassDetail error,id is  " + id);
            model.addAttribute("code", -100000);
        }
        return "/common-skill-service/classTimetable/json/classTimetableDetail";
    }

    /**
     * 发送消息给旷课者
     *
     * @param user     旷课人
     * @param id       课堂id
     * @param template
     * @param point    是否扣分
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    public void sendMessageToabscent(User user, Long id, Long arrangeTime, Integer template, boolean point) throws ServiceException, ServiceDaoException, IOException {

        log.info(" sendMessageToabscent start ");
        log.info("params=== user=" + user + " id=" + id + " arrangeTime=" + arrangeTime + " template=" + template + " point=" + point);

        //创建消息
        String content = "您未参加" + "XXX" + "的小课堂，点击XXX可重新进入学习!";
//实际上content应该是json  返回给前端的template为"您未参加" + arrangeTime + "的小课堂，点击查看可重新进入学习!"
        Message message = new Message();

        message.setReceiveId(user.getId());
        message.setReceiveName(user.getNick());
        message.setStatus(Message.STATUS_UNDELETE);
        message.setUnread(Message.Status_Unread);
        message.setType(Message.CLASS_TYPE);
        message.setTemplate(template);
        message.setCreateAt(currentTimeMillis);
        message.setUpdateAt(currentTimeMillis);
        message.setSendId(0L);
        message.setRelationId(id);

        List<Map> list = new ArrayList<>();
        Map<String, Object> map = new HashMap<>();
        map.put("content", content);
        Map<String, Object> map1 = new HashMap<>();
        map1.put("childContent", arrangeTime);
        map1.put("skip", false);
        Map<String, Object> map2 = new HashMap<>();
        map2.put("childContent", "查看");
        map2.put("skip", true);
        map2.put("lessonId", id);


        list.add(map);
        list.add(map1);
        list.add(map2);
        //把list转成json格式的String字符串
        ObjectMapper json = new ObjectMapper();
        String contentStr = json.writeValueAsString(list);
        message.setContent(contentStr);
        log.info(list);
        messageService.insert(message);
        log.info("insert success==" + message);

        //发送
//        adminSend(user.getMobile(), content);

        //更新个人消息未读数
        Integer unLook = user.getIsLook() + 1;
        user.setIsLook(unLook);
        user.setLatestMsg(Message.CLASSES_TYPE);
        userService.update(user);
        //如果point为true，则说明是旷课，需要扣除相应学分并发送另一条消息
        if (point) {
            log.info("user is ：" + user);
            int oldScore = user.getScore();
            long newScore;
            newScore = (long) oldScore - UserScore.CLASSES_ABSENT;
            log.info("oldScore is " + oldScore + "newScore :" + newScore);
            UserScore userScore = new UserScore();
            userScore.setScore((long) -UserScore.CLASSES_ABSENT);


            userScore.setScoreType(0);//scoreType == 0
            user.setScore((int) newScore);
            log.info("user.score is :" + user.getScore());


            userScore.setUid(user.getId());
            log.info("userScore" + userScore);
            userScoreService.insert(userScore);
//            userService.update(user);
            log.info("update score success==");
            //更新用户信息

            log.info("user" + user);
            user.setIsLook(user.getIsLook() + 1);
            user.setLatestMsg(Message.SCORE_TYPE);
            userService.update(user);

            // 发送信息
            Message message1 = new Message();
            message1.setStatus(1);
            message1.setReceiveName(user.getNick());
            message1.setSendName("admin");
            message1.setSendId(0L);
            message1.setContent("");
            message1.setReceiveId(id);
            message1.setUnread(1);
            message1.setType("score");


            Long mid = messageService.insert(message);

            message = this.messageService.getObjectById(mid);
            String content1;

            content1 = "<span  class=\"font-16px system-alert-outline \">您的积分已消费，" +
                    "<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                    "/school/" + id + "/score///1\" target=\"_blank\">点击查看</a></span>";

            template = Message.TEMPLATE_NONE;


            log.info("user : " + user.getMobile() + " send : " + content1);
            adminSend(user.getMobile(), content1);
            message.setContent(content1);

            message.setTemplate(template);

            messageService.update(message);
//            model.addAttribute("code", 0);


        }

    }

    //发送信息，手机号+内容
    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }
}

