package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.LogUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Answer  crud
 *
 * @author guchen
 * @Date 2018-01-19
 */
@Controller
public class AnswerController {
    private static final Log log = LogFactory.getLog(AnswerController.class);

    @Autowired
    private AnswerService answerService;

    @Autowired
    private QuestionService questionService;

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private MessageService messageService;

    /**
     * 1 新增回答
     *
     * @param request
     * @param response
     * @param model
     * @param answer
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer", method = RequestMethod.POST)
    public String addAnswerJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Answer answer) throws Exception {

        log.info("update answer : answer= " + answer);

        if (answer.getQuestionId() == null) {
            model.addAttribute("code", -29001);
            log.info("questionId is null");
            return "/common/failure";
        }

        if (answer.getContent() == null) {
            model.addAttribute("code", -29002);
            log.info("content is null");
            return "/common/failure";
        }


        try {
            answer.setId(null);
            answer.setLikeNum(0);
            answer.setIsLike(0);
            answer.setStatus(Constants.STATUS_SHOW);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            answer.setCreateBy(Long.parseLong(userId));
            answer.setUpdateBy(Long.parseLong(userId));

            Long id = answerService.insert(answer);
            if (DataUtils.isNullOrEmpty(id)) {
                log.info("add answer error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            //新增问题回答关系
            Question question = questionService.getObjectById(answer.getQuestionId());
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error :question == null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            } else {
                log.info("get question data is " + question);
                question.setAnswerNum(question.getAnswerNum() + 1);
                boolean isUpdate = questionService.update(question);
                if (isUpdate) {
                    log.info(" update success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add answer error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 2 获取回答详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer/{id}", method = RequestMethod.GET)
    public String getAnswerJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);

        if (id == null) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }

        try {
            Answer answer = answerService.getObjectById(id);
            log.info("get answer data is " + answer);
            if (DataUtils.isNullOrEmpty(answer)) {
                log.info("get answer error :answer == null");
                model.addAttribute("code", -29004);
                return "/common/failure";
            }

            model.addAttribute("code", 0);
            model.addAttribute("answer", answer);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get answer error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/answer/json/answerDetailJson";
    }


    /**
     * 3 修改回答
     *
     * @param request
     * @param response
     * @param model
     * @param answer
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer/{id}", method = RequestMethod.PUT)
    public String updateAnswerJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Answer answer,
                                   @PathVariable Long id) throws Exception {

        log.info("update answer : answer= " + answer);

        if (id == null) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }

        if (answer.getContent() == null) {
            model.addAttribute("code", -29002);
            log.info("content is null");
            return "/common/failure";
        }

        try {

            Answer oldAnswer = answerService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(oldAnswer)) {
                log.info("get oldAnswer error :oldAnswer == null");
                model.addAttribute("code", -29004);
                return "/common/failure";
            } else {
                log.info("get oldAnswer data is " + oldAnswer);
            }

            oldAnswer.setContent(answer.getContent());

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            oldAnswer.setUpdateBy(Long.parseLong(userId));

            boolean isUpdate = answerService.update(oldAnswer);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update answer error,id is  " + answer.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 4 隐藏/展示回答
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateAnswerStatusJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model,
                                         @PathVariable Long id, @PathVariable Integer status
    ) throws Exception {

        log.info("answer id is: " + id + ". status is: " + status);

        if (id == null) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }

        if (status == null) {
            model.addAttribute("code", -29006);
            log.info("status is null");
            return "/common/failure";
        }

        try {

            Answer answer = answerService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(answer)) {
                log.info("get answer error ");
                model.addAttribute("code", -29004);
                return "/common/failure";
            } else {
                log.info("get answer data is " + answer);
            }


            if (status.equals(answer.getStatus())) {
                model.addAttribute("code", -29007);
                return "/common/failure";
            } else {
                log.info(" answer  status is different from database");
            }

            answer.setStatus(status);
            Boolean isUpdateAnswer = answerService.update(answer);
            if (isUpdateAnswer) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            Question question = questionService.getObjectById(answer.getQuestionId());
            log.info("get question data is " + question);
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error, question is null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            if (null == userId) {
                log.info("get user error ");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            Manager manager = managerService.getObjectById(Long.valueOf(userId));
            log.info("get manager data is " + manager);
            if (DataUtils.isNullOrEmpty(manager)) {
                log.info("get manager error :manager == null");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            User user = userService.getObjectById(answer.getCreateBy());
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("get user error :user == null");
                model.addAttribute("code", -5003);
                return "/common/failure";
            } else {
                log.info("get user data is " + user);
            }

            if (status.equals(Constants.STATUS_HIDE)) {
                question.setAnswerNum(question.getAnswerNum() - 1);
                //发送消息给回答创建者，template=3
                sendMessageToUser(manager, user, answer, Message.TEMPLATE_3);

            } else if (status.equals(Constants.STATUS_SHOW)) {
                question.setAnswerNum(question.getAnswerNum() + 1);
            }

            boolean isUpdateQuestion = questionService.update(question);
            if (isUpdateQuestion) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update answer error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 5 删除回答
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer", method = RequestMethod.DELETE)
    public String deleteAnswerJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long[] id)
            throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }
        List<Long> list = Arrays.asList(id);
        log.info("delete  : list= " + list);


        try {

            List<Long> questionIdList = new ArrayList<>();
            List<Answer> answerList = new ArrayList<>();
            List<Question> questionList = new ArrayList<>();

            answerList = answerService.getObjectsByIds(list);
            if (CollectionUtils.isEmpty(answerList)) {
                log.info(" answerList is null ");
            } else {
                log.info(" answerList size =  " + answerList.size());
                for (Answer answer : answerList) {
                    if (answer.getQuestionId() != null) {
                        questionIdList.add(answer.getQuestionId());
                    }
                }
            }

            answerService.deleteList(Answer.class, list);
            log.info("delete  success");

            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
                questionList = questionService.getObjectsByIds(questionIdList);
                for (Question question : questionList) {
                    question.setAnswerNum(question.getAnswerNum() - 1);
                }
                boolean isUpdate = questionService.updateList(questionList);
                if (isUpdate) {
                    log.info(" update success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete  error,list is  " + list);
            model.addAttribute("code", -1);

        }
        return "/common/success";
    }

    /**
     * 6 搜索回答列表
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type
     * @param questionId
     * @param status
     * @param createBy
     * @param title
     * @param labelIds
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/answer/search", method = RequestMethod.GET)
    public String searchAnswerList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type, Long questionId,
            Integer status, Long createBy, String title, String labelIds,
            Integer orderBy, Integer sort,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/u/answer/search  by==id", id, "oid", oid, "tid", tid,
                "uid", uid, "type", type, "questionId", questionId, "status", status, "createBy", createBy, "title", title, "labelIds", labelIds,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(paramStr);


        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值

            List<Long> answerIdList = new ArrayList<>();
            List<Long> questionIdList = new ArrayList<>();
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();
            String questionIdS = null;


            List<Answer> answerList = new ArrayList<>();
            List<Question> questionList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<User> userList = new ArrayList<>();


            //动态查询-获取参数列表

            if (null != questionId) {
                questionIdS = questionId.toString();
            }

            Map<String, Object> paramList = DynamicUtil.getAnswerListParam(id, oid, tid, uid, type, questionIdS, status, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());
            //获取相关list
            answerIdList = answerService.getIdsByDynamicCondition(Answer.class, paramList, start, size);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                return "/common-skill-service/answer/json/answerListJson";
            } else {
                log.info(" answerIdList size =  " + answerIdList.size());
            }
            //获取total
            List<Long> allAnswer = answerService.getIdsByDynamicCondition(Answer.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allAnswer.size());

            //获取关联list
            answerList = answerService.getObjectsByIds(answerIdList);
            for (Answer answer : answerList) {
                    questionIdList.add(answer.getQuestionId());
                    uidList.add(answer.getCreateBy());
            }

            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
                questionList = questionService.getObjectsByIds(questionIdList);
                for (Question question : questionList) {
                    oidList.add(question.getOid());
                    tidList.add(question.getTid());
                }
            }


            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", answerList.size());
            model.addAttribute("total", allAnswer.size());
            model.addAttribute("answerList", answerList);
            model.addAttribute("questionList", questionList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("userList", userList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/answer/json/answerListJson";
    }


    /**
     * 发送消息给回答创建者
     *
     * @param manager
     * @param user
     * @param answer
     * @param template
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    public void sendMessageToUser(Manager manager, User user, Answer answer, Integer template) throws ServiceException, ServiceDaoException {

        log.info(" sendMessageToUser start ");

        //创建消息
        String content = answer.getId().toString();

        Message message = new Message();

        message.setSendId(manager.getId());
        message.setReceiveId(user.getId());
        message.setReceiveName(user.getNick());
        message.setSendName(manager.getNick());
        message.setContent(content);
        message.setStatus(Message.STATUS_UNDELETE);
        message.setUnread(Message.Status_Unread);
        message.setType(Message.QUESTION_TYPE);
        message.setTemplate(template);
        message.setRelationId(answer.getQuestionId());
        message.setCreateBy(manager.getId());
        message.setUpdateBy(manager.getId());

        messageService.insert(message);

        //发送
        adminSend(user.getMobile(), content);

        //更新个人消息未读数
        Integer unLook = user.getIsLook() + 1;
        user.setIsLook(unLook);
        user.setLatestMsg(Message.QUESTION_TYPE);
        userService.update(user);
    }

    //发送信息，手机号+内容
    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }

}

