package com.ptteng.util;

import com.gemantic.common.util.StringUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Created by yeqin on 2016/10/19.
 */
public class SkillUtil {

    private static final Log log = LogFactory.getLog(SkillUtil.class);

    public static Map<String,Object> getSkillList(){		//获取skill表的所有id
        Map<String,Object> params=new HashedMap();
        Long now = System.currentTimeMillis();

        Set<String> tables = new HashSet();
        tables.add("skill");

        params.put("@order", " skill.id");
        params.put("@query", " skill.id");
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }
    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        Iterator var4 = tables.iterator();

        while(var4.hasNext()) {
            String table = (String)var4.next();
            ++index;
            tableBuffer = tableBuffer.append(table);
            if(index < tables.size()) {
                tableBuffer = tableBuffer.append(",");
            }
        }

        return tableBuffer.toString();
    }
    
    public static Map<String,Object> getTaskSkillRelationIdByTidAndSid(Long tid, Long sid){		//获取skill表的所有id
        Map<String,Object> params=new HashedMap();
        Long now = System.currentTimeMillis();

        Set<String> tables = new HashSet();
        tables.add("task_skill_relation");

        params.put("task_skill_relation.tid", tid);
        params.put("task_skill_relation.sid", sid);
        
        params.put("@order", " task_skill_relation.id");
        params.put("@query", " task_skill_relation.id");
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }
    public static Map<String,Object> getDocumentIdsBySidAndType(Long sid, int type){		//在Document表中获取sid和type所对应的文档或视频的id
        Map<String,Object> params=new HashedMap();
        Long now = System.currentTimeMillis();

        Set<String> tables = new HashSet();
        tables.add("document");
        params.put("document.sid", sid);
        params.put("document.type", type);


        params.put("@query", " id");
        String table = convertTable(tables);
        params.put("@table", table);

        return params;
    }
}
