package com.ptteng.controller;

import java.lang.reflect.Type;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.LogUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.model.UidTime;
import com.qding.common.util.json.GsonUtil;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.TeacherService;
/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog(ArticleController.class);

    @Autowired
    private ArticleService articleService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private UserService userService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CommentService commentService;

    @Autowired
    private ArticleTaskRelationService articleTaskRelationService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private ClassesService classesService;
    @Autowired
    private TaskSkillRelationService taskSkillRelationService;
    @Autowired
    private SkillService skillService;
    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private TeacherService teacherService;

    /**
     * @param
     * @return
     */

    //19.日报信息读取
    @RequestMapping(value = "/a/daily/{did}", method = RequestMethod.GET)
    public String dailyInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            @PathVariable Long did, Integer page, Integer size) throws Exception {

        log.info("============================================");
        log.info("get dailyInfo " + did + " page is " + page + " size is " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        if (did.equals(null)) {
            model.addAttribute("code", -1000);
            log.info("did is null");
            return "/common/success";
        }

        try {
            Map<Long, Long> commentId_num = new HashMap<>();

            Article daily = articleService.getObjectById(did);

            if (daily == null) {
                model.addAttribute("code", -5000);
                log.info("no this article");
                return "/common/success";
            }

            Long uid = daily.getUid();
            Long cid = daily.getCid();
            Long userClassRelationId = userClassRelationService.getUserClassRelationIdByCidAndUid(cid, uid);
            UserClassRelation userClassRelation = userClassRelationService.getObjectById(userClassRelationId);
            Long dailyNum = userClassRelation.getNum();


            String type = daily.getType();

            if (type.equals("daily")) {
            } else {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }

            daily.setReadCount(daily.getReadCount() + 1);
            articleService.update(daily);

            Integer commentCount = commentService.countCommentIdsByDid(did);
            List<Long> commentIdList = commentService.getCommentIdsByDid(did, start, size);
            List<Comment> commentList = commentService.getObjectsByIds(commentIdList);

            List<Long> taskIdList = articleTaskRelationService.getTidsByDid(did, 0, Integer.MAX_VALUE);
            List<Task> taskList = taskService.getObjectsByIds(taskIdList);

            boolean result = false;
            for (Comment comment : commentList) {
                Long relationID = userClassRelationService.getUserClassRelationIdByCidAndUid(cid, comment.getUid());
                if (relationID != null) {
                    result = true;
                    UserClassRelation relation = userClassRelationService.getObjectById(relationID);
                    Long num = relation.getNum();
                    commentId_num.put(comment.getId(), num);
                } else {
                    result = false;
                    Long num = 0L;
                    commentId_num.put(comment.getId(), num);
                }
            }

            boolean next = false;
            if (commentCount > end + 1) {
                next = true;
            }
            User user = userService.getObjectById(uid);
//            log.info("user"+user);
//            Long tid = taskList.get(0).getId();
//            Task task = taskService.getObjectById(tid);
            Long teacherUid = user.getTeacherId();
            User teacher = userService.getObjectById(teacherUid);
            log.info("teacher"+teacher);
            BranchInstitute branch = new BranchInstitute();
            if(user.getBranch()!=null) {
                branch = branchInstituteService.getObjectById(user.getBranch().longValue());
            }
            log.info("branch"+branch);
            BranchInstitute teacherBranch = new BranchInstitute();
            if (teacher.getBranch()!=null){
                teacherBranch = branchInstituteService.getObjectById(teacher.getBranch().longValue());
            }


            model.addAttribute("code", 0);
            model.addAttribute("num", dailyNum);
            model.addAttribute("next", next);
            model.addAttribute("daily", daily);
            model.addAttribute("taskList", taskList);
            model.addAttribute("branch",branch);
            model.addAttribute("teacher",teacher);
            model.addAttribute("teacherBranch",teacherBranch);
            model.addAttribute("user",user);
            model.addAttribute("commentList", commentList);
            model.addAttribute("commentId_num", commentId_num);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dailyInfo error,did is " + did);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/dailyInfo";
    }


    /**
     * @param
     * @return
     */

    //20.职业日报列表
    @RequestMapping(value = "/a/occupation/daily/{oid}", method = RequestMethod.GET)
    public String occupationDailyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                      @PathVariable Long oid, Integer page, Integer size) throws Exception {

        log.info("============================================");
        log.info("get occupation dailyInfo " + oid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        if (oid.equals(null)) {
            model.addAttribute("code", -1000);
            log.info("cid is null");
            return "/common/success";
        }

        try {
            Map<Long, Long> did_num = new HashMap<>();
            Occupation occupation = occupationService.getObjectById(oid);

            if (occupation == null) {
                model.addAttribute("code", -4002);
                log.info("no this classes");
                return "/common/success";
            }

            List<Long> articleIds = articleService.getArticleIdsByOidAndType(oid, "daily", start, size);
            List<Article> articles = articleService.getObjectsByIds(articleIds);
            Integer total = articleService.countArticleIdsByOidAndType(oid, "daily");

            Map<Long, UserClassRelation> aid_relation = new HashMap<>();
            Map<Long, List<Task>> aid_taskList = new HashMap<>();
            Long relationId;
            UserClassRelation relation = new UserClassRelation();

            for (Article article : articles) {
                Long aid = article.getId();
                relationId = userClassRelationService.getUserClassRelationIdByCidAndUid(article.getCid(), article.getUid());
                relation = userClassRelationService.getObjectById(relationId);
                aid_relation.put(aid, relation);
                List<Long> taskIdList = articleTaskRelationService.getTidsByDid(aid, 0, Integer.MAX_VALUE);
                List<Task> taskList = taskService.getObjectsByIds(taskIdList);
                aid_taskList.put(aid, taskList);
            }

            boolean next = false;
            if (total > end + 1) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("oid", oid);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("articles", articles);
            model.addAttribute("aid_relation", aid_relation);
            model.addAttribute("aid_taskList", aid_taskList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is " + oid);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/occupationDailyList";
    }


    /**
     * @param
     * @return
     */

    //21.班级日报列表
    @RequestMapping(value = "/a/class/daily/{cid}", method = RequestMethod.GET)
    public String classesDailyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long cid) throws Exception {

        log.info("============================================");
        log.info("get dailyInfo " + cid);


        if (cid.equals(null)) {
            model.addAttribute("code", -1000);
            log.info("cid is null");
            return "/common/success";
        }

        try {
            Map<Long, Long> did_num = new HashMap<>();
            Classes classes = classesService.getObjectById(cid);

            if (classes == null) {
                model.addAttribute("code", -4002);
                log.info("no this classes");
                return "/common/success";
            }

            Long oid = classes.getOid();

            List<Long> relationIdList = userClassRelationService.getUserClassRelationIdsByCid(cid, 0, Integer.MAX_VALUE);
            List<UserClassRelation> relations = userClassRelationService.getObjectsByIds(relationIdList);
            log.info("relations is " + relations.size());

            Map<Long, Article> uid_daily = new HashMap<>();
            Map<Long, List<Task>> uid_taskList = new HashMap<>();
            Map<Long, UserClassRelation> uid_relation = new HashMap<>();
            List<UidTime> uidTimes = new ArrayList<>();

            for (UserClassRelation relation : relations) {
                UidTime uidTime = new UidTime();
                Long uid = relation.getUid();
                uid_relation.put(uid, relation);
                if (relation.getLastDaily() != null) {
                    Long did = relation.getLastDaily();
                    Article article = articleService.getObjectById(did);
                    Long time = article.getCreateAt();
                    Long dailyTime = article.getDailyTime();
                    List<Long> taskIdList = articleTaskRelationService.getTidsByDid(did, 0, Integer.MAX_VALUE);
                    List<Task> taskList = taskService.getObjectsByIds(taskIdList);
                    uid_daily.put(article.getUid(), article);
                    uid_taskList.put(article.getUid(), taskList);
                    uidTime.setUid(uid);
                    uidTime.setDailyTime(dailyTime);
                    uidTime.setTime(time);
                    uidTimes.add(uidTime);
                } else {
                    uidTime.setTime(0L);
                    uidTime.setDailyTime(0L);
                    uidTime.setUid(uid);
                    uidTimes.add(uidTime);
                }
            }

            Collections.sort(uidTimes);

            List<Long> uidList = new ArrayList<>();
            for (UidTime uidTime1 : uidTimes) {
                uidList.add(uidTime1.getUid());
            }

            model.addAttribute("code", 0);
            model.addAttribute("oid", oid);
            model.addAttribute("uidList", uidList);
            model.addAttribute("uid_relation", uid_relation);
            model.addAttribute("uid_daily", uid_daily);
            model.addAttribute("uid_taskList", uid_taskList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classesDailyList error,cid is " + cid);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/classesDailyList";
    }

    /**
     * @param
     * @return
     */

    //22.个人日报列表
//    @RequestMapping(value = "/a/user/daily/{uid}", method = RequestMethod.GET)
//    public String userDailyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
//                                @PathVariable Long uid, Long cid, Integer page, Integer size) throws Exception {
//
//        log.info("============================================");
//        log.info("get userDailyList uid is " + uid + " cid is " + cid + " page is " + page + " size is " + size);
//
//        if (page == null) {
//            page = 1;
//        }
//        if (size == null) {
//            size = 10;
//        }
//        int start = (page - 1) * size;
//        if (start < 0) {
//            start = 0;
//        }
//        int end = start + size - 1;
//
//        if (cid.equals(null)) {
//            model.addAttribute("code", -1000);
//            log.info("cid is null");
//            return "/common/success";
//        }
//
//        try {
//            Classes classes = classesService.getObjectById(cid);
//
//            if (classes.equals(null)) {
//                model.addAttribute("code", -4002);
//                log.info("no this classes");
//                return "/common/success";
//            }
//
//            Long relationID = userClassRelationService.getUserClassRelationIdByCidAndUid(cid, uid);
//            UserClassRelation userClassRelation = userClassRelationService.getObjectById(relationID);
//            Long num = userClassRelation.getNum();
//
//            if (relationID == null) {
//                model.addAttribute("code", -4003);
//                log.info("user is not in the classes");
//                return "/common/success";
//            }
//
//            List<Long> articleIds = articleService.getArticleIdByUidAndCid(uid, cid, start, size);
//            log.info("articleIds is " + articleIds);
//            List<Article> articleList = articleService.getObjectsByIds(articleIds);
//            log.info("articleList is " + articleList);
//
//            Map<Long, List<Task>> did_taskList = new HashMap<>();
//            for (Long did : articleIds) {
//                List<Long> taskIdList = articleTaskRelationService.getTidsByDid(did, 0, Integer.MAX_VALUE);
//                List<Task> taskList = taskService.getObjectsByIds(taskIdList);
//                did_taskList.put(did, taskList);
//            }
//
//            List<Long> articleCount = articleService.getArticleIdByUidAndCid(uid, cid, 0, Integer.MAX_VALUE);
//            boolean next = false;
//            if (articleCount.size() > end + 1) {
//                next = true;
//            }
//
//            model.addAttribute("code", 0);
//            model.addAttribute("next", next);
//            model.addAttribute("num", num);
//            model.addAttribute("total", articleCount.size());
//            model.addAttribute("articleList", articleList);
//            model.addAttribute("did_taskList", did_taskList);
//
//        } catch (Throwable t) {
//            log.error(t.getMessage());
//            log.error("get classesDailyList error,cid is " + cid);
//            model.addAttribute("code", -100000);
//        }
//
//        return "/common-skill-service/article/json/userDailyList";
//    }

    /**
     * @param
     * @return
     */

    //24.删除日报
    @RequestMapping(value = "/a/u/daily/{did}", method = RequestMethod.DELETE)
    public String deleteDaily(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long did) throws Exception {

        log.info("============================================");
        log.info("delete daily : did is " + did);


        if (did.equals(null)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }

        try {
            Article daily = articleService.getObjectById(did);

            if (daily.equals(null)) {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }

            articleService.delete(did);

            List<Long> taskIds = articleTaskRelationService.getArticleTaskRelationIdsByDid(did, 0, Integer.MAX_VALUE);
            articleTaskRelationService.deleteList(ArticleTaskRelation.class, taskIds);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete daily error,did is " + did);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * @param
     * @return
     */

    //25.修改日报
    @RequestMapping(value = "/a/u/daily/{did}", method = RequestMethod.PUT)
    public String updateDaily(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long did, String content) throws Exception {

        log.info("============================================");
        log.info("update daily : did is " + did + " title is "  + " content is " + content);


        if (did.equals(null) || StringUtil.isEmpty(content)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }

        try {
            Article daily = articleService.getObjectById(did);

            if (daily.equals(null)) {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }
            String type = daily.getType();

            if (type.equals("daily")) {
            } else {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }

            daily.setContent(content);
//            daily.setTitle(title);

            articleService.update(daily);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update daily error,did is " + did + " title is "  + " content is " + content);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * @param
     * @return
     */

    //26.删除评论
    @RequestMapping(value = "/a/u/comment/{commentId}", method = RequestMethod.DELETE)
    public String deleteComment(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long commentId) throws Exception {

        log.info("============================================");
        log.info("delete daily : commentId is " + commentId);


        if (commentId.equals(null)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }

        try {
            Comment comment = commentService.getObjectById(commentId);

            if (comment.equals(null)) {
                model.addAttribute("code", -5001);
                log.info("no this comment");
                return "/common/success";
            }

            commentService.delete(commentId);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete daily error,commentId is " + commentId);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


    /**
     * 此处直接取DB里的Token。获取Token由Python完成。之后由Crontab控制，每天更新一次。
     *
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/init/article", method = RequestMethod.GET)
    public String initArticle(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, Long endAt, Integer step) throws ServiceException, ServiceDaoException {
        log.info(pwd + " will init user step is " + step + " and  endAt " + endAt);


        if ("xdylxdyl".equals(pwd)) {


            Integer aritcleCounts = this.articleService.countArticleIds();
            log.info(" all aritcleCounts is " + aritcleCounts);
            int start = 0;
            if (step == null) {
                step = 200;
            }

            while (start <= aritcleCounts) {
                Long batchStart = System.currentTimeMillis();
                List<Long> aids = this.articleService.getArticleIds(start, step);
                List<Article> articles = this.articleService.getObjectsByIds(aids);

                for (Article article : articles) {
                    Long startAt = System.currentTimeMillis();
                    Long articleID = article.getId();
                    List<Long> commentIDS = this.commentService.getCommentIdsByDid(articleID, 0, Integer.MAX_VALUE);
                    article.setReply(Long.valueOf(commentIDS.size()));

                    List<Long> relationIDS = this.articleTaskRelationService.getArticleTaskRelationIdsByDid(articleID, 0, Integer.MAX_VALUE);
                    List<ArticleTaskRelation> relations = this.articleTaskRelationService.getObjectsByIds(relationIDS);
                    List<Long> tids = new ArrayList();
                    for (ArticleTaskRelation relation : relations) {
                        tids.add(relation.getTid());
                    }
                    String tidContents = GsonUtil.toJson(tids);
                    article.setTids(tidContents);
                    this.articleService.update(article);
                    log.info(articleID + " user time is " + (System.currentTimeMillis() - startAt));

                }

                start = start + step;
                log.info(start + " ====================== is update ,step is ====================== " + step + " user time is " + (System.currentTimeMillis() - batchStart));

            }


        } else {

            model.addAttribute("code", -10000);
            return "/common/success";

        }
        model.addAttribute("code", 0);

        return "/common/success";

    }

    //日报列表
    @RequestMapping(value = "/a/daily/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Long teacherUid, Long uid, Long tid,
                              Long cid, Long oid, Long startAt, Long endAt, Integer page, Integer size, Integer orderBy, Integer sort,
                              Integer evaluation, String userType, Long userOid, Integer studyNumber, Integer stuEvaluation,
                              String nick,Integer identity,Integer status,String type) {

        String paramStr = LogUtil.convertParam("searchDaily by==teacherUid", teacherUid, "uid", uid, "cid", cid, "oid",
                oid, "startAt", startAt, "endAt", endAt, "page", page, "size", size + " orderby " + orderBy + "sort = " + sort
                ,"type",type);
        log.info(paramStr);

		/* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        Integer total = 0;
        boolean next = false;

        try {

            List<Long> articleIDS = new ArrayList();
            List<Long> articleCount = new ArrayList();
            if (DataUtils.isNullOrEmpty(orderBy)) {
                orderBy = UserArticleRelation.ARTICLE_CREATE_AT;
            }
            if (DataUtils.isNullOrEmpty(sort)) {
                sort = UserArticleRelation.DESC;
            }
			/* 2-1 普通日报搜索 */
            if (CheckDataUtil.isNull(teacherUid)) {

                Map<String, Object> articleParam = DynamicUtil.getArticleListByParam(
                        uid, tid, cid, oid, startAt, endAt, false, orderBy, sort, evaluation, userType, userOid, studyNumber,nick,identity,status,type, false);
                articleIDS = this.articleService.getIdsByDynamicCondition(Document.class, articleParam, start, limit);

                Map<String, Object> countArticleParam = DynamicUtil.getArticleListByParam(
                        uid, tid, cid, oid, startAt, endAt, false, orderBy, sort, evaluation, userType, userOid, studyNumber,nick,identity,status,type, true);
                articleCount = this.articleService.getIdsByDynamicCondition(Document.class, countArticleParam, 0, Integer.MAX_VALUE);

            }

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleCount)) {
                total = articleCount.get(0).intValue();
            }

            String str2 = LogUtil.convertParam(" get total of daily is ", "total", total, "date", articleIDS);
            log.info(str2);

            List<Article> articles = new ArrayList();
            List<User> users = new ArrayList();
            List<Task> tasks = new ArrayList();
            List<Classes> classes = new ArrayList();
            List<BranchInstitute> branches = new ArrayList();

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleIDS)) {
                articles = this.articleService.getObjectsByIds(articleIDS);
                if (articles.size() >= size) {
                    articles = articles.subList(0, size);
                    next = true;
                }
            }

            Gson gson = new Gson();
            Type typeToken = new TypeToken<List<Long>>() {
            }.getType();
            Set<Long> uids = new HashSet();
            Set<Long> tids = new HashSet();
            Set<Long> cids = new HashSet();

            for (Article article : articles) {
                uids.add(article.getUid());
                cids.add(article.getCid());
                List<Long> taskIDS = gson.fromJson(article.getTids(), typeToken);
                if (taskIDS != null) {
                    tids.addAll(taskIDS);
                }


            }

            if (CollectionUtils.isEmpty(tids)) {

            } else {
                tasks = this.taskService.getObjectsByIds(new ArrayList(tids));
                log.info(" get tasks is " + tids);
            }


            if (CollectionUtils.isEmpty(uids)) {

            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                DynamicUtil.checkUserGraduateStatus(users);
                log.info(" get user is " + uids);
                classes = this.classesService.getObjectsByIds(new ArrayList(cids));
            }
            List<Long> bids = new ArrayList<>();
            int userSize = users.size();
            for (int i =0 ;i < userSize;i++){
                User user = users.get(i);
                if (user.getBranch()!=null){
                    bids.add(user.getBranch().longValue());
                }
            }
            if (bids!=null){
                branches = this.branchInstituteService.getObjectsByIds(bids);
            }


            model.addAttribute("code", 0);
            model.addAttribute("aricles", articles);
            model.addAttribute("users", users);
            model.addAttribute("tasks", tasks);
            model.addAttribute("classesList", classes);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("branches",branches);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is " + oid);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/articleList";

    }



}

