package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserTeamRelation;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.service.UserTeamRelationService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Team;
import com.ptteng.common.skill.service.TeamService;

/**
 * Team  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TeamController {
	private static final Log log = LogFactory.getLog(TeamController.class);

	@Autowired
	private TeamService teamService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private UserTeamRelationService userTeamRelationService;

	@Autowired
	private UserService userService;


    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */


	//小组详情
	@RequestMapping(value = "/a/u/team/{id}", method = RequestMethod.GET)
	public String getTeamJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("iteration id cannot be null");
			model.addAttribute("code", -22002);
		}
		try {
			Team team = teamService.getObjectById(id);
//			log.info("get team data is " + team);

			model.addAttribute("code", 0);

			model.addAttribute("team", team);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get team error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/team/json/teamDetailJson";
	}

	//编辑小组
	@RequestMapping(value = "/a/u/team/{id}", method = RequestMethod.PUT)
	public String updateTeamJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, Team team) throws Exception {
		//判空
		log.info("update team : team= " + team);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		Team oldTeam = teamService.getObjectById(id);
		if (oldTeam == null){
			model.addAttribute("code", -22009);
			log.info("The team does not exist");
			return "/common/success";
		}
		if (team.getName() == null||team.getSeniorId()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}


		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			team.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录到数据库
			team.setCreateBy(oldTeam.getCreateBy());
			team.setCreateAt(oldTeam.getCreateAt());

			teamService.update(team);

			model.addAttribute("code", 0);

			model.addAttribute("team", team);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update team error,id is  " + team.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//新增小组
	@RequestMapping(value = "/a/u/team", method = RequestMethod.POST)
	public String addTeamJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Team team) throws Exception {

		if (team.getName() == null||team.getSeniorId()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}
		//验证名称是否重复
		List<Long> alreadyTeam=teamService.getTeamIdsByNameOrderByCreateAt(team.getName(),0,Integer.MAX_VALUE);
		if (alreadyTeam.size()==0){
			log.info("this name is new");
		}else {
			model.addAttribute("code", -22021);
			log.info("this name is already exist");
			return "/common/success";
		}
//		User leader = userService.getObjectById(team.getLeaderId());
//		int leaderIdentity = leader.getIdentity();
		User senior = userService.getObjectById(team.getSeniorId());
		//判断用户是否存在
		if (senior==null){
			model.addAttribute("code", -22019);
			log.info("user is not exist");
			return "/common/success";
		}
		int seniorIdentity = senior.getIdentity();
//		log.info(leaderIdentity);
//		//小组长身份验证
//		if (leaderIdentity==40||leaderIdentity==30||leaderIdentity==50){
//
//		}else {
//			model.addAttribute("code", -22003);
//			log.info("leaderId is wrong");
//			return "/common/success";
//		}
		//复盘师兄身份验证
		if (seniorIdentity!=60){
			model.addAttribute("code", -22004);
			log.info("seniorId is wrong");
			return "/common/success";
		}
		try {
			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			team.setCreateBy(Long.parseLong(userId));
			team.setUpdateBy(Long.parseLong(userId));

			//记录小组初始人数,复盘师兄不算在小组里
			team.setNums(0);

			Long tid=teamService.insert(team);

			//成员表添加记录
			//插入小组长的关系记录
//			UserTeamRelation memberOne = new UserTeamRelation();
//			log.info(team);
//			memberOne.setUid(team.getLeaderId());
//			memberOne.setTid(tid);
//			log.info(memberOne);
//			userTeamRelationService.insert(memberOne);

			//插入复盘师兄的关系记录
			UserTeamRelation memberSenior = new UserTeamRelation();
			memberSenior.setUid(team.getSeniorId());
//			memberSenior.setTid(tid);
			Long mid=userTeamRelationService.insert(memberSenior);

			//用户表更新关联字段
			//更新小组长
//			leader.setUserTeamId(String.valueOf(memberOne.getId()));
//			userService.update(leader);

			//记录成员表更改数据的操作者
//			memberSenior.setCreateBy(Long.parseLong(userId));
//			memberSenior.setUpdateBy(Long.parseLong(userId));

//			userTeamRelationService.update(memberSenior);


			//更新复盘师兄用户表关联字段
			String userTeamId = senior.getUserTeamId();

			//复盘师兄可能同时带多个复盘小组
			log.info(memberSenior.getId());
			if (userTeamId.equals("-1")){
				senior.setUserTeamId(String.valueOf(mid));
			}else {
				senior.setUserTeamId(userTeamId+','+String.valueOf(mid));
			}
			userService.update(senior);
			log.info(senior);

			model.addAttribute("code", 0);
			model.addAttribute("tid", tid);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add team error ");
			model.addAttribute("code", -6002);
		}

		return "/common-skill-service/team/json/addTeam";
	}

	@RequestMapping(value = "/a/team/{id}", method = RequestMethod.DELETE)
	public String deleteTeamJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete team : id= " + id);
		try {
			teamService.delete(id);

			log.info("add team success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete team error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	//小组列表
	@RequestMapping(value = "/a/u/team/search", method = RequestMethod.GET)
	public String getMultiTeamJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,
								   String name,Long leaderId,Long seniorId)
			throws Exception {
		log.info("name"+name+"leaderId"+leaderId+"seniorId");
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getTeamListParam(name,leaderId,seniorId,false);
			log.info("paramList size =" + paramList.size());
			//获取小组Id列表
			List<Long> teamsIdList = teamService.getIdsByDynamicCondition(Team.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getTeamListParam(name,leaderId,seniorId,true);
			List<Long> teamsIdCount = teamService.getIdsByDynamicCondition(Team.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(teamsIdCount)) {
				total = teamsIdCount.get(0);
			}
			//获取小组列表
			List<Team> teamList = teamService.getObjectsByIds(teamsIdList);
			log.info("get  team data is " + teamList.size());

			//复盘师兄要展示名字，因此返回用户信息
			//获取用户id列表
			List<Long> userIds = new ArrayList();

			for (int i=0;i<teamList.size();i++){
				Team team = teamList.get(i);
				userIds.add(team.getSeniorId());
				if (team.getLeaderId()!=null){
					userIds.add(team.getLeaderId());
				}
			}

			//获取用户列表
			List<User> userList = userService.getObjectsByIds(userIds);
			log.info("get user size is"+userList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("teamList", teamList);
			model.addAttribute("users",userList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get team list error  ");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/team/json/teamListJson";
	}

}

