package com.ptteng.controller;

import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.RecordLog;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.ManagerService;
import com.ptteng.common.skill.service.RecordLogService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
public class RecordLogController {

    public static final Log log = LogFactory.getLog(RecordLogController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private RecordLogService recordLogService;

    @Autowired
    private ManagerService managerService;

    /**
     * @Description: 搜索审核记录列表
     * @param: branchId 分院ID
     * @param name 学员昵称
     * @param operate 审核操作
     * @param minLogAt 记录日期下限
     * @param maxLogAt 记录日期上限
     * @param operator 操作人
     * @param page 页码
     * @param size 单页数据量
     * @return 审核记录列表
     */
    @RequestMapping(value = "/a/u/record/log/search", method = RequestMethod.GET)
    public String searchRecordLog(ModelMap model, Long branchId, String name, Integer operate, Long minLogAt, Long maxLogAt,
                                  String operator, Integer page, Integer size) {

        log.info("GET /a/u/record/log/search: search record-log by params: branchId = " + branchId + ", name = " + name
                + ", operate = " + operate + ", minLogAt = " + minLogAt + ", maxLogAt = " + maxLogAt + ", operator = " +operator
                + ", page = " + page + ", size = " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try{

            Map<String, Object> params = DynamicUtil.getRecordLogListParam(branchId, name, operate, minLogAt, maxLogAt, operator, false);
            log.info("get dynamic params: " + params);

            List<Long> recordLogIds = recordLogService.getIdsByDynamicCondition(RecordLog.class, params, start, size);
            log.info("get recordLogIds size: " + recordLogIds.size());
            if (CollectionUtils.isEmpty(recordLogIds)) {
                model.addAttribute("code", -39000);
                return "/common/failure";
            }

            List<RecordLog> recordLogList = recordLogService.getObjectsByIds(recordLogIds);
            log.info("get recordLogList size: " + recordLogList.size());

            Map<String, Object> countParams = DynamicUtil.getRecordLogListParam(branchId, name, operate, minLogAt, maxLogAt, operator, true);
            log.info("get countParams: " + params);

            List<Long> countRecordLogIds = recordLogService.getIdsByDynamicCondition(RecordLog.class, countParams, 0, Integer.MAX_VALUE);
            log.info("get countRecordLogIds size: " + countRecordLogIds.size());

            int total = 0;
            if (!CollectionUtils.isEmpty(countRecordLogIds)) {
                total = countRecordLogIds.get(0).intValue();
            }

            List<Long> uids = new ArrayList<>();
            List<Long> mids = new ArrayList<>();
            for (RecordLog recordLog : recordLogList) {
                Long uid = recordLog.getUid();
                uids.add(uid);

                Long mid = recordLog.getCreateBy();
                mids.add(mid);
            }

            List<User> userList = userService.getObjectsByIds(uids);
            log.info("get userList size: " + userList.size());

            List<Manager> managerList = managerService.getObjectsByIds(mids);
            log.info("get managerList size: " + managerList.size());

            Map<Long, User> userMap = new HashMap<>();
            Map<Long, Manager> managerMap = new HashMap<>();

            for (User user : userList) {
                userMap.put(user.getId(), user);
            }
            for (Manager manager : managerList) {
                managerMap.put(manager.getId(), manager);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("recordLogList", recordLogList);
            model.addAttribute("userMap", userMap);
            model.addAttribute("managerMap", managerMap);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("search record-log failure, try again later");
            model.addAttribute("code", -39001);
        }
        return "/common-skill-service/recordLog/json/recordLogListJson";
    }


}
