package com.ptteng.controller;

import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserScore;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserScoreService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.ComputeUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.LogUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * UserScore  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserScoreController {
	private static final Log log = LogFactory.getLog(UserScoreController.class);

	@Autowired
	private UserScoreService userScoreService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private UserService userService;

	@Autowired
	private OccupationService occupationService;

	@Autowired
	private CookieUtil cookieUtil;


    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//搜索积分列表
	@RequestMapping(value = "/a/u/score/search", method = RequestMethod.GET)
	public String getScoreList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model , Integer page, Integer size,Long uid,
							   String nick
			, Long oid, Integer identity, String type, Long startAt, Long endAt,Integer scoreType,Long score
	)
			throws Exception {
		log.info("pageList : page= " + page + " , size=" + size);
        /* 1 默认分页 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
		//打印入参
		String paramStr = LogUtil.convertParam("searchScoreList by==uid", uid, "nick", nick,"oid",oid,
				"identity",identity,"type",type,"startAt",startAt,"endAt",endAt,"scoreType",scoreType,
				"score",score,"page", page, "size", size);
		log.info(paramStr);

		try {
            /* 初始值 */
			List<Long> userIdList = new ArrayList<>();
			List<Long> occupationIdList = new ArrayList<>();
			Long total = 0L;

            //动态查询-获取参数列表
			Map<String,Object> paramList = DynamicUtil.getScoresListParam(uid,nick, oid, identity, type, startAt, endAt,scoreType,score, false);
			log.info("paramList size =" + paramList.size());
			//获取积分scoresIdList
			List<Long> scoresIdList = userScoreService.getIdsByDynamicCondition(UserScore.class,paramList,start, size);
			if (CollectionUtils.isEmpty(scoresIdList)){
				log.info("scoresIdList is null");
			}else{
				log.info("scores size ="+scoresIdList.size());
			}
			//获取total
			Map<String, Object> paramCount = DynamicUtil.getScoresListParam(uid,nick, oid, identity, type, startAt, endAt,scoreType,score, true);
			log.info("get param:" + paramCount);
			List<Long> scoresIdCount = userScoreService.getIdsByDynamicCondition(UserScore.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get scoresIdCount:" + scoresIdCount.size());
			if (CollectionUtils.isNotEmpty(scoresIdCount)) {
				total = scoresIdCount.get(0);
			}
			//获取scoresList
			List<UserScore> scoresList = userScoreService.getObjectsByIds(scoresIdList);

			//获取userIdList
			int scoresSize = scoresList.size();
			for (int i = 0;i<scoresSize;i++){
				UserScore scores = scoresList.get(i);
				userIdList.add(scores.getUid());
			}
			//获取userList
			List<User> userList = userService.getObjectsByIds(userIdList);
			log.info("userList" +userList.size());

			//获取occupationIdList
			int userSize = userList.size();
			for (int i =0 ;i < userSize;i++){
				User user = userList.get(i);
				occupationIdList.add(user.getOid());
			}
            //获得occupationList
			List<Occupation> occupationList = occupationService.getObjectsByIds(occupationIdList);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("userScoreList", scoresList);
            model.addAttribute("users",userList);
			model.addAttribute("occupations", occupationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" search scores list error ");
			model.addAttribute("code", -1);
		}
		return "/common-skill-service/userScore/json/userScoreListJson";
	}

	//新增积分记录
	@RequestMapping(value = "/a/u/score", method = RequestMethod.POST)
	public String updateUserScore(HttpServletRequest request,
									  HttpServletResponse response, ModelMap model, Long score ,String comment
	,Long uid,Integer scoreType) throws Exception {

		log.info("update score:"+score+",update comment:"+comment+",get uid:"+uid+"");
		if(DataUtils.isNullOrEmpty(score)){
			log.error("score is null");
			model.addAttribute("code",-1);
			return "/common/success";
		}else {
			log.info("score is :" + score);
		}
		if(DataUtils.isNullOrEmpty(uid)){
			log.error("uid is null");
			model.addAttribute("code",-1);
			return "/common/success";
		}else {
			log.info("uid is :" + uid);
		}
		User user = userService.getObjectById(uid);
		if (DataUtils.isNullOrEmpty(user)) {
			log.info("add leaves error :user == null");
			model.addAttribute("code", -5003);
			return "/common/success";
		} else if (!(user.getType().equals(User.TYPE_OFFLINE))) {
			log.info("add leaves error :user type != offline");
			model.addAttribute("code", -19005);
			return "/common/success";
		}

		try {

			log.info("user is ：" + user);
			int oldScore = user.getScore();

			long newScore;

			if (scoreType == 0){
				newScore=(long) oldScore + score;
			}else {
				newScore=(long) oldScore - score;
			}
			log.info("oldScore is " + oldScore + "newScore :" + newScore);


			log.info(" ====update self userInfo==== " + uid);
			 UserScore userScore= new UserScore();
			//设置userScore的对象属性
			userScore.setUid(uid);
			if(scoreType == 1){
				userScore.setScore(-score);
			}else {
				userScore.setScore(+score);
			}
			userScore.setComment(comment);
			userScore.setScoreType(scoreType);
			user.setScore((int)newScore);
			log.info("user.score is :" + user.getScore());
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			userScore.setCreateBy(Long.parseLong(userId));
			userScore.setUpdateBy(Long.parseLong(userId));

			userScoreService.insert(userScore);
			userService.update(user);

			//更新用户信息

			user.setIsLook(user.getIsLook() + 1);
			user.setLatestMsg(Message.SCORE_TYPE);
			userService.update(user);

			// 发送信息
			Message message = new Message();
			message.setStatus(1);
			message.setReceiveName(user.getNick());
			message.setSendName("admin");
			message.setSendId(0L);
			message.setContent("");
			message.setReceiveId(uid);
			message.setUnread(1);
			message.setType("score");


			Long mid = messageService.insert(message);

			message = this.messageService.getObjectById(mid);
			String content;
			if (scoreType == 0) {
				content = "<span  class=\"font-16px system-alert-outline \">您得到了积分奖励，" +
						"<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
						"/school/"+uid+"/score///0\" target=\"_blank\">点击查看</a></span>";
			} else {
				content = "<span  class=\"font-16px system-alert-outline \">您的积分已消费，" +
						"<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
						"/school/"+uid+"/score///1\" target=\"_blank\">点击查看</a></span>";
			}


			log.info("user : " + user.getMobile() + " send : " + content);
			adminSend(user.getMobile(), content);
			message.setContent(content);
			messageService.update(message);
			model.addAttribute("code", 0);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userScore error,score is "+score+"  comment is "+comment+"");
			model.addAttribute("code", -1);

		}
//
		return "/common/success";
	}

	public static String adminSend(String mobile, String content) {
		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
		log.info(result);
		return result;
	}

	@RequestMapping(value = "a/u/userScoreUpDown/{id}", method = RequestMethod.GET)
	public String getUserScore(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userScore/" + id + "  to /userScore/view/userScoreDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-skill-service/userScore/view/userScoreDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userScore/{id}", method = RequestMethod.GET)
	public String getUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserScore userScore = userScoreService.getObjectById(id);
			log.info("get userScore data is " + userScore);

			model.addAttribute("code", 0);

			model.addAttribute("userScore", userScore);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userScore/json/userScoreDetailJson";
	}



	@RequestMapping(value = "/a/u/userScoreUpDown", method = RequestMethod.POST)
	public String addUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserScore userScore) throws Exception {

		log.info("update userScore : userScore= " + userScore);

		try {
			userScore.setId(null);

			userScoreService.insert(userScore);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userScore error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userScore/{id}", method = RequestMethod.DELETE)
	public String deleteUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userScore : id= " + id);
		try {
			userScoreService.delete(id);

			log.info("add userScore success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userScore error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/a/multi/userScore", method = RequestMethod.GET)
	public String getMultiUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<UserScore> userScoreList = userScoreService.getObjectsByIds(idList);
			log.info("get  userScore data is " + userScoreList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",userScoreList.size());

			model.addAttribute("userScoreList", userScoreList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userScore/json/userScoreListJson";
	}
	

}

