package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Stage;
import com.ptteng.common.skill.model.Task;
import com.ptteng.common.skill.service.ArticleService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.StageService;
import com.ptteng.common.skill.service.TaskService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Stage  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class StageController {
	private static final Log log = LogFactory.getLog(StageController.class);

	@Autowired
	private StageService stageService;

	@Autowired
	private TaskService taskService;

	@Autowired
	private OccupationService occupationService;

	@Autowired
	private CookieUtil cookieUtil;




    /**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//职业阶段列表
	@RequestMapping(value = "/a/u/occupation/{oid}/stage", method = RequestMethod.GET)
	public String getStageList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long oid, Integer page, Integer size) throws Exception {

		log.info("get stage list:oid"+oid);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			if (oid==null){
				log.info("occupation id cannot be null");
				model.addAttribute("code", -24001);
			}else {
				List<Long> stageIds = stageService.getStageIdsByOidOrderBySort(oid,start,size);
				List<Stage> stages = stageService.getObjectsByIds(stageIds);
				log.info("stages count is"+stages.size());
				Integer total = stageService.countStageIdsByOidOrderBySort(oid);
				log.info("the total count is"+total);

				model.addAttribute("code", 0);
				model.addAttribute("total", total);
				model.addAttribute("stages", stages);
				model.addAttribute("page",page);
				model.addAttribute("size",size);
			}
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("select stage error ");
			model.addAttribute("code", -1);
		}

		log.info("/stage  to /stage/json/stageList");

		return "/common-skill-service/stage/json/stageListJson";
	}

    //职业阶段列表拖动排序
	@RequestMapping(value = "/a/u/occupation/{oid}/stage/sort", method = RequestMethod.POST)
	public String sortStage(HttpServletRequest request,
							HttpServletResponse response, ModelMap model,@RequestBody List<Long> ids)
			throws Exception{
		log.info("sort stage:ids="+ids);
		try {
			List<Stage> stages = this.stageService.getObjectsByIds(ids);
			int index = 0;
			for (Stage stage:stages){
				stage.setSort(index);
				index = index +10;
			}
			this.stageService.updateList(stages);
			model.addAttribute("code",0);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("order stages error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}




	//阶段详情
	@RequestMapping(value = "/a/u/stage/{id}", method = RequestMethod.GET)
	public String getStageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("stage id cannot be null");
			model.addAttribute("code", -24000);
		}
		try {
			Stage stage = this.stageService.getObjectById(id);
			log.info("get stage data is " + stage);

			model.addAttribute("code", 0);

			model.addAttribute("stage", stage);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get stage error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/stage/json/stageDetailJson";
	}
    //修改阶段
	@RequestMapping(value = "/a/u/stage/{id}", method = RequestMethod.PUT)
	public String updateStageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, Stage stage) throws Exception {

		log.info("update stage : stage= " + stage);

		try {
			Long oid=stage.getOid();

			Occupation occupation = occupationService.getObjectById(oid);

			if(occupation.equals(null)){
				log.info("the occupation is null");
				model.addAttribute("code", -9005);
				return "/common/success";
			}
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			stage.setUpdateBy(Long.parseLong(userId));

			stageService.update(stage);
			model.addAttribute("code", 0);
			model.addAttribute("stage", stage);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update stage error,id is  " + stage.getId());
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

    //获取阶段列表数据长度
	private Integer getStageSize() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getSingleFieldParam(
				"sort desc", "stage");
		List<Long> sizes = this.stageService.getIdsByDynamicCondition(
				Stage.class, param, 0, Integer.MAX_VALUE);
		int size = 0;
		if (CollectionUtils.isEmpty(sizes)) {
			log.info("first order ");

		} else {
			Long sizeId = sizes.get(0);
			Stage stage = this.stageService.getObjectById(sizeId);

			size =stage.getSort().intValue();
			log.info("quiz size order is" + size);
		}
		return size+3;
	}


	//新增阶段
	@RequestMapping(value = "/a/u/stage", method = RequestMethod.POST)
	public String addStageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Stage stage) throws Exception {

		log.info("update stage : stage= " + stage);
		if (stage.getOid()==null){
			log.info("occupation id cannot be null");
			model.addAttribute("code", -24001);
		}
		if (stage.getName()==null){
			log.info("stageName  cannot be null");
			model.addAttribute("code", -24002);
		}
		try {
			int size = this.getStageSize();

			stage.setSort(size);
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			stage.setCreateBy(Long.parseLong(userId));
			stage.setUpdateBy(Long.parseLong(userId));

			stageService.insert(stage);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add stage error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	//删除阶段
	@RequestMapping(value = "/a/u/stage/{id}", method = RequestMethod.DELETE)
	public String deleteStageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete stage : id= " + id);
		if (id==null){
			log.info("stage id cannot be null");
			model.addAttribute("code", -24000);
			return "/common/success";
		}
		try {
			int size =10;
			int page =1;
			int start = (page - 1) * size;
			if (start < 0) {
				start = 0;
			}
			//先查询该阶段下是否有任务
			Long sid = id;//将阶段id赋值给sid
			Map<String, Object> param = DynamicUtil.getTaskListParam(sid, false);
			List<Long> ids = this.taskService.getIdsByDynamicCondition(Task.class, param, start, size + 1);
			if (ids.size()>0){
				log.info("must delete task first");
				model.addAttribute("code", -24003);

			}else {
				stageService.delete(id);
				log.info("delete stage success");
				model.addAttribute("code", 0);
				return "/common/success";
			}
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete stage error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

}

