package com.ptteng.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;

/**
 * Created by ouyang on 2016/12/16.
 */
public class ComputeUtil {

    private static final Log log = LogFactory.getLog(ComputeUtil.class);

    /**
     * 向上取整
     * @param numerator
     * @param denominator
     * @return Long
     */
    public static Long myDivideiCeil(Long numerator, Integer denominator) {
        BigDecimal b1 = new BigDecimal(numerator),
                b2 = new BigDecimal(denominator);
        BigDecimal b3 = b1.divide(b2, 0, BigDecimal.ROUND_CEILING);
        return b3.longValue();
    }

    /**
     * 向上取整
     * @param numerator
     * @param denominator
     * @return String
     */
    public static String myDivideiCeil(Long numerator, Long denominator) {
        BigDecimal b1 = new BigDecimal(numerator),
                b2 = new BigDecimal(denominator);
        BigDecimal b3 = b1.divide(b2, 4, BigDecimal.ROUND_CEILING);
        return b3.toString();
    }
}
