package com.ptteng.controller;

import java.lang.ref.PhantomReference;
import java.security.acl.Owner;
import java.util.*;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.aliyun.oss.common.utils.DateUtil;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.common.skill.service.ManagerService;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sleepycat.je.tree.IN;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.OBJ_ADAPTER;
import org.restlet.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;

/**
 * Ctype  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class CtypeController {
    private static final Log log = LogFactory.getLog(CtypeController.class);

    @Autowired
    private CtypeService ctypeService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private CardService cardService;

    @Autowired
    private ManagerService managerService;


    //卡券类型禁用启用
    /**
     * @param id;
     * @param status;
     * @return /data/json；
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/cardType/{id}/status/{status}", method = RequestMethod.PUT)
    public String editCardTypeStatus(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer status)
            throws Exception {

        //参数校验
        if (id == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("update ctype id is" + id);
        }
        if (status == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("updata cypte status is" + status);
        }


        try {
            Ctype ctype = ctypeService.getObjectById(id);

            //获取类型下卡券
            Map<String ,Object> param = new HashMap<String, Object>();
            param.put(" tid ", id);
            param.put("@table","card");

            List<Long> cids = cardService.getIdsByDynamicCondition(Ctype.class,param,0,Integer.MAX_VALUE);
            List<Card> cards=null;
            if (cids.isEmpty()){
                log.info("There is no card in this type");
            }else {
                log.info("The number of coupons for this type is" + cids.size());
                cards = cardService.getObjectsByIds(cids);
            }





            //卡券类型禁用启用,传参不一致则修改数据库
            if (status == Ctype.Status_Enable) {//禁用
                ctype.setStatus(Ctype.Status_Disable);
                if (cards != null){
                    for (Card card: cards){
                        card.setTypeValid(Ctype.Status_Disable);
                    }
                }
                log.info("update ctype status is " + Ctype.Status_Disable);

            } else if (status == Ctype.Status_Disable) {//启用
                ctype.setStatus(Ctype.Status_Enable);
                if (cards != null){
                    for (Card card: cards){
                        card.setTypeValid(Ctype.Status_Enable);
                    }
                }
                log.info("update ctype status is " + Ctype.Status_Enable);
            } else {
                model.addAttribute("code", -23018);
                return "/data/json";
            }

            boolean update= ctypeService.update(ctype);
            if (update){
                cardService.updateList(cards);
                log.info("update ctype status success, ctype id is " + id);
                log.info("update card typeValid success, ctype id is ");
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ctype error,id is  " + id);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/data/json";
    }



    //卡券类型列表
    /**
     * @param page;
     * @param size;
     * @param status;
     * @param title;
     * @param createStartAt;
     * @param createEndAt;
     * @param createBy;
     * @return /common-skill-service/ctype/json/ctypeListJson；
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/cardType/search", method = RequestMethod.GET)
    public String getCtypeIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                             HttpServletResponse response, ModelMap model, Integer page, Integer size, Integer status, String title, Long createStartAt, Long createEndAt, String createBy
    ) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size + " , title=" +title + " , status=" +status +
                " , createStartAt=" +createStartAt +  " , createEndAt=" + createEndAt + " , createBy=" + createBy );

        try {
            //获取卡券类型列表\
            Map<String, Object>   param;
            if (createBy !=null && !createBy.isEmpty()){
                Map<String,Object> managerParam =new HashMap<String, Object>();
                managerParam.put(" name & like","'%"+createBy+"%'");
                List<Long> managerIds = managerService.getIdsByDynamicCondition(Manager.class,managerParam,0,Integer.MAX_VALUE);
                createBy=org.apache.commons.lang3.StringUtils.join(managerIds,",");

                Card[] cardList={};
                if( createBy ==null || createBy.isEmpty() ){
                    model.addAttribute("code",0);
                    model.addAttribute("page", page);
                    model.addAttribute("size", size);
                    model.addAttribute("total", 0);
                    model.addAttribute("cardList",cardList );
                    return "/common-skill-service/card/json/cardListJson";
                }

                log.info("ctype createBy is " + createBy);
                param = DynamicUtil.getCardsTypeQueryListByCreateByParam(title, status, createStartAt, createEndAt, createBy, false);
                log.info("get cardType params is: " + param);
            }else {
                param = DynamicUtil.getCardsTypeQueryListParam(title, status, createStartAt, createEndAt, createBy, false);
                log.info("get cardType params is: " + param);
            }






            List<Long> tids = ctypeService.getIdsByDynamicCondition(Ctype.class, param, start, size);
            Integer total = ctypeService.getIdsByDynamicCondition(Ctype.class, param, 0, Integer.MAX_VALUE).size();
            log.info("get Ctype size is " + tids.size()+"tis is  " +tids) ;

            if (tids.isEmpty()) {
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", 0);
                model.addAttribute("ctypeList", tids);
                return "/common-skill-service/ctype/json/ctypeListJson";
            }

            List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
            List<Long> managerIds=managerService.getManagerIds(0,Integer.MAX_VALUE);
            log.info("get managerIds size is " + managerIds.size());
            List<Manager> managers = managerService.getObjectsByIds(managerIds);
            Map<Long, User> manager = MyListUtil.convert2Map(Manager.class.getDeclaredField("id"), managers);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("ctypeList", ctypeList);
            model.addAttribute("manager", manager);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ctype list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/ctype/json/ctypeListJson";
    }

    /**
     * @param id;
     * @throws Exception;
     */
    //查看卡券类型详情
    @RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.GET)
    public String getCtypeJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Ctype ctype = ctypeService.getObjectById(id);

            Float ctypeExpire = (float) ctype.getExpire()/86400000L;

            model.addAttribute("code", 0);

            model.addAttribute("ctype", ctype);
            model.addAttribute("expire", ctypeExpire);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ctype error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/ctype/json/ctypeDetailJson";
    }



    //编辑卡券类型
    /**
     * @param id;
     * @param title;
     * @param img;
     * @param description;
     * @param expire;
     * @return /common-skill-service/ctype/json/ctypeListJson；
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.PUT)
    public String updateCtypeJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model,
                                  @PathVariable Long id, String title, String img, String description,
                                  Float expire) throws Exception {

        log.info("card type params, title: " + title + ", img: " + img + ", description: " + description + ", expire: " + expire);

        //传参检查
        if (id == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("ctype update , id is " + id);
        }

        if (title == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The title of the ctype is " + title);
        }

        if (img == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The img of the ctype is " + img);
        }

        if (description == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The description of the ctype is " + description);
        }
        Integer expireMs;
        if (expire == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The expire of the ctype is " + expire);
            expireMs = (int) (expire*86400000);
        }
        Ctype orignCard;
        try {
            //获取cookie中用户id
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            log.info("update ctype, uid is" + uid);
            //原卡券信息
            orignCard = ctypeService.getObjectById(id);
            orignCard.setId(id);
            orignCard.setTitle(title);
            orignCard.setImg(img);
            orignCard.setDescription(description);
            orignCard.setExpire(expireMs);
            orignCard.setStatus(orignCard.getStatus());
            orignCard.setCreateBy(uid);
            orignCard.setUpdateBy(uid);
            orignCard.setCreateCount(orignCard.getCreateCount());
            orignCard.setAssignCount(orignCard.getAssignCount());
            orignCard.setVerifyingCount(orignCard.getVerifyingCount());
            orignCard.setVerifiedCount(orignCard.getVerifiedCount());
            orignCard.setCessionCount(orignCard.getCessionCount());
            orignCard.setExpiredCount(orignCard.getExpiredCount());


            ctypeService.update(orignCard);
            log.info("update ctype success ,ctype id is" + id);

            model.addAttribute("code", 0);

            model.addAttribute("ctype", orignCard);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update ctype error,id is  " + id );
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }


    //新增卡券类型
    /**
     * @param title;
     * @param img;
     * @param description;
     * @param expire;
     * @return /common-skill-service/ctype/json/ctypeListJson；
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/cardType", method = RequestMethod.POST)
    public String addCtypeJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, String title, String img, String description, Float expire) throws Exception {


        //传参检查
        if (title == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The title of the ctype is " + title);
        }

        if (img == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The img of the ctype is " + img);
        }

        if (description == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The description of the ctype is " + description);
        }
        //小数转化为整毫秒
        Integer expireMs;
        if (expire == null) {
            model.addAttribute("code", -1000);
            return "/data/json";
        } else {
            log.info("The expire of the ctype is " + expire);
            expireMs = (int) (expire*86400000);
        }




        try {
            //获取cookie中用户id
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            Ctype ctype = new Ctype();

            //检查是否有重名
            Map <String ,Object> param = DynamicUtil.getCtypeQueryByTitleParam(title,true);
            List<Long> ctypeIds = ctypeService.getIdsByDynamicCondition(Ctype.class,param,0,Integer.MAX_VALUE);
            if (ctypeIds.get(0).intValue()>0){
                model.addAttribute("code", -21023);
                return "/data/json";
            }


            ctype.setTitle(title);
            ctype.setImg(img);
            ctype.setDescription(description);
            ctype.setExpire(expireMs);
            //默认新增类型状态为禁用
            ctype.setStatus(Ctype.Status_Disable);
            ctype.setCreateBy(uid);
            ctype.setUpdateBy(uid);
            //设置卡券计数
            ctype.setCreateCount(Ctype.Statistics_InitialValue);
            ctype.setAssignCount(Ctype.Statistics_InitialValue);
            ctype.setVerifyingCount(Ctype.Statistics_InitialValue);
            ctype.setExpiredCount(Ctype.Statistics_InitialValue);
            ctype.setCessionCount(Ctype.Statistics_InitialValue);
            ctype.setVerifiedCount(Ctype.Statistics_InitialValue);

            ctypeService.insert(ctype);
            log.info("insert ctype is success");
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add ctype error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }


    //删除卡券类型
    /**
     * @param id;
     * @return /data/json；
     * @throws Exception；
     */
    @RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.DELETE)
    public String deleteCtypeJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete ctype : id= " + id);
        if (id == null) {
            model.addAttribute("code",-1000);
            return "/data/json";
        }

        try {
            //判断ID是否有效
            Ctype ctype = ctypeService.getObjectById(id);

            if (ctype == null) {
                model.addAttribute("code", -21002);
                log.info("The ctype does not exist");
                return "/common/success";
            }

            // get total
            Map<String, Object> paramCount = DynamicUtil.getCtypeInCardsQueryListParam(id, null, null, false);
            log.info("paramCount is " + paramCount);
            List<Long> ids = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);
            log.info("delete ctype, ctype id is " + id +" , Number of cards :" + ids.size());

            //判断是否符合删除条件
            if (ids.isEmpty()) {
                ctypeService.delete(id);
                log.info("delete ctype success, ctype id is " + id );
                model.addAttribute("code", 0);
            } else {
                model.addAttribute("code", -21019);
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete ctype error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


//    @RequestMapping(value = "/a/multi/ctype", method = RequestMethod.GET)
//    public String getMultiCtypeJson(HttpServletRequest request,
//                                    HttpServletResponse response, ModelMap model, Long[] ids)
//            throws Exception {
//
//        List<Long> idList = new ArrayList();
//        if (ids == null) {
//
//        } else {
//            idList = Arrays.asList(ids);
//        }
//        try {
//
//
//            List<Ctype> ctypeList = ctypeService.getObjectsByIds(idList);
//            log.info("get  ctype data is " + ctypeList.size());
//
//            model.addAttribute("code", 0);
//            model.addAttribute("total", ctypeList.size());
//
//            model.addAttribute("ctypeList", ctypeList);
//
//        } catch (Throwable t) {
//            log.error(t.getMessage());
//            log.error("get ctype error,id is  " + idList);
//            model.addAttribute("code", -100000);
//        }
//
//        return "/skill-service/ctype/json/ctypeListJson";
//    }


}

