package com.ptteng.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.Document;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sleepycat.je.tree.IN;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import com.ptteng.common.skill.model.Contents;
import com.ptteng.common.skill.service.ContentsService;

/**
 * Contents  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ContentsController {
	private static final Log log = LogFactory.getLog(ContentsController.class);

	@Autowired
	private ContentsService contentsService;

	@Autowired
	private CookieUtil cookieUtil;


	/**
	* 获取单个内容信息
	* @param request
	* @param response
	* @param model
	* @param id
	* @return
	* @throws Exception
	* */
	@RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.GET)
	public String getContents(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		if (id.equals(null)) {
			model.addAttribute("code", -17003);
			log.info("id is null");
			return "/common/success";
		}

		log.info("get  content : content id = " + id);

		try {

			Contents contents = contentsService.getObjectById(id);
			if (contents == null) {
				model.addAttribute("code", -17002);
				log.info("no this contents");
				return  "/common/success";
			} else {
				log.info("get contents data is " + contents);
				model.addAttribute("contents", contents);
				model.addAttribute("code", 0);
			}


		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get contents error, id is " +id);
			model.addAttribute("code", -17001);
		}


		return "/common-skill-service/contents/json/contentsDetailJson";
	}


	/*
	 * 修改单个内容信息
	 * */
	@RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.PUT)
	public String updateContentsJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Contents contents, @PathVariable Long id) throws Exception {

		log.info("update contents : contents= " + contents);



		if (contents == null || contents.getId() == null || contents.getType() == null || contents.getStatus() == null) {
			model.addAttribute("code",-17002);
			log.info("id/type/status is null, id: " + id);
			return "/data/json";
		} else {
			log.info("contents params is ok, id: " + id);
		}

		Contents orignContent = contentsService.getObjectById(id);
		if (orignContent == null) {
			model.addAttribute("code",-17001);
			log.info(id + " contents is null");
			return "/data/json";
		} else {
			log.info("contents " + id + " is ready");
		}


		String userId = cookieUtil.getKeyIdentity(request,
				CookieUtil.USER_ID);

		contents.setCreateAt(orignContent.getCreateAt());
		contents.setCreateBy(orignContent.getCreateBy());
		contents.setUpdateBy(Long.parseLong(userId));
		contents.setPublishAt(System.currentTimeMillis());

		try {

			boolean result =  contentsService.update(contents);
			if (result) {
				log.info(id + " contents update success");
			} else {
				log.info(id + " contents update fail");
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update contents error,id is  " + contents.getId());
			model.addAttribute("code", -17001);
		}



		model.addAttribute("code", 0);
		model.addAttribute("contents", contents);

		return "/data/json";
	}


	/*
	 * 新增单个内容信息
	 * */
	@RequestMapping(value = "/a/u/contents", method = RequestMethod.POST)
	public String addContentsJson(HttpServletRequest request,
								  HttpServletResponse response, ModelMap model, Contents contents) throws Exception {

		log.info("update contents : contents= " + contents);


		contents.setId(null);

		String userId = cookieUtil.getKeyIdentity(request,
				CookieUtil.USER_ID);
		contents.setCreateAt(System.currentTimeMillis());
		contents.setCreateBy(Long.parseLong(userId));
		contents.setUpdateBy(Long.parseLong(userId));
		contents.setPublishAt(System.currentTimeMillis());

		try {
			Long result = contentsService.insert(contents);
			log.info(result);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update contents error ");
			model.addAttribute("code", -17004);
		}

		model.addAttribute("code", 0);
		return "/data/json";
	}
	/*
	 * 删除单个内容信息
	 * */
	@RequestMapping(value = "/a/u/contents/{id}", method = RequestMethod.DELETE)
	public String deleteContentsJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete contents : id= " + id);
		try {
			contentsService.delete(id);

			log.info("add contents success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete contents error,id is  " + id);
			model.addAttribute("code", -17005);

		}

		return "/data/json";
	}

	/*
	 * 上架下架
	 * */
	@RequestMapping(value= "/a/u/contents/{id}/status/{status}", method = RequestMethod.PUT)
	public String updateContentsStatus(HttpServletRequest request,
									   HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer status) throws Exception {

		log.info("content id is: " + id + ", status is: " + status);

		if (id == null) {
			model.addAttribute("code",-17002);
			log.info("content id is null");
			return "/data/json";
		} else {
			log.info("content id is: " + id);
		}
		if (status == null) {
			model.addAttribute("code",-17002);
			log.info("content status is null");
			return "/data/json";
		} else {
			log.info("content status is not null: " + status);
		}
		if (status != 1 && status != 0) {
			model.addAttribute("code",-17006);
			log.info("content status value is not legal： " + status);
			return "/data/json";
		} else {
			log.info("content status is equal 0 or 1: " + status);
		}

		try {
			Contents content = contentsService.getObjectById(id);

			if (content.getStatus() == status.intValue()) {
				log.info("content status is equal, no need update status: " + status);
			} else {
				String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
				content.setStatus(status);
				content.setUpdateAt(System.currentTimeMillis());
				content.setUpdateBy(Long.parseLong(userId));
				content.setPublishAt(System.currentTimeMillis());

				boolean result =  contentsService.update(content);
				if (result) {
					log.info(id + " contents update success");
				} else {
					log.info(id + " contents update fail");
				}
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update contents status error, id is  " + id);
			model.addAttribute("code", -17001);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}




	/**
	 * 内容搜索
	 * @param request
	 * @param response
	 * @param model
	 * @param type
	 * @param title
	 * @param status
	 * @param createBy
	 * @param createStartAt
	 * @param createEndAt
	 * @param publishStartAt
	 * @param publishEndAt
	 * @param page
	 * @param size
	 * @return
	 */
	@RequestMapping(value = "/a/u/contents/search", method = RequestMethod.GET)
	public String searchContents(HttpServletRequest request,
								 HttpServletResponse response,
								 ModelMap model,
								 Integer[] type,
								 Integer status,
								 String title,
								 Long createBy,
								 Long createStartAt,
								 Long createEndAt,
								 Long publishStartAt,
								 Long publishEndAt,
								 Integer page,
								 Integer size
								 ) {
		/* 1 初始化参数 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("pageList : start= " + start + " , size=" + size);
		try {

			Map<String, Object> param = DynamicUtil.getContentsQueryListParam(type, status, title, createBy, createStartAt, createEndAt,publishStartAt,publishEndAt,false);
			log.info("contents params is: " + param);

			List<Long> ids = contentsService.getIdsByDynamicCondition(Contents.class, param, start, size);
			log.info("the ids is " + ids);


			List<Contents> contentsList = contentsService.getObjectsByIds(ids);
			log.info("get contents data is " + contentsList.size());


			// get total
			Map<String, Object> paramCount = DynamicUtil.getContentsQueryListParam(type, status, title, createBy, createStartAt, createEndAt,publishStartAt,publishEndAt,true);
			log.info("count content sql: " + paramCount);
			List<Long> totalList = contentsService.getIdsByDynamicCondition(Contents.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("count contents list: " + totalList);
			Integer total = totalList.get(0).intValue();
			log.info("get contents size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("contentsList", contentsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get contentsList error");
			model.addAttribute("code", -17001);
		}

		return "/common-skill-service/contents/json/contentsListJson";
	}



	@RequestMapping(value = "/a/u/contents/sort", method = RequestMethod.PUT)
	public String sortContents(HttpServletRequest request,
							   HttpServletResponse response,
							   ModelMap model,
							   @RequestParam(value = "ids[]") Long[] ids) throws Exception {

		if (ids == null) {
			log.info("sort contents ids is null");
			model.addAttribute("code", -17003);
			return "/data/json";
		} else {
			log.info("sort contents : ids= " + ids);
		}

		List<Long> idList = new ArrayList();
		idList = Arrays.asList(ids);

		try {

			List<Contents> contents = this.contentsService.getObjectsByIds(idList);

			int index = 0;
			for (Contents content : contents) {
				content.setLevel(index);
				index = index + 10;
			}
			this.contentsService.updateList(contents);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("sort contents error,ids is  " + ids);
			model.addAttribute("code", -17007);
		}

		return "/data/json";
	}

	
	
	
	
}

