package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Goods;
import com.ptteng.common.skill.model.Order;
import com.ptteng.common.skill.service.GoodsService;
import com.ptteng.common.skill.service.OrderService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Goods  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class GoodsController {
	private static final Log log = LogFactory.getLog(GoodsController.class);

	@Autowired
	private GoodsService goodsService;


   @Autowired
   private OrderService orderService;

    /**
	 *
	 * @param
	 * @returno
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

		@RequestMapping(value = "/a/u/goods", method = RequestMethod.GET)
	public String getGoodsIdsByBuyerAndIsConfirmJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long buyer,Integer isConfirm) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {


			List<Long> ids= goodsService.getGoodsIds(start, size);
		log.info("get countGoodsIdsByBuyerAndIsConfirm size is " + ids.size());

			List<Goods> goodsList = goodsService.getObjectsByIds(ids);
			log.info("get goods data is " + goodsList.size());

			Integer total = goodsService. countGoodsIds();
			log.info("get goods count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}







	/**
	 * 获取订单的产品列表
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/goods/order/{oid}/{uid} ", method = RequestMethod.GET)
	public String getGoodsForOrder(HttpServletRequest request,
								   HttpServletResponse response, ModelMap model, Integer page,
								   Integer size,@PathVariable Long uid,Integer isConfirm,@PathVariable String oid) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {


			List<Long> ids = goodsService.getGoodsByBuyerAndOrderid(uid, oid, start, size);
			log.info("get countGoodsIdsByBuyerAndIsConfirm size is " + ids.size());

			List<Goods> goodsList = goodsService.getObjectsByIds(ids);

			log.info("get goods data is " + goodsList.size());

			Integer total = goodsService.countGoodsIdsByBuyerAndIsConfirm(uid, 1);
			log.info("get goods count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}










	@RequestMapping(value = "/a/u/goods/{id}", method = RequestMethod.GET)
	public String getGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Goods goods = goodsService.getObjectById(id);
			log.info("get goods data is " + goods);

			model.addAttribute("code", 0);

			model.addAttribute("goods", goods);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/goods/json/goodsDetailJson";
	}

	@RequestMapping(value = "/a/u/goods/{id}", method = RequestMethod.PUT)
	public String updateGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Goods goods) throws Exception {

		log.info("update goods : goods= " + goods);

		try {

			goodsService.update(goods);

			model.addAttribute("code", 0);

			model.addAttribute("goods", goods);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update goods error,id is  " + goods.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

//	@RequestMapping(value = "/a/u/goods", method = RequestMethod.POST)
//	public String addGoodsJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Goods goods) throws Exception {
//
//		log.info("update goods : goods= " + goods);
//		try {
//			goods.setId(null);
//
//			goodsService.insert(goods);
//
//			model.addAttribute("code", 0);
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("add goods error ");
//			model.addAttribute("code", -6002);
//		}
//
//		return "/data/json";
//	}

	@RequestMapping(value = "/a/u/goods/{id}", method = RequestMethod.DELETE)
	public String deleteGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete goods : id= " + id);
		try {
			goodsService.delete(id);

			log.info("add goods success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete goods error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/web/a/multi/goods", method = RequestMethod.GET)
	public String getMultiGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Goods> goodsList = goodsService.getObjectsByIds(idList);
			log.info("get  goods data is " + goodsList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",goodsList.size());

			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get goods error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}


}

