package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    StringBuffer sbuf = new StringBuffer();

    @Autowired
    private UserService userService;

    @Autowired
    private ClassesService classesService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private TeacherService teacherService;

    @Autowired
    private BranchInstituteService branchInstituteService;

    /**
     * 移交师弟
     *
     * @param request
     * @param response
     * @param model
     * @param uid      要移交到的师兄的ID
     * @param type     动作类型{move:移交}
     * @param uids     师弟们的ID
     * @return
     */
    @RequestMapping(value = "/a/u/student/{type}/{uid}", method = RequestMethod.PUT)
    public String getHisStudent(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long uid, @PathVariable String type, Long[] uids) {
        log.info(" put /a/u/student/{type}/{uid} uid =" + uid + " type " + type + " uids " + uids + " to uid " + uid + " start ... ");
        //校验
        if (DataUtils.isNullOrEmpty(uids)) {
            model.addAttribute("code", -1000);
            return "/data/json";
        }

        List<Long> uidList = Arrays.asList(uids);
        try {
            User teacher = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(teacher)) {
                model.addAttribute("code", -15008);
                return "/data/json";
            }
            //校验被移交人身份
            if (User.IDENTIFY_40.equals(teacher.getIdentity())
                    || User.IDENTIFY_50.equals(teacher.getIdentity())
                    || User.IDENTIFY_60.equals(teacher.getIdentity())
                    || User.IDENTIFY_70.equals(teacher.getIdentity())) {
                log.info(" teacher identity is correct ");
            } else {
                log.info(" teacher identity is not correct ");
                model.addAttribute("code", -15013);
                return "/data/json";
            }
            //校验是否在师兄名单，若不在，加入到师兄名单
            Teacher teacherYes = teacherService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(teacherYes)) {
                log.info(" user is not a teacher ,so add ");
                teacherYes = addTeacher(uid);
            }

            Long studentId = uids[0];
            User student = userService.getObjectById(studentId);
            Long oid = 0L;
            Long oldTeacherId = 0L;
            if (DataUtils.isNotNullOrEmpty(student)) {
                oid = student.getOid();
                oldTeacherId = student.getTeacherId();
            }
            User oldTeacher = userService.getObjectById(oldTeacherId);
            log.info(" student oid = " + oid + " old teacher is " + oldTeacherId);
            List<User> users = userService.getObjectsByIds(uidList);
            if (CollectionUtils.isEmpty(users)) {
                log.info(" get userList by uids ,get user List is null ");
            } else {
                for (User user : users) {
                    user.setTeacherId(uid);
                    //发送解除消息给师弟
                    sendMessageToStudent(user, oldTeacher, false);
                    //发送指派消息给师弟
                    sendMessageToStudent(user, teacher, true);
                }
                boolean update = userService.updateList(users);
                log.info(" update user's teacher id " + update);
            }
            //1.解除与原师兄的关系
            teacherService.dropTeacherRelationToStundent(users, oldTeacherId);
            sendMessageToTeacher(users, oldTeacher, false);
            //2.新增与现师兄的关系
            teacherService.addTeacherRelationToStundents(users, uid);
            sendMessageToTeacher(users, teacher, true);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(" move uids " + uids + " to uid " + uid + " error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    /**
     * 15.获取用户的师弟信息
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/user/{uid}/student", method = RequestMethod.GET)
    public String getHisStudent(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long uid, Integer page, Integer size) {

        log.info(uid + "  want to getHisStudentInfo");
        if (CheckDataUtil.isNull(uid)) {
            log.info(" uid is null ");
            model.addAttribute("code", -15002);
            return "/common/success";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            /* 1 获取自己的用户基础信息 */
            User teacher = userService.getObjectById(uid);
            if (CheckDataUtil.isNull(teacher)) {
                log.info(" user is null ");
                model.addAttribute("code", -15000);
                return "/common/success";
            }

            /* 2 获取师弟们的用户基础信息 */
            Long total = 0L,
                    totalPage = 1L;
            Set<Long> cids = new HashSet<>(),
                    oids = new HashSet<>();

            /* 获取该师兄单页要显示的师弟信息 */
            Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, false);
            log.info("get param:" + paramList);
            List<Long> studentUids = userService.getIdsByDynamicCondition(User.class, paramList, start, size);
            log.info("get studentUids:" + studentUids);
            List<User> studentList = userService.getObjectsByIds(studentUids);

            /* 获取该类别下师弟总数、总页数 */
            Map<String, Object> paramCount = DynamicUtil.getHisStudentRelationListParam(uid, true);
            List<Long> studentCount = userService.getIdsByDynamicCondition(UserDocumentRelation.class, paramCount, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(studentCount)) {
                total = studentCount.get(0);
                totalPage = ComputeUtil.myDivideiCeil(total, size);
            }

            /* 计算写日报率 */
            int studentSize = studentList.size();
            for (int i = 0; i < studentSize; i++) {
                User student = studentList.get(i);
                oids.add(student.getOid());
                cids.add(student.getCid());
            }
            log.info("their cids: " + cids);
            log.info("their oids: " + oids);

            /* 3 获取师弟们的职业信息 */
            List<Occupation> occupationList = occupationService.getObjectsByIds(new ArrayList<Long>(oids));

            /* 4 获取师弟们的班级信息 */
            List<Classes> classesList = this.classesService.getObjectsByIds(new ArrayList<Long>(cids));

            log.info("studentListde size :" + studentList.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("studentList", studentList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("classesList", classesList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error(uid + " failed in getting his students ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/hisStudentsInfo";
    }


    /**
     * 1.搜索用户
     *
     * @param oid
     * @param type
     * @param studyNumber
     * @param mobile
     * @param startAt
     * @param endAt
     * @param nick
     * @param status
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
    public String searchUserList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 Long uid, String mobile, Long oid, String type, Long studyNumber, Long startAt,
                                 Long endAt, String nick, Integer status, Integer identity,
                                 Long graduateStartAt, Long graduateEndAt, Integer branch, Long recommendId,
                                 String recommendMobile, Long teacherUid,
                                 Integer page, Integer size) {
        log.info(" teacherUid = " + teacherUid + " recommendId = " + recommendId);
        String paramStr = LogUtil.convertParam("searchUserList by==uid", uid, "mobile", mobile, "oid", oid, "type", type,
                "studyNumber", studyNumber, "startAt", startAt, "endAt", endAt, "branch", branch,
                "nick", nick, "status", status, "teacherUid", teacherUid, "recommendId", recommendId,
                "recommendMobile", recommendMobile, "page", page, "size", size);
        log.info(paramStr);

        /* 1 默认分页 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            /* 初始值 */
            List<User> userList = new ArrayList<>();
            List<Long> oids = new ArrayList<>();
            Long total = 0L,
                    totalPage = 1L;

            /* 2-1 入参有UID，按UID精准匹配userList */
            if (CheckDataUtil.isNotNull(uid)) {
                User user = userService.getObjectById(uid);
                if (CheckDataUtil.isNotNull(user)) {
                    userList.add(user);
                    log.info("userList" + userList);
                    oids.add(user.getOid());
                    total++;
                }

            /* 2-2 入参没有UID、手机号，则多条件模糊匹配userList */
            } else {

                Map<String, Object> paramList = DynamicUtil.getUserListParam(oid, type, studyNumber, status, mobile, nick, startAt, endAt,
                        identity, graduateStartAt, graduateEndAt, branch, recommendId, recommendMobile, teacherUid, false);
                log.info("get param:" + paramList);
                List<Long> userIds = userService.getIdsByDynamicCondition(User.class, paramList, start, size);
                log.info("get userIds:" + userIds);

                Map<String, Object> paramCount = DynamicUtil.getUserListParam(oid, type, studyNumber, status, mobile, nick, startAt, endAt,
                        identity, graduateStartAt, graduateEndAt, branch, recommendId, recommendMobile, teacherUid, true);
                log.info("get param:" + paramList);
                List<Long> userCount = userService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
                log.info("get userCount:" + userCount);

                /* 获取uesrList数据 */
                userList = userService.getObjectsByIds(userIds);
                log.info("userList" + userList);

                /* 获取total、totalPage */
                if (CollectionUtils.isNotEmpty(userCount)) {
                    total = userCount.get(0);
                    totalPage = ComputeUtil.myDivideiCeil(total, size);
                }

                /* 获取全部用户的职业ID */
                int userSize = userList.size();
                for (int i = 0; i < userSize; i++) {
                    User user = userList.get(i);
                    oids.add(user.getOid());
                }
            }

            /* 3 获得occupationList */
            List<Occupation> occupationList = new ArrayList<>();
            if (total > 0) {
                occupationList = occupationService.getObjectsByIds(oids);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("userList", userList);
            model.addAttribute("occupationList", occupationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search user error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }


    /**
     * 2.获取用户信息
     *
     * @param uid
     * @return
     */
    @RequestMapping(value = "/a/u/user/{uid}/detail", method = RequestMethod.GET)
    public String getUserDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long uid) {

        log.info(" getUserDetail by uid:" + uid);

        try {

            /* 1 获取用户基础信息 */
            User user = userService.getObjectById(uid);
            if (CheckDataUtil.isNull(user)) {
                log.info(" user doesn`t exist ");
                model.addAttribute("code", -15000);
                return "/common/success";
            }

            /* 2 获取用户拓展信息 */
            Teacher teacher = teacherService.getObjectById(uid);
            User teacherUser = userService.getObjectById(user.getTeacherId());


            /* 3 获取班级信息 */
            Long cid = user.getCid();
            Classes classes = null;
            if (CheckDataUtil.isNotNull(cid)) {
                classes = classesService.getObjectById(cid);
            }

            /* 4 获取职业信息 */
            Long oid = user.getOid();
            log.info(" oid = " + oid);
            Occupation occupation = null;
            if (CheckDataUtil.isNotNull(oid)) {
                occupation = occupationService.getObjectById(oid);
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("teacher", teacher);
            model.addAttribute("classes", classes);
            model.addAttribute("occupation", occupation);
            if (DataUtils.isNullOrEmpty(teacherUser)) {
                log.info(" user " + uid + " don't have teacher ");
                model.addAttribute("teacherName", "");
            } else {
                log.info(" user " + uid + " have teacher ");
                model.addAttribute("teacherName", teacherUser.getNick());
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get user error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userExDetailJson";
    }

    /**
     * 设置学员结业
     * @param request
     * @param response
     * @param model
     * @param uid
     * @return
     */
    @RequestMapping(value = "/a/u/user/graduate/{uid}", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @PathVariable Long uid, Integer relieve) {
        log.info(" update user ,set user graduated ");
        try {
            User user = userService.getObjectById(uid);
            //判断名下是否有师弟，如果有不能结业
            Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, false);
            log.info("get param:" + paramList);
            List<Long> studentUids = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(studentUids)) {
                log.info(" user don't have students ,so can graduate ");
            } else {
                model.addAttribute("code", -15016);
                return "/data/json";
            }

            //解除师兄弟关系判断
            Boolean relieveTeacher = true;
            Boolean relieveStudents = true;
            relieveRelation(user, relieveTeacher, relieveStudents);
            Long graduateAt = System.currentTimeMillis();
            user.setGraduateAt(graduateAt);

            userService.update(user);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" update user ,set user graduated  error ");
            model.addAttribute("code", -1);
        }

        model.addAttribute("code", 0);
        return "common/success";


    }

    /**
     * 3.修改用户信息
     *
     * @param uid
     * @param mobile
     * @param level
     * @param teacherUid
     * @param groupQQ
     * @return
     */
    @RequestMapping(value = "/a/u/user/{uid}", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @PathVariable Long uid, String mobile, Integer level, Long teacherUid,
                             String groupQQ, Integer identity, Long graduateAt, String entranceVideo, String graduatedVideo,
                             Long startAt, Integer status, String companyName, String salaryLow, String salaryHigh, Integer salary,
                             String nick, Integer studyNumber, Integer score) {

        String paramStr = LogUtil.convertParam("updateUser by==uid", uid, "mobile", mobile, "level", level,
                "teacherUid", teacherUid, "groupQQ", groupQQ, "status", status, nick, "nick", studyNumber, "studyNumber");
        log.info(paramStr);

        try {

            /*一、校验非空参数*/
            User user = userService.getObjectById(uid);
            if (CheckDataUtil.isNull(user)) {
                log.info(" user doesn`t exist ");
                model.addAttribute("code", -15000);
                return "/common/success";
            }

             /* 1 获取原始用户基础信息 */
            Long oid = user.getOid();
            Long newTeacherId = User.TeacherID_None;
            Long oldTeacherId = user.getTeacherId();
            User oldTeacher = new User();
            Teacher oldTeacherExd = new Teacher();
            User newTeacher = new User();
            if (DataUtils.isNullOrEmpty(oldTeacherId)) {

            } else {
                oldTeacher = userService.getObjectById(oldTeacherId);
                oldTeacherExd = teacherService.getObjectById(oldTeacherId);
            }
            /*二、修改用户基本信息*/
            /* 2 校验参数，并修改用户基础信息 */
            if (StringUtils.isNotBlank(mobile)) {
                if (CheckDataUtil.checkMobile(mobile)) {
                    user.setMobile(mobile);
                    log.info(" mobile is legal ");
                } else {
                    log.info(" mobile is illegal ");
                    model.addAttribute("code", -15006);
                    return "/common/success";
                }
            }

            if (CheckDataUtil.isNotNull(level)) {
                user.setLevel(level);
            }

            user.setGraduateAt(graduateAt);
            user.setEntranceVideo(entranceVideo);
            user.setGraduatedVideo(graduatedVideo);
            user.setStartAt(startAt);
            user.setStatus(status);
            user.setCompanyName(companyName);
            user.setSalaryLow(salaryLow);
            user.setSalaryHigh(salaryHigh);
            user.setSalary(salary);
            user.setNick(nick);
            user.setStudyNumber(studyNumber);
            user.setScore(score);
            //修改班级内的学号
            Long relationId = userClassRelationService.getUserClassRelationIdByCidAndUid(user.getCid(), uid);
            log.info(" relationId = " + relationId);
            if (DataUtils.isNotNullOrEmpty(relationId)) {
                log.info(" relationId is not null ");
                UserClassRelation relation = userClassRelationService.getObjectById(relationId);
                relation.setNum(Long.valueOf(studyNumber));
                userClassRelationService.update(relation);
            }
            /*校验是否需要自动分配师兄*/
            if (DataUtils.isNullOrEmpty(teacherUid)
                    || User.TeacherID_None.equals(teacherUid)) {
                log.info(" teacherUid is null,so need adopt new teacher to user " + uid);
                   /*四、用户身份信息相关逻辑*/
                if (User.IDENTIFY_50.equals(identity)) { //设置用户身份为首席弟子
                    log.info(" update user identity is chef ");
                /*1.判断用户当前身份是否是内门弟子*/
                    log.info(" 管理员不指定师兄，需要随机分配");
                          /* 2.分配真传弟子为师兄 */
                    newTeacherId = getTeacherIds(oid, User.IDENTIFY_60, Teacher.chef_now, "");
                    log.info(" code = " + newTeacherId);
                    if (newTeacherId < 0) {
                        model.addAttribute("code", newTeacherId);
                        //发送系统消息给修真院收官者
                        sendMessageToGM(user);
                        return "/common/success";
                    } else {
                        newTeacher = userService.getObjectById(newTeacherId);
                        if (CheckDataUtil.isNull(newTeacher)) {
                            log.info("appointed teacher doesn`t exist ");
                            model.addAttribute("code", -15005);
                            return "/common/success";
                        }
                    }
                }
            }

            /*三、指定师兄相关逻辑*/
            if (CheckDataUtil.isNull(oldTeacherId)) {
                oldTeacherId = User.TeacherID_None;
            }
            user.setIdentity(identity);
            /* 3-1 校验参数非空，则新增/修改用户的师兄关联 */
            if (CheckDataUtil.isNotNull(teacherUid) && !User.TeacherID_None.equals(teacherUid)) {
                User myTeacherInfo = userService.getObjectById(teacherUid);
                if (CheckDataUtil.isNull(myTeacherInfo)) {
                    log.info("appointed teacher doesn`t exist ");
                    model.addAttribute("code", -15005);
                    return "/common/success";
                }
                Teacher newTeacherExd = teacherService.getObjectById(teacherUid);
                /* 如指定的师兄还没有用户拓展信息，则新增一个 */
                if (CheckDataUtil.isNull(newTeacherExd)) {
                    newTeacherExd = addTeacher(teacherUid);
                }
                /* 如果teacherId发生变化了，需要更新两个师兄的统计量 */
                if (CheckDataUtil.notEqual(oldTeacherId, teacherUid)) {
                    //解除师兄弟关系
                    if (DataUtils.isNotNullOrEmpty(oldTeacherId)
                            && !User.TeacherID_None.equals(oldTeacherId)) {
                        log.info(" user old teacher id is " + oldTeacherId);
                        //修改统计值
                        if (DataUtils.isNotNullOrEmpty(oldTeacherExd)) {
                            List<User> students = new ArrayList<>();
                            students.add(user);
                            teacherService.dropTeacherRelationToStundent(students, oldTeacherId);
                        }
                        //各自发送推送消息
                        sendMessageToStudent(user, oldTeacher, false);
                        sendMessageToTeacher(user, oldTeacher, false);
                    }
                    //新建师兄弟关系
                    newTeacher = userService.getObjectById(teacherUid);
                    if (CheckDataUtil.isNull(newTeacher)) {
                        log.info("appointed teacher doesn`t exist ");
                        model.addAttribute("code", -15005);
                        return "/common/success";
                    }
                    if (DataUtils.isNullOrEmpty(newTeacherExd)) {//如果查到的真传弟子还不是师兄，将他的拓展信息插入到师兄表
                        log.info(" user id " + teacherUid + " haven't teacher ,so add ");
                        addTeacher(teacherUid);
                    }
                    user.setTeacherId(teacherUid);
                    //修改teacher统计值
                    teacherService.addTeacherRelationToStundent(user, teacherUid);
                    //分别发送推送
                    sendMessageToStudent(user, newTeacher, true);
                    sendMessageToTeacher(user, newTeacher, true);
                }


            /* 3-2 校验参数为空，则解除用户的师兄关联 */
            } else {
                 /*四、用户身份信息相关逻辑*/
                if (User.IDENTIFY_50.equals(identity)) { //设置用户身份为首席弟子
                    log.info(" update user identity is chef ");
                /*1.判断用户当前身份是否是内门弟子*/
                          /* 2.分配真传弟子为师兄，前面校验已返回师兄ID */
                    log.info(teacherUid + " has the least chef students");

                        /*3.解除真传弟子与之前的师兄的师兄弟关系，并且给之前的师兄和该用户发送解除通知 */
                    if (DataUtils.isNotNullOrEmpty(oldTeacherId)
                            && !User.TeacherID_None.equals(oldTeacherId)) {
                        log.info(" user old teacher id is " + oldTeacherId);

                        oldTeacher = userService.getObjectById(oldTeacherId);
                        //修改统计值
                        if (DataUtils.isNotNullOrEmpty(oldTeacherExd)) {
                            List<User> students = new ArrayList<>();
                            students.add(user);
                            teacherService.dropTeacherRelationToStundent(students, oldTeacherId);
                        }
                        //各自发送推送消息
                        sendMessageToStudent(user, oldTeacher, false);
                        sendMessageToTeacher(user, oldTeacher, false);
                    } else {
                        log.info(" user didn't have teacher ever ");
                    }
                    /*4.新建真传弟子与刚刚查询到的师兄的师兄弟关系，并且给师兄和师弟分别发送新建通知 */
                    Teacher newTeacherExt = teacherService.getObjectById(newTeacherId);
                    if (DataUtils.isNullOrEmpty(newTeacherExt)) {//如果查到的真传弟子还不是师兄，将他的拓展信息插入到师兄表
                        log.info(" user id " + newTeacherId + " haven't teacher ,so add ");
                        addTeacher(newTeacherId);
                    }
                    //设置用户的师兄
                    user.setTeacherId(newTeacherId);
                    //修改teacher统计值
                    teacherService.addTeacherRelationToStundent(user, newTeacherId);
                    //分别发送推送
                    sendMessageToStudent(user, newTeacher, true);
                    sendMessageToTeacher(user, newTeacher, true);
                }

            }
            if (User.IDENTIFY_60.equals(identity)) {//设置用户身份是真传弟子
                log.info(" user identity is zhenchuan ");
                Teacher newTeacherExt = teacherService.getObjectById(uid);
                if (DataUtils.isNullOrEmpty(newTeacherExt)) {//如果该用户还不是师兄，将他添加到teacher表里，真传可以做首席的师兄
                    log.info(" user id " + teacherUid + " haven't teacher ,so add ");
                    addTeacher(uid);
                }
                user.setIdentity(identity);
            } else {
                log.info(" user is other identity " + identity);
                user.setIdentity(identity);
            }

            /* 4 校验参数，检查是否需要新增用户拓展信息 */
            Teacher teacherSelf = teacherService.getObjectById(uid);
            if (CheckDataUtil.isNull(teacherSelf)) {
                log.info(" user " + uid + " is not a teacher ");
            }
            log.info(" teacherSelf =========" + teacherSelf);
            /* 5 校验参数，更新用户拓展信息 */
            if (StringUtils.isNotBlank(groupQQ)) {
                if (CheckDataUtil.isNotNull(teacherSelf)) {
                    teacherSelf.setGroupQQ(groupQQ);
                    teacherService.update(teacherSelf);
                    log.info(" update GroupQQ");
                }
            }
            userService.update(user);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" updateUser user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 30.推出班级
     */
    @RequestMapping(value = "/a/u/classmate/{cid}", method = RequestMethod.PUT)
    public String quitClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long cid, Long uid, Boolean relieveTeacher,
                              Boolean relieveStudents) throws Exception {


        log.info("uid" + uid + " quitClasses cid =" + cid + " and relieveTeacher is " + relieveTeacher + " relieveStudents is " + relieveStudents);
        log.info("cid is " + cid + " uid is " + uid);

        try {
            if (uid == null) {
                model.addAttribute("code", -1004);
                log.info("classes is null");
                return "/common/success";
            }

            Classes classes = classesService.getObjectById(cid);

            if (classes.equals(null)) {
                model.addAttribute("code", -10002);
                log.info("classes is null");
                return "/common/success";
            }

            Long relationId = userClassRelationService.getUserClassRelationIdByCidAndUid(cid, uid);

            if (relationId == null) {
                model.addAttribute("code", -10003);
                log.info("you are not in the classes");
                return "/common/success";
            }

            UserClassRelation relation = userClassRelationService.getObjectById(relationId);
            Integer status = relation.getStatus();

            if (status == 1) {

                if (classes.getLeader() == uid) {
                    classes.setLeader(null);
                }
                User user = this.userService.getObjectById(uid);
                if (user == null) {
                    log.info("not get any user of uid " + uid);
                } else {
                    //解除师兄弟关系判断
                    relieveRelation(user, relieveTeacher, relieveStudents);
                    //修改用户信息
                    user.setBranch(null);
                    user.setOid(User.Occupation_None);
                    user.setCid(User.Classes_None);
                    user.setUserClassID(User.Classes_None);
                    user.setType(Classes.Type_None);
                    user.setStudyNumber(User.Study_Number_None);
                    user.setIdentity(User.IDENTIFY_10);
                    this.userService.update(user);
                    //修改用户班级关系
                    relation.setStatus(0);
                    userClassRelationService.update(relation);
                }

            } else {
                model.addAttribute("code", -10007);
                log.info("you have quit the classes");
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("quit classes error,cid is  " + cid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    public Long getTeacherIds(Long oid, Integer identity, String orderBy, String type) throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getTeacherInfoListParam(oid, identity, orderBy, false);
        List<Long> teacherIds = teacherService.getIdsByDynamicCondition(User.class, param, 0, 1);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            log.info(" has teachers can adopt ");
            return teacherIds.get(0);
        } else {
            log.info(" there is not a teacher for oid=" + oid);
            if (Classes.Type_Outline.equals(type)) {
                log.info(" user add outline class ");
                return -15014L;
            } else if (Classes.Type_Offline.equals(type)) {
                log.info(" user add offline class ");
                return -15015L;
            } else if (Classes.Type_Online.equals(type)) {
                log.info(" user add online class ");
                return -15014L;
            } else {
                log.info(" user update identity is shouxi  ");
                return -15012L;
            }

        }

    }

    /**
     * @param
     * @return
     */

    //18.加入班级
    @RequestMapping(value = "/a/u/classmate/{cid}", method = RequestMethod.POST)
    public String joinClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long cid, String swear, Long uid, Long graduateAt, String type) throws Exception {


        log.info("============================================");
        log.info("cid is " + cid + " swear is " + swear + " uid is " + uid);

        List<Long> cidList = new ArrayList();
        try {

            User user = this.userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info(" get user info error :user == null");
                model.addAttribute("code", -5003);
                return "/common/success";
            }


            Classes classes = classesService.getObjectById(cid);
            if (DataUtils.isNullOrEmpty(classes)) {
                model.addAttribute("code", -10002);
                log.info("classes is null");
                return "/common/success";
            }
            String classType = classes.getType();

            log.info("----------------------------------开始了");
//            if (type.equals(User.TYPE_OFFLINE) || type.equals(User.TYPE_OUTLINE)){
//                if (graduateAt == null){
//                    log.info("----------------------------------结束了");
//                    model.addAttribute("code",-16000);
//                    return "/common/success";
//                }
//                user.setGraduateAt(graduateAt);
//                userService.insert(user);
//            }
//            user.setGraduateAt(graduateAt);
//            userService.insert(user);
//            log.info(uid + " get user info is " + user);
            Long oldTeacherId = user.getTeacherId();
            Long oid = classes.getOid();
            Long teacherId = -1L; //分配到的师兄ID
            Integer identity = -1;
            String orderBy = "";
            // 检查用户是否是无名弟子，否则不能加入班级
            if (!User.IDENTIFY_10.equals(user.getIdentity())) {
                log.info(" user's identity is not wuming ,so can't add new class ,user now class is  " + user.getCid());
                model.addAttribute("code", -15017);
                return "/common/success";
            }

            //加入线下班级，自动设置内门弟子结业时间
//            if (classType.equals(User.TYPE_OFFLINE)) {
//                Long OldGraduateAt = user.getGraduateAt();
//                Long startAt = user.getStartAt();
//                //web弟子可能会加入两次线下班级，只有第一次才需要设置结业时间
//                if (OldGraduateAt == null) {
//                    Long branchId = Long.valueOf(classes.getBranch());
//                    BranchInstitute branchInstitute = branchInstituteService.getObjectById(branchId);
//                    Integer period = branchInstitute.getPeriod();
//                    Long NewGraduateAt = startAt + period * 86400000;
//                    user.setGraduateAt(NewGraduateAt);
//                    userService.insert(user);
//                }
////                user.setGraduateAt(graduateAt);
////                userService.update(user);
//            }


            Long relationId1 = userClassRelationService.getUserClassRelationIdByCidAndUidAndStatus(cid, uid, 1);
            if (relationId1 != null) {
                model.addAttribute("code", -10000);
                log.info(uid + " already in a classes " + relationId1);
                return "/common/success";
            }



            /*校验是否需要重新分配师兄*/
            if (DataUtils.isNullOrEmpty(oldTeacherId)) {
                //校验是否有师兄可分配
                if (Classes.Type_Outline.equals(classType)) {
                    log.info(" user add outline class ");
                    identity = User.IDENTIFY_40;
                    orderBy = Teacher.outline_now;
                } else if (Classes.Type_Offline.equals(classType)) {
                    log.info(" user add offline class ");
                    identity = User.IDENTIFY_50;
                    orderBy = Teacher.offline_now;
                } else {
                    identity = User.IDENTIFY_40;
                    orderBy = Teacher.online_now;
                    log.info(" user add online class ");
                }
                //4.分配师兄
                teacherId = getTeacherIds(classes.getOid(), identity, orderBy, classType);
                log.info(" code = " + teacherId);
                if (teacherId < 0) {
                    model.addAttribute("code", teacherId);
                    //发送系统消息给修真院收官者
                    sendMessageToGM(user);
                    return "/common/success";
                }
            } else {
                log.info(" user have teacher ,so don't need adopt a new teacher ");
            }

            Long relationId0 = this.userClassRelationService.getUserClassRelationIdByCidAndUidAndStatus(cid, uid, 0);
            Long total = null;
            Occupation occupation = occupationService.getObjectById(oid);
            //后面记得加外门的判断--为毛不新建好字段，还得我自己加
            if (Classes.Type_Online.equals(classType)) {
                total = occupation.getOnlineUserCount();
                user.setType(Classes.Type_Online);
            } else if (Classes.Type_Offline.equals(classType)) {

                total = occupation.getOfflineUserCount();
                user.setType(Classes.Type_Offline);
            } else if (Classes.Type_Outline.equals(classType)) {
                total = occupation.getOutlineUserCount() == null ? 0L : occupation.getOutlineUserCount();
                user.setType(Classes.Type_Outline);
            }
            if (relationId0 == null) {
                log.info(" user want to add another classs relationId0 =" + relationId0);
                if (StringUtil.isEmpty(swear)) {
                    model.addAttribute("code", -1004);
                    log.info("swear is null");
                    return "/common/success";
                }


                Long status = classes.getStatus();
                if (status == 1) {
                    model.addAttribute("code", -10001);
                    log.info("classes have 20 students");
                    return "/common/success";
                }

                total = total + 1;
                UserClassRelation userClassRelation = new UserClassRelation();
                userClassRelation.setCid(cid);
                userClassRelation.setUid(uid);
                userClassRelation.setSwear(swear);
                userClassRelation.setNum(total);
                userClassRelation.setStatus(1);
                userClassRelation.setOid(oid);


                Long ucID = userClassRelationService.insert(userClassRelation);

                log.info(cid + " get ucID is " + ucID);

                Long classesTotal = classes.getTotal();
                classesTotal = classesTotal + 1;
                classes.setTotal(classesTotal);
                if (classesTotal == 20) {
                    classes.setStatus(1L);
                }
                classesService.update(classes);

                if (Classes.Type_Online.equals(classType)) {
                    occupation.setOnlineUserCount(total);
                } else if (Classes.Type_Offline.equals(classType)) {

                    occupation.setOfflineUserCount(total);
                } else if (Classes.Type_Outline.equals(classType)) {
                    occupation.setOutlineUserCount(total);
                }

                if (occupationService.update(occupation)) {
                    log.info(" update occupation success ");
                } else {
                    log.info(" update occupation failed ");
                }

                user.setUserClassID(ucID);

            } else {
                log.info(" user want to add same classs relationId0 =" + relationId0);
                UserClassRelation userClassRelation = userClassRelationService.getObjectById(relationId0);
                userClassRelation.setStatus(1);
                userClassRelationService.update(userClassRelation);
                total = userClassRelation.getNum();

                user.setUserClassID(relationId0);
            }

            user.setCid(cid);
            user.setStudyNumber(total.intValue());
            user.setOid(oid);
            if (CheckDataUtil.isNull(user.getStartAt())) {
                user.setStartAt(System.currentTimeMillis());

            }


            if (Classes.Type_Outline.equals(classType)) {
                log.info(" user add outline class ");
                //1.设置身份
                user.setIdentity(User.IDENTIFY_30);
                //3.设为师兄
                Teacher teacher = teacherService.getObjectById(uid);
                if (DataUtils.isNullOrEmpty(teacher)) {
                    addTeacher(uid);
                }
            } else if (Classes.Type_Offline.equals(classType)) {
                log.info(" user add offline class ");
                //1.设置身份
                user.setIdentity(User.IDENTIFY_40);
                //2.设置分院
                user.setBranch(classes.getBranch());
                //3.设为师兄
                Teacher teacher = teacherService.getObjectById(uid);
                if (DataUtils.isNullOrEmpty(teacher)) {
                    addTeacher(uid);
                }
                log.info(" user don't have teacher ,so need fenpei a new teacher to him ");
            } else {
                log.info(" user add online class ");
                //1.设置身份
                user.setIdentity(User.IDENTIFY_20);
            }
            //4.分配师兄
            if (DataUtils.isNullOrEmpty(oldTeacherId)) {
                if (teacherId > 0) {
                    User newTeacher = userService.getObjectById(teacherId);
                    sendMessageToStudent(user, newTeacher, true);
                    sendMessageToTeacher(user, newTeacher, true);
                    user.setTeacherId(teacherId);
                } else {
                    model.addAttribute("code", teacherId);
                    //发送系统消息给修真院收官者
                    sendMessageToGM(user);
                    return "/common/success";
                }
            }
            log.info(" user unlook = " + user.getIsLook());
            Integer unlook = user.getIsLook() == null ? 0 : user.getIsLook() + 1;
            user.setIsLook(unlook);
            user.setLatestMsg(Message.CLASS_TYPE);
            log.info(" user unlook = " + user.getIsLook());
            //5.修改师兄的统计值
            teacherService.addTeacherRelationToStundent(user, teacherId);
            userService.update(user);


            // 发送信息
            Message message = new Message();
            message.setStatus(1);
            message.setReceiveName(user.getNick());
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent("");
            message.setReceiveId(uid);
            message.setUnread(1);
            message.setType(Message.CLASS_TYPE);
            message.setRelationId(cid);
            Long mid = messageService.insert(message);
            message = this.messageService.getObjectById(mid);
            String content = "<span class=\"font-16px system-alert-outline ng-scope\"><span class=\"font-green\">您</span>已成功加入<a data-mid=\"" + mid + "\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/class/" + classes.getId() + "//intro\" class=\"font-orange\">" + classes.getType() + "-" + occupation.getName() + "-" + classes.getName() + "班</a></span>";
            log.info("user : " + user.getMobile() + " send : " + content);
            adminSend(user.getMobile(), content);
            message.setContent(content);
            messageService.update(message);


            model.addAttribute("code", 0);
            model.addAttribute("num", total);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classes error,id is  " + cidList, t);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    public void relieveRelation(User student, Boolean relieveTeacher,
                                Boolean relieveStudents) throws Exception {

        if (DataUtils.isNullOrEmpty(relieveTeacher)) {
            relieveTeacher = false;
        }
        if (DataUtils.isNullOrEmpty(relieveStudents)) {
            relieveStudents = false;
        }

        Long teacherId = student.getTeacherId();
        Long uid = student.getId();
        log.info(" user " + student.getId() + " want to quit class ,so relieve master-apprentice relation ,teacher id " + teacherId);
        User teacher = userService.getObjectById(teacherId);
        if (relieveTeacher && !relieveStudents) {
            log.info(" user only relieve his teacher ");
            //修改统计值

            if (DataUtils.isNullOrEmpty(teacherId)
                    || User.TeacherID_None.equals(teacherId)) {
                log.info(" user don't have teacher ");
            } else {
                List<User> students = new ArrayList<>();
                students.add(student);
                teacherService.dropTeacherRelationToStundent(students, teacherId);
                //发送消息
                sendMessageToStudent(student, teacher, false);
                sendMessageToTeacher(student, teacher, false);
            }

            //设置师兄为null
            student.setTeacherId(null);
        } else if (!relieveTeacher & relieveStudents) {
            log.info(" user only relieve his  students ");
            Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, false);
            log.info("get param:" + paramList);
            List<Long> studentUids = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(studentUids)) {
                log.info(" user don't have students ");
            } else {
                log.info(" user's student ids is " + studentUids);
                List<User> students = new ArrayList<>();
                students = userService.getObjectsByIds(studentUids);
                //修改统计值
                teacherService.dropTeacherRelationToStundent(students, uid);
                for (User user : students) {
                    log.info(" student id = " + user.getId() + " oid = " + user.getOid());
                    //设置师兄值为空
                    user.setTeacherId(null);
                    //给师弟发送消息
                    sendMessageToStudent(user, student, false);


                }
                //给用户发送消息
                sendMessageToTeacher(students, student, false);

                userService.updateList(students);

            }


        } else if (relieveStudents && relieveTeacher) {
            log.info(" user  relieve his teacher and his student ");
            List<User> students = new ArrayList<>();
            //1.解除他的师兄
            //修改统计值
            if (DataUtils.isNullOrEmpty(teacherId)
                    || User.TeacherID_None.equals(teacherId)) {
                log.info(" user don't have teacher ");
            } else {

                students.add(student);
                teacherService.dropTeacherRelationToStundent(students, teacherId);
                //发送消息
                sendMessageToStudent(student, teacher, false);
                sendMessageToTeacher(student, teacher, false);
            }

            //2.解除他的师弟
            Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, false);
            log.info("get param:" + paramList);
            List<Long> studentUids = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(studentUids)) {
                log.info(" studentUids is empty, user don't have student ");
            } else {
                log.info(" user's student ids is " + studentUids);

                students = userService.getObjectsByIds(studentUids);
                //修改统计值
                teacherService.dropTeacherRelationToStundent(students, uid);
                for (User user : students) {
                    //设置师兄值为空
                    user.setTeacherId(null);
                    //给师弟发送消息
                    sendMessageToStudent(user, student, false);
                    sendMessageToTeacher(user, student, false);
                }
                userService.updateList(students);
            }
            //设置师兄为null
            student.setTeacherId(null);
        } else {
            log.info(" teacher and student all don't relieve ");

        }


    }


    /**
     * 推送即时消息给修真院守关者
     *
     * @param student
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToGM(User student) throws ServiceException, ServiceDaoException {
        log.info(" sendMessageToGM start ,student id " + student.getId());
        List<Message> messages = new ArrayList<>();
        Long studentUid = student.getId();
        String studentNick = student.getNick();
        Long oid = student.getOid();
        log.info(" user oid = " + oid);
        String occupationName = "无名";
        Occupation occupation = occupationService.getObjectById(oid);
        if (DataUtils.isNullOrEmpty(occupation)) {
        } else {
            occupationName = occupation.getName();
        }
        //查找该职业下的所有真传弟子
        List<Long> leaderIds = userService.getIdsByOidAndIdentity(oid, User.IDENTIFY_60, 0, Integer.MAX_VALUE);
        log.info(" leader ids = " + leaderIds);
        if (CollectionUtils.isEmpty(leaderIds)) {
            //如果没有真传弟子，则发送给守关人
            leaderIds.add(User.SGUID);
        }
        log.info(" leader size = " + leaderIds.size() + " ids = " + leaderIds);
        List<User> leaders = userService.getObjectsByIds(leaderIds);
        for (User leader : leaders) {
            Long GMuid = leader.getId();
            String nick = leader.getNick();
            Integer unLook = leader.getIsLook() + 1;
            leader.setIsLook(unLook);

            Message message = new Message();
            message.setStatus(1);
            message.setReceiveName(nick);
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent(leader.getMobile());
            message.setReceiveId(GMuid);
            message.setUnread(1);
            message.setType("teacher");
            message.setRelationId(studentUid);
            messages.add(message);

        }
        log.info(" messages size = " + messages.size());
        List<Message> newMessages = messageService.insertList(messages);
        userService.updateList(leaders);
        String content = "";
        for (Message message : newMessages) {
            log.info(" message content = " + message.getContent());
            Long mid = message.getId();
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" href=\\\"/school/", studentUid,
                    "/class\\\"><span class=\\\"font-green\\\">", occupationName,
                    "新学员 ", studentNick, "</span> </a>无师兄可分配，请在后台手动指定师兄</span>");
            adminSend(message.getContent(), content);
            message.setContent(content);
        }
        messageService.updateList(newMessages);

    }


    /**
     * 添加用户拓展信息
     *
     * @param uid
     * @return
     * @throws Exception
     */
    public Teacher addTeacher(Long uid) throws Exception {

        Teacher teacher = new Teacher();
        try {
            if (CheckDataUtil.isNotNull(uid)) {
                teacher.setId(uid);
                teacherService.insert(teacher);
                log.info(" insert a teacher ,the new teacher id :" + uid);
                teacher = teacherService.getObjectById(uid);
            }
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add teacher error ");
        }

        return teacher;
    }


    /**
     * 推送新建关系的即时消息给师弟
     * action == true, 建立关系
     * action == false, 解除关系
     *
     * @param student
     * @param teacher
     * @param action
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToStudent(User student, User teacher, boolean action) throws ServiceException, ServiceDaoException {

        String content = "";

        Long studentUid = student.getId();
        String nick = student.getNick();
        String mobile = student.getMobile();
        Integer unLook = student.getIsLook() + 1;
        student.setIsLook(unLook);
        student.setLatestMsg(Message.CLASS_TYPE);
        Long teacherUid = teacher.getId();
        Long oid = teacher.getOid();
        String type = teacher.getType();
        Integer studyNumber = teacher.getStudyNumber();
        String occupationName = "";
        Occupation occupation = occupationService.getObjectById(oid);
        if (DataUtils.isNotNullOrEmpty(occupation)) {
            occupationName = occupation.getName();
        }

        type = convertTypeIntoCH(type);

        Message message = new Message();
        message.setStatus(1);
        message.setReceiveName(nick);
        message.setSendName("admin");
        message.setSendId(0L);
        message.setContent(content);
        message.setReceiveId(studentUid);
        message.setUnread(1);
        message.setType(Message.CLASS_TYPE);
        message.setRelationId(teacherUid);

        Long mid = messageService.insert(message);

        message = messageService.getObjectById(mid);


        if (action) {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员指派 <a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    type, "-", occupationName, "-", studyNumber, "</span> </a> 担任您的师兄</span>");

        } else {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员解除了 <a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    type, "-", occupationName, "-", studyNumber, "</span> </a> 与您的师兄弟关系</span>");
        }

        log.info("user : " + studentUid + " send : " + content);
        adminSend(mobile, content);
        message.setContent(content);
        messageService.update(message);

        userService.update(student);
    }


    /**
     * 推送新建关系的即时消息给师兄
     * action == true, 建立关系
     * action == false, 解除关系
     *
     * @param student
     * @param teacher
     * @param action
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToTeacher(User student, User teacher, boolean action) throws ServiceException, ServiceDaoException {

        String content = "";

        Long teacherUid = teacher.getId();
        String nick = teacher.getNick();
        String mobile = teacher.getMobile();
        Integer unLook = teacher.getIsLook() + 1;
        teacher.setIsLook(unLook);
        teacher.setLatestMsg(Message.CLASS_TYPE);

        Long studentUid = student.getId();
        Long oid = student.getOid();
        String type = student.getType();
        Integer studyNumber = student.getStudyNumber();
        String occupationName = "";
        Occupation occupation = occupationService.getObjectById(oid);
        if (DataUtils.isNotNullOrEmpty(occupation)) {
            occupationName = occupation.getName();
        }
        type = convertTypeIntoCH(type);

        Message message = new Message();
        message.setStatus(1);
        message.setReceiveName(nick);
        message.setSendName("admin");
        message.setSendId(0L);
        message.setContent(content);
        message.setReceiveId(teacherUid);
        message.setUnread(1);
        message.setType(Message.CLASS_TYPE);
        message.setRelationId(studentUid);

        Long mid = messageService.insert(message);

        message = messageService.getObjectById(mid);

        if (action) {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员指派 <a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    type, "-", occupationName, "-", studyNumber, "</span> </a> 成为您的师弟</span>");

        } else {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员解除了 <a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    type, "-", occupationName, "-", studyNumber, "</span> </a> 与您的师兄弟关系</span>");
        }

        log.info("user : " + teacherUid + " send : " + content);
        adminSend(mobile, content);
        message.setContent(content);
        messageService.update(message);

        userService.update(teacher);
    }


    /**
     * 推送新建关系的即时消息给师兄--多个师弟发送一条消息
     * action == true, 建立关系
     * action == false, 解除关系
     *
     * @param students
     * @param teacher
     * @param action
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToTeacher(List<User> students, User teacher, boolean action) throws ServiceException, ServiceDaoException {

        String content = "";

        Long teacherUid = teacher.getId();
        String nick = teacher.getNick();
        String mobile = teacher.getMobile();
        Integer unLook = teacher.getIsLook() + 1;
        teacher.setIsLook(unLook);
        teacher.setLatestMsg(Message.CLASS_TYPE);
        Message message = new Message();
        message.setStatus(1);
        message.setReceiveName(nick);
        message.setSendName("admin");
        message.setSendId(0L);
        message.setReceiveId(teacherUid);
        message.setUnread(1);
        message.setType(Message.CLASS_TYPE);
        //message.setRelationId(studentUid);
        message.setContent(content);
        Long mid = messageService.insert(message);
        message = messageService.getObjectById(mid);

        if (action) {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员指派 ");

        } else {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">管理员解除了");
        }
        StringBuilder aa = new StringBuilder("");
        int i = 0;
        for (User student : students) {
            i++;
            String bb = "";
            Long studentUid = student.getId();
            Long oid = student.getOid();
            String type = student.getType();
            Integer studyNumber = student.getStudyNumber();
            String occupationName = "";
            Occupation occupation = occupationService.getObjectById(oid);
            if (DataUtils.isNotNullOrEmpty(occupation)) {
                occupationName = occupation.getName();
            }
            type = convertTypeIntoCH(type);

            bb = LogUtil.convertString("<a data-mid=", mid, " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                    "/class\\\"><span class=\\\"font-green\\\">", type, "-", occupationName, "-", studyNumber, "</span> </a> ");
            if (i == students.size()) {
                aa.append(bb);
            } else {
                aa.append(bb + ",");
            }

        }

        if (action) {
            content = LogUtil.convertString(content, aa, "成为您的师弟</span>");

        } else {
            content = LogUtil.convertString(content, aa, "与您的师兄弟关系</span>");
        }


        log.info("user : " + teacherUid + " send : " + content);
        adminSend(mobile, content);
        message.setContent(content);
        messageService.update(message);
        userService.update(teacher);
    }


    public static String convertTypeIntoCH(String type) {
        if (StringUtils.isNotBlank(type)) {
            if (Classes.Type_None.equals(type)) {
                type = "无名";
            } else if (Classes.Type_Online.equals(type)) {
                type = "散修";
            } else if (Classes.Type_Outline.equals(type)) {
                type = "外门";
            } else if (Classes.Type_Offline.equals(type)) {
                type = "内门";
            } else {
                type = "未知类型";
            }

        }

        return type;
    }


    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }


    public static void setUpUserInvitationCode() throws IOException {
        List<String> sequenceList = generateSequenceList();
        String fileName = Txt.creatSqlFile("inviet");
        for (int i = 0; i < 10123; i++) {
            int j = i + 1;
            StringBuilder stringBuilder = new StringBuilder("update user set invitation_code = '" + j + sequenceList.get(i) + "' where id = " + j + ";");
            Txt.writeTxtFile(stringBuilder.toString());
        }


    }

    public static List<String> generateSequenceList() {
        List<String> sequenceList = new ArrayList<>();
        for (int i = 1; i < 10124; i++) {
            String j = i + "";
            String aa = RandomStringUtils.randomNumeric(8 - j.length());
            sequenceList.add(aa);
        }

        return sequenceList;

    }

    public static void main(String[] args) throws IOException {
        setUpUserInvitationCode();
    }
}