package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;

/**
 * Ctype  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CtypeController {
	private static final Log log = LogFactory.getLog(CtypeController.class);

	@Autowired
	private CtypeService ctypeService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/ctype", method = RequestMethod.GET)
	public String getctypeList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/ctype  to /ctype/view/ctypeList");

		return "/skill-service/ctype/view/ctypeList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/ctype1 ", method = RequestMethod.GET)
	public String getCtypeIdsByStatusOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer status) throws Exception {

		log.info("/ctype  to /ctype/view/ctypeList");

		return "/skill-service/ctype/view/ctypeList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/ctype/{id}", method = RequestMethod.GET)
	public String getCtype(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/ctype/" + id + "  to /ctype/view/ctypeDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/skill-service/ctype/view/ctypeDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/ctype1 ", method = RequestMethod.GET)
	public String getCtypeIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer status) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= ctypeService.getCtypeIdsByStatusOrderByCreateAt(status,start,size);
		log.info("get countCtypeIdsByStatusOrderByCreateAt size is " + ids.size());

			List<Ctype> ctypeList = ctypeService.getObjectsByIds(ids);
			log.info("get ctype data is " + ctypeList.size());

			Integer total = ctypeService. countCtypeIdsByStatusOrderByCreateAt(status);
			log.info("get ctype count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("ctypeList", ctypeList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/skill-service/ctype/json/ctypeListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/ctype/{id}", method = RequestMethod.GET)
	public String getCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Ctype ctype = ctypeService.getObjectById(id);
			log.info("get ctype data is " + ctype);

			model.addAttribute("code", 0);

			model.addAttribute("ctype", ctype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get ctype error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/skill-service/ctype/json/ctypeDetailJson";
	}

	@RequestMapping(value = "/a/ctype/{id}", method = RequestMethod.PUT)
	public String updateCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Ctype ctype) throws Exception {
		
		log.info("update ctype : ctype= " + ctype);
		
		try {
			
			ctypeService.update(ctype);

			model.addAttribute("code", 0);

			model.addAttribute("ctype", ctype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update ctype error,id is  " + ctype.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/ctype", method = RequestMethod.POST)
	public String addCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Ctype ctype) throws Exception {
		
		log.info("update ctype : ctype= " + ctype);
		
		try { 
			ctype.setId(null);

			ctypeService.insert(ctype);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add ctype error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/ctype/{id}", method = RequestMethod.DELETE)
	public String deleteCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete ctype : id= " + id);
		try {
			ctypeService.delete(id);

			log.info("add ctype success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete ctype error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/ctype", method = RequestMethod.GET)
	public String getMultiCtypeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Ctype> ctypeList = ctypeService.getObjectsByIds(idList);
			log.info("get  ctype data is " + ctypeList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",ctypeList.size());

			model.addAttribute("ctypeList", ctypeList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get ctype error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/skill-service/ctype/json/ctypeListJson";
	}
	
	
	
	
	
}

