package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.common.skill.service.CtypeService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.service.ClogService;

/**
 * Clog  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ClogController {
	private static final Log log = LogFactory.getLog(ClogController.class);

	@Autowired
	private ClogService clogService;


	@Autowired
	private CtypeService ctypeService;


	@Autowired
	private CardService cardService;


	@Autowired
	private UserService userService;
	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/clog/search", method = RequestMethod.GET)
	public String getClogList(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model, Integer page, Integer size,
							  String cid, Long adminId, Long useId, Long receiveId, Integer type,
							  Long createStartAt, Long createEndAt) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getClogsQueryListParam(cid, adminId, useId, receiveId, type, createStartAt,createEndAt, false);
			log.info("clog params is: " + param);

			List<Long> ids = clogService.getIdsByDynamicCondition(Clog.class, param, start, size);
			log.info("clogs ids is " + ids);

			List<Clog> clogList = clogService.getObjectsByIds(ids);
			log.info("clogs list data is " + clogList);


			// 获取type use receive的内容
			List<Long> tids = new ArrayList<>();
			List<Long> uids = new ArrayList<>();
			List<Long> rids = new ArrayList<>();
			List<Long> cids = new ArrayList<>();

			for (Clog clogTemp : clogList) {
				tids.add(clogTemp.getTid());
				uids.add(clogTemp.getUseId());
				rids.add(clogTemp.getReceiveId());
				cids.add(clogTemp.getCid());
			}
			log.info("clog type id is " + tids);
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
			List<User> useList = userService.getObjectsByIds(uids);
			List<User> receiveList = userService.getObjectsByIds(rids);
			List<Card> cardList = cardService.getObjectsByIds(cids);



			// get total
			Map<String, Object> paramCount = DynamicUtil.getClogsQueryListParam(cid, adminId, useId, receiveId, type, createStartAt,createEndAt, true);
			List<Long> totalList = clogService.getIdsByDynamicCondition(Clog.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get clog size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("clogList", clogList);
			model.addAttribute("ctypeList", ctypeList);
			model.addAttribute("useList", useList);
			model.addAttribute("receiveList", receiveList);
			model.addAttribute("cardList", cardList);


		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get clog list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/clog/json/clogListJson";
	}


	
	
}

