package com.ptteng.controller;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.service.MessageService;
import com.ptteng.util.CheckDataUtil;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sleepycat.je.tree.IN;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.util.CardIdUtil;

import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;
import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.service.ClogService;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.service.MessageService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Card  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private CookieUtil cookieUtil;

	/**
	 * 新建卡券
	 * @param tid
	 * @param count
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card", method = RequestMethod.POST)
	public String addCards(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Long tid, Integer count) throws Exception {

		// 传参检查
		if (tid == null) {
			model.addAttribute("code",-21000);
			return "/data/json";
		} else if (count == null) {
			model.addAttribute("code",-21001);
			return "/data/json";
		} else if (count > 999) {
			model.addAttribute("code",-21015);
			return "/data/json";
		} else {
			log.info("Card create, tid is: " + tid + ". count is: " + count);
		}

		// 根据tid获取卡券类型
		Ctype cardType = new Ctype();
		try {
			cardType = ctypeService.getObjectById(tid);
			log.info("get card type is: " + cardType);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get type id error,id is " + tid );
			model.addAttribute("code", -21002);

		}


		// 生成卡券编号
		String[] cardId = CardIdUtil.generateCode(tid, count);

		// 获取user id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));

		// 生成card实体并插入到cardList
		List<Card> CardList = new ArrayList<Card>();
		for(int i = 0; i < count; i++) {
			Card card = new Card();
			card.setCid(cardId[i]);
			card.setTid(tid);
			card.setStatus(Card.Status_Unissued);
			card.setCStatus(cardType.getStatus());
			card.setCreateBy(uid);
			card.setCreateAt(System.currentTimeMillis());
			CardList.add(card);
		}
		try {
			cardService.insertList(CardList);
			log.info("insert card list is: " + CardList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("insert card list error,id is " + tid );
			model.addAttribute("code", -21003);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}




	/**
	 * 修改卡券状态
	 * @param card
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}", method = RequestMethod.PUT)
	public String updateCards(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model,
						   Card card, @PathVariable Long id) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-21004);
			return "/data/json";
		} else {
			log.info("update card id is: " + id);
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
			log.info("orignCard is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21005);
		}

		// 卡券禁用，无法进行修改操作
		if (orignCard.getCStatus() == Card.Cstatus_Disable) {
			model.addAttribute("code",-21008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}


		// 获取user id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		// 提交不同状态判断
		if (orignCard.getStatus() == Card.Status_Unissued && card.getStatus() == Card.Status_Issued) {
			// 发放1->2
			orignCard.setOwnerId(card.getOwnerId());
			orignCard.setAssignId(uid);
			orignCard.setAssignAt(System.currentTimeMillis());
			orignCard.setStatus(card.getStatus());

			saveClog(Card.Status_Issued, orignCard.getId(), orignCard.getTid(), uid, card.getOwnerId(), null);
		} else if (orignCard.getStatus() == Card.Status_Issued && card.getStatus() == Card.Status_Verificating) {
			// 使用2->3
			if (CheckDataUtil.notEqual(card.getOwnerId(), orignCard.getOwnerId())) {
				model.addAttribute("code",-21009);
				return "/data/json";
			} else {
				orignCard.setApplyAt(System.currentTimeMillis());
				orignCard.setStatus(card.getStatus());

				saveClog(Card.Status_Verificating, orignCard.getId(), orignCard.getTid(), null, card.getOwnerId(), null);
			}
		} else if (orignCard.getStatus() == Card.Status_Verificating && card.getStatus() == Card.Status_Verificated) {
			// 核销通过3->4
			orignCard.setVerificationId(uid);
			orignCard.setVerificationAt(System.currentTimeMillis());
			orignCard.setStatus(card.getStatus());

			saveClog(Card.Status_Verificated, orignCard.getId(), orignCard.getTid(), uid, null, null);

		} else if (orignCard.getStatus() == Card.Status_Verificating && card.getStatus() == Card.Status_Unverificated) {
			// 核销拒绝3->5
			orignCard.setVerificationId(uid);
			orignCard.setVerificationAt(System.currentTimeMillis());
			orignCard.setStatus(Card.Status_Verificating);

			saveClog(Card.Status_Verificated, orignCard.getId(), orignCard.getTid(), uid, null, null);

		} else {
			model.addAttribute("code",-21006);
			return "/data/json";
		}

		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(uid);

		try {
			cardService.update(orignCard);
			log.info("update card is: " + orignCard);

			// 消息通知
			Long ownerId = card.getOwnerId();
			if (ownerId == null) {
				ownerId = orignCard.getOwnerId();
			}
			sendMessage(ownerId, card.getStatus(), orignCard.getCid(), orignCard.getTid());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券转让
	 * @param mobile
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/cession", method = RequestMethod.PUT)
	public String cessionCard(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id, String mobile) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		} else if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		} else {
			log.info("card id is: " + id + ". mobile is: " + mobile);
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
			log.info("orignCard is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 根据mobile获取用户id
		Long userId = null;
		try {
			userId = userService.getUserIdByMobile(mobile);
			log.info("user id is: " + userId);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user id error, mobile is " + mobile );
			model.addAttribute("code", -23005);
		}

		if (orignCard.getStatus() != Card.Status_Issued || orignCard.getCStatus() == Card.Cstatus_Disable) {
			model.addAttribute("code",-23013);
			return "/data/json";
		}

		saveClog(Card.Status_Cession, orignCard.getId(), orignCard.getTid(), null, orignCard.getOwnerId(), userId);


//		 获取user id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));



		orignCard.setOwnerId(userId);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(uid);



		try {
			cardService.update(orignCard);
			log.info("update card is: " + orignCard);

			// 消息通知
			sendMessage(userId, Card.Status_Cession, orignCard.getCid(), orignCard.getTid());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}

	/**
	 * 卡券启用禁用
	 * @param cStatus
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/status/{cStatus}", method = RequestMethod.PUT)
	public String updateCardIsAble(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model,
						   @PathVariable Long id, @PathVariable Integer cStatus) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-21004);
			return "/data/json";
		} else if (cStatus == null) {
			model.addAttribute("code",-21011);
			return "/data/json";
		} else {
			log.info("card id is: " + id + ". cStatus is: " + cStatus);
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
			log.info("orignCard is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21005);
		}

		// 判断状态是否不一样
		if (cStatus.equals(orignCard.getCStatus())) {
			model.addAttribute("code",-21014);
			return "/data/json";
		} else {
			log.info("card cstatus is different from database");
		}

		// 获取user id
		Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));


		orignCard.setCStatus(cStatus);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(uid);

		try {
			cardService.update(orignCard);
			log.info("update card is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -21007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
						   HttpServletResponse response,
						   ModelMap model, Integer page, Integer size,
							  String cid, Long tid, Long ownerId, Integer status, Integer cStatus,
							  Long assignStartAt, Long assignEndAt,
							  Long applyStartAt, Long applyEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getCardsQueryListParam(cid, tid, ownerId, status, cStatus, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt, false);
			log.info("card params is: " + param);

			List<Long> ids = cardService.getIdsByDynamicCondition(Card.class, param, start, size);
			log.info("cards ids is " + ids);

			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("card list data is " + cardList);


			// 获取type的内容
			List<Long> tids = new ArrayList<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
			log.info("card type id is " + tids);


			// get total
			Map<String, Object> paramCount = DynamicUtil.getCardsQueryListParam(cid, tid, ownerId, status, cStatus, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt,true);
			List<Long> totalList = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get card size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("cardList", cardList);
			model.addAttribute("ctypeList", ctypeList);

		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/card/json/cardListJson";
	}


	// 存入卡券记录
	private void saveClog(Integer type, Long cid, Long tid, Long adminId, Long useId, Long receiveId) throws Exception {

		log.info("save clog, type: " + type + ". cid: " + cid + ". tid: " + tid);

		Clog clog = new Clog();
		clog.setType(type);
		clog.setCid(cid);
		clog.setTid(tid);
		clog.setAdminId(adminId);
		clog.setUseId(useId);
		clog.setReceiveId(receiveId);
		clog.setUpdateAt(System.currentTimeMillis());

		if (adminId != null) {
			clog.setCreateAt(adminId);
			clog.setCreateBy(adminId);
			clog.setUpdateBy(adminId);
		} else if (useId != null) {
			clog.setCreateAt(useId);
			clog.setCreateBy(useId);
			clog.setUpdateBy(useId);
		}

		log.info("clog object is: " + clog);

		Long logId = clogService.insert(clog);
		log.info("new clog id is: " + logId);

	}


	// 消息通知
	private void sendMessage(Long uid, Integer type, String code, Long tid) throws Exception {

		log.info("send message args, uid: " + uid + ". type: " + type + ". code: " + code + ". tid: " + tid);
		// 获取用户信息
		User user = userService.getObjectById(uid);
		log.info("user object is: " + user);
		String userName = user.getNick();
		log.info("user name is: " + userName);

		// 获取卡券类型信息
		Ctype ctype = ctypeService.getObjectById(tid);
		String title = ctype.getTitle();

		//存入系统消息
		Message message = new Message();
		message.setSendName("admin");
		message.setSendId(0L);
		message.setReceiveName(userName);
		message.setReceiveId(uid);
		message.setContent("");
		message.setStatus(1);
		message.setUnread(1);
		message.setType(Message.CARD_TYPE);
		Long mid = messageService.insert(message);

		//发送系统信息
		String content = "";
		if (type == Card.Status_Issued) {
			// {发放人名称}给你发放了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<span class=\\\"font-green\\\">管理员</span>给您发放了一张" +
					"<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/card/"+uid+"\\\">"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else if (type == Card.Status_Verificating) {
			// 使用
			return;
		} else if (type == Card.Status_Verificated) {
			// 核销通过：你的{卡券类型名称}{卡券编号}已审核通过并生效
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/card/"+uid+"\\\">"+ title + "[" + code + "]" +"</a>已审核通过并生效" +
					"</span>";
		} else if (type == Card.Status_Unverificated) {
			// 核销拒绝：你的{卡券类型名称}{卡券编号}已审核拒绝
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/card/"+uid+"\\\">"+ title + "[" + code + "]" +"</a>已审核拒绝" +
					"</span>";
		} else if (type == Card.Status_Cession) {
			// 转让：{转让人名称}给你转让了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<a data-mid=" + mid + " target=\"_blank\" href=\"/school/" + uid +"/class\"><span class=\"font-green\">" + userName + "</span></a>" +
					"<span class=\\\"font-green\\\">给您转让了一张</span>" +
					"<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/card/"+uid+"\\\">"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else {
			log.info("message error");
			return;
		}

		adminSend(user.getMobile(), content);
		message = messageService.getObjectById(mid);
		message.setContent(content);
		log.info("message mid is " + mid);

		Boolean result = messageService.update(message);
		log.info("message update result is " + result);


		//更新用户信息
		user.setIsLook(user.getIsLook() + 1);
		user.setLatestMsg(Message.CARD_TYPE);
		userService.update(user);

	}
	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}

	
}

