package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.service.BranchInstituteService;

/**
 * BranchInstitute  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BranchInstituteController {
    private static final Log log = LogFactory.getLog(BranchInstituteController.class);

    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private UserService userService;


    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.GET)
    public String getBranchInstituteJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
            log.info("get branchInstitute data is " + branchInstitute);
            if (branchInstitute == null) {
                model.addAttribute("code", -18007);
                return "/common/success";
            }

            User user = new User();
            Long uid = branchInstitute.getUid();

            user = this.userService.getObjectById(uid);


            model.addAttribute("code", 0);

            model.addAttribute("branchInstitute", branchInstitute);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get branchInstitute error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteDetailJson";
    }

    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.PUT)
    public String updateBranchInstituteJson(HttpServletRequest request,
                                            HttpServletResponse response, @PathVariable Long id, ModelMap model, String name, Long uid,
                                            String qq, Integer period, String phone, String url, String address, Integer status) throws Exception {

        BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
        log.info("update branchInstitute : branchInstitute= " + branchInstitute);

        try {

            log.info("update the branch to start :");

            log.info("check name =>>");
            if (StringUtil.isEmpty(name)) {
                log.info("name is null");
                model.addAttribute("code", -18000);
                return "/common/success";
            }
            log.info("name is " + name);

            log.info("check uid =>>");
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("uid is null");
                model.addAttribute("code", -18003);
                return "/common/success";
            }

            log.info("check user =>>");
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                log.info("user is null");
                model.addAttribute("code", -15000);
                return "/common/success";
            }
            log.info("uid is " + uid);

            log.info("check qq =>>");
            if (StringUtil.isEmpty(qq)) {
                log.info("qq is null");
                model.addAttribute("code", -18004);
                return "/common/success";
            }
            log.info("qq is " + qq);

            log.info("check period =>>");
            if (period == null) {
                log.info("period is null");
                model.addAttribute("code",-18008);
                return "/common/success";
            }
            log.info("period is " + period);

            log.info("check phone");
            if (StringUtil.isEmpty(phone)) {
                log.info("phone is null");
                model.addAttribute("code", -18002);
                return "/common/success";
            }
            log.info("phone is " + phone);

            log.info("check url");
            if (StringUtil.isEmpty(url)) {
                log.info("url is null");
                model.addAttribute("code", -18006);
                return "/common/success";
            }
            log.info("url is " + url);

            log.info("check address");
            if (StringUtil.isEmpty(address)) {
                log.info("address is null");
                model.addAttribute("code", -18005);
                return "/common/success";
            }
            log.info("address is " + address);

            log.info("check status");
            if (status == null) {
                log.info("status is null and add ");
                model.addAttribute("code",-18009);
                return "/common/success";
            }
            log.info("status is " + status);
            branchInstitute.setId(id);
            branchInstitute.setUid(uid);
            branchInstitute.setPhone(phone);
            branchInstitute.setPeriod(period);
            branchInstitute.setQq(qq);
            branchInstitute.setAddress(address);
            branchInstitute.setName(name);
            branchInstitute.setStatus(status);
            branchInstitute.setUrl(url);


            branchInstituteService.update(branchInstitute);
            model.addAttribute("code", 0);

            model.addAttribute("branchInstitute", branchInstitute);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update branchInstitute error,id is  " + branchInstitute.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }


    //新增分院
    @RequestMapping(value = "/a/u/branchInstitute", method = RequestMethod.POST)
    public String addBranchInstituteJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, BranchInstitute branchInstitute, String name, Long uid,
                                         String qq, Integer period, String phone, String url, String address, Integer status) throws Exception {

        log.info("update branchInstitute : branchInstitute= " + branchInstitute);

        try {
            log.info("add the branch to start :");

            log.info("check name =>>");
            if (StringUtil.isEmpty(name)) {
                log.info("name is null");
                model.addAttribute("code", -18000);
                return "/common/success";
            }
            log.info("name is " + name);

            log.info("check uid =>>");
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("uid is null");
                model.addAttribute("code", -18003);
                return "/common/success";
            }

            log.info("check user =>>");
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                log.info("user is null");
                model.addAttribute("code", -15000);
                return "/common/success";
            }
            log.info("uid is " + uid);

            log.info("check qq =>>");
            if (StringUtil.isEmpty(qq)) {
                log.info("qq is null");
                model.addAttribute("code", -18004);
                return "/common/success";
            }
            log.info("qq is " + qq);

            log.info("check period =>>");
            if (period == null) {
                log.info("period is null");
                model.addAttribute("code",-18008);
                return "/common/success";
            }
            log.info("period is " + period);

            log.info("check phone");
            if (StringUtil.isEmpty(phone)) {
                log.info("phone is null");
                model.addAttribute("code", -18002);
                return "/common/success";
            }
            log.info("phone is " + phone);

            log.info("check url");
            if (StringUtil.isEmpty(url)) {
                log.info("url is null");
                model.addAttribute("code", -18006);
                return "/common/success";
            }
            log.info("url is " + url);

            log.info("check address");
            if (StringUtil.isEmpty(address)) {
                log.info("address is null");
                model.addAttribute("code", -18005);
                return "/common/success";
            }
            log.info("address is " + address);

            log.info("check status");
            if (status == null) {
                log.info("status is null and add ");
                model.addAttribute("code",-18009);
                return "/common/success";
            }
            log.info("status is " + status);

            branchInstitute.setUid(uid);
            branchInstitute.setPhone(phone);
            branchInstitute.setPeriod(period);
            branchInstitute.setQq(qq);
            branchInstitute.setAddress(address);
            branchInstitute.setName(name);
            branchInstitute.setStatus(status);
            branchInstitute.setUrl(url);

            branchInstituteService.insert(branchInstitute);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add branchInstitute error ");
            model.addAttribute("code", -6002);
        }

        return "/common/success";
    }

    //删除分院
    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.DELETE)
    public String deleteBranchInstituteJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete branchInstitute : id= " + id);
        try {
            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);

            if (branchInstitute == null) {
                model.addAttribute("code", -18007);
                log.info("The branch does not exist");
                return "/common/success";
            }

            branchInstituteService.delete(id);

            log.info("add branchInstitute success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete branchInstitute error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }


    //修改分院上下架状态    0:上架,1:下架
    @RequestMapping(value = "/a/u/branchInstitute/{id}/status", method = RequestMethod.PUT)
    public String updateBranchStauts(ModelMap model, @PathVariable Long id) throws Exception {
        log.info("update branch status : id is " + id);
        try {

            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
            log.info("check status");

            if (branchInstitute == null){
                model.addAttribute("code", -18007);
                log.info("The branch does not exist");
                return "/common/success";
            }

            Integer status = branchInstitute.getStatus();


            //下架操作
            if (status == 0) {
                branchInstitute.setStatus(1);
            } else if (status == 1) {
                //上架操作
                branchInstitute.setStatus(0);
            } else {
                log.info("status is " + status);
                model.addAttribute("code",-18010);
            }

            log.info("now status is :" + branchInstitute.getStatus());
            branchInstituteService.update(branchInstitute);
            model.addAttribute("code", 0);



        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update branch status error,id is " + id);
            model.addAttribute("code", -6004);
        }
        return "/common/success";
    }


    @RequestMapping(value = "/a/multi/branchInstitute", method = RequestMethod.GET)
    public String getMultiBranchInstituteJson(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<BranchInstitute> branchInstituteList = branchInstituteService.getObjectsByIds(idList);
            log.info("get  branchInstitute data is " + branchInstituteList);

            model.addAttribute("code", 0);
            model.addAttribute("total", branchInstituteList.size());

            model.addAttribute("branchInstituteList", branchInstituteList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get branchInstitute error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteListJson";
    }


    //分院列表
    @RequestMapping(value = "/a/branch/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String name, Long uid,
                              String qq, Integer period, String phone, String url, String address, Integer status,
                              Integer page, Integer size, String nick, Integer orderBy, Integer sort) {

		/* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        boolean next = false;

        List<Long> idList = null;
        List<Long> totalList = null;
        List<Long> userIdList = null;
        List<User> userList = null;
        List<User> users = new ArrayList();
        Integer total = null;
        List<BranchInstitute> branchInstituteList = new ArrayList<>();
        BranchInstitute branchInstitute = new BranchInstitute();
        try {

            if (StringUtil.isEmpty(nick)) {
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                log.info("====== idlist is " + idList);
                totalList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, 0, Integer.MAX_VALUE);

                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                total = totalList.size();
                List<Long> user1 = new ArrayList<>();
                List<Long> uids1 = new ArrayList<>();
                Long uid1 = 0L;
                Set<Long> uids = new HashSet();
                for (BranchInstitute branchInstitute1 : branchInstituteList) {
                    uids.add(branchInstitute1.getUid());
                }

                if (CollectionUtils.isEmpty(uids)) {

                } else {
                    users = this.userService.getObjectsByIds(new ArrayList(uids));
                }
            } else{

                Map<String, Object> param2 = DynamicUtil.getUserListParam2(nick);
                userIdList = userService.getIdsByDynamicCondition(User.class, param2, start, size);
                users = this.userService.getObjectsByIds(userIdList);
                log.info("============= users : " + users);
                List<Long> uids = new ArrayList<Long>();
                for (User user : users){
                    uids.add(user.getId());
                }
                log.info("========uids : is " + uids);
                uid = uids.get(0);
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                uids.add(uid);
                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                log.info("branchInstituteList is " + branchInstituteList);



            }

            List<BranchInstitute> branchs = new ArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(idList)) {
                branchs = this.branchInstituteService.getObjectsByIds(idList);
                if (branchs.size() >= size) {
                    branchs = branchs.subList(0, size);
                    next = true;
                }
            }




            model.addAttribute("users", users);
            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("page",page);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is ");
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branchInstitute/json/branchInstituteListJson";

    }


}