package com.ptteng.common.skill.model;

import javax.persistence.*;
import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "contents")
public class Contents implements Serializable {

    /**
     * Status_Online:上架状态
     * Status_Offline：下架状态
     * Max_School_Banner_Count：最多上架校园banner数量
     * Content_Type_School：校园相关的
     * Content_Subtype_Banner：校园banner
     * Content_Subtype_Pic：校园图片
     * Not_Top：未置顶
     * Is_Top：置顶
     */
    private static final long serialVersionUID = 843767499935608832L;

    public static final int Status_Online = 1;
    public static final int Status_Offline = 0;
    public static final int Max_School_Banner_Count = 8;
    public static final int Content_Type_School = 20;
    public static final int Content_Subtype_Banner = 2;
    public static final int Content_Subtype_Pic = 1;
    public static final int Not_Top = 0;
    public static final int Is_Top = 1;



    private Long id;


    private Integer type;


    private String img;


    private String title;


    private Integer level;


    private String author;


    private String content;


    private String summary;


    private String url;


    private Integer status;


    private Long createBy;


    private Long updateBy;


    private Long publishAt;


    private Long updateAt;


    private Long createAt;

    private Integer subType;

    private Integer isTop;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "level")
    public Integer getLevel() {
        return level;
    }


    public void setLevel(Integer level) {
        this.level = level;
    }

    @Column(name = "author")
    public String getAuthor() {
        return author;
    }


    public void setAuthor(String author) {
        this.author = author;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "summary")
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "publish_at")
    public Long getPublishAt() {
        return publishAt;
    }


    public void setPublishAt(Long publishAt) {
        this.publishAt = publishAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "sub_type")
    public Integer getSubType() {
        return subType;
    }


    public void setSubType(Integer subType) {
        this.subType = subType;
    }


    @Column(name = "is_top")
    public Integer getIsTop() {
        return isTop;
    }

    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

