/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Maps;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.WaimaiStoreConsumerService;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class StoreConsumerServiceImpl
implements WaimaiStoreConsumerService {
    @Autowired
    @Qualifier(value="meituanStoreService")
    private WaimaiStoreService meituanStoreService;
    private static Map<String, WaimaiStoreService> waimaiStoreServiceMap = Maps.newHashMap();

    private Map<String, WaimaiStoreService> getWaimaiStoreServiceMap() {
        if (CollectionUtils.isEmpty(waimaiStoreServiceMap.entrySet())) {
            waimaiStoreServiceMap.put("meituan", this.meituanStoreService);
        }
        return waimaiStoreServiceMap;
    }

    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        for (WaimaiStoreService s : this.getWaimaiStoreServiceMap().values()) {
            s.updateStore(mchId, storeId, waimaiStoreDTO);
        }
    }

    public void updateStoreByPlatform(Long mchId, Long storeId, List<String> platformTypes, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        for (String platformType : platformTypes) {
            if (!this.getWaimaiStoreServiceMap().keySet().contains(platformType)) continue;
            this.getWaimaiStoreServiceMap().get(platformType).updateStore(mchId, storeId, waimaiStoreDTO);
        }
    }

    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        for (WaimaiStoreService s : this.getWaimaiStoreServiceMap().values()) {
            s.onlineStore(mchId, storeId);
        }
    }

    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        for (WaimaiStoreService s : this.getWaimaiStoreServiceMap().values()) {
            s.offlineStore(mchId, storeId);
        }
    }

    public void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = this.getWaimaiStoreServiceMap().get(platform);
        if (service != null) {
            waimaiStoreServiceMap.get(platform).onlineStore(mchId, storeId);
        }
    }

    public void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = this.getWaimaiStoreServiceMap().get(platform);
        if (service != null) {
            waimaiStoreServiceMap.get(platform).offlineStore(mchId, storeId);
        }
    }

    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = this.getWaimaiStoreServiceMap().get("meituan");
        if (service != null) {
            return service.getStoreComment(mchId, storeId, startTime, endTime, pageSize);
        }
        return null;
    }

    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = this.getWaimaiStoreServiceMap().get("meituan");
        if (service != null) {
            service.replyStoreComment(mchId, storeId, commentId, replyContent);
        }
    }
}

