/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Lists;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.ShopService;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.Shop;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.ConvertUtils;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class MeituanStroeServiceImpl
extends MeituanAbstractService
implements WaimaiStoreService {
    private static Logger logger = Logger.getLogger(MeituanStroeServiceImpl.class);
    private static final String DEFAULT_MEITUAN_STORE_ID = "0";

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000001").booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        ShopService shopService = client.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        String mappingId = storeMapping == null ? String.valueOf(storeId) : storeMapping.getMappingId();
        try {
            Shop shop = this.buildUpdateShop(mappingId, waimaiStoreDTO, shopService);
            shopService.save(shop);
            if (storeMapping == null) {
                this.saveStoreMapping(mchId, storeId, DEFAULT_MEITUAN_STORE_ID, "000001");
            }
        }
        catch (MtWmErrorException mtWmErrorException) {
            logger.error((Object)mtWmErrorException.getMessage(), (Throwable)mtWmErrorException);
        }
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000001").booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        ShopService shopService = client.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        String mappingId = storeMapping == null ? String.valueOf(storeId) : storeMapping.getMappingId();
        logger.info((Object)("storeMapping is " + storeMapping + " ,mappingId is " + mappingId));
        try {
            shopService.open(mappingId);
        }
        catch (MtWmErrorException mtWmErrorException) {
            logger.error((Object)mtWmErrorException.getMessage(), (Throwable)mtWmErrorException);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        ShopService shopService = client.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        String mappingId = storeMapping == null ? String.valueOf(storeId) : storeMapping.getMappingId();
        try {
            Shop oldShop = this.getStore(mappingId, shopService);
            if (oldShop != null) {
                shopService.close(mappingId);
            }
        }
        catch (MtWmErrorException mtWmErrorException) {
            logger.error((Object)mtWmErrorException.getMessage(), (Throwable)mtWmErrorException);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return null;
        }
        ShopService shopService = client.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return null;
        }
        logger.info((Object)"getStoreComment is execute");
        try {
            List comments = shopService.getShopComment(storeMapping.getMappingId(), startTime, endTime, pageSize);
            return ConvertUtils.converts(comments, WaimaiStoreCommentDTO.class);
        }
        catch (MtWmErrorException mtWmErrorException) {
            logger.error((Object)mtWmErrorException.getMessage(), (Throwable)mtWmErrorException);
            return null;
        }
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        ShopService shopService = client.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        logger.info((Object)"replyStoreComment is execute");
        try {
            shopService.replyShopComment(storeMapping.getMappingId(), String.valueOf(commentId), replyContent);
        }
        catch (MtWmErrorException mtWmErrorException) {
            logger.error((Object)mtWmErrorException.getMessage(), (Throwable)mtWmErrorException);
        }
    }

    private Shop getStore(String mappingId, ShopService shopService) {
        try {
            List shops = shopService.gets((List)Lists.newArrayList((Object[])new String[]{mappingId}));
            if (CollectionUtils.isNotEmpty((Collection)shops)) {
                return (Shop)shops.get(0);
            }
            return null;
        }
        catch (MtWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
            return null;
        }
    }

    private Shop buildCreateShop(String mappingId, WaimaiStoreDTO waiMaiDTO) {
        Shop shop = new Shop();
        shop.setApp_poi_code(mappingId);
        shop.setName(waiMaiDTO.getName());
        shop.setPhone(waiMaiDTO.getServicePhone());
        shop.setShipping_time(waiMaiDTO.getOpenTime());
        shop.setPic_url(waiMaiDTO.getShopLogo());
        shop.setPic_url_large(waiMaiDTO.getShopLogo());
        shop.setPre_book(Integer.valueOf(waiMaiDTO.getIsBookable()));
        shop.setStandby_tel(waiMaiDTO.getPhone());
        shop.setPromotion_info(waiMaiDTO.getPromotionInfo());
        if (waiMaiDTO.getIsInvoice() == 1) {
            shop.setInvoice_support(Integer.valueOf(1));
            shop.setInvoice_min_price(Double.valueOf(CommonUtil.fenChangeY(waiMaiDTO.getInvoiceMinAmount())));
            shop.setInvoice_description("");
        } else {
            shop.setInvoice_support(Integer.valueOf(0));
        }
        return shop;
    }

    private Shop buildUpdateShop(String mappingId, WaimaiStoreDTO waiMaiDTO, ShopService shopService) {
        Shop shop = this.buildCreateShop(mappingId, waiMaiDTO);
        Shop oldShop = this.getStore(mappingId, shopService);
        if (oldShop != null) {
            shop.setAddress(oldShop.getAddress());
            shop.setLatitude(Double.valueOf(oldShop.getLatitude() / 1000000.0));
            shop.setLongitude(Double.valueOf(oldShop.getLongitude() / 1000000.0));
            shop.setShipping_fee(oldShop.getShipping_fee());
        }
        return shop;
    }
}

