/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Maps;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.ElemeAbstractService;
import com.ptteng.onway.platform.service.waimai.ElemeClient;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import eleme.openapi.sdk.api.entity.shop.OShop;
import eleme.openapi.sdk.api.enumeration.shop.OShopProperty;
import eleme.openapi.sdk.api.service.ProductService;
import eleme.openapi.sdk.api.service.ShopService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElemeStoreServiceImpl
extends ElemeAbstractService
implements WaimaiStoreService {
    private static Logger logger = Logger.getLogger(ElemeStoreServiceImpl.class);

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000100").booleanValue()) {
            return;
        }
        ElemeClient elemeClient = this.getElemeClient(mchId);
        if (elemeClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000100");
        if (storeMapping == null) {
            return;
        }
        ShopService restaurantService = elemeClient.getShopService();
        try {
            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()).longValue());
            if (restaurant != null) {
                ProductService productService = elemeClient.getProductService();
                Map<OShopProperty, Object> shopMap = this.buildRestaurant(storeId, storeMapping.getTargetId(), productService, waimaiStoreDTO);
                restaurantService.updateShop(Long.valueOf(storeMapping.getMappingId()).longValue(), shopMap);
            }
        }
        catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Map<OShopProperty, Object> buildRestaurant(Long storeId, String targetId, ProductService productService, WaimaiStoreDTO waimaiStoreDTO) {
        String imageHash = "";
        try {
            imageHash = productService.uploadImageWithRemoteUrl(waimaiStoreDTO.getShopLogo() + "@750w_750h_1e_1c_1pr");
        }
        catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap restaurant = Maps.newHashMap();
        restaurant.put(OShopProperty.name, waimaiStoreDTO.getName());
        restaurant.put(OShopProperty.logoImageHash, imageHash);
        restaurant.put(OShopProperty.isBookable, waimaiStoreDTO.getIsBookable());
        restaurant.put(OShopProperty.openTime, waimaiStoreDTO.getOpenTime());
        restaurant.put(OShopProperty.phone, waimaiStoreDTO.getPhone());
        restaurant.put(OShopProperty.promotionInfo, waimaiStoreDTO.getPromotionInfo());
        restaurant.put(OShopProperty.invoice, waimaiStoreDTO.getIsInvoice());
        restaurant.put(OShopProperty.invoiceMinAmount, CommonUtil.fenChangeY(waimaiStoreDTO.getInvoiceMinAmount()));
        if (waimaiStoreDTO.getNoAgentFeeTotal() > 0) {
            restaurant.put(OShopProperty.noAgentFeeTotal, CommonUtil.fenChangeY(waimaiStoreDTO.getNoAgentFeeTotal()));
        }
        restaurant.put(OShopProperty.packingFee, CommonUtil.fenChangeY(waimaiStoreDTO.getPackingFee()));
        return restaurant;
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000100").booleanValue()) {
            return;
        }
        ElemeClient elemeClient = this.getElemeClient(mchId);
        if (elemeClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000100");
        if (storeMapping == null) {
            return;
        }
        ShopService restaurantService = elemeClient.getShopService();
        try {
            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()).longValue());
            if (restaurant != null) {
                HashMap map = Maps.newHashMap();
                map.put(OShopProperty.isOpen, "1");
                restaurantService.updateShop(Long.valueOf(storeMapping.getTargetId()).longValue(), (Map)map);
            }
        }
        catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000100").booleanValue()) {
            return;
        }
        ElemeClient elemeClient = this.getElemeClient(mchId);
        if (elemeClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000100");
        if (storeMapping == null) {
            return;
        }
        ShopService restaurantService = elemeClient.getShopService();
        try {
            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()).longValue());
            if (restaurant != null) {
                HashMap map = Maps.newHashMap();
                map.put(OShopProperty.isOpen, "0");
                restaurantService.updateShop(Long.valueOf(storeMapping.getTargetId()).longValue(), (Map)map);
            }
        }
        catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        return null;
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
    }
}

