/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.other.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiOrderMappingDTO;
import com.ptteng.onway.platform.model.WaimaiStoreMappingDTO;
import com.ptteng.onway.platform.service.WaimaiService;
import com.ptteng.onway.platform.service.waimai.other.ConvertUtils;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiLogInfoDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiOrderMappingDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiStoreMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiLogInfo;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class WaimaiServiceImpl
implements WaimaiService {
    @Autowired
    private WaimaiLogInfoDao waimaiLogInfoDao;
    @Autowired
    private WaimaiStoreMappingDao waimaiStoreMappingDao;
    @Autowired
    private WaimaiOrderMappingDao waimaiOrderMappingDao;

    public void saveWaiMaiLog(String cmd, String method, Boolean isSuccess, String request, String response) throws ServiceException, ServiceDaoException {
        WaimaiLogInfo log = new WaimaiLogInfo();
        log.setCmd(cmd);
        log.setMethod(method);
        log.setIsSuccess(isSuccess);
        log.setRequest(request);
        log.setResponse(response);
        this.waimaiLogInfoDao.saveLogInfo(log);
    }

    public WaimaiStoreMappingDTO findStoreMappingByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiStoreMapping waimaiStoreMapping = this.waimaiStoreMappingDao.findOneByMappingIdPlatformType(mappingId, platformType);
        if (Objects.isNull(waimaiStoreMapping)) {
            return null;
        }
        return ConvertUtils.convert((Object)waimaiStoreMapping, WaimaiStoreMappingDTO.class);
    }

    public WaimaiStoreMappingDTO findStoreMappingByStoreIdPlatformType(Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiStoreMapping waimaiStoreMapping = this.waimaiStoreMappingDao.findOneByStoreIdPlatformType(storeId, platformType);
        if (Objects.isNull(waimaiStoreMapping)) {
            return null;
        }
        return ConvertUtils.convert((Object)waimaiStoreMapping, WaimaiStoreMappingDTO.class);
    }

    public WaimaiOrderMappingDTO findOrderMappingByTargetIdPlatformType(String targetId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiOrderMapping waimaiOrderMapping = this.waimaiOrderMappingDao.findOneByTargetIdPlatformType(targetId, platformType);
        if (Objects.isNull(waimaiOrderMapping)) {
            return null;
        }
        return ConvertUtils.convert((Object)waimaiOrderMapping, WaimaiOrderMappingDTO.class);
    }

    public void saveOrderMapping(Long mchId, Long storeId, Long orderId, String targetId, String viewId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiOrderMapping orderMapping = new WaimaiOrderMapping();
        orderMapping.setMchId(mchId);
        orderMapping.setStoreId(storeId);
        orderMapping.setOrderId(orderId);
        orderMapping.setTargetId(targetId);
        orderMapping.setViewId(viewId);
        orderMapping.setPlatformType(platformType);
        this.waimaiOrderMappingDao.saveOrderMapping(orderMapping);
    }
}

