/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.OrderService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import com.ptteng.onway.platform.service.waimai.order.impls.MeituanOrderServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.apache.log4j.Logger;

public class BaiduOrderServiceImpl
extends BaiduAbstractService
implements WaimaiOrderService {
    private static Logger logger = Logger.getLogger(MeituanOrderServiceImpl.class);

    @Override
    public void confirmOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!this.isBaiduOrder(orderId).booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000010");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = bdWmClient.getOrderService();
        try {
            orderService.confirm(orderMapping.getTargetId());
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void cancelOrder(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        if (!this.isBaiduOrder(orderId).booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000010");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = bdWmClient.getOrderService();
        try {
            orderService.cancel(orderMapping.getTargetId(), reasonId.intValue(), reason);
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void completeOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!this.isBaiduOrder(orderId).booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000010");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = bdWmClient.getOrderService();
        try {
            orderService.complete(orderMapping.getTargetId());
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
    }
}

