/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.dish.impls;

import com.alibaba.fastjson.JSONArray;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.google.common.collect.Lists;
import com.jiabangou.mtwmsdk.api.FoodService;
import com.jiabangou.mtwmsdk.api.ImageService;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.AvailableTimes;
import com.jiabangou.mtwmsdk.model.Food;
import com.jiabangou.mtwmsdk.model.FoodCategory;
import com.jiabangou.mtwmsdk.model.FoodSkuStock;
import com.jiabangou.mtwmsdk.model.Sku;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.dish.WaimaiDishService;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishCategoryMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class MeituanDishServiceImpl
extends MeituanAbstractService
implements WaimaiDishService {
    private static Logger logger = Logger.getLogger(MeituanDishServiceImpl.class);
    private static final String DEFAULT_MEITUAN_CATEGORY_ID = "0";
    private static final String DEFAULT_MEITUAN_DISH_ID = "0";

    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000001").booleanValue()) {
            return;
        }
        MtWmClient mtWmClient = this.getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        FoodCategory foodCategory = new FoodCategory();
        foodCategory.setApp_poi_code(storeMapping.getMappingId());
        foodCategory.setCategory_name(dishGroup.getName());
        foodCategory.setCategory_name_origin(dishGroup.getOldName());
        foodCategory.setSequence(String.valueOf(-dishGroup.getGroupRank().longValue()));
        try {
            FoodService foodService = mtWmClient.getFoodService();
            foodService.updateCategory(foodCategory);
            this.saveDishCategoryMapping(mchId, storeId, dishGroupId, foodCategory.getCategory_name(), "0", "000001");
        }
        catch (MtWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        this.saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
    }

    @Override
    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000001").booleanValue()) {
            return;
        }
        MtWmClient mtWmClient = this.getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        if (Objects.isNull(dishNormWmDTO.getDishGroupWmDTO())) {
            return;
        }
        DishGroupWmDTO category = dishNormWmDTO.getDishGroupWmDTO();
        WaimaiDishCategoryMapping dishCategoryMapping = this.findDishCategoryMapping(mchId, storeId, category.getId(), "000001");
        if (dishCategoryMapping == null) {
            this.saveDishCategoryMapping(mchId, storeId, category.getId(), category.getName(), "0", "000001");
        }
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000001");
        try {
            FoodService foodService = mtWmClient.getFoodService();
            ImageService imageService = mtWmClient.getImageService();
            Food food = this.buildFoodSave(dishNormId, storeMapping, dishNormWmDTO, imageService);
            if (dishMapping == null) {
                this.addDishMapping(mchId, storeId, dishNormId, "0", "000001");
            }
            foodService.initdata(food);
        }
        catch (MtWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    private Food buildFoodSave(Long dishNormId, WaimaiStoreMapping storeMapping, DishNormWmDTO dishNormWmDTO, ImageService imageService) throws MtWmErrorException {
        Food food = new Food();
        food.setApp_poi_code(storeMapping.getMappingId());
        food.setApp_food_code(String.valueOf(dishNormId));
        food.setName(dishNormWmDTO.getName());
        food.setPrice(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPrice())));
        food.setMin_order_count(Integer.valueOf(dishNormWmDTO.getMinOrderNum()));
        food.setBox_num(Float.valueOf(dishNormWmDTO.getPackageBoxNum()));
        food.setBox_price(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPackageFee())));
        food.setCategory_name(dishNormWmDTO.getDishGroupWmDTO().getName());
        food.setIs_sold_out(Integer.valueOf(0));
        food.setSequence(Integer.valueOf(-dishNormWmDTO.getDishGroupWmDTO().getRank().intValue()));
        String imageName = dishNormWmDTO.getPic().substring(dishNormWmDTO.getPic().lastIndexOf("/") + 1);
        if (!imageName.contains(".jpg")) {
            String imageType = imageName.substring(imageName.lastIndexOf("."));
            imageName = imageName.replace(imageType, ".jpg");
        }
        String picture = imageService.uploadImage(storeMapping.getMappingId(), imageName, dishNormWmDTO.getPic() + "@750w_625h_1e_1c_1pr");
        food.setPicture(picture);
        Sku sku = new Sku();
        sku.setSku_id(String.valueOf(dishNormId));
        sku.setSpec(dishNormWmDTO.getName());
        sku.setPrice(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPrice())));
        sku.setStock(Integer.valueOf(dishNormWmDTO.getStock()));
        this.setAvailableTime(dishNormWmDTO, sku);
        ArrayList<Sku> skus = new ArrayList<Sku>();
        skus.add(sku);
        food.setSkus(skus);
        return food;
    }

    private void setAvailableTime(DishNormWmDTO dishNormWmDTO, Sku sku) {
        String deliveryTime = dishNormWmDTO.getAvailableTimes();
        if (StringUtil.isNotEmpty((String)deliveryTime)) {
            sku.setAvailable_times((AvailableTimes)JSONArray.parseObject((String)deliveryTime, AvailableTimes.class));
        }
    }

    @Override
    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000001").booleanValue()) {
            return;
        }
        MtWmClient mtWmClient = this.getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000001");
        if (dishMapping == null) {
            return;
        }
        try {
            FoodService foodService = mtWmClient.getFoodService();
            Food food = new Food();
            food.setApp_poi_code(String.valueOf(storeId));
            food.setApp_food_code(String.valueOf(dishNormId));
            food.setIs_sold_out(Integer.valueOf(1));
            foodService.initdata(food);
        }
        catch (MtWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        WaimaiDishMapping dishMapping;
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000001").booleanValue()) {
            return;
        }
        MtWmClient mtWmClient = this.getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        if (Objects.isNull(dishNormWmDTO.getDishGroupWmDTO())) {
            return;
        }
        DishGroupWmDTO category = dishNormWmDTO.getDishGroupWmDTO();
        WaimaiDishCategoryMapping dishCategoryMapping = this.findDishCategoryMapping(mchId, storeId, category.getId(), "000001");
        if (dishCategoryMapping == null) {
            this.saveDishCategoryMapping(mchId, storeId, category.getId(), category.getName(), "0", "000001");
        }
        if ((dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000001")) == null) {
            return;
        }
        try {
            FoodService foodService = mtWmClient.getFoodService();
            ImageService imageService = mtWmClient.getImageService();
            Food food = this.buildFoodSave(dishNormId, storeMapping, dishNormWmDTO, imageService);
            foodService.initdata(food);
        }
        catch (MtWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        for (DishNormWmDTO dishNormWmDTO : dishNormWmDTOs) {
            this.updateDish(mchId, storeId, dishNormWmDTO.getDishNormId(), dishNormWmDTO);
        }
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000001").booleanValue()) {
            return;
        }
        MtWmClient mtWmClient = this.getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000001");
        if (null == dishMapping) {
            return;
        }
        FoodService foodService = mtWmClient.getFoodService();
        try {
            ArrayList skus = Lists.newArrayList();
            Sku sku = new Sku();
            sku.setSku_id(dishMapping.getMappingId());
            sku.setStock(Integer.valueOf(stock));
            skus.add(sku);
            FoodSkuStock foodSkuStock = new FoodSkuStock();
            foodSkuStock.setApp_food_code(dishMapping.getMappingId());
            foodSkuStock.setSkus((List)skus);
            ArrayList foodSkuStocks = Lists.newArrayList();
            foodSkuStocks.add(foodSkuStock);
            foodService.updateSkuStock(storeMapping.getMappingId(), (List)foodSkuStocks);
        }
        catch (MtWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

