/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.dish.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Lists;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.DishService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Category;
import com.jiabangou.bdwmsdk.model.CategoryUpdate;
import com.jiabangou.bdwmsdk.model.Dish;
import com.jiabangou.bdwmsdk.model.DishDetail;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.dish.WaimaiDishService;
import com.ptteng.onway.platform.service.waimai.other.ConvertUtils;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import java.util.List;
import org.apache.log4j.Logger;

public class BaiduDishServiceImpl
extends BaiduAbstractService
implements WaimaiDishService {
    private static Logger logger = Logger.getLogger(BaiduDishServiceImpl.class);
    private static final String DEFAULT_BAIDU_CATEGORY_ID = "0";
    private static final int STOCK_COUNT = 300;

    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        DishService dishService = bdWmClient.getDishService();
        String storeMappingId = storeMapping.getMappingId();
        try {
            String dishGroupOldName = dishGroup.getOldName() != null ? dishGroup.getOldName() : dishGroup.getName();
            Category oldCategory = dishService.getCategory(storeMappingId, dishGroupOldName);
            if (oldCategory != null) {
                CategoryUpdate categoryUpdate = new CategoryUpdate();
                categoryUpdate.setName(dishGroup.getName());
                categoryUpdate.setOld_name(oldCategory.getName());
                categoryUpdate.setRank(Integer.valueOf(dishGroup.getGroupRank().intValue()));
                categoryUpdate.setShop_id(storeMappingId);
                dishService.updateCategory(categoryUpdate);
                this.saveDishCategoryMapping(mchId, storeId, dishGroupId, categoryUpdate.getName(), DEFAULT_BAIDU_CATEGORY_ID, "000010");
            } else {
                Category category = new Category();
                category.setName(dishGroup.getName());
                category.setRank(Integer.valueOf(dishGroup.getGroupRank().intValue()));
                category.setShop_id(storeMappingId);
                Long categoryId = dishService.createCategory(category);
                this.saveDishCategoryMapping(mchId, storeId, dishGroupId, category.getName(), String.valueOf(categoryId), "000010");
            }
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        this.saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
    }

    @Override
    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        DishService dishService = bdWmClient.getDishService();
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000010");
        String dishMappingId = dishMapping == null ? String.valueOf(dishNormId) : dishMapping.getMappingId();
        try {
            this.checkDishGroupAndCreate(mchId, storeId, dishNormWmDTO.getDishGroupWmDTO(), dishService, storeMapping.getMappingId());
            DishDetail dishDetail = dishService.get(storeMapping.getMappingId(), dishMappingId);
            if (dishDetail != null) {
                dishService.online(storeMapping.getMappingId(), dishMappingId);
            }
        }
        catch (BdWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkDishGroupAndCreate(Long mchId, Long storeId, DishGroupWmDTO dishGroupWmDTO, DishService dishService, String storeMappingId) throws ServiceException, ServiceDaoException {
        try {
            Category oldCategory = dishService.getCategory(storeMappingId, dishGroupWmDTO.getName());
            if (oldCategory == null) {
                Category category = new Category();
                category.setName(dishGroupWmDTO.getName());
                category.setRank(Integer.valueOf(dishGroupWmDTO.getGroupRank().intValue()));
                category.setShop_id(storeMappingId);
                long categoryId = dishService.createCategory(category);
                this.saveDishCategoryMapping(mchId, storeId, dishGroupWmDTO.getId(), category.getName(), String.valueOf(categoryId), "000010");
            }
        }
        catch (BdWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000010");
        if (dishMapping == null) {
            return;
        }
        try {
            DishService dishService = bdWmClient.getDishService();
            dishService.offline(String.valueOf(storeMapping.getMappingId()), String.valueOf(dishNormId));
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        DishService dishService = bdWmClient.getDishService();
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000010");
        String dishMappingId = dishMapping == null ? String.valueOf(dishNormId) : dishMapping.getMappingId();
        Dish dish = this.buildBdWmDish(storeMapping.getMappingId(), dishNormWmDTO, dishMappingId);
        try {
            this.checkDishGroupAndCreate(mchId, storeId, dishNormWmDTO.getDishGroupWmDTO(), dishService, storeMapping.getMappingId());
            DishDetail dishDetail = dishService.get(storeMapping.getMappingId(), dishMappingId);
            if (dishDetail != null) {
                dishService.update(dish);
            }
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    private Dish buildBdWmDish(String storeMappingId, DishNormWmDTO dishNormWmDTO, String mappingId) throws ServiceException {
        Dish bdWmDish = new Dish();
        bdWmDish.setShop_id(storeMappingId);
        bdWmDish.setDish_id(mappingId);
        bdWmDish.setPrice(Integer.valueOf(dishNormWmDTO.getPrice()));
        bdWmDish.setPic(dishNormWmDTO.getPic() + "@750w_625h_1e_1c_1pr");
        bdWmDish.setMin_order_num(Integer.valueOf(dishNormWmDTO.getMinOrderNum()));
        bdWmDish.setPackage_box_num(Integer.valueOf(dishNormWmDTO.getPackageBoxNum()));
        bdWmDish.setDescription(dishNormWmDTO.getDescription());
        bdWmDish.setName(dishNormWmDTO.getName());
        bdWmDish.setCategory((List)Lists.newArrayList((Object[])new Category[]{ConvertUtils.convert((Object)dishNormWmDTO.getDishGroupWmDTO(), Category.class)}));
        bdWmDish.setStock(Integer.valueOf(300));
        return bdWmDish;
    }

    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        for (DishNormWmDTO dishNormWmDTO : dishNormWmDTOs) {
            this.updateDish(mchId, storeId, dishNormWmDTO.getDishNormId(), dishNormWmDTO);
        }
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {
        if (!this.checkDishPlatformById(mchId, storeId, dishNormId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        WaimaiDishMapping dishMapping = this.findDishMapping(mchId, storeId, dishNormId, "000010");
        if (null == dishMapping) {
            return;
        }
        DishService dishService = bdWmClient.getDishService();
        try {
            dishService.setThreshold(storeMapping.getMappingId(), dishMapping.getMappingId(), stock);
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }
}

