/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.TrademarkParamsRelation;
import com.ptteng.onway.platform.service.impl.TrademarkParamsRelationServiceImpl;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.ElemeClient;
import com.ptteng.onway.platform.service.waimai.WaimaiAbstractService;
import eleme.openapi.sdk.api.service.OrderService;
import eleme.openapi.sdk.api.service.ProductService;
import eleme.openapi.sdk.api.service.ShopService;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.OAuthClient;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.PropertiesUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElemeAbstractService
extends WaimaiAbstractService {
    private Logger logger = Logger.getLogger(BaiduAbstractService.class);
    private static final boolean isSandbox = true;
    private OAuthClient client = null;
    private Map<String, String> tokenMap = new HashMap<String, String>();
    @Autowired
    @Qualifier(value="trademarkParamsRelationService")
    private TrademarkParamsRelationServiceImpl trademarkParamsRelationService;

    public ElemeClient getElemeClient(Long mchId) throws ServiceException, ServiceDaoException {
        List<Long> ids = this.trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatform(mchId, "000100", 0, 1);
        if (CollectionUtils.isEmpty(ids)) {
            throw new ServiceException("trademarkParamsRelation is null ! mch id is :" + String.valueOf(mchId));
        }
        List<TrademarkParamsRelation> trademarkParamsRelations = this.trademarkParamsRelationService.getObjectsByIds(ids);
        if (CollectionUtils.isEmpty(trademarkParamsRelations)) {
            throw new ServiceException("trademarkParamsRelation is null ! id is :" + String.valueOf(ids.get(0)));
        }
        TrademarkParamsRelation trademarkParamsRelation = trademarkParamsRelations.get(0);
        Config config = new Config(true, trademarkParamsRelation.getAppid(), trademarkParamsRelation.getSecret());
        this.client = new OAuthClient(config);
        this.clientToken();
        ShopService shopService = new ShopService(config, this.getToken());
        ProductService productService = new ProductService(config, this.getToken());
        OrderService orderService = new OrderService(config, this.getToken());
        ElemeClient elemeClient = new ElemeClient();
        elemeClient.setShopService(shopService);
        elemeClient.setProductService(productService);
        elemeClient.setOrderService(orderService);
        return elemeClient;
    }

    private Token getToken() {
        String access_token = PropertiesUtils.getPropValueByKey((String)"access_token");
        String token_type = PropertiesUtils.getPropValueByKey((String)"token_type");
        String expires_in = PropertiesUtils.getPropValueByKey((String)"expires_in");
        String refresh_token = PropertiesUtils.getPropValueByKey((String)"refresh_token");
        if (access_token.isEmpty()) {
            System.out.println("access_token is null");
            return null;
        }
        Token token = new Token();
        token.setAccessToken(access_token);
        token.setTokenType(token_type);
        token.setExpires(Long.valueOf(expires_in).longValue());
        token.setRefreshToken(refresh_token);
        return token;
    }

    private void setTokenInfo(Token token) {
        if (null != token && token.isSuccess()) {
            this.tokenMap.put("access_token", token.getAccessToken());
            this.tokenMap.put("token_type", token.getTokenType());
            this.tokenMap.put("expires_in", String.valueOf(token.getExpires()));
            this.tokenMap.put("refresh_token", token.getRefreshToken());
            PropertiesUtils.setProps(this.tokenMap);
        }
    }

    private void clientToken() {
        Token token = this.client.getTokenInClientCredentials();
        if (token.isSuccess()) {
            this.setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }
}

