/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.UserOrder;
import com.ptteng.onway.platform.service.UserOrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog(UserOrderServiceImpl.class);

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public List<Long> getUserOrderIdsByPlatform(String platform, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by platform,start,limit  : " + platform + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByPlatform", new Object[]{platform}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by platform,start,limit)  : " + platform + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdByOrderNum(Long orderNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNum  : " + orderNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdByOrderNum", new Object[]{orderNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNum  : " + orderNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserOrderIdByPlatformOrderNum(String platformOrderNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by platformOrderNum  : " + platformOrderNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdByPlatformOrderNum", new Object[]{platformOrderNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by platformOrderNum  : " + platformOrderNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserOrderIdByPlatformOrderId(String platformOrderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by platformOrderNum  : " + platformOrderId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdByPlatformOrderId", new Object[]{platformOrderId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by platformOrderId  : " + platformOrderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserOrderIdByPlatformOrderIds(String platformOrderIds, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by platformOrderIds : " + platformOrderIds));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdByPlatformOrderIds", new Object[]{platformOrderIds}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by platformOrderIds,start,limit)  : " + platformOrderIds + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByBuyAt(Long startBuyAt, Long endBuyAt, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by startBuyAt,endBuyAt,start,limit  : " + startBuyAt + " , " + endBuyAt + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByBuyAt", new Object[]{startBuyAt, endBuyAt}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by startBuyAt,endBuyAt,start,limit)  : " + startBuyAt + " , " + endBuyAt + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByTrademarkId(Long trademarkId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by trademarkId,start,limit  : " + trademarkId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByTrademarkId", new Object[]{trademarkId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus, Integer orderStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by acceptStatus,orderStatus,start,limit  : " + acceptStatus + " , " + orderStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByAcceptStatusAndOrderStatus", new Object[]{acceptStatus, orderStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by acceptStatus,orderStatus,start,limit)  : " + acceptStatus + " , " + orderStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByStoreId(Long storeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by storeId,start,limit  : " + storeId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByStoreId", new Object[]{storeId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by storeId,start,limit)  : " + storeId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByStoreIdAcceptStatus(Long storeId, Integer acceptStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by storeId,acceptStatus,start,limit  : " + storeId + " , " + acceptStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByStoreIdAcceptStatus", new Object[]{storeId, acceptStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by storeId,start,limit)  : " + storeId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIdsByPlatform(String platform) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by platform  : " + platform));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByPlatform", new Object[]{platform});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by platform)  : " + platform));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByBuyAt(Long startBuyAt, Long endBuyAt) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by startBuyAt,endBuyAt  : " + startBuyAt + " , " + endBuyAt));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByBuyAt", new Object[]{startBuyAt, endBuyAt});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by startBuyAt,endBuyAt)  : " + startBuyAt + " , " + endBuyAt));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByTrademarkId(Long trademarkId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by trademarkId  : " + trademarkId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByTrademarkId", new Object[]{trademarkId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by trademarkId)  : " + trademarkId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus, Integer orderStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by acceptStatus,orderStatus  : " + acceptStatus + " , " + orderStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByAcceptStatusAndOrderStatus", new Object[]{acceptStatus, orderStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by acceptStatus,orderStatus)  : " + acceptStatus + " , " + orderStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByStoreId(Long storeId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by storeId  : " + storeId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByStoreId", new Object[]{storeId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by storeId)  : " + storeId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

