/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.service.StoreService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreServiceImpl
extends BaseDaoServiceImpl
implements StoreService {
    private static final Log log = LogFactory.getLog(StoreServiceImpl.class);

    public Long insert(Store store) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + store));
        if (store == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        store.setCreateAt(Long.valueOf(currentTimeMillis));
        store.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)store);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + store));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Store> insertList(List<Store> storeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (storeList == null ? "null" : Integer.valueOf(storeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(storeList)) {
            return new ArrayList<Store>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Store store : storeList) {
            store.setCreateAt(Long.valueOf(currentTimeMillis));
            store.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(storeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + storeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Store.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Store store) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (store == null ? "null" : store.getId())));
        boolean result = false;
        if (store == null) {
            return true;
        }
        store.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)store);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + store));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + store));
        }
        return result;
    }

    public boolean updateList(List<Store> storeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (storeList == null ? "null" : Integer.valueOf(storeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(storeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Store store : storeList) {
            store.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(storeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + storeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + storeList.size()));
        return result;
    }

    public Store getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Store store = null;
        if (id == null) {
            return store;
        }
        try {
            store = (Store)this.dao.get(Store.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return store;
    }

    public List<Store> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List store = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Store>();
        }
        try {
            store = this.dao.getList(Store.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (store == null ? "null" : Integer.valueOf(store.size()))));
        return store;
    }

    public List<Long> getStoreIdsByTrademarkNum(String trademarkNum, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by trademarkNum,start,limit  : " + trademarkNum + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStoreIdsByTrademarkNum", new Object[]{trademarkNum}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by trademarkNum,start,limit)  : " + trademarkNum + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStoreIdsByTrademarkId(Long trademarkId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by trademarkId,start,limit  : " + trademarkId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStoreIdsByTrademarkId", new Object[]{trademarkId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getStoreIdByStoreNum(String storeNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by storeNum  : " + storeNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStoreIdByStoreNum", new Object[]{storeNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by storeNum  : " + storeNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countStoreIdsByTrademarkNum(String trademarkNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by trademarkNum  : " + trademarkNum));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStoreIdsByTrademarkNum", new Object[]{trademarkNum});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by trademarkNum)  : " + trademarkNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStoreIdsByTrademarkId(Long trademarkId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by trademarkId  : " + trademarkId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStoreIdsByTrademarkId", new Object[]{trademarkId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by trademarkId)  : " + trademarkId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStoreIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStoreIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStoreIdsByMtOnline(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStoreIdsByMtOnline", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStoreIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStoreIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStoreIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

