/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.Food;
import com.ptteng.onway.platform.service.FoodService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FoodServiceImpl
extends BaseDaoServiceImpl
implements FoodService {
    private static final Log log = LogFactory.getLog(FoodServiceImpl.class);

    public Long insert(Food food) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + food));
        if (food == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        food.setCreateAt(Long.valueOf(currentTimeMillis));
        food.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)food);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + food));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Food> insertList(List<Food> foodList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (foodList == null ? "null" : Integer.valueOf(foodList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(foodList)) {
            return new ArrayList<Food>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Food food : foodList) {
            food.setCreateAt(Long.valueOf(currentTimeMillis));
            food.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(foodList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + foodList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Food.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Food food) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (food == null ? "null" : food.getId())));
        boolean result = false;
        if (food == null) {
            return true;
        }
        food.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)food);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + food));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + food));
        }
        return result;
    }

    public boolean updateList(List<Food> foodList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (foodList == null ? "null" : Integer.valueOf(foodList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(foodList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Food food : foodList) {
            food.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(foodList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + foodList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + foodList.size()));
        return result;
    }

    public Food getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Food food = null;
        if (id == null) {
            return food;
        }
        try {
            food = (Food)this.dao.get(Food.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return food;
    }

    public List<Food> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List food = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Food>();
        }
        try {
            food = this.dao.getList(Food.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (food == null ? "null" : Integer.valueOf(food.size()))));
        return food;
    }

    public Long getFoodIdByFoodNum(String foodNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by foodNum  : " + foodNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getFoodIdByFoodNum", new Object[]{foodNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by foodNum  : " + foodNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getFoodIdsByfoodType(Integer foodType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by foodType,start,limit  : " + foodType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodIdsByfoodType", new Object[]{foodType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by foodType,start,limit)  : " + foodType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFoodIdsByfoodType(Integer foodType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by foodType  : " + foodType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getFoodIdsByfoodType", new Object[]{foodType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by foodType)  : " + foodType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getFoodIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFoodIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFoodIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFoodIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

