/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.BusinessHours;
import com.ptteng.onway.platform.service.BusinessHoursService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BusinessHoursServiceImpl
extends BaseDaoServiceImpl
implements BusinessHoursService {
    private static final Log log = LogFactory.getLog(BusinessHoursServiceImpl.class);

    public Long insert(BusinessHours businessHours) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + businessHours));
        if (businessHours == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        businessHours.setCreateAt(Long.valueOf(currentTimeMillis));
        businessHours.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)businessHours);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + businessHours));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BusinessHours> insertList(List<BusinessHours> businessHoursList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (businessHoursList == null ? "null" : Integer.valueOf(businessHoursList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(businessHoursList)) {
            return new ArrayList<BusinessHours>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BusinessHours businessHours : businessHoursList) {
            businessHours.setCreateAt(Long.valueOf(currentTimeMillis));
            businessHours.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(businessHoursList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + businessHoursList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BusinessHours.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BusinessHours businessHours) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (businessHours == null ? "null" : businessHours.getId())));
        boolean result = false;
        if (businessHours == null) {
            return true;
        }
        businessHours.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)businessHours);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + businessHours));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + businessHours));
        }
        return result;
    }

    public boolean updateList(List<BusinessHours> businessHoursList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (businessHoursList == null ? "null" : Integer.valueOf(businessHoursList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(businessHoursList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BusinessHours businessHours : businessHoursList) {
            businessHours.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(businessHoursList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + businessHoursList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + businessHoursList.size()));
        return result;
    }

    public BusinessHours getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BusinessHours businessHours = null;
        if (id == null) {
            return businessHours;
        }
        try {
            businessHours = (BusinessHours)this.dao.get(BusinessHours.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return businessHours;
    }

    public List<BusinessHours> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List businessHours = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BusinessHours>();
        }
        try {
            businessHours = this.dao.getList(BusinessHours.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (businessHours == null ? "null" : Integer.valueOf(businessHours.size()))));
        return businessHours;
    }

    public List<Long> getBusinessHoursIdsByTargetId(Long targetId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by targetId,start,limit  : " + targetId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBusinessHoursIdsByTargetId", new Object[]{targetId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by targetId,start,limit)  : " + targetId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBusinessHoursIdsByTargetIdAndStatus(Long targetId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by targetId,status,start,limit  : " + targetId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBusinessHoursIdsByTargetIdAndStatus", new Object[]{targetId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by targetId,status,start,limit)  : " + targetId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getBusinessHoursIdByTargetIdAndMealTypeAndStatus(Long targetId, Integer mealType, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by targetId,mealType,status  : " + targetId + " , " + mealType + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getBusinessHoursIdByTargetIdAndMealTypeAndStatus", new Object[]{targetId, mealType, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by targetId,mealType,status  : " + targetId + " , " + mealType + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countBusinessHoursIdsByTargetId(Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by targetId  : " + targetId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBusinessHoursIdsByTargetId", new Object[]{targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by targetId)  : " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBusinessHoursIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBusinessHoursIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBusinessHoursIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBusinessHoursIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBusinessHoursIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

