/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.finance.etl.unit;

import com.ptteng.onway.finance.etl.unit.CipCaterTakeoutPoiQueryReviewList;
import com.ptteng.onway.platform.model.FoodTypeRelation;
import com.ptteng.onway.platform.model.Store;
import com.sankuai.sjst.platform.developer.domain.RequestSysParams;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishBaseQueryByEPoiIdRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishBatchUploadRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishCatDeleteRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishCatUpdateRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishDeleteRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutDishMapRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiCloseRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiDelayDispatchQueryRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiDelayDispatchUpdateRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiInfoQueryRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiOpenRequest;
import com.sankuai.sjst.platform.developer.request.CipCaterTakeoutPoiOpenTimeUpdateRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class WaimaiEPRUtil {
    private static final Log log = LogFactory.getLog(WaimaiEPRUtil.class);
    private static final String secret = "n9p3fbjra1jpm80d";

    private static RequestSysParams requestSysParams(String appAuthToken) {
        return new RequestSysParams(secret, appAuthToken);
    }

    public static String takeoutPoiOpen(String appAuthToken) {
        CipCaterTakeoutPoiOpenRequest cipCaterTakeoutPoiOpenRequest = new CipCaterTakeoutPoiOpenRequest();
        cipCaterTakeoutPoiOpenRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiOpenRequest.doRequest();
            log.info((Object)"====== takeout poi open result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi open error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiClose(String appAuthToken) {
        CipCaterTakeoutPoiCloseRequest cipCaterTakeoutPoiCloseRequest = new CipCaterTakeoutPoiCloseRequest();
        cipCaterTakeoutPoiCloseRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiCloseRequest.doRequest();
            log.info((Object)"====== takeout poi close result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi close error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiUpdateOpenTime(String appAuthToken, String openTime) {
        CipCaterTakeoutPoiOpenTimeUpdateRequest cipCaterTakeoutPoiOpenTimeUpdateRequest = new CipCaterTakeoutPoiOpenTimeUpdateRequest();
        cipCaterTakeoutPoiOpenTimeUpdateRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutPoiOpenTimeUpdateRequest.setOpenTime(openTime);
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiOpenTimeUpdateRequest.doRequest();
            log.info((Object)"====== takeout poi update open time result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi update open time error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiQueryDelayDispatch(String appAuthToken) {
        CipCaterTakeoutPoiDelayDispatchQueryRequest cipCaterTakeoutPoiDelayDispatchQueryRequest = new CipCaterTakeoutPoiDelayDispatchQueryRequest();
        cipCaterTakeoutPoiDelayDispatchQueryRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiDelayDispatchQueryRequest.doRequest();
            log.info((Object)"====== takeout poi delay dispatch query result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi delay dispatch query: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiUpdateDelayDispatch(String appAuthToken, Integer delaySeconds) {
        CipCaterTakeoutPoiDelayDispatchUpdateRequest cipCaterTakeoutPoiDelayDispatchUpdateRequest = new CipCaterTakeoutPoiDelayDispatchUpdateRequest();
        cipCaterTakeoutPoiDelayDispatchUpdateRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutPoiDelayDispatchUpdateRequest.setDelaySeconds(delaySeconds);
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiDelayDispatchUpdateRequest.doRequest();
            log.info((Object)"====== takeout poi delay dispatch update result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi delay dispatch update  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiInfoQuery(String appAuthToken, String ePoiIds) {
        CipCaterTakeoutPoiInfoQueryRequest cipCaterTakeoutPoiInfoQueryRequest = new CipCaterTakeoutPoiInfoQueryRequest();
        cipCaterTakeoutPoiInfoQueryRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutPoiInfoQueryRequest.setEPoiIds(ePoiIds);
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiInfoQueryRequest.doRequest();
            log.info((Object)"====== takeout poi info query result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi info query  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutPoiQueryReviewList(String appAuthToken, String ePoiIds, Long startTime, Long endTime, Integer offset, Integer limit) {
        log.info((Object)("appAuthToken is " + appAuthToken + " ,ePoiIds is " + ePoiIds + " ,startTime is " + startTime / 1000L + " ,endTime is " + endTime / 1000L + " ,offset is " + offset + " ,limit is " + limit));
        CipCaterTakeoutPoiQueryReviewList cipCaterTakeoutPoiQueryReviewList = new CipCaterTakeoutPoiQueryReviewList();
        cipCaterTakeoutPoiQueryReviewList.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutPoiQueryReviewList.setePoiId(ePoiIds);
        cipCaterTakeoutPoiQueryReviewList.setStartTime(String.valueOf(startTime / 1000L));
        cipCaterTakeoutPoiQueryReviewList.setEndTime(String.valueOf(endTime / 1000L));
        cipCaterTakeoutPoiQueryReviewList.setOffset(offset.toString());
        cipCaterTakeoutPoiQueryReviewList.setLimit(limit.toString());
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutPoiQueryReviewList.doRequest();
            log.info((Object)"====== takeout poi query review list result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout poi query review list  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutDishQueryBaseListByEPoiId(String appAuthToken, String ePoiIds) {
        log.info((Object)("appAuthToken is " + appAuthToken + " ,ePoiIds is " + ePoiIds));
        CipCaterTakeoutDishBaseQueryByEPoiIdRequest cipCaterTakeoutDishBaseQueryByEPoiIdRequest = new CipCaterTakeoutDishBaseQueryByEPoiIdRequest();
        cipCaterTakeoutDishBaseQueryByEPoiIdRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutDishBaseQueryByEPoiIdRequest.setePoiId(ePoiIds);
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutDishBaseQueryByEPoiIdRequest.doRequest();
            log.info((Object)"====== takeout Dish Query Base List result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout  Dish Query Base List  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutDishMap(String appAuthToken, String ePoiIds) {
        log.info((Object)("appAuthToken is " + appAuthToken + " ,ePoiIds is " + ePoiIds));
        CipCaterTakeoutDishMapRequest cipCaterTakeoutDishMapRequest = new CipCaterTakeoutDishMapRequest();
        cipCaterTakeoutDishMapRequest.setRequestSysParams(WaimaiEPRUtil.requestSysParams(appAuthToken));
        cipCaterTakeoutDishMapRequest.setePoiId(ePoiIds);
        String resultJson = "";
        try {
            resultJson = cipCaterTakeoutDishMapRequest.doRequest();
            log.info((Object)"====== takeout Dish Map result ======");
            log.info((Object)("result: " + resultJson));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout Dish Map error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static Boolean checkResult(String resultJson) {
        boolean result = false;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            jsonObject.getString("data");
            result = true;
            log.info((Object)"===== request success =====");
        }
        catch (Throwable t) {
            jsonObject.getString("error");
            log.info((Object)"===== request error =====");
        }
        return result;
    }

    public static Boolean checkResultForArray(String resultJson) {
        boolean result = false;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            jsonObject.getString("error");
            log.info((Object)"===== request error =====");
        }
        catch (Throwable t) {
            result = true;
            log.info((Object)"===== request success =====");
        }
        return result;
    }

    public static String getResultMessage(String resultJson, String key) {
        String str;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            str = jsonObject.getString("data");
        }
        catch (Throwable t) {
            str = jsonObject.getJSONObject("error").getString(key);
        }
        log.info((Object)("message is " + str));
        return str;
    }

    public static String getJsonResultByKey(String jsonStr, String key, String type) {
        String str = "";
        JSONObject jsonObject = new JSONObject(jsonStr);
        try {
            if (type.equals("string")) {
                str = jsonObject.getString(key);
            } else if (type.equals("array")) {
                str = jsonObject.getJSONArray(key).toString();
            }
        }
        catch (Throwable t) {
            log.info((Object)("not found this key ,jsonStr is " + jsonStr));
        }
        log.info((Object)("the key value is " + str));
        return str;
    }

    public static String takeoutDishBatchUpload(String appAuthToken, String dishs, Store store) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = new RequestSysParams(secret, appAuthToken, "UTF-8");
            CipCaterTakeoutDishBatchUploadRequest cipCaterTakeoutDishBatchUploadRequest = new CipCaterTakeoutDishBatchUploadRequest();
            cipCaterTakeoutDishBatchUploadRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishBatchUploadRequest.setDishes(dishs);
            cipCaterTakeoutDishBatchUploadRequest.setePoiId(store.getId().toString());
            resultJson = cipCaterTakeoutDishBatchUploadRequest.doRequest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout dish update  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutDishDelete(String appAuthToken, Long id, Store store) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = new RequestSysParams(secret, appAuthToken, "UTF-8");
            CipCaterTakeoutDishDeleteRequest cipCaterTakeoutDishDeleteRequest = new CipCaterTakeoutDishDeleteRequest();
            cipCaterTakeoutDishDeleteRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishDeleteRequest.setePoiId(String.valueOf(store.getId()));
            cipCaterTakeoutDishDeleteRequest.seteDishCode(String.valueOf(id));
            resultJson = cipCaterTakeoutDishDeleteRequest.doRequest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout dish update  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutDishCatUpdate(String appAuthToken, FoodTypeRelation foodTypeRelation, String oldName) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = new RequestSysParams(secret, appAuthToken, "UTF-8");
            CipCaterTakeoutDishCatUpdateRequest cipCaterTakeoutDishCatUpdateRequest = new CipCaterTakeoutDishCatUpdateRequest();
            cipCaterTakeoutDishCatUpdateRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishCatUpdateRequest.setCatName(foodTypeRelation.getName());
            cipCaterTakeoutDishCatUpdateRequest.setSequence(foodTypeRelation.getGroupRank());
            if (null != oldName) {
                cipCaterTakeoutDishCatUpdateRequest.setOldCatName(oldName);
            }
            resultJson = cipCaterTakeoutDishCatUpdateRequest.doRequest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout dish update  error: " + t.getMessage()));
        }
        return resultJson;
    }

    public static String takeoutDishCatDetele(String appAuthToken, FoodTypeRelation foodTypeRelation) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = new RequestSysParams(secret, appAuthToken, "UTF-8");
            CipCaterTakeoutDishCatDeleteRequest caterTakeoutDishCatDeleteRequest = new CipCaterTakeoutDishCatDeleteRequest();
            caterTakeoutDishCatDeleteRequest.setRequestSysParams(requestSysParams);
            caterTakeoutDishCatDeleteRequest.setCatName(foodTypeRelation.getName());
            resultJson = caterTakeoutDishCatDeleteRequest.doRequest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)("takeout dish update  error: " + t.getMessage()));
        }
        return resultJson;
    }
}

