/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.finance.etl.unit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUtil {
    private static final Log log = LogFactory.getLog(StringUtils.class);

    public static String getPlatformQueryString(String platform) {
        ArrayList<String> arr = new ArrayList<String>();
        log.info((Object)("platform query is " + platform));
        String meituan = "00000" + StringUtils.substring((String)platform, (int)5, (int)6);
        log.info((Object)("meituan query is " + meituan));
        String baidu = "0000" + StringUtils.substring((String)platform, (int)4, (int)5) + "0";
        log.info((Object)("baidu query is " + baidu));
        String ele = "000" + StringUtils.substring((String)platform, (int)3, (int)4) + "00";
        log.info((Object)("ele query is " + ele));
        arr.add(baidu);
        arr.add(meituan);
        arr.add(ele);
        log.info((Object)"zhangfan+++++++");
        ArrayList<String> resultArr = new ArrayList<String>();
        for (String s : arr) {
            log.info((Object)("s is " + s));
            if (s.equals("000000")) continue;
            resultArr.add(s);
        }
        String str = StringUtils.join(resultArr, (String)",");
        log.info((Object)("str is " + str));
        return str;
    }

    public static String getPlatformQueryStringAll(String platform) {
        ArrayList<String> arr = new ArrayList<String>();
        String meituan = StringUtils.substring((String)platform, (int)5, (int)6);
        String baidu = StringUtils.substring((String)platform, (int)4, (int)5);
        String ele = StringUtils.substring((String)platform, (int)3, (int)4);
        if (meituan.equals("1")) {
            arr.add("000001");
            arr.add("000011");
            arr.add("000101");
            arr.add("000111");
        }
        if (baidu.equals("1")) {
            arr.add("000010");
            arr.add("000110");
            arr.add("000011");
            arr.add("000111");
        }
        if (ele.equals("1")) {
            arr.add("000100");
            arr.add("000101");
            arr.add("000110");
            arr.add("000111");
        }
        HashSet s = new HashSet(arr);
        arr.clear();
        arr.addAll(s);
        String str = StringUtils.join(arr, (String)",");
        log.info((Object)("str is " + str));
        return str;
    }

    public static List<String> getPlatformQueryList(String platform) {
        ArrayList<String> arr = new ArrayList<String>();
        log.info((Object)("platform query is " + platform));
        String meituan = "00000" + StringUtils.substring((String)platform, (int)5, (int)6);
        log.info((Object)("meituan query is " + meituan));
        String baidu = "0000" + StringUtils.substring((String)platform, (int)4, (int)5) + "0";
        log.info((Object)("baidu query is " + baidu));
        String ele = "000" + StringUtils.substring((String)platform, (int)3, (int)4) + "00";
        log.info((Object)("ele query is " + ele));
        arr.add(baidu);
        arr.add(meituan);
        arr.add(ele);
        for (String s : arr) {
            if (!s.equals("000000")) continue;
            arr.remove(s);
        }
        return arr;
    }

    public static String setPlatform(List<String> platform) {
        String str = "000000";
        log.info((Object)("platform is " + platform));
        for (String s : platform) {
            int idx = StringUtils.indexOf((CharSequence)s, (CharSequence)"1");
            log.info((Object)("idx is " + idx));
            str = StringUtils.overlay((String)str, (String)StringUtils.substring((String)s, (int)idx, (int)(idx + 1)), (int)idx, (int)(idx + 1));
        }
        return str;
    }

    public static String updatePlatformStr(String platform, Integer status, String oPlatform) {
        int idx = StringUtils.indexOf((CharSequence)platform, (CharSequence)"1");
        oPlatform = StringUtils.overlay((String)oPlatform, (String)status.toString(), (int)idx, (int)(idx + 1));
        return oPlatform;
    }

    public static boolean inPlatform(String platformStr, String platform) {
        boolean result = false;
        switch (platform) {
            case "meituan": {
                result = platformStr.substring(5, 6).equals("1");
                break;
            }
            case "baidu": {
                result = platformStr.substring(4, 5).equals("1");
                break;
            }
            case "ele": {
                result = platformStr.substring(3, 4).equals("1");
            }
        }
        return result;
    }
}

