/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.finance.etl.unit;

import com.ptteng.onway.platform.model.EvaluateOrderRelation;
import com.ptteng.onway.platform.model.Food;
import com.ptteng.onway.platform.model.FoodSolid;
import com.ptteng.onway.platform.model.GroupFoodSort;
import com.ptteng.onway.platform.model.UserOrder;
import com.ptteng.onway.platform.model.mtERP.DishesEPR;
import com.ptteng.onway.platform.model.mtERP.OrderDetailEPR;
import com.ptteng.onway.platform.model.mtERP.OrderEPR;
import com.ptteng.onway.platform.model.mtERP.SkusEPR;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoverUtil {
    private static final Log log = LogFactory.getLog(CoverUtil.class);

    public static UserOrder OrderEPRCover2UserOrder(String order, Long trademarkId) {
        JSONObject jsonObject = JSONObject.fromObject((Object)order);
        OrderEPR orderEPR = (OrderEPR)JSONObject.toBean((JSONObject)jsonObject, OrderEPR.class);
        UserOrder userOrder = new UserOrder();
        userOrder.setId(null);
        userOrder.setStoreName(orderEPR.getPoiName());
        if (orderEPR.getIsPoiFirstOrder().booleanValue()) {
            userOrder.setBuyCount(Integer.valueOf(1));
        } else {
            userOrder.setBuyCount(Integer.valueOf(2));
        }
        userOrder.setStoreId(orderEPR.getePoiId());
        userOrder.setTrademarkId(trademarkId);
        userOrder.setPlatform("000001");
        userOrder.setUserName(orderEPR.getRecipientName());
        userOrder.setMobile(orderEPR.getRecipientPhone());
        userOrder.setDeliveryAddress(orderEPR.getRecipientAddress());
        userOrder.setExpectTime(String.valueOf(orderEPR.getDeliveryTime()));
        userOrder.setBuyAt(Long.valueOf(orderEPR.getCtime() * 1000L));
        switch (orderEPR.getStatus()) {
            case 1: {
                userOrder.setAcceptStatus(Integer.valueOf(1));
                userOrder.setOrderStatus(Integer.valueOf(1));
                break;
            }
            case 2: {
                userOrder.setAcceptStatus(Integer.valueOf(1));
                userOrder.setOrderStatus(Integer.valueOf(1));
                break;
            }
            case 4: {
                userOrder.setAcceptAt(Long.valueOf(orderEPR.getUtime() * 1000L));
                userOrder.setAcceptStatus(Integer.valueOf(2));
                userOrder.setOrderStatus(Integer.valueOf(1));
                break;
            }
            case 6: {
                userOrder.setAcceptStatus(Integer.valueOf(2));
                userOrder.setOrderStatus(Integer.valueOf(2));
                break;
            }
            case 8: {
                userOrder.setAcceptStatus(Integer.valueOf(2));
                userOrder.setOrderStatus(Integer.valueOf(3));
                userOrder.setEndAt(Long.valueOf(orderEPR.getUtime() * 1000L));
                break;
            }
            case 9: {
                userOrder.setAcceptStatus(Integer.valueOf(2));
                userOrder.setOrderStatus(Integer.valueOf(4));
            }
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)orderEPR.getDetail());
        Double boxFee = 0.0;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
            boxFee = boxFee + orderDetailEPRJson.getDouble("box_price") * orderDetailEPRJson.getDouble("box_num");
        }
        userOrder.setOrderPrice(orderEPR.getOriginalPrice());
        log.info((Object)("orderEPR OriginalPrice is " + orderEPR.getOriginalPrice()));
        userOrder.setBoxFee(BigDecimal.valueOf(boxFee).setScale(2, 4));
        userOrder.setDeliveryFee(orderEPR.getShippingFee());
        userOrder.setPayFee(orderEPR.getTotal());
        userOrder.setSort(orderEPR.getDaySeq());
        userOrder.setPayWay(orderEPR.getPayType());
        userOrder.setPlatformOrderNum(orderEPR.getOrderIdView().toString());
        userOrder.setPlatformOrderId(orderEPR.getOrderId());
        userOrder.setDeliveryMethod(orderEPR.getLogisticsCode().toString());
        userOrder.setInvoice(orderEPR.getHasInvoiced());
        userOrder.setInvoiceTitle(orderEPR.getInvoiceTitle());
        userOrder.setTaxNum(orderEPR.getTaxpayerId());
        userOrder.setDetail(orderEPR.getDetail());
        userOrder.setDinnersNumber(orderEPR.getDinnersNumber());
        CoverUtil.jsonStrCover2OrderDetailEPRList(userOrder.getDetail());
        userOrder.setOrderRemarks(orderEPR.getCaution());
        return userOrder;
    }

    public static DishesEPR FoodCover2DishesEPR(Food food, String foodType, List<SkusEPR> skusEPRS, FoodSolid foodSolid, GroupFoodSort groupFoodSort, Long storeId) {
        DishesEPR dishesEPR = new DishesEPR();
        dishesEPR.setBoxNum(food.getPackageBoxNum());
        dishesEPR.setBoxPrice(food.getPackageFee());
        dishesEPR.setCategoryName(foodType);
        dishesEPR.setDescription(food.getDescription());
        dishesEPR.setDishName(food.getName());
        dishesEPR.setEDishCode(food.getId());
        dishesEPR.setePoiId(storeId);
        dishesEPR.setIsSoldOut(Integer.valueOf(0));
        dishesEPR.setMinOrderCount(food.getMinOrderNum());
        dishesEPR.setPicture(food.getPic());
        dishesEPR.setSequence(groupFoodSort.getGroupRank());
        dishesEPR.setPrice(foodSolid.getPrice());
        String format = "";
        switch (food.getFormat()) {
            case 1: {
                format = "\u4efd";
                break;
            }
            case 2: {
                format = "\u4e2a";
                break;
            }
            case 3: {
                format = "\u65a4";
                break;
            }
            default: {
                format = "\u4efd";
            }
        }
        dishesEPR.setUnit(format);
        return dishesEPR;
    }

    public static List<OrderDetailEPR> jsonStrCover2OrderDetailEPRList(String detail) {
        ArrayList<OrderDetailEPR> orderDetailEPRList = new ArrayList<OrderDetailEPR>();
        JSONArray jsonArray = JSONArray.fromObject((Object)detail);
        log.info((Object)("a jsonArray " + jsonArray));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
            OrderDetailEPR orderDetailEPR = new OrderDetailEPR();
            orderDetailEPR.setAppFoodCode(Long.valueOf(orderDetailEPRJson.getLong("app_food_code")));
            orderDetailEPR.setBoxNum(Integer.valueOf(orderDetailEPRJson.getInt("box_num")));
            orderDetailEPR.setBoxPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("box_price")));
            orderDetailEPR.setCartId(Integer.valueOf(orderDetailEPRJson.getInt("cart_id")));
            orderDetailEPR.setFoodDiscount(BigDecimal.valueOf(orderDetailEPRJson.getDouble("food_discount")));
            orderDetailEPR.setFoodName(orderDetailEPRJson.getString("food_name"));
            orderDetailEPR.setFoodProperty(orderDetailEPRJson.getString("food_property"));
            orderDetailEPR.setQuantity(Integer.valueOf(orderDetailEPRJson.getInt("quantity")));
            orderDetailEPR.setPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("price")));
            orderDetailEPR.setSkuId(orderDetailEPRJson.getString("sku_id"));
            orderDetailEPR.setUnit(orderDetailEPRJson.getString("unit"));
            orderDetailEPR.setSpec(orderDetailEPRJson.getString("spec"));
            orderDetailEPRList.add(orderDetailEPR);
        }
        log.info((Object)("orderDetailEPRList size is " + orderDetailEPRList.size()));
        return orderDetailEPRList;
    }

    public static List<EvaluateOrderRelation> EPRJsonStrCover2EvaluateOrderRelationList(String JsonStr, Long storeId, Long evaId) {
        ArrayList<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<EvaluateOrderRelation>();
        JSONArray jsonArray = JSONArray.fromObject((Object)JsonStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            EvaluateOrderRelation evaluateOrderRelation = new EvaluateOrderRelation();
            evaluateOrderRelation.setOrderScore(Integer.valueOf(jsonObject.getInt("orderCommentScore")));
            evaluateOrderRelation.setFoodCommentScore(Integer.valueOf(jsonObject.getInt("foodCommentScore")));
            evaluateOrderRelation.setDeliveryCommentScore(Integer.valueOf(jsonObject.getInt("orderCommentScore")));
            evaluateOrderRelation.setContent(jsonObject.getString("commentContent"));
            evaluateOrderRelation.setPlatform("000001");
            evaluateOrderRelation.setAddCommentTime(jsonObject.getString("addCommentTime") + "000");
            evaluateOrderRelation.setAddComment(jsonObject.getString("addComment"));
            evaluateOrderRelation.setStoreId(storeId);
            evaluateOrderRelation.setPlatformEvaId(Long.valueOf(jsonObject.getLong("commentId")));
            if (evaId != null && evaluateOrderRelation.getPlatformEvaId() > evaId) {
                evaluateOrderRelationList.add(evaluateOrderRelation);
                continue;
            }
            if (evaId != null) continue;
            evaluateOrderRelationList.add(evaluateOrderRelation);
        }
        log.info((Object)("orderDetailEPRList size is " + evaluateOrderRelationList.size()));
        return evaluateOrderRelationList;
    }
}

