/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.finance.etl;

import com.ptteng.onway.finance.etl.unit.CoverUtil;
import com.ptteng.onway.finance.etl.unit.TimeUtil;
import com.ptteng.onway.finance.etl.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.EvaluateOrderRelation;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.model.SynRecord;
import com.ptteng.onway.platform.service.EvaluateOrderRelationService;
import com.ptteng.onway.platform.service.StoreService;
import com.ptteng.onway.platform.service.SynRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsignPayEtl {
    private static final int TASK_LEN = 100;
    private static final String developerId = "101536";
    private static final long SLEEP_MILLISECOND = 1000L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private EvaluateOrderRelationService evaluateOrderRelationService;
    private StoreService storeService;
    private SynRecordService synRecordService;
    private Long interval = 30000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    if (TimeUtil.getThisTime().equals("3:0:0")) {
                        List ids = this.storeService.getStoreIdsByMtOnline(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                        List storeList = this.storeService.getObjectsByIds(ids);
                        SynRecord synRecord = new SynRecord();
                        synRecord.setSynType(Integer.valueOf(3));
                        synRecord.setPlatform("000001");
                        log.info((Object)"userMemberRelations etl not get any id ,sleep 1000 ms ");
                        for (Store store : storeList) {
                            Long storeId = store.getId();
                            synRecord.setTrademarkId(store.getTrademarkId());
                            log.info((Object)("store is " + store));
                            List lastIds = this.evaluateOrderRelationService.getEvaluateOrderRelationIdsByStoreIdPlatform(storeId, "000001", Integer.valueOf(0), Integer.valueOf(1));
                            Long platformEvaId = 0L;
                            log.info((Object)("lastIds size is " + ids.size()));
                            if (CollectionUtils.isNotEmpty((Collection)lastIds)) {
                                EvaluateOrderRelation evaluateOrderRelation = this.evaluateOrderRelationService.getObjectById((Long)lastIds.get(0));
                                platformEvaId = evaluateOrderRelation.getPlatformEvaId();
                            }
                            log.info((Object)("last platformEvaId " + platformEvaId));
                            Integer offset = 0;
                            ArrayList<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<EvaluateOrderRelation>();
                            while (true) {
                                String result;
                                if (WaimaiEPRUtil.checkResultForArray(result = WaimaiEPRUtil.takeoutPoiQueryReviewList(store.getMtAppAuthToken(), store.getId().toString(), TimeUtil.getTimesTodayMorningInMillis(), System.currentTimeMillis(), offset, 20)).booleanValue()) {
                                    evaluateOrderRelationList.addAll(CoverUtil.EPRJsonStrCover2EvaluateOrderRelationList(WaimaiEPRUtil.getJsonResultByKey(result, "data", "array"), storeId, platformEvaId));
                                }
                                if (evaluateOrderRelationList.size() < 20) break;
                                offset = offset + 20;
                            }
                            this.evaluateOrderRelationService.insertList(evaluateOrderRelationList);
                            log.info((Object)("insert evaluate list success ,size is " + evaluateOrderRelationList.size()));
                            synRecord.setStoreId(storeId);
                            synRecord.setStatus(Integer.valueOf(1));
                            this.synRecordService.insert(synRecord);
                            Thread.sleep(1000L);
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(1000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    public EvaluateOrderRelationService getEvaluateOrderRelationService() {
        return this.evaluateOrderRelationService;
    }

    public void setEvaluateOrderRelationService(EvaluateOrderRelationService evaluateOrderRelationService) {
        this.evaluateOrderRelationService = evaluateOrderRelationService;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public SynRecordService getSynRecordService() {
        return this.synRecordService;
    }

    public void setSynRecordService(SynRecordService synRecordService) {
        this.synRecordService = synRecordService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public static void main(String[] arg) {
    }
}

