package com.ptteng.onway.finance.etl.unit;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created by Master on 2017/11/6.
 */
public class QueryUtil {
    private static final Log log = LogFactory.getLog(StringUtils.class);
    public static String getPlatformQueryString (String platform) {
        String str ;
        List<String> arr = new ArrayList<>();
        log.info("platform query is "  +platform);
        //美团
        String meituan ="00000" + StringUtils.substring(platform,5,6);
        log.info("meituan query is "  +meituan);
        //百度
        String baidu =  "0000"+StringUtils.substring(platform,4,5)+"0";
        log.info("baidu query is "  +baidu);
        //饿了么
        String ele = "000" + StringUtils.substring(platform,3,4)+"00";
        log.info("ele query is "  +ele);

        arr.add(baidu);
        arr.add(meituan);
        arr.add(ele);
        log.info("zhangfan+++++++");
        List<String> resultArr = new ArrayList<>();
        for (String s:arr){
            log.info("s is "+s);
            if (!s.equals("000000")){
                resultArr.add(s);
            }
        }

        str = StringUtils.join(resultArr,",");
        log.info("str is " + str);
        return str;
    }
    public static String getPlatformQueryStringAll (String platform) {
        String str,idx ;
        List<String>arr = new ArrayList<>();
        String meituan  = StringUtils.substring(platform,5,6);
        String baidu  = StringUtils.substring(platform,4,5);
        String ele  = StringUtils.substring(platform,3,4);
        if (meituan.equals("1")){
            arr.add("000001");
            arr.add("000011");
            arr.add("000101");
            arr.add("000111");
        }
        if (baidu.equals("1")){
            arr.add("000010");
            arr.add("000110");
            arr.add("000011");
            arr.add("000111");
        }
        if (ele.equals("1")){
            arr.add("000100");
            arr.add("000101");
            arr.add("000110");
            arr.add("000111");
        }
        HashSet<String> s = new HashSet<>(arr);
        arr.clear();
        arr.addAll(s);
        str = StringUtils.join(arr,",");
        log.info("str is " + str);
        return str;
    }
    public static List<String> getPlatformQueryList (String platform) {

        List<String> arr = new ArrayList<>();
        log.info("platform query is "  +platform);
        //美团
        String meituan ="00000" + StringUtils.substring(platform,5,6);
        log.info("meituan query is "  +meituan);
        //百度
        String baidu =  "0000"+StringUtils.substring(platform,4,5)+"0";
        log.info("baidu query is "  +baidu);
        //饿了么
        String ele = "000" + StringUtils.substring(platform,3,4)+"00";
        log.info("ele query is "  +ele);
        arr.add(baidu);
        arr.add(meituan);
        arr.add(ele);
        for (String s:arr){
            if (s.equals("000000")){
                arr.remove(s);
            }
        }

        return arr;
    }
    public static String setPlatform (List<String> platform) {
        String   str = "000000";
        log.info("platform is "+platform );
        for (String s:platform){
            int idx = StringUtils.indexOf(s,"1");
            log.info("idx is " +idx);
            str = StringUtils.overlay(str,StringUtils.substring(s,idx,idx+1),idx,idx+1) ;
        }
        return str;
    }
    public static String updatePlatformStr (String platform,Integer status,String oPlatform) {
        int idx = StringUtils.indexOf(platform,"1");

        oPlatform = StringUtils.overlay(oPlatform,status.toString(),idx,idx+1);

        return oPlatform;
    }
    public static boolean inPlatform (String platformStr,String platform) {
        boolean result = false;
      switch (platform){
          case "meituan":
             result = platformStr.substring(5,6).equals("1");
             break;
          case "baidu":
              result = platformStr.substring(4,5).equals("1");
              break;
          case "ele":
              result = platformStr.substring(3,4).equals("1");
              break;
      }
      return  result;
    }

}
