package com.ptteng.onway.finance.etl.unit;


import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.DishesEPR;
import com.ptteng.onway.platform.model.mtERP.OrderDetailEPR;
import com.ptteng.onway.platform.model.mtERP.OrderEPR;
import com.ptteng.onway.platform.model.mtERP.SkusEPR;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * Created by shaobo on 2017/12/7；
 */
public class CoverUtil {
    private static final Log log = LogFactory.getLog(CoverUtil.class);

    /*
    * 将美团EPR推动的订单实体化-转成系统的订单格式
    * */
    public static UserOrder OrderEPRCover2UserOrder(String order,Long trademarkId) {
//        log.info("push order is "+ order+" , trademarkId is " + trademarkId);

        JSONObject jsonObject = JSONObject.fromObject(order);
//        log.info("jsonObject is " +jsonObject);
        OrderEPR orderEPR = (OrderEPR) JSONObject.toBean(jsonObject,OrderEPR.class);
//        log.info("orderEPR is " + orderEPR);

        UserOrder userOrder = new UserOrder();
        userOrder.setId(null);
        userOrder.setStoreName(orderEPR.getPoiName());
        //是否首次下单
        if (orderEPR.getIsPoiFirstOrder()) {
            userOrder.setBuyCount(1);
        }else {
            userOrder.setBuyCount(2);
        }
        //门店id
        userOrder.setStoreId(orderEPR.getePoiId());
        //品牌id
        userOrder.setTrademarkId(trademarkId);
        //渠道
        userOrder.setPlatform("000001");
        //用户名
        userOrder.setUserName(orderEPR.getRecipientName());
        //手机号
        userOrder.setMobile(orderEPR.getRecipientPhone());
        //送货地址
        userOrder.setDeliveryAddress(orderEPR.getRecipientAddress());
        //期望送到时间
        userOrder.setExpectTime(String.valueOf(orderEPR.getDeliveryTime()));
        //购买时间
        userOrder.setBuyAt(orderEPR.getCtime()*1000);
        //接单状态

        //订单状态
        switch (orderEPR.getStatus()) {
            //用户已提交订单
            case 1:
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_WAIT);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;
            case 2://2-可推送到App方平台也可推送到商家
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_WAIT);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;

            case 4://4-商家已确认
                userOrder.setAcceptAt(orderEPR.getUtime()*1000);
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                break;

            case 6://6-已配送
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_PROCESSING);
                break;

            case 8://8-已完成
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_FINISH);
                //订单更新时间为结束时间
                userOrder.setEndAt(orderEPR.getUtime()*1000);
                break;
            case 9://已取消
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_REFUNDING);
                break;

        }

        JSONArray jsonArray = JSONArray.fromObject(orderEPR.getDetail());
//        log.info("a jsonArray " +jsonArray );
        Double boxFee = 0.00;
        for (int i = 0; i < jsonArray.size(); i++) {     //遍历json数组内容
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
//            log.info("object is " +orderDetailEPRJson);
            boxFee +=(orderDetailEPRJson.getDouble("box_price")*orderDetailEPRJson.getDouble("box_num"));
        }


        //订单金额（订单原价）
        userOrder.setOrderPrice(orderEPR.getOriginalPrice());
        log.info("orderEPR OriginalPrice is " + orderEPR.getOriginalPrice());

        //餐盒费
        userOrder.setBoxFee(BigDecimal.valueOf(boxFee).setScale(2,BigDecimal.ROUND_HALF_UP));
        //配送费
        userOrder.setDeliveryFee(orderEPR.getShippingFee());
        //支付金额（订单总价）
        userOrder.setPayFee(orderEPR.getTotal());
        //优惠金额

        //抽取佣金

        //平台补贴

        //流水单号
        userOrder.setSort(orderEPR.getDaySeq());

        //支付途径 1：货到付款；2：在线支付
        userOrder.setPayWay(orderEPR.getPayType());
        //第三方订单号(订单展示id）
        userOrder.setPlatformOrderNum(orderEPR.getOrderIdView().toString());
        //第三方订单id
        userOrder.setPlatformOrderId(orderEPR.getOrderId());
        //配送方式
        userOrder.setDeliveryMethod(orderEPR.getLogisticsCode().toString());
        //是否需要发票
        userOrder.setInvoice(orderEPR.getHasInvoiced());
        //发票抬头
        userOrder.setInvoiceTitle(orderEPR.getInvoiceTitle());
        //税号
        userOrder.setTaxNum(orderEPR.getTaxpayerId());
        //详情
        userOrder.setDetail(orderEPR.getDetail());
        //用餐人数
        userOrder.setDinnersNumber(orderEPR.getDinnersNumber());

        jsonStrCover2OrderDetailEPRList(userOrder.getDetail());
        //订单备注
        userOrder.setOrderRemarks(orderEPR.getCaution());

        return userOrder;

    }

    public static DishesEPR FoodCover2DishesEPR  (Food food, String foodType, List<SkusEPR> skusEPRS, FoodSolid foodSolid, GroupFoodSort groupFoodSort, Long storeId) {


        DishesEPR dishesEPR = new DishesEPR();
        dishesEPR.setBoxNum(food.getPackageBoxNum());
        dishesEPR.setBoxPrice(food.getPackageFee());
        dishesEPR.setCategoryName(foodType);
        dishesEPR.setDescription(food.getDescription());
        dishesEPR.setDishName(food.getName());
        dishesEPR.setEDishCode(food.getId());
        dishesEPR.setePoiId(storeId);
        dishesEPR.setIsSoldOut(0);
        dishesEPR.setMinOrderCount(food.getMinOrderNum());
        dishesEPR.setPicture(food.getPic());
        dishesEPR.setSequence(groupFoodSort.getGroupRank());
        dishesEPR.setPrice(foodSolid.getPrice());

        String format="";
        switch (food.getFormat()){
            case 1:
                format="份";
                break;
            case 2:
                format="个";
                break;
            case 3:
                format="斤";
                break;
                default:
                    format="份";
                    break;
        }
        dishesEPR.setUnit(format);

        return dishesEPR;

    }

    public static List<OrderDetailEPR> jsonStrCover2OrderDetailEPRList  (String detail) {
        List<OrderDetailEPR> orderDetailEPRList= new ArrayList<>();
        JSONArray jsonArray = JSONArray.fromObject(detail);
        log.info("a jsonArray " +jsonArray );
        for (int i = 0; i < jsonArray.size(); i++) {     //遍历json数组内容
            JSONObject orderDetailEPRJson = jsonArray.getJSONObject(i);
            OrderDetailEPR orderDetailEPR = new OrderDetailEPR();
            orderDetailEPR.setAppFoodCode(orderDetailEPRJson.getLong("app_food_code"));
            orderDetailEPR.setBoxNum(orderDetailEPRJson.getInt("box_num"));
            orderDetailEPR.setBoxPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("box_price")));
            orderDetailEPR.setCartId(orderDetailEPRJson.getInt("cart_id"));
            orderDetailEPR.setFoodDiscount(BigDecimal.valueOf(orderDetailEPRJson.getDouble("food_discount")));
            orderDetailEPR.setFoodName(orderDetailEPRJson.getString("food_name"));
            orderDetailEPR.setFoodProperty(orderDetailEPRJson.getString("food_property"));
            orderDetailEPR.setQuantity(orderDetailEPRJson.getInt("quantity"));
            orderDetailEPR.setPrice(BigDecimal.valueOf(orderDetailEPRJson.getDouble("price")));
//            orderDetailEPR.setFoodShareFeeChargeByPoi(orderDetailEPRJson.getDouble("foodShareFeeChargeByPoi"));
            orderDetailEPR.setSkuId(orderDetailEPRJson.getString("sku_id"));
            orderDetailEPR.setUnit(orderDetailEPRJson.getString("unit"));
            orderDetailEPR.setSpec(orderDetailEPRJson.getString("spec"));

            orderDetailEPRList.add(orderDetailEPR);
        }
        log.info("orderDetailEPRList size is "  +orderDetailEPRList.size());

        return orderDetailEPRList;

    }

    public static List<EvaluateOrderRelation> EPRJsonStrCover2EvaluateOrderRelationList  (String JsonStr,Long storeId,Long evaId) {
        List<EvaluateOrderRelation> evaluateOrderRelationList= new ArrayList<>();
        JSONArray jsonArray = JSONArray.fromObject(JsonStr);
        for (int i = 0; i < jsonArray.size(); i++) {     //遍历json数组内容
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            EvaluateOrderRelation evaluateOrderRelation = new EvaluateOrderRelation();
            evaluateOrderRelation.setOrderScore(jsonObject.getInt("orderCommentScore"));
            evaluateOrderRelation.setFoodCommentScore(jsonObject.getInt("foodCommentScore"));
            evaluateOrderRelation.setDeliveryCommentScore(jsonObject.getInt("orderCommentScore"));
            evaluateOrderRelation.setContent(jsonObject.getString("commentContent"));
            evaluateOrderRelation.setPlatform("000001");
            //美团返回时间戳为秒，加3个000转为毫秒
            evaluateOrderRelation.setAddCommentTime(jsonObject.getString("addCommentTime")+"000");
            evaluateOrderRelation.setAddComment(jsonObject.getString("addComment"));
            evaluateOrderRelation.setStoreId(storeId);
            evaluateOrderRelation.setPlatformEvaId(jsonObject.getLong("commentId"));

//            evaluateOrderRelation.setEvaluateAt(System.currentTimeMillis());
            //数据中大于库里id的数据才是新数据
            if (evaId != null && (evaluateOrderRelation.getPlatformEvaId()>evaId)) {
                evaluateOrderRelationList.add(evaluateOrderRelation);
            } else if (evaId == null){
                evaluateOrderRelationList.add(evaluateOrderRelation);
            }

        }
        log.info("orderDetailEPRList size is "  +evaluateOrderRelationList.size());

        return evaluateOrderRelationList;

    }

}
