package com.ptteng.onway.finance.etl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;

import com.ptteng.onway.finance.etl.unit.CipCaterTakeoutPoiQueryReviewList;
import com.ptteng.onway.finance.etl.unit.CoverUtil;
import com.ptteng.onway.finance.etl.unit.TimeUtil;
import com.ptteng.onway.finance.etl.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.EvaluateOrderRelation;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.model.SynRecord;
import com.ptteng.onway.platform.service.*;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.collections.CollectionUtils;
import com.sleepycat.je.tree.IN;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ConsignPayEtl {

    private static final int TASK_LEN = 100;// 一次任务检测的条数
    private static final String developerId = "101536";


    private static final long SLEEP_MILLISECOND = 1000;// ====空转任务间隔休息毫秒数

    private static final Log log = LogFactory.getLog("autoScan");



    private EvaluateOrderRelationService evaluateOrderRelationService;

    private StoreService storeService;

    private SynRecordService synRecordService;
    private Long interval = 30000L;


    public ConsignPayEtl() {
        super();
    }

    public void process() throws InterruptedException {

        while (true) {

            try {
//                log.info("this time is " +TimeUtil.getThisTime());
                if (TimeUtil.getThisTime().equals("3:0:0")) {

                    List<Long> ids = storeService.getStoreIdsByMtOnline(0, Integer.MAX_VALUE);
                    List<Store> storeList = storeService.getObjectsByIds(ids);

                    SynRecord synRecord = new SynRecord();
                    synRecord.setSynType(SynRecord.SYN_TYPE_EVALUATION);
                    synRecord.setPlatform("000001");
                    log.info("userMemberRelations etl not get any id ,sleep " + SLEEP_MILLISECOND + " ms ");

                    for (Store store:storeList) {
                        Long storeId = store.getId();
                        synRecord.setTrademarkId(store.getTrademarkId());
//                        Store store = storeList.listIterator().next();
                        log.info("store is " +store);
                        /**
                         **美团评价处理，美团这里没有返回时间、订单数据
                         * 根据美团的评价id与库里存储的美团最新评价的id比对，判断是否为新数据入库
                         * 如果一次数据量不满20条，说明后面已经没有数据；
                         * */
                        //1.查找最近的一条评价数据读取第三方评价id
                        List<Long> lastIds = evaluateOrderRelationService.getEvaluateOrderRelationIdsByStoreIdPlatform(storeId,"000001",0,1);
                        Long platformEvaId = 0L;
                        log.info("lastIds size is " +ids.size());
                        if (CollectionUtils.isNotEmpty(lastIds)) {
                            EvaluateOrderRelation evaluateOrderRelation = evaluateOrderRelationService.getObjectById(lastIds.get(0));
                            platformEvaId = evaluateOrderRelation.getPlatformEvaId();
                        }
                        log.info("last platformEvaId " +platformEvaId);

                        Integer offset = 0;
                        //2.请求门店评价数据-时间节点为0点到现在，不满20条就不用再执行了，否则重复执行拉取所有数据
                        List<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<>();
                        while (true) {
                            String result =WaimaiEPRUtil.takeoutPoiQueryReviewList(store.getMtAppAuthToken(),store.getId().toString(),TimeUtil.getTimesTodayMorningInMillis(),System.currentTimeMillis(),offset,20);
                            if (WaimaiEPRUtil.checkResultForArray(result)){
                                evaluateOrderRelationList.addAll(CoverUtil.EPRJsonStrCover2EvaluateOrderRelationList(WaimaiEPRUtil.getJsonResultByKey(result,"data","array"),storeId,platformEvaId));
                            }
                            //不满20调终止循环，否则累加查询起始位置
                            if (evaluateOrderRelationList.size()<20) {
                                evaluateOrderRelationService.insertList(evaluateOrderRelationList);
                                log.info("insert evaluate list success ,size is " +evaluateOrderRelationList.size());
                                //存同步记录
                                synRecord.setStoreId(storeId);
                                synRecord.setStatus(SynRecord.SYN_STATUS_SUCCESS);

                                synRecordService.insert(synRecord);

                                break;
                            }else {
                                offset+=20;
                            }
                        }

                        Thread.sleep(1000);
                    }
                }


                Thread.sleep(SLEEP_MILLISECOND);
            } catch (Throwable t) {

                t.printStackTrace();
                Thread.sleep(SLEEP_MILLISECOND);
                log.error("process goods bytime status error ,sleep " + t.getMessage());
            }

        }

    }

//	private List<UserMemberRelation> getUserMemberRelation() {
//		List<UserMemberRelation> userMemberRelations = new ArrayList<>();
//		Long now = System.currentTimeMillis();
//		Map<String,Object> param = new HashMap<>();
//		//会员状态订单
//		param.put(" status ", User.IS_MEMBER);
//		param.put(" end_at & <=", now);
//		param.put("@table"," user_member_relation");
//
//
//		try {
//			List<Long> ids = this.userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param, 0, TASK_LEN);
//			if(CollectionUtils.isEmpty(ids)){
//
//				log.info("not ger any process message ");
//			}else{
//				userMemberRelations=this.userMemberRelationService.getObjectsByIds(ids);
//				for(UserMemberRelation userMemberRelation : userMemberRelations){
//					if(now>=userMemberRelation.getEndAt()){
//						log.info(" userMemberRelation id = "+userMemberRelation.getId());
//						userMemberRelation.setStatus(User.IS_EXPRIED_MEMBER);
//
//					}
//				}
//				this.userMemberRelationService.updateList(userMemberRelations);
//
//				log.info("get process messages is "+userMemberRelations.size());
//			}
//
//		} catch (Throwable t) {
//			// TODO Auto-generated catch block
//			t.printStackTrace();
//			log.error(t);
//		}
//		return userMemberRelations;
//	}




    public EvaluateOrderRelationService getEvaluateOrderRelationService() {
        return evaluateOrderRelationService;
    }

    public void setEvaluateOrderRelationService(EvaluateOrderRelationService evaluateOrderRelationService) {
        this.evaluateOrderRelationService = evaluateOrderRelationService;
    }
    public StoreService getStoreService() {
        return storeService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public SynRecordService getSynRecordService() { return synRecordService;}
    public void setSynRecordService (SynRecordService synRecordService) { this.synRecordService = synRecordService;}

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }


    public static void main(String[] arg) {

    }


}
