package com.ptteng.onway.admin.waimai;

import com.jiabangou.mtwmsdk.api.PushConsumer;
import com.jiabangou.mtwmsdk.model.OrderDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by wanglei on 16-10-13.
 */
public class MeituanWaimaiPushConsumer implements PushConsumer {

    private static final Logger logger = LoggerFactory.getLogger(MeituanWaimaiPushConsumer.class);

    private Long mchId;

    private MeituanWaimaiPushService meituanWaimaiPushService;

    public MeituanWaimaiPushConsumer(Long mchId, MeituanWaimaiPushService meituanWaimaiPushService) {
        this.mchId = mchId;
        this.meituanWaimaiPushService = meituanWaimaiPushService;
    }

    @Override
    public void createOrder(OrderDetail orderDetail) {
        try {
            meituanWaimaiPushService.createOrder(mchId, orderDetail);
        } catch (Exception e){
            logger.error(e.getMessage(), e);
        }

    }

    @Override
    public void confirmedOrder(OrderDetail orderDetail) {
        try {
            meituanWaimaiPushService.confirmedOrder(mchId, orderDetail);
        } catch (Exception e){
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void completedOrder(OrderDetail orderDetail) {
        try {
            meituanWaimaiPushService.completedOrder(mchId, orderDetail);
        } catch (Exception e){
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void cancelOrder(String orderId, Integer reasonCode, String reason) {
        try {
            meituanWaimaiPushService.cancelOrder(mchId, orderId, reasonCode, reason);
        } catch (Exception e){
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void refundOrder(String orderId, String notifyType, String reason) {
        try {
            meituanWaimaiPushService.refundOrder(mchId, orderId, notifyType, reason);
        } catch (Exception e){
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void deliveryStatus(String s, Short aShort, String s1, String s2, String s3) {

    }

}
