package com.ptteng.onway.admin.unit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class mailUtil {

    private static final Log log = LogFactory.getLog("mail");

    private static final Executor exec = Executors.newFixedThreadPool(3);

    static final String url = "http://www.sendcloud.net/webapi/mail.send_template.json";
    static final String apiUser = "chinalovelsb_test_Btl4fZ";
    static final String apiKey = "tmiCpq4RqviKOVXb";
    static final String template = "syn_error_template";

    public static String sendMail(String userName, String mailAdress, String periodName, String path) throws IOException {

        HttpClient httpclient = new DefaultHttpClient();
        HttpPost httpost = new HttpPost(url);

        String vars = "{\"to\": [\"" + mailAdress + "\"],\"sub\":{\"%name%\": [\"" + periodName + "\"],\"%user%\":[\"" + userName + "\"]}}";

        // 涉及到附件上传, 需要使用 MultipartEntity
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"));
        entity.addPart("api_user", new StringBody(apiUser, Charset.forName("UTF-8")));
        entity.addPart("api_key", new StringBody(apiKey, Charset.forName("UTF-8")));
        entity.addPart("substitution_vars", new StringBody(vars, Charset.forName("UTF-8")));
        entity.addPart("template_invoke_name", new StringBody("sendpaper", Charset.forName("UTF-8")));
        entity.addPart("from", new StringBody("111i@HaNINHHEzvAviqMcZPcDkCiHNGCFIqEj.sendcloud.org", Charset.forName("UTF-8")));
        entity.addPart("fromname", new StringBody("111", Charset.forName("UTF-8")));
        entity.addPart("subject", new StringBody("111" + periodName + "学习资料！", Charset.forName("UTF-8")));
        entity.addPart("resp_email_id", new StringBody("true"));

        // 添加附件
        File file = new File(path);
        FileBody attachment = new FileBody(file, "application/octet-stream", "UTF-8");
        entity.addPart("files", attachment);

        httpost.setEntity(entity);

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Long startTime = System.currentTimeMillis();
        String startDate = format.format(startTime);

        // 请求
        log.info("http start : " + startDate);
        HttpResponse response = httpclient.execute(httpost);

        Long endTime = System.currentTimeMillis();
        String endDate = format.format(endTime);
        log.info("http end : " + endDate);

        // 处理响应
        if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) { // 正常返回
            // 读取xml文档
            String result = EntityUtils.toString(response.getEntity());
            log.info(result);
        } else {
            log.info("send mail error");
        }
        httpost.releaseConnection();
        return response + "";
    }

    public static String sendSMSMail(String mailAdress, String name,String synType,String errMsg) throws IOException {

        HttpClient httpclient = new DefaultHttpClient();
        HttpPost httpost = new HttpPost(url);
        String resultCode = "";

        String vars = "{\"to\": [\"" + mailAdress + "\"],\"sub\":{\"%name%\":[\"" + name + "\"],\"%synType%\":[\""+synType+"\"],\"%errMsg%\":[\"" + errMsg + "\"]}}";

        // 涉及到附件上传, 需要使用 MultipartEntity
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"));
        entity.addPart("api_user", new StringBody(apiUser, Charset.forName("UTF-8")));
        entity.addPart("api_key", new StringBody(apiKey, Charset.forName("UTF-8")));
        entity.addPart("substitution_vars", new StringBody(vars, Charset.forName("UTF-8")));
        entity.addPart("template_invoke_name", new StringBody(template, Charset.forName("UTF-8")));
        entity.addPart("from", new StringBody("onway@dHaNINHHEzvAviqMcZPcDkCiHNGCFIqEj.sendcloud.org", Charset.forName("UTF-8")));
//        entity.addPart("fromname", new StringBody("逗你学", Charset.forName("UTF-8")));
        entity.addPart("subject", new StringBody("路上餐厅外卖后台同步异常", Charset.forName("UTF-8")));
        entity.addPart("resp_email_id", new StringBody("true"));

        httpost.setEntity(entity);

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Long startTime = System.currentTimeMillis();
        String startDate = format.format(startTime);

        // 请求
        log.info("http start : " + startDate);
        HttpResponse response = httpclient.execute(httpost);

        Long endTime = System.currentTimeMillis();
        String endDate = format.format(endTime);
        log.info("http end : " + endDate);

        // 处理响应
        if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) { // 正常返回
            // 读取xml文档
            String result = EntityUtils.toString(response.getEntity());
            log.info(result);
            resultCode = "0";
        } else {
            log.info("send mail error");
            resultCode = "-1";
        }
        httpost.releaseConnection();
//        return response + "";
        return resultCode;
    }


    public static void main(String[] args) throws IOException {
        mailUtil test = new mailUtil();
//        test.sendMail("冯培宇", "fengpeiyu@ptteng.com", "公倍数问题", "D:\\work\\项目\\逗你学\\回家学习7.16-ios版本\\标记页面\\个人信息-修改邮箱_MarkMan.png");
        test.sendSMSMail("lishaobo@ptteng.com", "123456","菜品", "sendPwdMail");
    }

    public String dateTime() {
        Long time = System.currentTimeMillis();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }
}