package com.ptteng.onway.admin.unit;

import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.admin.waimai.CipCaterTakeoutPoiAddReplay;
import com.ptteng.onway.admin.waimai.CipCaterTakeoutPoiQueryReviewList;
import com.ptteng.onway.platform.model.FoodTypeRelation;
import com.ptteng.onway.platform.model.Store;

import com.sankuai.sjst.platform.developer.domain.RequestSysParams;
import com.sankuai.sjst.platform.developer.request.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;


/**
 * Created by shaobo on 2017/12/8.
 */
public class WaimaiEPRUtil {


    private static final Log log = LogFactory.getLog(WaimaiEPRUtil.class);

    //设置EPR请求系统参数
    private static RequestSysParams requestSysParams (String appAuthToken ) {
        return  new RequestSysParams(WaimaiConstents.secret,appAuthToken);
    }


    /**
     * 门店设置营业状态
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutPoiOpen ( String appAuthToken ) {
        CipCaterTakeoutPoiOpenRequest cipCaterTakeoutPoiOpenRequest = new CipCaterTakeoutPoiOpenRequest();
        cipCaterTakeoutPoiOpenRequest.setRequestSysParams(requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiOpenRequest.doRequest();
            log.info("====== takeout poi open result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi open error: "+t.getMessage());
        }

        return resultJson;
    }

    /**
     * 门店设置歇业状态
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutPoiClose ( String appAuthToken ) {
        CipCaterTakeoutPoiCloseRequest cipCaterTakeoutPoiCloseRequest = new CipCaterTakeoutPoiCloseRequest();
        cipCaterTakeoutPoiCloseRequest.setRequestSysParams(requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiCloseRequest.doRequest();
            log.info("====== takeout poi close result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi close error: "+t.getMessage());
        }

        return resultJson;
    }

    /**
     * 门店修改营业时间
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutPoiUpdateOpenTime ( String appAuthToken ,String openTime) {
        CipCaterTakeoutPoiOpenTimeUpdateRequest cipCaterTakeoutPoiOpenTimeUpdateRequest = new CipCaterTakeoutPoiOpenTimeUpdateRequest();
        cipCaterTakeoutPoiOpenTimeUpdateRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutPoiOpenTimeUpdateRequest.setOpenTime(openTime);
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiOpenTimeUpdateRequest.doRequest();
            log.info("====== takeout poi update open time result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi update open time error: "+t.getMessage());
        }

        return resultJson;
    }

    /**
     * 门店查询是否延迟配送
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutPoiQueryDelayDispatch ( String appAuthToken ) {
        CipCaterTakeoutPoiDelayDispatchQueryRequest cipCaterTakeoutPoiDelayDispatchQueryRequest = new CipCaterTakeoutPoiDelayDispatchQueryRequest();
        cipCaterTakeoutPoiDelayDispatchQueryRequest.setRequestSysParams(requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiDelayDispatchQueryRequest.doRequest();
            log.info("====== takeout poi delay dispatch query result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi delay dispatch query: "+t.getMessage());
        }

        return resultJson;
    }


    /**
     * 门店设置查询是否延迟配送
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param delaySeconds 迟发配送时间单位秒，该参数需在300-600秒之间
     */
    public static String takeoutPoiUpdateDelayDispatch ( String appAuthToken, Integer delaySeconds ) {
        CipCaterTakeoutPoiDelayDispatchUpdateRequest cipCaterTakeoutPoiDelayDispatchUpdateRequest = new CipCaterTakeoutPoiDelayDispatchUpdateRequest();
        cipCaterTakeoutPoiDelayDispatchUpdateRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutPoiDelayDispatchUpdateRequest.setDelaySeconds(delaySeconds);
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiDelayDispatchUpdateRequest.doRequest();
            log.info("====== takeout poi delay dispatch update result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi delay dispatch update  error: "+t.getMessage());
        }

        return resultJson;
    }



    /**
     * 门店查询信息
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param ePoiIds ERP方门店id(半角逗号分隔)
     */
    public static String takeoutPoiInfoQuery ( String appAuthToken, String ePoiIds ) {
        CipCaterTakeoutPoiInfoQueryRequest cipCaterTakeoutPoiInfoQueryRequest = new CipCaterTakeoutPoiInfoQueryRequest();
        cipCaterTakeoutPoiInfoQueryRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutPoiInfoQueryRequest.setEPoiIds(ePoiIds);
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiInfoQueryRequest.doRequest();
            log.info("====== takeout poi info query result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi info query  error: "+t.getMessage());
        }

        return resultJson;
    }



    /**
     * 门店查询评价信息
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param ePoiIds ERP方门店id(半角逗号分隔)
     * @param startTime 查询评价起始时间
     * @param endTime 查询评价结束时间
     * @param offset 查询起始位置
     * @param limit 查询条数
     */
    public static String takeoutPoiQueryReviewList ( String appAuthToken, String ePoiIds,Long startTime,Long endTime,Integer offset,Integer limit) {
        log.info("appAuthToken is " +appAuthToken+" ,ePoiIds is " +ePoiIds+" ,startTime is " +startTime/1000+" ,endTime is " +endTime/1000+" ,offset is " +offset+" ,limit is " +limit);
        CipCaterTakeoutPoiQueryReviewList cipCaterTakeoutPoiQueryReviewList = new CipCaterTakeoutPoiQueryReviewList();
        cipCaterTakeoutPoiQueryReviewList.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutPoiQueryReviewList.setePoiId(ePoiIds);
        cipCaterTakeoutPoiQueryReviewList.setStartTime(String.valueOf(startTime/1000));
        cipCaterTakeoutPoiQueryReviewList.setEndTime(String.valueOf(endTime/1000));
        cipCaterTakeoutPoiQueryReviewList.setOffset(offset.toString());
        cipCaterTakeoutPoiQueryReviewList.setLimit(limit.toString());
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutPoiQueryReviewList.doRequest();
            log.info("====== takeout poi query review list result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi query review list  error: "+t.getMessage());
        }


        return resultJson;
    }


    /**
     * 查询门店下菜品信息
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param ePoiIds ERP方门店id
     */
    public static String takeoutDishQueryBaseListByEPoiId ( String appAuthToken, String ePoiIds) {
        log.info("appAuthToken is " +appAuthToken+" ,ePoiIds is " +ePoiIds);
        CipCaterTakeoutDishBaseQueryByEPoiIdRequest cipCaterTakeoutDishBaseQueryByEPoiIdRequest = new CipCaterTakeoutDishBaseQueryByEPoiIdRequest();
        cipCaterTakeoutDishBaseQueryByEPoiIdRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutDishBaseQueryByEPoiIdRequest.setePoiId(ePoiIds);
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutDishBaseQueryByEPoiIdRequest.doRequest();
            log.info("====== takeout Dish Query Base List result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout  Dish Query Base List  error: "+t.getMessage());
        }

        return resultJson;
    }

    /**
     * 菜品映射
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param ePoiIds ERP方门店id
     */
    public static String takeoutDishMap ( String appAuthToken, String ePoiIds) {
        log.info("appAuthToken is " +appAuthToken+" ,ePoiIds is " +ePoiIds);
        CipCaterTakeoutDishMapRequest cipCaterTakeoutDishMapRequest = new CipCaterTakeoutDishMapRequest();
        cipCaterTakeoutDishMapRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutDishMapRequest.setePoiId(ePoiIds);
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutDishMapRequest.doRequest();
            log.info("====== takeout Dish Map result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout Dish Map error: "+t.getMessage());
        }

        return resultJson;
    }



    /**
     * 查询门店菜品分类
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String queryCatList ( String appAuthToken) {
        log.info("appAuthToken is " +appAuthToken );
        CipCaterTakeoutDishCatListQueryRequest cipCaterTakeoutDishMapRequest = new CipCaterTakeoutDishCatListQueryRequest();
        cipCaterTakeoutDishMapRequest.setRequestSysParams(requestSysParams(appAuthToken));
        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutDishMapRequest.doRequest();
            log.info("====== takeout Dish Map result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout Dish Map error: "+t.getMessage());
        }

        return resultJson;
    }


    /**
     * 删除菜品分类
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String deleteCat ( String appAuthToken,String catName) {
        log.info("appAuthToken is " +appAuthToken +" , catName is " + catName);
        CipCaterTakeoutDishCatDeleteRequest cipCaterTakeoutDishCatDeleteRequest = new CipCaterTakeoutDishCatDeleteRequest();
        cipCaterTakeoutDishCatDeleteRequest.setRequestSysParams(requestSysParams(appAuthToken));
        cipCaterTakeoutDishCatDeleteRequest.setCatName(catName);

        String resultJson = "";
        try {
            // 发送请求，接收Json ，所有Request都有doRequest方法直接调用即可
            resultJson = cipCaterTakeoutDishCatDeleteRequest.doRequest();
            log.info("====== takeout Dish Map result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout Dish Map error: "+t.getMessage());
        }

        return resultJson;
    }








    /**
    * 判断接口是否返回正常-返回布尔值
    * */
    public static Boolean checkResult (String resultJson) {
        boolean result = false;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            jsonObject.getString("data");
            result = true;
            log.info("===== request success =====");

        } catch (Throwable t) {
            jsonObject.getJSONObject("error");
            log.info("===== request error =====");
            log.info("error msg is " + jsonObject.getJSONObject("error").toString());
        }
        return result;
    }

    /**
    * 判断接口是否返回正常-返回布尔值-数组类型
    * */
    public static Boolean checkResultForArray (String resultJson) {
        boolean result = false;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            jsonObject.getString("error");
            log.info("===== request error =====");

        } catch (Throwable t) {
//            jsonObject.getJSONArray("data").;
            result = true;
            log.info("===== request success =====");

        }
        return result;
    }


    /**
    * 判断接口是否返回正常-返回信息
    * */
    public static String getResultMessage (String resultJson,String key) {
        String str;
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            str = jsonObject.getString("data");
        } catch (Throwable t) {
            str = jsonObject.getJSONObject("error").getString(key);
        }
        log.info("message is " + str);
        return str;
    }

    /**
     * 取出JSON里的key-value值
     * */
    public static String getJsonResultByKey (String jsonStr,String key,String type) {
        String str="";
        JSONObject jsonObject = new JSONObject(jsonStr);

        try {
            if (type.equals("string")){
                str = jsonObject.getString(key);
            }else if(type.equals("array")) {
                str = jsonObject.getJSONArray(key).toString();
            }
        } catch (Throwable t) {
           log.info("not found this key ,jsonStr is "+jsonStr);

        }
//        log.info("the key value is " + str);
        return str;
    }

    /**
     * 菜品批量新增或修改
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutDishBatchUpload (String appAuthToken, String dishs,String StoreId) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishBatchUploadRequest cipCaterTakeoutDishBatchUploadRequest =new CipCaterTakeoutDishBatchUploadRequest();
            cipCaterTakeoutDishBatchUploadRequest.setRequestSysParams(requestSysParams);

            cipCaterTakeoutDishBatchUploadRequest.setDishes(dishs);
            cipCaterTakeoutDishBatchUploadRequest.setePoiId(StoreId);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutDishBatchUploadRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 菜品删除
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutDishDelete (String appAuthToken, String dishCode,String ePoiId) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishDeleteRequest cipCaterTakeoutDishDeleteRequest =new CipCaterTakeoutDishDeleteRequest();
            cipCaterTakeoutDishDeleteRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishDeleteRequest.setePoiId(ePoiId);
            cipCaterTakeoutDishDeleteRequest.seteDishCode(dishCode);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutDishDeleteRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 菜品类型新增修改
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutDishCatUpdate (String appAuthToken, FoodTypeRelation foodTypeRelation,String oldName) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishCatUpdateRequest cipCaterTakeoutDishCatUpdateRequest =new CipCaterTakeoutDishCatUpdateRequest();
            cipCaterTakeoutDishCatUpdateRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishCatUpdateRequest.setCatName(foodTypeRelation.getName());
            cipCaterTakeoutDishCatUpdateRequest.setSequence(foodTypeRelation.getGroupRank());
            if(null != oldName){
                cipCaterTakeoutDishCatUpdateRequest.setOldCatName(oldName);
            }
            // 准备接收返回Json
            resultJson = cipCaterTakeoutDishCatUpdateRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 菜品SKU库存修改
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutDishStockUpdateRequest (String appAuthToken, String ePoiId,String dishSkuStocks) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishStockUpdateRequest cipCaterTakeoutDishStockUpdateRequest =new CipCaterTakeoutDishStockUpdateRequest();
            cipCaterTakeoutDishStockUpdateRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishStockUpdateRequest.setePoiId(ePoiId);
            cipCaterTakeoutDishStockUpdateRequest.setDishSkuStocks(dishSkuStocks);

            // 准备接收返回Json
            resultJson = cipCaterTakeoutDishStockUpdateRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 菜品类型删除
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutDishCatDetele (String appAuthToken, FoodTypeRelation foodTypeRelation) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishCatDeleteRequest caterTakeoutDishCatDeleteRequest =new CipCaterTakeoutDishCatDeleteRequest();
            caterTakeoutDishCatDeleteRequest.setRequestSysParams(requestSysParams);
            caterTakeoutDishCatDeleteRequest.setCatName(foodTypeRelation.getName());
            // 准备接收返回Json
            resultJson = caterTakeoutDishCatDeleteRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }
    /**
     * 菜品SKU删除
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param eDishCode 菜品id
     * @param eDishSkuCode
     */
    public static String takeoutDishSkuDeleteRequest (String appAuthToken,String eDishCode,String eDishSkuCode) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutDishSkuDeleteRequest cipCaterTakeoutDishSkuDeleteRequest =new CipCaterTakeoutDishSkuDeleteRequest();
            cipCaterTakeoutDishSkuDeleteRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutDishSkuDeleteRequest.setEDishSkuCode(eDishSkuCode);
            cipCaterTakeoutDishSkuDeleteRequest.setEDishCode(eDishCode);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutDishSkuDeleteRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("delete dish sku error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 查询众包配送费
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderZbShippingFeeQueryRequest (String appAuthToken, String orderIds) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderZbShippingFeeQueryRequest cipCaterTakeoutOrderZbShippingFeeQueryRequest =new CipCaterTakeoutOrderZbShippingFeeQueryRequest();
            cipCaterTakeoutOrderZbShippingFeeQueryRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderZbShippingFeeQueryRequest.setOrderIds(orderIds);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderZbShippingFeeQueryRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }



    /**
     * 众包配送预下单
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderZbDispatchPrepareRequest (String appAuthToken, Long orderId,Double shippingFee,Double tipAmount) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderZbDispatchPrepareRequest cipCaterTakeoutOrderZbDispatchPrepareRequest =new CipCaterTakeoutOrderZbDispatchPrepareRequest();
            cipCaterTakeoutOrderZbDispatchPrepareRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderZbDispatchPrepareRequest.setOrderId(orderId);
            cipCaterTakeoutOrderZbDispatchPrepareRequest.setShippingFee(shippingFee);
            cipCaterTakeoutOrderZbDispatchPrepareRequest.setTipAmount(tipAmount);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderZbDispatchPrepareRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }


    /**
     * 众包配送加小费
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderZbDispatchTipUpdateRequest (String appAuthToken, Long orderId,Double shippingFee,Double tipAmount) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderZbDispatchTipUpdateRequest cipCaterTakeoutOrderZbDispatchTipUpdateRequest =new CipCaterTakeoutOrderZbDispatchTipUpdateRequest();
            cipCaterTakeoutOrderZbDispatchTipUpdateRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderZbDispatchTipUpdateRequest.setOrderId(orderId);
            cipCaterTakeoutOrderZbDispatchTipUpdateRequest.setTipAmount(tipAmount);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderZbDispatchTipUpdateRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 众包配送场景－确认下单
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderZbDispatchConfirmRequest (String appAuthToken, Long orderId,Double tipAmount) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderZbDispatchConfirmRequest cipCaterTakeoutOrderZbDispatchConfirmRequest =new CipCaterTakeoutOrderZbDispatchConfirmRequest();
            cipCaterTakeoutOrderZbDispatchConfirmRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderZbDispatchConfirmRequest.setOrderId(orderId);
            cipCaterTakeoutOrderZbDispatchConfirmRequest.setTipAmount(tipAmount);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderZbDispatchConfirmRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }

    /**
     * 美团专送场景－发配送
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderDispatchRequest (String appAuthToken, Long orderId,Double shippingFee,Double tipAmount) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderDispatchRequest cipCaterTakeoutOrderDispatchRequest =new CipCaterTakeoutOrderDispatchRequest();
            cipCaterTakeoutOrderDispatchRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderDispatchRequest.setOrderId(orderId);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderDispatchRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }
    /**
     * 美团专送场景－取消配送
     * @param appAuthToken 认领门店返回的token【一店一token】
     */
    public static String takeoutOrderDispatchCancelRequest (String appAuthToken, Long orderId,Double shippingFee,Double tipAmount) {
        String resultJson = "";
        try {
            ///dish/deleteCat
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderDispatchCancelRequest cipCaterTakeoutOrderDispatchCancelRequest =new CipCaterTakeoutOrderDispatchCancelRequest();
            cipCaterTakeoutOrderDispatchCancelRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderDispatchCancelRequest.setOrderId(orderId);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderDispatchCancelRequest.doRequest();
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout dish update  error: "+t.getMessage());
        }
        return resultJson;
    }


    /**
     * 美团确认接单
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param orderId 订单id
     */
    public static String takeoutOrderConfirmRequest(String appAuthToken, Long orderId) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams=new RequestSysParams(WaimaiConstents.secret,appAuthToken,"UTF-8");
            CipCaterTakeoutOrderConfirmRequest cipCaterTakeoutOrderConfirmRequest =new CipCaterTakeoutOrderConfirmRequest();
            cipCaterTakeoutOrderConfirmRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderConfirmRequest.setOrderId(orderId);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderConfirmRequest.doRequest();
            log.info("====== takeout order confirm result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout order confirm error: "+t.getMessage());
        }
        return resultJson;
    }
    /**
     * 美团取消订单
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param orderId 订单id
     */
    public static String takeoutOrderCancelRequest(String appAuthToken, Long orderId,String reason,String reasonCode) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = requestSysParams(appAuthToken);
            CipCaterTakeoutOrderCancelRequest cipCaterTakeoutOrderCancelRequest=new CipCaterTakeoutOrderCancelRequest();
            cipCaterTakeoutOrderCancelRequest.setRequestSysParams(requestSysParams);
            cipCaterTakeoutOrderCancelRequest.setOrderId(orderId);
            cipCaterTakeoutOrderCancelRequest.setReason(reason);
            cipCaterTakeoutOrderCancelRequest.setReasonCode(reasonCode);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutOrderCancelRequest.doRequest();
            log.info("====== takeout order cancel result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout order cancel error: "+t.getMessage());
        }
        return resultJson;
    }
    /**
     * 回复评价
     * @param appAuthToken 认领门店返回的token【一店一token】
     * @param commentId 三方评价id
     * @param ePoiId 门店id
     * @param reply 回复内容
     */
    public static String takeoutPoiAddReply(String appAuthToken, Long commentId,String ePoiId,String reply) {
        String resultJson = "";
        try {
            RequestSysParams requestSysParams = requestSysParams(appAuthToken);
            CipCaterTakeoutPoiAddReplay cipCaterTakeoutPoiAddReplay=new CipCaterTakeoutPoiAddReplay();
            cipCaterTakeoutPoiAddReplay.setRequestSysParams(requestSysParams);
            cipCaterTakeoutPoiAddReplay.setCommentId(commentId);
            cipCaterTakeoutPoiAddReplay.setePoiId(ePoiId);
            cipCaterTakeoutPoiAddReplay.setReply(reply);
            // 准备接收返回Json
            resultJson = cipCaterTakeoutPoiAddReplay.doRequest();
            log.info("====== takeout poi add reply result ======");
            log.info("result: "+resultJson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("takeout poi add reply error: "+t.getMessage());
        }
        return resultJson;
    }

}




