package com.ptteng.onway.admin.unit;

import com.ptteng.onway.platform.model.BusinessHours;
import com.ptteng.onway.platform.model.mtERP.AvailableTimes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * show
 * @author lishaobo
 * @date    2018/1/23
 */
public class MtErpUtil {
    private static final Log log = LogFactory.getLog(MtErpUtil.class);
    public static AvailableTimes getAvailableTimes (String mealTypeString, Map<Integer, BusinessHours> businessHoursMap)  throws Exception {
        try {
            log.info("mealTypeString is " + mealTypeString);
            List<String> monday = new ArrayList<>();
            List<String> tuesday = new ArrayList<>();
            List<String> wednesday = new ArrayList<>();
            List<String> thursday = new ArrayList<>();
            List<String> friday = new ArrayList<>();
            List<String> saturday = new ArrayList<>();
            List<String> sunday = new ArrayList<>();
            AvailableTimes availableTimes = new AvailableTimes();
            if (BusinessHours.DISABLE.equals(mealTypeString)){
                availableTimes.setMonday("00:00-00:00");
                availableTimes.setMonday("00:00-00:00");
                availableTimes.setTuesday("00:00-00:00");
                availableTimes.setWednesday("00:00-00:00");
                availableTimes.setThursday("00:00-00:00");
                availableTimes.setFriday("00:00-00:00");
                availableTimes.setSaturday("00:00-00:00");
                availableTimes.setSunday("00:00-00:00");
                return availableTimes;
            }
            List<String> mealTypes = Arrays.asList(mealTypeString.split(","));

            for (String mealType : mealTypes) {
                BusinessHours businessHours = businessHoursMap.get(Integer.valueOf(mealType));
                log.info("businessHours is " + businessHours);
                String week = businessHours.getWeek();
                //周一时间
                if (week.contains(BusinessHours.MONDAY + "")) {
                    monday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周二时间
                if (week.contains(BusinessHours.TUESDAY + "")) {
                    tuesday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周三时间
                if (week.contains(BusinessHours.WEDNESDAY + "")) {
                    wednesday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周四时间
                if (week.contains(BusinessHours.THURSDAY + "")) {
                    thursday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周五时间
                if (week.contains(BusinessHours.FRIDAY + "")) {
                    friday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周六时间
                if (week.contains(BusinessHours.SATURDAY + "")) {
                    saturday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }
                //周日时间
                if (week.contains(BusinessHours.SUNDAY + "")) {
                    sunday.add(businessHours.getStartTime() + "-" + businessHours.getEndTime());
                }

            }


            availableTimes.setMonday(String.join(",", monday));
            availableTimes.setTuesday(String.join(",", tuesday));
            availableTimes.setWednesday(String.join(",", wednesday));
            availableTimes.setThursday(String.join(",", thursday));
            availableTimes.setFriday(String.join(",", friday));
            availableTimes.setSaturday(String.join(",", saturday));
            availableTimes.setSunday(String.join(",", sunday));
            log.info("availableTimes is " + availableTimes);
            return availableTimes;


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("getAvailableTimes error ");
            return null;
        }

    }
}
