package com.ptteng.onway.admin.unit;

import com.ptteng.onway.platform.model.mtERP.DishesEPR;
import com.ptteng.onway.platform.model.Food;
import com.ptteng.onway.platform.model.mtERP.SkusEPR;
import com.qding.common.util.DataUtils;

import java.util.List;

/**
 * Created by Master on 2017/12/26.
 */
public class MtCover2Model {

    public static DishesEPR FoodCover2DishesEPR  (Food food, String foodType, List<SkusEPR> skusEPRS) {

        DishesEPR dishesEPR = new DishesEPR();
        dishesEPR.setBoxNum(food.getPackageBoxNum());
        dishesEPR.setBoxPrice(food.getPackageFee());
        dishesEPR.setCategoryName(foodType);
        dishesEPR.setDescription(food.getDescription());
        dishesEPR.setDishName(food.getName());
        dishesEPR.setEDishCode(food.getId());
//        dishesEPR.setePoiId(food.getStoreId());
        dishesEPR.setIsSoldOut(0);
        dishesEPR.setMinOrderCount(food.getMinOrderNum());
        dishesEPR.setPicture(food.getPic());
//        dishesEPR.setSequence(food.getRank());
//        dishesEPR.setPrice(food.getPrice());
        if(DataUtils.isNotNullOrEmpty(skusEPRS)){
            dishesEPR.setSkus(skusEPRS);
        }
        String format="";
        switch (food.getFormat()){
            case 1:
                format="份";
                break;
            case 2:
                format="个";
                break;
            case 3:
                format="斤";
                break;
        }
        dishesEPR.setUnit(format);

        return dishesEPR;

    }
}
