package com.ptteng.onway.admin.unit;


import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class
DynamicUtil {

    public static Map<String,Object> getTrademark (Long trademarkNum) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(trademarkNum)) {
            param.put(" trademark_num ", trademarkNum);
        }

        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," trademark ");
        return param;
    }
    public static Map<String,Object> getTrademarkList (String name, String platform) {
        Map<String,Object> param = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(name)) {
            param.put(" name & like ","'%"+ name+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(platform)) {
            platform = QueryUtil.getPlatformQueryStringAll(platform);
            param.put(" platform & in ","("+ platform+")" );
        }
        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," trademark ");
        return param;
    }
    public static Map<String,Object> getUserOrderList (Long trademarkId, Long storeId, Long timeStart, Long TimeEnd,String platformOrderNum,String userMobile ,String platform,String acceptStatus, String orderStatus) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(trademarkId)) {
            param.put(" trademark_id ", trademarkId);
        }
        if (DataUtils.isNotNullOrEmpty(storeId)) {
            param.put(" store_id ", storeId);
        }
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            param.put(" buy_at & >= ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(TimeEnd)) {
            param.put(" buy_at & <=", TimeEnd);
        }
        if (DataUtils.isNotNullOrEmpty(platformOrderNum)) {
            param.put(" platform_order_num & like ","'%"+ platformOrderNum+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(userMobile)) {
            param.put(" mobile & like ", "'%"+userMobile+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(acceptStatus)) {
            param.put(" accept_status & in ", "(" + acceptStatus + ")");
        }
        if (DataUtils.isNotNullOrEmpty(platform)) {
            platform = QueryUtil.getPlatformQueryString(platform);
            param.put(" platform & in ","("+ platform+")" );
        }
        if (DataUtils.isNotNullOrEmpty(orderStatus)) {
            param.put(" order_status & in ","(" +orderStatus + ")");
        }
        param.put("@query"," id");
        param.put("@order", " buy_at desc ");
        param.put("@table"," user_order ");
        return param;
    }
    public static Map<String,Object> getFootOrderListByOrderId (List<Long> ids) {
        Map<String,Object> param = new HashMap<>();
        if (CollectionUtils.isNotEmpty(ids)) {
          String str = org.apache.commons.lang3.StringUtils.join(ids,",");
            param.put(" order_id & in ","("+ str+")");
        }
        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," food_order_relation ");
        return param;
    }
    public static Map<String,Object> getEvaluateList (Long timeStart, Long timeEnd, String platformOrderNum, String mobile, String platform, String orderScore,Long storeId,Long trademarkId) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            param.put(" e.buy_at & >= ",timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            param.put(" e.buy_at & <= ",timeEnd);
        }
        if (DataUtils.isNotNullOrEmpty(platformOrderNum)) {
            param.put(" e.platform_order_num & like ","'%"+platformOrderNum+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            param.put(" o.mobile & like ","'%"+mobile+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(platform)) {
            platform = QueryUtil.getPlatformQueryString(platform);
            param.put(" e.platform & in ","("+ platform+")" );
        } else {
            platform = QueryUtil.getPlatformQueryString("000110");
            param.put(" e.platform & in ","("+ platform+")" );
        }
        if (DataUtils.isNotNullOrEmpty(orderScore)) {
            param.put(" e.order_score & in ","("+orderScore+")");
        }
        if (DataUtils.isNotNullOrEmpty(storeId)) {
            param.put(" e.store_id ",storeId);
        }
        if (DataUtils.isNotNullOrEmpty(trademarkId)) {
            param.put(" e.trademark_id ",trademarkId);
        }
        param.put(" e.order_id "," o.id ");
        param.put("@query"," e.id");
        param.put("@order", " e.create_at desc ");
        param.put("@table"," evaluate_order_relation as e,user_order as o");
        return param;
    }
    public static Map<String,Object> getEvaluateListByMeituan (String orderScore,Long storeId,Long trademarkId) {
        Map<String,Object> param = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(orderScore)) {
            param.put(" order_score & in ","("+orderScore+")");
        }
        if (DataUtils.isNotNullOrEmpty(storeId)) {
            param.put(" store_id ",storeId);
        }
        if (DataUtils.isNotNullOrEmpty(trademarkId)) {
            param.put(" trademark_id ",trademarkId);
        }
        param.put(" platform ", WaimaiConstents.platform_meitian);
        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," evaluate_order_relation ");
        return param;
    }
    public static Map<String,Object> getUserList (Long timeStart,Long timeEnd,String mobile,String name,String platform) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            param.put(" create_at & >= ",timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            param.put(" create_at & <= ",timeEnd);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            param.put(" name & like ","'%"+name+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            param.put(" mobile & like ","'%"+mobile+"%'");
        }
        if (DataUtils.isNotNullOrEmpty(platform)) {
            param.put(" platform ", platform);
        }

        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," user ");
        return param;
    }

    public static Map<String,Object> getFoodList (Long date , Integer meituan,Integer baidu ,Integer ele, Long timeStart, Long timeEnd) {
        Map<String,Object> param = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(date)) {
            param.put("create_at & > ", date);
        }

        if (DataUtils.isNotNullOrEmpty(meituan)) {
            param.put(" meituan_status ", meituan);
        }
        if (DataUtils.isNotNullOrEmpty(baidu)) {
            param.put("baidu_status ", baidu);
        }
        if (DataUtils.isNotNullOrEmpty(ele)) {
            param.put(" ele_status ", ele);
        }
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            param.put("create_at & >  ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            param.put("create_at & <  ", timeEnd);
        }

        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," food ");
        return param;
    }

    public static Map<String,Object> getNewOrderList (String acceptStatus,String orderStatus,Long storeId,Long startAt,Long endAt) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(acceptStatus)) {
            param.put(" accept_status & in ","(" + acceptStatus+")");
        }
        if (DataUtils.isNotNullOrEmpty(orderStatus)) {
            param.put(" order_status & in ","(" +orderStatus+")");
        }
        if (DataUtils.isNotNullOrEmpty(storeId)) {
            param.put(" store_id ",storeId);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            param.put(" create_at & >= ",startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            param.put(" create_at & <= ",endAt);
        }

        param.put("@query"," id");
        param.put("@order", "update_at desc ");
        param.put("@table"," user_order ");
        return param;
    }

    public static Map<String,Object> getFoodSolidListAll ( Integer meituan,Integer baidu ,Integer ele, Integer type,String storeNum) {
        Map<String,Object> param = new HashMap<>();


        if (DataUtils.isNotNullOrEmpty(meituan)&&!meituan.equals(0)) {
            param.put("f.meituan_status ", meituan);
        }
        if (DataUtils.isNotNullOrEmpty(baidu)&&!baidu.equals(0)) {
            param.put("f.baidu_status ", baidu);
        }
        if (DataUtils.isNotNullOrEmpty(ele)&&!ele.equals(0)) {
            param.put("f.ele_status ", ele);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            param.put("fs.meal_type & like ","'%"+ type+"%'");
        }
        param.put("fs.store_num", storeNum);
        param.put("fs.status","1");
        param.put("f.food_num", "fs.food_num");
        param.put("@query","fs.id");
        param.put("@order", " fs.create_at desc ");
        param.put("@table"," food as f,food_solid as fs ");
        return param;
    }

    public static Map<String,Object> getFoodListByFoodNums ( List<String> foodNums ) {
        Map<String,Object> param = new HashMap<>();

        if (CollectionUtils.isNotEmpty(foodNums)) {
            param.put(" food_num & in ","("+ String.join(",",foodNums)+")");
        }

        param.put("@query","id");
        param.put("@order", " create_at desc ");
        param.put("@table"," food ");
        return param;
    }


    public static Map<String,Object> getSynchronizeList ( String platform,String synType ,String synStatus, Long timeStart,Long timeEnd) {
        Map<String,Object> param = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(platform)) {
            platform = QueryUtil.getPlatformQueryString(platform);
            param.put(" platform & in ","("+ platform+")" );
        }
        if (DataUtils.isNotNullOrEmpty(synType)) {
            param.put(" syn_type & in ", "("+synType+")");
        }
        if (DataUtils.isNotNullOrEmpty(synStatus)) {
            param.put(" status & in ", "("+synStatus+")");
        }
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            param.put(" create_at & >= ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            param.put(" create_at & <= ", timeEnd);
        }
        param.put("@query"," id");
        param.put("@order", " create_at desc ");
        param.put("@table"," syn_record ");
        return param;
    }


    public static Map<String,Object> getFoodIdsByStoreNumAndStatus ( String storeNum,Integer status ) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(storeNum)) {
            param.put(" fs.store_num ", storeNum);
            param.put(" gs.store_num ", storeNum);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            param.put(" fs.status ", status);
        }
        param.put("fs.food_num","f.food_num");
        param.put("gs.food_num","fs.food_num");
        param.put("@query", "f.id");
        param.put("@group"," f.id");

        param.put("@order", " gs.group_rank ");
        param.put("@table"," food as f, food_solid as fs,group_food_sort as gs");
        return param;
    }
    public static Map<String,Object> getGroupFoodSortIdsByStoreNumAndFoodNumList ( String storeNum,List<String> foodNum ) {
        Map<String,Object> param = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(storeNum)) {
            param.put(" store_num ", storeNum);
        }
        if (CollectionUtils.isNotEmpty(foodNum)) {
            param.put("food_num & in ", "("+String.join(",",foodNum)+")");
        }

        param.put("@query", "id");
        param.put("@order", " food_num ");
        param.put("@table"," group_food_sort");
        return param;
    }
    public static Map<String,Object> getFoodSpecListByTargetIds ( List<Long> ids ) {
        Map<String,Object> param = new HashMap<>();

        if (CollectionUtils.isNotEmpty(ids)) {
            List<String> newIds = new ArrayList<>();
           for (Long id :ids) {
               newIds.add(id.toString());
           }
            param.put("target_id & in ", "("+String.join(",",newIds)+")");
        }

        param.put("@query", "id");
        param.put("@order", " create_at ");
        param.put("@table"," food_spec_relation");
        return param;
    }
}