package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.admin.unit.CoverUtil;
import com.ptteng.onway.admin.unit.DynamicUtil;
import com.ptteng.onway.admin.unit.QueryUtil;
import com.ptteng.onway.admin.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.*;
import com.ptteng.onway.platform.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * UserOrder  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserOrderController {
    private static final Log log = LogFactory.getLog(UserOrderController.class);

    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private StoreService storeService;

    @Autowired
    private FoodOrderRelationService foodOrderRelationService;

    @Autowired
    private TemplateTestService templateTestService;

    @Autowired
    private UserService userService;


    /**
     * 订单列表
     *
     * @param timeStart        下单时间开始
     * @param timeEnd          下单时间结束
     * @param platformOrderNum 订单号
     * @param mobile           手机号
     * @param platform         外卖渠道
     * @param acceptStatus     接单状态
     * @param orderStatus      订单状态
     */

    @RequestMapping(value = "/a/u/order/list", method = RequestMethod.GET)
    public String getUserOrderList(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, String platformOrderNum, String mobile, String platform, String acceptStatus, String orderStatus, Integer page, Integer size, Integer type) throws Exception {
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("get /a/userOrder");
        log.info("get order by:storeId =" + storeId + " ,timeStart = " + timeStart + " ,timeEnd = " + timeEnd + " ,platformOrderNum = " + platformOrderNum + " ,mobile = " + mobile + " ,platform = " + platform + " ,acceptStatus = " + acceptStatus + " ,orderStatus = " + orderStatus);

        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("page is " + page + " ,size is " + size);
        try {
            Store store = storeService.getObjectById(storeId);
            Long trademarkId = store.getTrademarkId();

            Map<String, Object> param = DynamicUtil.getUserOrderList(trademarkId, storeId, timeStart, timeEnd, platformOrderNum, mobile, platform, acceptStatus, orderStatus);
            List<Long> ids = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, start, size);
            List<UserOrder> userOrderList = userOrderService.getObjectsByIds(ids);
            log.info("get  userOrder size is " + ids.size());
            List<Long> idsTotal = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, 0, Integer.MAX_VALUE);
            Integer total = idsTotal.size();

            //获取订单关联菜品
            Map<String, Object> foodParam = DynamicUtil.getFootOrderListByOrderId(ids);
            List<Long> fids = foodOrderRelationService.getIdsByDynamicCondition(FoodOrderRelation.class, foodParam, 0, Integer.MAX_VALUE);
            List<FoodOrderRelation> foodOrderRelationList = foodOrderRelationService.getObjectsByIds(fids);
            log.info("food relation size is " + fids.size());
            Map<String, List<FoodOrderRelation>> foodOrderRelationMap = new HashMap<>();
            for (FoodOrderRelation foodOrderRelation : foodOrderRelationList) {
                String orderId = foodOrderRelation.getOrderId().toString();
                List<FoodOrderRelation> foodList = foodOrderRelationMap.get(orderId);

                if (null == foodList) {
                    foodList = new ArrayList<>();
                }

                log.info("order id is " + orderId + " ; foodList size is " + foodList.size());
                foodList.add(foodOrderRelation);
                foodOrderRelationMap.put(orderId, foodList);
            }

            //设置品牌、门店名
            //门店ids
            List<Long> sids = storeService.getStoreIds(0, Integer.MAX_VALUE);
            List<Store> stores = storeService.getObjectsByIds(sids);
            log.info("stores size is " + stores.size());
            Map<Long, String> storeMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), stores);
            //品牌ids
            List<Long> tids = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE);
            List<Trademark> trademarks = trademarkService.getObjectsByIds(tids);
            log.info("trademarks size is " + trademarks.size());
            Map<Long, String> trademarkMap = MyListUtil.convert2Map(Trademark.class.getDeclaredField("id"), Trademark.class.getDeclaredField("name"), trademarks);

            for (UserOrder userOrder : userOrderList) {
                userOrder.setStoreName(storeMap.get(userOrder.getStoreId()));
                userOrder.setTrademarkName(trademarkMap.get(userOrder.getTrademarkId()));
            }


            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("userOrderList", userOrderList);
            model.addAttribute("foodList", foodOrderRelationMap);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }

        log.info(" page is " + page + " size is " + size);

        return "/onway-platform-service/userOrder/json/userOrderListJson";
    }

    //excel_list
    @RequestMapping(value = "/a/order/list/excel", method = RequestMethod.GET)
    public String getUserOrderListExcel(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, Long trademarkId, Long storeId, Long timeStart, Long timeEnd, String orderNum, String userMobile, String platform, String acceptStatus, String orderStatus, Integer page, Integer size, Integer type) throws Exception {
        log.info("get /a/userOrder");
        log.info("get order by:trademarkId= " + trademarkId + " ,storeId =" + storeId + " ,timeStart = " + timeStart + " ,timeEnd = " + timeEnd + " ,orderNum = " + orderNum + " ,userMobile = " + userMobile + " ,platform = " + platform + " ,acceptStatus = " + acceptStatus + " ,orderStatus = " + orderStatus);
        page = 1;

        size = 9999999;
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("page is " + page + " ,size is " + size);
        try {
            Map<String, Object> param = DynamicUtil.getUserOrderList(trademarkId, storeId, timeStart, timeEnd, orderNum, userMobile, platform, acceptStatus, orderStatus);
            List<Long> ids = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, start, size);
            List<UserOrder> userOrderList = userOrderService.getObjectsByIds(ids);
            log.info("get  userOrder size is " + ids.size());
            List<Long> idsTotal = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, 0, Integer.MAX_VALUE);
            Integer total = idsTotal.size();

            //获取订单关联菜品
            Map<String, Object> foodParam = DynamicUtil.getFootOrderListByOrderId(ids);
            List<Long> fids = foodOrderRelationService.getIdsByDynamicCondition(FoodOrderRelation.class, foodParam, 0, Integer.MAX_VALUE);
            List<FoodOrderRelation> foodOrderRelationList = foodOrderRelationService.getObjectsByIds(fids);
            log.info("food relation size is " + fids.size());

            Map<String, List<FoodOrderRelation>> foodOrderRelationMap = new HashMap<>();
            for (FoodOrderRelation foodOrderRelation : foodOrderRelationList) {
                String orderId = foodOrderRelation.getOrderId().toString();
                List<FoodOrderRelation> foodList = foodOrderRelationMap.get(orderId);

                if (null == foodList) {
                    foodList = new ArrayList<>();
                }

                log.info("order id is " + orderId + " ; foodList size is " + foodList.size());
                foodList.add(foodOrderRelation);
                foodOrderRelationMap.put(orderId, foodList);
            }

            //设置品牌、门店名
            //门店ids
            List<Long> sids = storeService.getStoreIds(0, Integer.MAX_VALUE);
            List<Store> stores = storeService.getObjectsByIds(sids);
            log.info("stores size is " + stores.size());
            Map<Long, String> storeMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), stores);
            //品牌ids
            List<Long> tids = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE);
            List<Trademark> trademarks = trademarkService.getObjectsByIds(tids);
            log.info("trademarks size is " + trademarks.size());
            Map<Long, String> trademarkMap = MyListUtil.convert2Map(Trademark.class.getDeclaredField("id"), Trademark.class.getDeclaredField("name"), trademarks);

            for (UserOrder userOrder : userOrderList) {
                userOrder.setStoreName(storeMap.get(userOrder.getStoreId()));
                userOrder.setTrademarkName(trademarkMap.get(userOrder.getTrademarkId()));
            }

            model.addAttribute("userOrderList", userOrderList);

            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("sheet");
            Row header_row = sheet.createRow(0);
            String headers[] = new String[]{"序号", "店铺", "外卖渠道", "用户姓名", "性别", "手机号", "下单时间", "接单状态", "产品", "订单状态", "订单金额", "第三方订单", "需要发票", "发票抬头", "发票税号"};
            for (int i = 0; i < headers.length; i++) {
                HSSFCell cell = (HSSFCell) header_row.createCell(i);
                cell.setCellValue(headers[i]);
            }
            for (int i = 1; i < userOrderList.size(); i++) {
                Row rose = sheet.createRow(i);
                for (int j = 0; j < headers.length; j++) {
                    UserOrder userOrder = userOrderList.get(i);
                    HSSFCell cell0 = (HSSFCell) rose.createCell(0);
                    cell0.setCellValue(i);
                    HSSFCell cell1 = (HSSFCell) rose.createCell(1);
                    cell1.setCellValue(userOrder.getStoreName());
                    HSSFCell cell2 = (HSSFCell) rose.createCell(2);
                    cell2.setCellValue(userOrder.getPlatform());
                    HSSFCell cell3 = (HSSFCell) rose.createCell(3);
                    cell3.setCellValue(userOrder.getUserName());
                    HSSFCell cell4 = (HSSFCell) rose.createCell(4);
                    cell4.setCellValue(userOrder.getSex());
                    HSSFCell cell5 = (HSSFCell) rose.createCell(5);
                    cell5.setCellValue(userOrder.getMobile());
                    HSSFCell cell6 = (HSSFCell) rose.createCell(6);
                    cell6.setCellValue(userOrder.getBuyAt());
                    HSSFCell cell7 = (HSSFCell) rose.createCell(7);
                    cell7.setCellValue(userOrder.getAcceptStatus());
                    HSSFCell cell8 = (HSSFCell) rose.createCell(8);
                    cell8.setCellValue("chanpin");
                    HSSFCell cell9 = (HSSFCell) rose.createCell(9);
                    cell7.setCellValue(userOrder.getOrderStatus());
                    HSSFCell cell10 = (HSSFCell) rose.createCell(10);
                    cell7.setCellValue(userOrder.getOrderPrice().toString());
                    HSSFCell cell11 = (HSSFCell) rose.createCell(11);
                    cell7.setCellValue(userOrder.getPlatformOrderNum());
                    HSSFCell cell12 = (HSSFCell) rose.createCell(12);
                    cell7.setCellValue(userOrder.getInvoice());
                    HSSFCell cell13 = (HSSFCell) rose.createCell(13);
                    cell7.setCellValue(userOrder.getInvoiceTitle());
                    HSSFCell cell14 = (HSSFCell) rose.createCell(14);
                    cell7.setCellValue(userOrder.getTaxNum());
                }

            }
            Long excelDate = System.currentTimeMillis();
            String url = "/data/webs/onway-admin-web/excel/外卖订单列表" + excelDate + ".xls";
            FileOutputStream output = new FileOutputStream(url);
            url = "/exceldownload/外卖订单列表" + excelDate + ".xls";
            wb.write(output);
            output.flush();
            model.addAttribute("code", 0);
            model.addAttribute("url", url);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }

        return "/common/url";
    }


    /**
     * 新订单数据计数
     * 美团
     *

     */

    @RequestMapping(value = "/a/u/order/count", method = RequestMethod.GET)
    public String getStoreNewOrderList(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model) throws Exception {
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("get /a/order/count ,store id is " + storeId);

        try {
        /**
        *待接单 acceptStatus=1
		* 已接单 acceptStatus=2 orderStatus = 1，2
		* 预定订单-美团暂无
		* 取消订单 acceptStatus=2 orderStatus = 0
		*退款订单 acceptStatus=2 orderStatus=4
		* */
            Map<String, Object> param = DynamicUtil.getNewOrderList("1,2", "0,1,2,4", storeId, MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis());
            List<Long> ids = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, 0, Integer.MAX_VALUE);
            List<UserOrder> orderList = userOrderService.getObjectsByIds(ids);
            Map<String, List<UserOrder>> newOrder = new HashMap<>();

            newOrder.put("wait", new ArrayList<UserOrder>());
            newOrder.put("refund", new ArrayList<UserOrder>());
            newOrder.put("cancel", new ArrayList<UserOrder>());
            newOrder.put("processing", new ArrayList<UserOrder>());
            newOrder.put("destine", new ArrayList<UserOrder>());

            for (UserOrder userOrder : orderList) {
                //待接订单
                Integer acceptStatus = userOrder.getAcceptStatus();
                Integer orderStatus = userOrder.getOrderStatus();
                switch (acceptStatus) {
                    case UserOrder.ACCEPT_STATUS_WAIT:
                        newOrder.get("wait").add(userOrder);
                        break;
                    case UserOrder.ACCEPT_STATUS_FINISH:
                        //退款单
                        if (orderStatus.equals(UserOrder.ORDER_STATUS_REFUNDING)) {
                            newOrder.get("refund").add(userOrder);
                            //取消单
                        } else if (orderStatus.equals(UserOrder.ORDER_STATUS_CANCEL)) {
                            newOrder.get("cancel").add(userOrder);
                            //已接单
                        } else {
                            newOrder.get("processing").add(userOrder);
                        }
                        break;
                        default:
                            log.info("acceptStatus is " + acceptStatus);

                            break;
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("orderList", newOrder);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }

//		log.info(" page is " + page + " size is " + size);

        return "/onway-platform-service/userOrder/json/userOrderCountJson";
    }

    /**
     * 新订单数据列表
     * 美团
     *
     */

    @RequestMapping(value = "/a/u/order/{type}/list", method = RequestMethod.GET)
    public String getStoreNewOrderJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Integer type) throws Exception {
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("get /a/newOrder/list ,store id is " + storeId + " , type is " + type);

        try {
                    /*
            *待接单 acceptStatus=1
			* 已接单 acceptStatus=2 orderStatus = 1，2
			* 预定订单-美团暂无
			* 取消订单 acceptStatus=2 orderStatus = 0
			*退款订单 acceptStatus=2 orderStatus=4
			* */
            String acceptStatus = null;
            String orderStatus = null;
            if (type == 1) {
                acceptStatus = "1";
            } else {
                acceptStatus = "2";
            }
            switch (type) {
                //未接订单
                case 1:
                    orderStatus = "1";
                    break;
                //退款订单
                case 2:
                    orderStatus = "4";
                    break;
                //取消订单
                case 3:
                    orderStatus = "0";
                    break;
                //已接订单
                case 4:
                    orderStatus = "1,2";
                    break;
                //预定订单
                case 5:
                    orderStatus = "6";
                    break;
                    default:
                        log.warn("type error,type is " + type);
                        break;
            }

            Map<String, Object> param = DynamicUtil.getNewOrderList(acceptStatus, orderStatus, storeId,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis());
            List<Long> ids = userOrderService.getIdsByDynamicCondition(UserOrder.class, param, 0, Integer.MAX_VALUE);
            log.info("ids size is " + ids.size());
            List<UserOrder> orderList = userOrderService.getObjectsByIds(ids);
            log.info("userOrderList is " + orderList);

            //获取订单关联菜品
            Map<String, Object> foodParam = DynamicUtil.getFootOrderListByOrderId(ids);
            List<Long> fids = foodOrderRelationService.getIdsByDynamicCondition(FoodOrderRelation.class, foodParam, 0, Integer.MAX_VALUE);
            List<FoodOrderRelation> foodOrderRelationList = foodOrderRelationService.getObjectsByIds(fids);
            log.info("food relation size is " + fids.size());

            Map<String, List<FoodOrderRelation>> foodOrderRelationMap = new HashMap<>();
            for (FoodOrderRelation foodOrderRelation : foodOrderRelationList) {
                String orderId = foodOrderRelation.getOrderId().toString();
                List<FoodOrderRelation> foodList = foodOrderRelationMap.get(orderId);

                if (null == foodList) {
                    foodList = new ArrayList<>();
                }

                log.info("order id is " + orderId + " ; foodList size is " + foodList.size());
                foodList.add(foodOrderRelation);
                foodOrderRelationMap.put(orderId, foodList);
            }

            //设置品牌、门店名
            //门店ids
            List<Long> sids = storeService.getStoreIds(0, Integer.MAX_VALUE);
            List<Store> stores = storeService.getObjectsByIds(sids);
            log.info("stores size is " + stores.size());
            Map<Long, String> storeMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), stores);
            //品牌ids
            List<Long> tids = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE);
            List<Trademark> trademarks = trademarkService.getObjectsByIds(tids);
            log.info("trademarks size is " + trademarks.size());
            Map<Long, String> trademarkMap = MyListUtil.convert2Map(Trademark.class.getDeclaredField("id"), Trademark.class.getDeclaredField("name"), trademarks);

            for (UserOrder userOrder : orderList) {
                userOrder.setStoreName(storeMap.get(userOrder.getStoreId()));
                userOrder.setTrademarkName(trademarkMap.get(userOrder.getTrademarkId()));
            }
            log.info("userOrderList is " + orderList);


            model.addAttribute("code", 0);
            model.addAttribute("userOrderList", orderList);
            model.addAttribute("foodList", foodOrderRelationMap);
            model.addAttribute("size", 100);
            model.addAttribute("page", 1);
            model.addAttribute("total", ids.size());
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }


        return "/onway-platform-service/userOrder/json/userOrderListJson";
    }

    /**
     * 订单数据统计
     *
     * @param storeId     门店id
     * @param trademarkId 品牌id
     * @param timeStart   下单时间开始
     * @param timeEnd     下单时间结束
     * @param orderType   0所有订单 1有效订单
     */

    @RequestMapping(value = "/a/u/order/statistics", method = RequestMethod.GET)
    public String getStoreOrderList(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Integer page, Integer size, Long storeId, Long trademarkId, Integer orderType) throws Exception {
        log.info("get /a/order/statistics");
        log.info("get order by:timeStart = " + timeStart + " ,timeEnd = " + timeEnd + " ,storeId = " + storeId + " ,trademarkId = " + trademarkId + " ,orderType = " + orderType);
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        if (null == orderType) {
            orderType = 0;
        }

        try {
            List<OrderStatistics> orderStatisticsList = new ArrayList<>();
            List<OrderStatistics> orderStatisticsAllList = new ArrayList<>();
            List<Long> ids = new ArrayList<>();
            List<OrderStatistics> trademarkPlatformOrderStatistics = new ArrayList<>();
            List<OrderStatistics> trademarkOrderStatistics = new ArrayList<>();
            //品牌总数据统计


            if (null == trademarkId) {
                //统计门店订单数据
                log.info("store orderStatisticsList start");
                //所有订单
                if (orderType == 0) {
                    orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreId(timeStart, timeEnd, storeId);
                    orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreId(timeStart, timeEnd, storeId);

                    //有效订单
                } else if (orderType == 1) {
                    orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
                    orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
                }

                ids.add(storeId);
                log.info("store orderStatisticsList is" + orderStatisticsList);
                log.info("store orderStatisticsAllList is" + orderStatisticsAllList);
            } else {
                //统计品牌订单数据
                log.info("trademark orderStatisticsList start");


                //品牌下所有门店
                ids = storeService.getStoreIdsByTrademarkId(trademarkId, 0, Integer.MAX_VALUE);


                //所有订单
                if (orderType == 0) {
                    orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);
                    orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);
                    //有效订单
                } else if (orderType == 1) {
                    orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndTrademarkIdAndOrderStatus(timeStart, timeEnd, trademarkId);
                    orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndTrademarkIdAndOrderStatus(timeStart, timeEnd, trademarkId);

                }

                log.info("trademark orderStatisticsList is" + orderStatisticsList);
                log.info("trademark orderStatisticsAllList is" + orderStatisticsAllList);
            }


            //设置map便于jsp中分类-按不同门店归类
            //统计订单总体数据
            Map<Long, OrderStatistics> orderStatisticsAllMap = new HashMap<>();
            for (OrderStatistics orderStatistics : orderStatisticsAllList) {
                orderStatisticsAllMap.put(orderStatistics.getId(), orderStatistics);
            }
            //统计不同平台数据
            Map<Long, List<OrderStatistics>> orderStatisticsMap = new HashMap<>();
            for (OrderStatistics orderStatistics : orderStatisticsList) {

                Long id = orderStatistics.getId();
                String platform = orderStatistics.getPlatform();
                switch (platform) {
                    case TrademarkParamsRelation.PLATFORM_BAIDU:
                        orderStatistics.setPlatformName("baidu");
                        break;
                    case TrademarkParamsRelation.PLATFORM_ELE:
                        orderStatistics.setPlatformName("ele");
                        break;
                    case TrademarkParamsRelation.PLATFORM_MEITUAN:
                        orderStatistics.setPlatformName("meituan");
                        break;
                        default:
                            log.warn("platform error,platform is " + platform);
                            break;

                }
                List<OrderStatistics> arr = orderStatisticsMap.get(id);
                if (DataUtils.isNullOrEmpty(arr) || CollectionUtils.isEmpty(arr)) {
                    List<OrderStatistics> newArr = new ArrayList<>();
                    newArr.add(orderStatistics);
                    orderStatisticsMap.put(id, newArr);
                } else {
                    orderStatisticsMap.get(id).add(orderStatistics);
                }
            }

            //数据填充-填充0
            for (Long id : ids) {
                if (DataUtils.isNullOrEmpty(orderStatisticsMap.get(id))) {
                    List<OrderStatistics> arr = new ArrayList<>();
                    arr.add(setZoreOrderStatistics("baidu"));
                    arr.add(setZoreOrderStatistics("ele"));
                    arr.add(setZoreOrderStatistics("meituan"));
                    orderStatisticsMap.put(id, arr);
                } else {
                    List<String> platformList = new ArrayList<>();

                    for (OrderStatistics orderStatistics : orderStatisticsMap.get(id)) {
                        platformList.add(orderStatistics.getPlatform());
                    }
                    if (!platformList.contains(TrademarkParamsRelation.PLATFORM_BAIDU)) {
                        orderStatisticsMap.get(id).add(setZoreOrderStatistics("baidu"));
                    }
                    if (!platformList.contains(TrademarkParamsRelation.PLATFORM_ELE)) {
                        orderStatisticsMap.get(id).add(setZoreOrderStatistics("ele"));
                    }
                    if (!platformList.contains(TrademarkParamsRelation.PLATFORM_MEITUAN)) {
                        orderStatisticsMap.get(id).add(setZoreOrderStatistics("meituan"));
                    }

                }
                if (DataUtils.isNullOrEmpty(orderStatisticsAllMap.get(id))) {
                    orderStatisticsAllMap.put(id, setZoreAllOrderStatistics());
                }
            }


            //获取店铺、品牌名
            List<Store> storeList = storeService.getObjectsByIds(ids);


            if (CollectionUtils.isNotEmpty(ids)) {
                Map<Long, String> storeNameMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), storeList);
                Long tid = storeList.get(0).getTrademarkId();
                Trademark trademark = trademarkService.getObjectById(tid);

                trademarkPlatformOrderStatistics = templateTestService.getTrademarkOrderStatisticsByPlatform(timeStart, timeEnd, tid, orderType);
                trademarkOrderStatistics = templateTestService.getTrademarkOrderStatisticsByTimeAndOrderStatus(timeStart, timeEnd, tid, orderType);
                log.info("trademarkOrderStatistics is " + trademarkOrderStatistics);
                List<String> arr = new ArrayList<>();
                for (OrderStatistics orderStatistics : trademarkPlatformOrderStatistics) {
                    arr.add(orderStatistics.getPlatform());
                    switch (orderStatistics.getPlatform()) {
                        case TrademarkParamsRelation.PLATFORM_BAIDU:
                            orderStatistics.setPlatformName("baidu");
                            break;
                        case TrademarkParamsRelation.PLATFORM_ELE:
                            orderStatistics.setPlatformName("ele");
                            break;
                        case TrademarkParamsRelation.PLATFORM_MEITUAN:
                            orderStatistics.setPlatformName("meituan");
                            break;
                            default:
                                log.warn("orderStatistics get platform error,platform is " + orderStatistics.getPlatform());
                    }
                }
                if (!arr.contains(TrademarkParamsRelation.PLATFORM_MEITUAN)) {
                    trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("meituan"));
                }
                if (!arr.contains(TrademarkParamsRelation.PLATFORM_BAIDU)) {
                    trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("baidu"));
                }
                if (!arr.contains(TrademarkParamsRelation.PLATFORM_ELE)) {
                    trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("ele"));
                }
                log.info("trademarkPlatformOrderStatistics is " + trademarkPlatformOrderStatistics);
                log.info("trademark is " + trademark);
                model.addAttribute("trademark", trademark);
                model.addAttribute("storeNameMap", storeNameMap);
                model.addAttribute("trademarkOrderStatistics", trademarkOrderStatistics.get(0));
                model.addAttribute("trademarkPlatformOrderStatistics", trademarkPlatformOrderStatistics);
            }
            //处理数据分页-因为统计数据没有实体,根据page、size计算开始、结束，截取ids后在jsp中展示对应数据
            Integer end = start + size;
            Integer total = ids.size();
            log.info("start is " + start + "  , end is " + end + " , total is " + total);
            if (start > total) {
                ids = new ArrayList<>();
            } else if (end > total) {
                ids = ids.subList(start, total);
            } else {
                ids = ids.subList(start, end);
            }

            log.info("ids is " + ids);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("orderStatisticsMap", orderStatisticsMap);
            model.addAttribute("orderStatisticsAllMap", orderStatisticsAllMap);
            model.addAttribute("ids", ids);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }


        return "/onway-platform-service/userOrder/json/orderStatisticsList";
    }


    //门店数据导出
    @RequestMapping(value = "/a/u/order/statistics/store/excel", method = RequestMethod.GET)
    public String getStoreOrderListExcel(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Long storeId, Integer orderType) throws Exception {
        log.info("get /a/order/statistics/store/excel");
        log.info("get order by:timeStart = " + timeStart + " ,timeEnd = " + timeEnd + " ,storeId = " + storeId + "  ,orderType = " + orderType);


        if (null == orderType) {
            orderType = 0;
        }

        List<OrderStatistics> orderStatisticsList = new ArrayList<>();
        List<OrderStatistics> orderStatisticsAllList = new ArrayList<>();
        List<Long> ids = new ArrayList<>();
        Integer baiduOrderNum = 0;
        Integer eleOrderNum = 0;
        Integer meituanOrderNum = 0;
        BigDecimal baiduAmount = BigDecimal.ZERO;
        BigDecimal eleAmount = BigDecimal.ZERO;
        BigDecimal meituanAmount = BigDecimal.ZERO;

        //统计门店订单数据
        log.info("store orderStatisticsList start");
        //所有订单
        if (orderType == 0) {
            orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreId(timeStart, timeEnd, storeId);
            orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreId(timeStart, timeEnd, storeId);
            //有效订单
        } else if (orderType == 1) {
            orderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
            orderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
        }

        //统计门店的情况,只有一个storeId
        ids.add(storeId);
        log.info("store orderStatisticsList is" + orderStatisticsList);
        log.info("store orderStatisticsAllList is" + orderStatisticsAllList);

        //设置map便于jsp中分类-按不同门店归类
        //统计订单总体数据
        Map<Long, OrderStatistics> orderStatisticsAllMap = new HashMap<>();
        for (OrderStatistics orderStatistics : orderStatisticsAllList) {
            orderStatisticsAllMap.put(orderStatistics.getId(), orderStatistics);
        }
        //统计不同平台数据
        Map<Long, List<OrderStatistics>> orderStatisticsMap = new HashMap<>();
        for (OrderStatistics orderStatistics : orderStatisticsList) {

            Long id = orderStatistics.getId();
            String platform = orderStatistics.getPlatform();
            log.info("platform is " + platform);
            switch (platform) {
                case TrademarkParamsRelation.PLATFORM_BAIDU:
                    orderStatistics.setPlatformName("baidu");
                    baiduOrderNum = orderStatistics.getOrderCount();
                    baiduAmount = orderStatistics.getAmount();
                    log.info("baiduAmount is" + baiduAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_ELE:
                    orderStatistics.setPlatformName("ele");
                    eleOrderNum = orderStatistics.getOrderCount();
                    eleAmount = orderStatistics.getAmount();
                    log.info("eleAmount is " + eleAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_MEITUAN:
                    orderStatistics.setPlatformName("meituan");
                    meituanOrderNum = orderStatistics.getOrderCount();
                    meituanAmount = orderStatistics.getAmount();
                    log.info("meituanAmount is " + meituanAmount);
                    break;
                    default:
                        log.warn("platform error ,platform is " + platform);
                        break;
            }
            //第一次循环时没有arr值,这里的id指的是storeId
            List<OrderStatistics> arr = orderStatisticsMap.get(id);
            if (DataUtils.isNullOrEmpty(arr) || CollectionUtils.isEmpty(arr)) {
                List<OrderStatistics> newArr = new ArrayList<>();
                newArr.add(orderStatistics);
                orderStatisticsMap.put(id, newArr);
            } else {
                orderStatisticsMap.get(id).add(orderStatistics);
            }
        }

        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet");
        //创建门店订单表头
        Row header_row = sheet.createRow(0);
        String headers[] = new String[]{"序号", "门店名称", "外卖订单数", "美团订单数", "饿了么订单数", "百度外卖订单数", "外卖订单额", "美团订单额", "饿了么订单额", "百度订单额"};
        for (int i = 0; i < headers.length; i++) {
            HSSFCell cell = (HSSFCell) header_row.createCell(i);
            cell.setCellValue(headers[i]);
        }

        Store store = storeService.getObjectById(storeId);
        Trademark trademark = trademarkService.getObjectById(store.getTrademarkId());
        Row rose = sheet.createRow(1);
        for (int j = 0; j < headers.length; j++) {

            //序号
            HSSFCell cell0 = (HSSFCell) rose.createCell(0);
            cell0.setCellValue(1);

            //门店名称
            HSSFCell cell1 = (HSSFCell) rose.createCell(1);
            cell1.setCellValue(store.getName());

            //外卖订单数
            HSSFCell cell2 = (HSSFCell) rose.createCell(2);
            cell2.setCellValue(orderStatisticsAllMap.get(storeId).getOrderCount());

            //美团订单数
            HSSFCell cell3 = (HSSFCell) rose.createCell(3);
            cell3.setCellValue(meituanOrderNum);

            //饿了么订单数
            HSSFCell cell4 = (HSSFCell) rose.createCell(4);
            cell4.setCellValue(eleOrderNum);

            //百度订单数
            HSSFCell cell5 = (HSSFCell) rose.createCell(5);
            cell5.setCellValue(baiduOrderNum);

            //总外卖订单金额
            HSSFCell cell6 = (HSSFCell) rose.createCell(6);
            cell6.setCellValue(String.valueOf(orderStatisticsAllList.get(0).getAmount()));

            //美团订单额
            HSSFCell cell7 = (HSSFCell) rose.createCell(7);
            cell7.setCellValue(String.valueOf(meituanAmount));

            //饿了么订单金额
            HSSFCell cell8 = (HSSFCell) rose.createCell(8);
            cell8.setCellValue(String.valueOf(eleAmount));

            //百度订单金额
            HSSFCell cell9 = (HSSFCell) rose.createCell(9);
            cell9.setCellValue(String.valueOf(baiduAmount));

        }

        Long excelDate = System.currentTimeMillis();
        String url = "/data/webs/onway-admin-web/excel/门店外卖订单统计" + excelDate + ".xls";
        FileOutputStream output = new FileOutputStream(url);
        url = "/exceldownload/门店外卖订单统计" + excelDate + ".xls";
        wb.write(output);
        output.flush();
        model.addAttribute("code", 0);
        model.addAttribute("url", url);

        return "/common/url";
    }


    //外卖营收数据导出
    @RequestMapping(value = "/a/u/order/statistics/revenue/excel", method = RequestMethod.GET)
    public String getTrademarkOrderListExcel(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Long storeId, Long trademarkId, Integer orderType) throws Exception {
        log.info("get /a/order/statistics/revenue/excel");
        log.info("get order by:timeStart = " + timeStart + " ,timeEnd = " + timeEnd + " ,storeId = " + storeId + " ,trademarkId = " + trademarkId + " ,orderType = " + orderType);

        if (null == orderType) {
            orderType = 0;
        }
        if (DataUtils.isNullOrEmpty(storeId)) {
            log.error("storeId is null");
            model.addAttribute("code", -2101);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(trademarkId)) {
            log.error("trademarkId is null");
            model.addAttribute("code", -2100);
            return "/common/success";
        }
        List<OrderStatistics> storeOrderStatisticsList = new ArrayList<>();
        List<OrderStatistics> storeOrderStatisticsAllList = new ArrayList<>();
        List<OrderStatistics> trademarkOrderStatisticsList = new ArrayList<>();
        List<OrderStatistics> trademarkOrderStatisticsAllList = new ArrayList<>();

        List<Long> ids = new ArrayList<>();
        List<OrderStatistics> trademarkPlatformOrderStatistics = new ArrayList<>();
        List<OrderStatistics> trademarkOrderStatistics = new ArrayList<>();

        Integer baiduOrderNum = 0;
        Integer eleOrderNum = 0;
        Integer meituanOrderNum = 0;
        Integer trademarkBaiduOrderNum = 0;
        Integer trademarkEleOrderNum = 0;
        Integer trademarkMeituanOrderNum = 0;

        BigDecimal baiduAmount = BigDecimal.ZERO;
        BigDecimal eleAmount = BigDecimal.ZERO;
        BigDecimal meituanAmount = BigDecimal.ZERO;
        BigDecimal trademarkBaiduAmount = BigDecimal.ZERO;
        BigDecimal trademarkEleAmount = BigDecimal.ZERO;
        BigDecimal trademarkMeituanAmount = BigDecimal.ZERO;

        //外卖营收数据统计
        //统计门店订单数据
        log.info("store orderStatisticsList start");
        //所有订单
        if (orderType == 0) {
            storeOrderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreId(timeStart, timeEnd, storeId);
            storeOrderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreId(timeStart, timeEnd, storeId);

            //有效订单
        } else if (orderType == 1) {
            storeOrderStatisticsList = templateTestService.getOrderStatisticsByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
            storeOrderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(timeStart, timeEnd, storeId);
        }

        log.info("store storeOrderStatisticsList is" + storeOrderStatisticsList);
        log.info("store storeOrderStatisticsAllList is" + storeOrderStatisticsAllList);

        //统计品牌订单数据
        log.info("trademark trademarkOrderStatisticsList  start");

        //品牌下所有门店
        ids = storeService.getStoreIdsByTrademarkId(trademarkId, 0, Integer.MAX_VALUE);

        //所有订单
        if (orderType == 0) {
            trademarkOrderStatisticsList = templateTestService.getOrderStatisticsByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);
            trademarkOrderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);

            //有效订单
        } else if (orderType == 1) {
            trademarkOrderStatisticsList = templateTestService.getOrderStatisticsByTimeAndTrademarkIdAndOrderStatus(timeStart, timeEnd, trademarkId);
            trademarkOrderStatisticsAllList = templateTestService.getOrderStatisticsAllByTimeAndTrademarkIdAndOrderStatus(timeStart, timeEnd, trademarkId);
        }
        log.info("trademark trademarkOrderStatisticsList is" + trademarkOrderStatisticsList);
        log.info("trademark trademarkOrderStatisticsAllList is" + trademarkOrderStatisticsAllList);


        //设置map便于jsp中分类-按不同门店归类
        //统计门店订单总体数据
        Map<Long, OrderStatistics> storeOrderStatisticsAllMap = new HashMap<>();
        for (OrderStatistics orderStatistics : storeOrderStatisticsAllList) {
            storeOrderStatisticsAllMap.put(orderStatistics.getId(), orderStatistics);
        }

        //统计品牌订单总体数据
        Map<Long, OrderStatistics> trademarkOrderStatisticsAllMap = new HashMap<>();
        for (OrderStatistics orderStatistics : trademarkOrderStatisticsAllList) {
            trademarkOrderStatisticsAllMap.put(orderStatistics.getId(), orderStatistics);
        }

        //统计门店不同平台数据
        Map<Long, List<OrderStatistics>> storeOrderStatisticsMap = new HashMap<>();
        for (OrderStatistics orderStatistics : storeOrderStatisticsList) {

            Long id = orderStatistics.getId();
            String platform = orderStatistics.getPlatform();
            log.info("platform is " + platform);
            switch (platform) {
                case TrademarkParamsRelation.PLATFORM_BAIDU:
                    orderStatistics.setPlatformName("baidu");
                    baiduOrderNum = orderStatistics.getOrderCount();
                    baiduAmount = orderStatistics.getAmount();
                    log.info("baiduAmount is" + baiduAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_ELE:
                    orderStatistics.setPlatformName("ele");
                    eleOrderNum = orderStatistics.getOrderCount();
                    eleAmount = orderStatistics.getAmount();
                    log.info("eleAmount is " + eleAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_MEITUAN:
                    orderStatistics.setPlatformName("meituan");
                    meituanOrderNum = orderStatistics.getOrderCount();
                    meituanAmount = orderStatistics.getAmount();
                    log.info("meituanAmount is " + meituanAmount);
                    break;
                    default:
                        break;
            }
            //第一次循环时没有arr值,这里的id指的是storeId
            List<OrderStatistics> arr = storeOrderStatisticsMap.get(id);
            if (DataUtils.isNullOrEmpty(arr) || CollectionUtils.isEmpty(arr)) {
                List<OrderStatistics> newArr = new ArrayList<>();
                newArr.add(orderStatistics);
                storeOrderStatisticsMap.put(id, newArr);
            } else {
                storeOrderStatisticsMap.get(id).add(orderStatistics);
            }
        }

        //统计品牌不同平台数据
        Map<Long, List<OrderStatistics>> trademarkOrderStatisticsMap = new HashMap<>();
        for (OrderStatistics orderStatistics : trademarkOrderStatisticsList) {

            Long id = orderStatistics.getId();
            String platform = orderStatistics.getPlatform();
            log.info("platform is " + platform);
            switch (platform) {
                case TrademarkParamsRelation.PLATFORM_BAIDU:
                    orderStatistics.setPlatformName("baidu");
                    trademarkBaiduOrderNum = orderStatistics.getOrderCount();
                    trademarkBaiduAmount = orderStatistics.getAmount();
                    log.info("baiduAmount is" + baiduAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_ELE:
                    orderStatistics.setPlatformName("ele");
                    trademarkEleOrderNum = orderStatistics.getOrderCount();
                    trademarkEleAmount = orderStatistics.getAmount();
                    log.info("eleAmount is " + eleAmount);
                    break;
                case TrademarkParamsRelation.PLATFORM_MEITUAN:
                    orderStatistics.setPlatformName("meituan");
                    trademarkMeituanOrderNum = orderStatistics.getOrderCount();
                    trademarkMeituanAmount = orderStatistics.getAmount();
                    log.info("meituanAmount is " + meituanAmount);
                    break;
                    default:
                        break;
            }
            //第一次循环时没有arr值,这里的id指的是storeId
            List<OrderStatistics> arr = trademarkOrderStatisticsMap.get(id);
            if (DataUtils.isNullOrEmpty(arr) || CollectionUtils.isEmpty(arr)) {
                List<OrderStatistics> newArr = new ArrayList<>();
                newArr.add(orderStatistics);
                trademarkOrderStatisticsMap.put(id, newArr);
            } else {
                trademarkOrderStatisticsMap.get(id).add(orderStatistics);
            }
        }


        //门店数据填充,填充为0
        if (DataUtils.isNullOrEmpty(storeOrderStatisticsMap.get(storeId))) {
            List<OrderStatistics> arr = new ArrayList<>();
            arr.add(setZoreOrderStatistics("baidu"));
            arr.add(setZoreOrderStatistics("ele"));
            arr.add(setZoreOrderStatistics("meituan"));
            storeOrderStatisticsMap.put(storeId, arr);
        } else {
            List<String> platformList = new ArrayList<>();
            for (OrderStatistics orderStatistics : storeOrderStatisticsMap.get(storeId)) {
                platformList.add(orderStatistics.getPlatform());
            }
            if (!platformList.contains(TrademarkParamsRelation.PLATFORM_BAIDU)) {
                storeOrderStatisticsMap.get(storeId).add(setZoreOrderStatistics("baidu"));
            }
            if (!platformList.contains(TrademarkParamsRelation.PLATFORM_ELE)) {
                storeOrderStatisticsMap.get(storeId).add(setZoreOrderStatistics("ele"));
            }
            if (!platformList.contains(TrademarkParamsRelation.PLATFORM_MEITUAN)) {
                storeOrderStatisticsMap.get(storeId).add(setZoreOrderStatistics("meituan"));
            }
        }
        if (DataUtils.isNullOrEmpty(storeOrderStatisticsAllMap.get(storeId))) {
            storeOrderStatisticsAllMap.put(storeId, setZoreAllOrderStatistics());
        }

        //品牌数据填充-填充0
        for (Long id : ids) {
            if (DataUtils.isNullOrEmpty(storeOrderStatisticsMap.get(id))) {
                List<OrderStatistics> arr = new ArrayList<>();
                arr.add(setZoreOrderStatistics("baidu"));
                arr.add(setZoreOrderStatistics("ele"));
                arr.add(setZoreOrderStatistics("meituan"));
                storeOrderStatisticsMap.put(id, arr);
            } else {
                List<String> platformList = new ArrayList<>();
                for (OrderStatistics orderStatistics : storeOrderStatisticsMap.get(id)) {
                    platformList.add(orderStatistics.getPlatform());
                }
                if (!platformList.contains(TrademarkParamsRelation.PLATFORM_BAIDU)) {
                    storeOrderStatisticsMap.get(id).add(setZoreOrderStatistics("baidu"));
                }
                if (!platformList.contains(TrademarkParamsRelation.PLATFORM_ELE)) {
                    storeOrderStatisticsMap.get(id).add(setZoreOrderStatistics("ele"));
                }
                if (!platformList.contains(TrademarkParamsRelation.PLATFORM_MEITUAN)) {
                    storeOrderStatisticsMap.get(id).add(setZoreOrderStatistics("meituan"));
                }
            }
            if (DataUtils.isNullOrEmpty(storeOrderStatisticsAllMap.get(id))) {
                storeOrderStatisticsAllMap.put(id, setZoreAllOrderStatistics());
            }
        }


        //获取店铺、品牌名
        List<Store> storeList = storeService.getObjectsByIds(ids);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map<Long, String> storeNameMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), storeList);

            Trademark trademark = trademarkService.getObjectById(trademarkId);

            //品牌各平台订单数据(应该有多条,各自属于三个平台)
            trademarkPlatformOrderStatistics = templateTestService.getTrademarkOrderStatisticsByPlatform(timeStart, timeEnd, trademarkId, orderType);

            //外卖营收统计(增加了商品优惠,标准用尽的选项,应该只有一条)
            trademarkOrderStatistics = templateTestService.getTrademarkOrderStatisticsByTimeAndOrderStatus(timeStart, timeEnd, trademarkId, orderType);
            log.info("trademarkOrderStatistics is " + trademarkOrderStatistics);
            List<String> arr = new ArrayList<>();
            for (OrderStatistics orderStatistics : trademarkPlatformOrderStatistics) {
                arr.add(orderStatistics.getPlatform());
                switch (orderStatistics.getPlatform()) {
                    case TrademarkParamsRelation.PLATFORM_BAIDU:
                        orderStatistics.setPlatformName("baidu");
                        trademarkBaiduOrderNum = orderStatistics.getOrderCount();
                        trademarkBaiduAmount = orderStatistics.getAmount();
                        break;
                    case TrademarkParamsRelation.PLATFORM_ELE:
                        orderStatistics.setPlatformName("ele");
                        trademarkEleOrderNum = orderStatistics.getOrderCount();
                        trademarkEleAmount = orderStatistics.getAmount();
                        break;
                    case TrademarkParamsRelation.PLATFORM_MEITUAN:
                        orderStatistics.setPlatformName("meituan");
                        trademarkMeituanOrderNum = orderStatistics.getOrderCount();
                        trademarkMeituanAmount = orderStatistics.getAmount();
                        break;
                        default:
                            break;
                }
            }
            if (!arr.contains(TrademarkParamsRelation.PLATFORM_MEITUAN)) {
                trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("meituan"));
            }
            if (!arr.contains(TrademarkParamsRelation.PLATFORM_BAIDU)) {
                trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("baidu"));
            }
            if (!arr.contains(TrademarkParamsRelation.PLATFORM_ELE)) {
                trademarkPlatformOrderStatistics.add(setZoreOrderStatistics("ele"));
            }
            log.info("trademarkPlatformOrderStatistics is " + trademarkPlatformOrderStatistics);
            log.info("trademark is " + trademark);
            log.info("ids is " + ids);

        }


        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet");
        //创建门店订单表头
        Row header_row = sheet.createRow(4);
        String headers[] = new String[]{"序号", "门店名称", "外卖订单数", "美团订单数", "饿了么订单数", "百度外卖订单数", "外卖订单额", "美团订单额", "饿了么订单额", "百度订单额", "商品应收", "商品优惠", "商品实收", "标准佣金", "补贴金额", "平台服务费", "平台补贴"};
        for (int i = 0; i < headers.length; i++) {
            HSSFCell cell = (HSSFCell) header_row.createCell(i);
            cell.setCellValue(headers[i]);
        }

        //创建品牌订单表头
        Row header_trademark_row = sheet.createRow(0);
        String headers_trademark[] = new String[]{"序号", "品牌名称", "外卖订单数", "美团订单数", "饿了么订单数", "百度外卖订单数", "外卖订单额", "美团订单额", "饿了么订单额", "百度订单额", "商品应收", "商品优惠", "商品实收", "标准佣金", "补贴金额", "平台服务费", "平台补贴"};

        for (int k = 0; k < headers_trademark.length; k++) {
            HSSFCell cellTK = (HSSFCell) header_trademark_row.createCell(k);
            cellTK.setCellValue(headers_trademark[k]);
        }

        //门店数据导出
        Store store = storeService.getObjectById(storeId);
        Row rose = sheet.createRow(5);
        for (int j = 0; j < headers.length; j++) {

            //序号
            HSSFCell cell0 = (HSSFCell) rose.createCell(0);
            cell0.setCellValue(1);

            //门店名称
            HSSFCell cell1 = (HSSFCell) rose.createCell(1);
            cell1.setCellValue(store.getName());

            //外卖订单数
            HSSFCell cell2 = (HSSFCell) rose.createCell(2);
            cell2.setCellValue(storeOrderStatisticsAllMap.get(storeId).getOrderCount());

            //美团订单数
            HSSFCell cell3 = (HSSFCell) rose.createCell(3);
            cell3.setCellValue(meituanOrderNum);

            //饿了么订单数
            HSSFCell cell4 = (HSSFCell) rose.createCell(4);
            cell4.setCellValue(eleOrderNum);

            //百度订单数
            HSSFCell cell5 = (HSSFCell) rose.createCell(5);
            cell5.setCellValue(baiduOrderNum);

            //总外卖订单金额
            HSSFCell cell6 = (HSSFCell) rose.createCell(6);
            cell6.setCellValue(String.valueOf(storeOrderStatisticsAllList.get(0).getAmount()));

            //美团订单额
            HSSFCell cell7 = (HSSFCell) rose.createCell(7);
            cell7.setCellValue(String.valueOf(meituanAmount));

            //饿了么订单金额
            HSSFCell cell8 = (HSSFCell) rose.createCell(8);
            cell8.setCellValue(String.valueOf(eleAmount));

            //百度订单金额
            HSSFCell cell9 = (HSSFCell) rose.createCell(9);
            cell9.setCellValue(String.valueOf(baiduAmount));

            //商品应收
            HSSFCell cell10 = (HSSFCell) rose.createCell(10);
            cell10.setCellValue(String.valueOf(baiduAmount));

            //商品优惠
            HSSFCell cell11 = (HSSFCell) rose.createCell(11);
            cell11.setCellValue(String.valueOf(baiduAmount));

            //商品实收
            HSSFCell cell12 = (HSSFCell) rose.createCell(12);
            cell12.setCellValue(String.valueOf(baiduAmount));

            //标准佣金
            HSSFCell cell13 = (HSSFCell) rose.createCell(13);
            cell13.setCellValue(String.valueOf(baiduAmount));

            //补贴金额
            HSSFCell cell14 = (HSSFCell) rose.createCell(14);
            cell14.setCellValue(String.valueOf(baiduAmount));

            //平台服务费
            HSSFCell cell15 = (HSSFCell) rose.createCell(15);
            cell15.setCellValue(String.valueOf(baiduAmount));

            //平台补贴
            HSSFCell cell16 = (HSSFCell) rose.createCell(16);
            cell16.setCellValue(String.valueOf(baiduAmount));

        }


        //品牌数据导出
        Trademark trademark = trademarkService.getObjectById(trademarkId);
        Row trademarkRow = sheet.createRow(1);
        for (int l = 0; l < headers_trademark.length; l++) {

            //序号
            HSSFCell cell0 = (HSSFCell) trademarkRow.createCell(0);
            cell0.setCellValue(1);

            //品牌名称
            HSSFCell cell1 = (HSSFCell) trademarkRow.createCell(1);
            cell1.setCellValue(trademark.getName());

            //外卖订单数
            HSSFCell cell2 = (HSSFCell) trademarkRow.createCell(2);
            cell2.setCellValue(trademarkOrderStatistics.get(0).getOrderCount());

            //美团订单数
            HSSFCell cell3 = (HSSFCell) trademarkRow.createCell(3);
            cell3.setCellValue(trademarkMeituanOrderNum);

            //饿了么订单数
            HSSFCell cell4 = (HSSFCell) trademarkRow.createCell(4);
            cell4.setCellValue(trademarkEleOrderNum);

            //百度订单数
            HSSFCell cell5 = (HSSFCell) trademarkRow.createCell(5);
            cell5.setCellValue(trademarkBaiduOrderNum);

            //总外卖订单金额
            HSSFCell cell6 = (HSSFCell) trademarkRow.createCell(6);
            cell6.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getAmount()));

            //美团订单额
            HSSFCell cell7 = (HSSFCell) trademarkRow.createCell(7);
            cell7.setCellValue(String.valueOf(trademarkMeituanAmount));

            //饿了么订单金额
            HSSFCell cell8 = (HSSFCell) trademarkRow.createCell(8);
            cell8.setCellValue(String.valueOf(trademarkEleAmount));

            //百度订单金额
            HSSFCell cell9 = (HSSFCell) trademarkRow.createCell(9);
            cell9.setCellValue(String.valueOf(trademarkBaiduAmount));

            //商品应收
            HSSFCell cell10 = (HSSFCell) trademarkRow.createCell(10);
            cell10.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getAmount()));

            //商品优惠
            HSSFCell cell11 = (HSSFCell) trademarkRow.createCell(11);
            cell11.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getPromotionFee()));

            //商品实收
            HSSFCell cell12 = (HSSFCell) trademarkRow.createCell(12);
            cell12.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getPayFee()));

            //标准佣金
            HSSFCell cell13 = (HSSFCell) trademarkRow.createCell(13);
            cell13.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getBrokerage()));

            //补贴金额
            HSSFCell cell14 = (HSSFCell) trademarkRow.createCell(14);
            cell14.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getPlatformSubsidy()));

            //平台服务费
            HSSFCell cell15 = (HSSFCell) trademarkRow.createCell(15);
            cell15.setCellValue(String.valueOf(0));

            //平台补贴
            HSSFCell cell16 = (HSSFCell) trademarkRow.createCell(16);
            cell16.setCellValue(String.valueOf(trademarkOrderStatistics.get(0).getPlatformSubsidy()));

        }


        Long excelDate = System.currentTimeMillis();
        String url = "/data/webs/onway-admin-web/excel/外卖营收统计" + excelDate + ".xls";
        FileOutputStream output = new FileOutputStream(url);
        url = "/exceldownload/外卖营收统计" + excelDate + ".xls";
        wb.write(output);
        output.flush();
        model.addAttribute("code", 0);
        model.addAttribute("url", url);


        return "/common/url";
    }

    private OrderStatistics setZoreOrderStatistics(String name) {

        OrderStatistics orderStatistics = new OrderStatistics();
        switch (name) {
            case "baidu":
                orderStatistics.setPlatform(TrademarkParamsRelation.PLATFORM_BAIDU);
                break;
            case "ele":
                orderStatistics.setPlatform(TrademarkParamsRelation.PLATFORM_ELE);
                break;
            case "meituan":
                orderStatistics.setPlatform(TrademarkParamsRelation.PLATFORM_MEITUAN);
                break;
                default:
                    break;
        }
        orderStatistics.setPlatformName(name);
        orderStatistics.setAmount(BigDecimal.ZERO);
        orderStatistics.setOrderCount(0);
        return orderStatistics;
    }

    private OrderStatistics setZoreAllOrderStatistics() {

        OrderStatistics orderStatistics = new OrderStatistics();
        orderStatistics.setOrderCount(0);
        orderStatistics.setAmount(BigDecimal.ZERO);
        orderStatistics.setBrokerage(BigDecimal.ZERO);
        orderStatistics.setPayFee(BigDecimal.ZERO);
        orderStatistics.setPlatformSubsidy(BigDecimal.ZERO);
        orderStatistics.setPromotionFee(BigDecimal.ZERO);
        return orderStatistics;
    }

    /**
     * 订单详情
     *
     * @param id 订单id
     */
    @RequestMapping(value = "/a/u/order/{id}", method = RequestMethod.GET)
    public String getUserOrderJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get /a/order/{id}");
        log.info("get data : id= " + id);
        Role role = (Role) request.getAttribute("role");

        try {
            UserOrder userOrder = userOrderService.getObjectById(id);
            if (null == userOrder) {
                model.addAttribute("code", -2116);
                return "/common/success";
            }
            log.info("get userOrder data is " + userOrder);

            //设置店铺名
            Store store = storeService.getObjectById(userOrder.getStoreId());
            if (store == null) {
                log.info("this store is not found !!");
                model.addAttribute("code", -2301);
                return "/common/success";
            }
            userOrder.setStoreName(store.getName());
            //设置品牌名
            Trademark trademark = trademarkService.getObjectById(userOrder.getTrademarkId());
            if (trademark == null) {
                log.info("this trademark is not found !!");
                model.addAttribute("code", -2119);
                return "/common/success";
            }

            userOrder.setTrademarkName(trademark.getName());

            //取订单菜品
            List<Long> foodIds = foodOrderRelationService.getFoodOrderRelationIdsByOrderId(id, 0, Integer.MAX_VALUE);
            List<FoodOrderRelation> foodOrderRelationList = foodOrderRelationService.getObjectsByIds(foodIds);
            log.info("foodOrderRelationList size is " + foodOrderRelationList.size());


            model.addAttribute("code", 0);
            model.addAttribute("userOrder", userOrder);
            model.addAttribute("foodList", foodOrderRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userOrder error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/userOrder/json/userOrderDetailJson";
    }

    /**
     * 接收订单
     *
     * @param id 订单id
     */
    @RequestMapping(value = "/a/u/order/accept/{id}", method = RequestMethod.PUT)
    public String updateUserOrderStatusJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("update order : accept===> id is " + id);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();

        try {
            UserOrder userOrder = userOrderService.getObjectById(id);
            if (null == userOrder) {
                model.addAttribute("code", -2116);
                return "/common/success";
            }

            if (!userOrder.getStoreId().equals(storeId)) {
                model.addAttribute("code", -10);
                return "/common/success";
            }
            Store store = storeService.getObjectById(userOrder.getStoreId());
            String resultJson = "";
            switch (userOrder.getPlatform()) {
                case WaimaiConstents.platform_meitian:
                    if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                        //美团确认订单
                        log.info("meituan ERP confirm order");
                        resultJson=WaimaiEPRUtil.takeoutOrderConfirmRequest(store.getMtAppAuthToken(), userOrder.getPlatformOrderId());
                        if (requestResult(resultJson)){
                            startZbShipping(userOrder.getId().toString(),storeId);
                        }else {
                            JSONObject jsonObject = new JSONObject(resultJson);
                            model.addAttribute("code", -1000);
                            model.addAttribute("message", jsonObject.getJSONObject("error").get("message"));
                            return "/common/result";
                        }
                    }else {
                        //TODO
                        log.info("meituan WTO confirm order");
                        //品牌接入方式
                    }
                    break;
                case WaimaiConstents.platform_baidu:
                    //TODO
                    break;
                case WaimaiConstents.platform_ele:
                    //TODO
                    break;
                default:
                    break;
            }

            //判断订单接单状态-只有是未接单状态才能接单
            log.info("order accept status is " + userOrder.getAcceptStatus());
            if (userOrder.getAcceptStatus().equals(UserOrder.ACCEPT_STATUS_WAIT)) {
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
            } else {
                model.addAttribute("code", -2120);
                return "/common/success";
            }
            if (requestResult(resultJson)) {
                userOrderService.update(userOrder);
            } else {
                if (!requestResult(resultJson)) {
                    JSONObject jsonObject = new JSONObject(resultJson);
                    model.addAttribute("code", -1000);
                    model.addAttribute("message", jsonObject.getJSONObject("error").get("message"));
                }
                return "/common/result";
            }
            model.addAttribute("code", 0);

        } catch (IOException e) {
            // 处理io异常
            e.printStackTrace();
            log.error(e.getMessage());
            log.error("io error");
            model.addAttribute("code", "-2123");
        } catch (URISyntaxException e) {
            // 处理URI语法异常
            e.printStackTrace();
            log.error(e.getMessage());
            log.error("URI error");
            model.addAttribute("code", "-2124");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userOrder error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    private boolean requestResult(String resultJson) {
        boolean result = false;
        String str = "";
        JSONObject jsonObject = new JSONObject(resultJson);
        try {
            str = jsonObject.getString("data");
            result = true;
            log.info("request success ,data is " + str);

        } catch (Throwable t) {
            str = jsonObject.getJSONObject("error").toString();
            log.info("request error ,data is " + str);
        }
        return result;
    }

    /**
     * 打印订单
     *
     * @param id 订单id
     */
    @RequestMapping(value = "/a/u/order/print/{id}", method = RequestMethod.PUT)
    public String updateUserOrderPrintJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("update order : accept===> id is " + id);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        try {
            UserOrder userOrder = userOrderService.getObjectById(id);
            if (null == userOrder) {
                model.addAttribute("code", -2116);
                return "/common/success";
            }else if (!userOrder.getStoreId().equals(storeId)) {
                model.addAttribute("code", -10);
                return "/common/success";
            }
            //判断订单接单状态-只有是已接单状态才能打印订单
            log.info("order accept status is " + userOrder.getAcceptStatus());
            if (userOrder.getAcceptStatus().equals(UserOrder.ACCEPT_STATUS_FINISH)) {
                userOrder.setPrintStatus(UserOrder.PRINT_STATUS_TRUE);
            } else {
                model.addAttribute("code", -2120);
                return "/common/success";
            }
            userOrderService.update(userOrder);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userOrder error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 取消订单
     *
     * @param id           订单id
     * @param cancelReason 取消原因
     */
    @RequestMapping(value = "/a/u/order/cancel/{id}", method = RequestMethod.PUT)
    public String updateUserOrderJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, @PathVariable Long id, String cancelReason) throws Exception {
        log.info("update order : cancel===> id is " + id);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        if (DataUtils.isNullOrEmpty(cancelReason)) {
            cancelReason = "其他原因";

        }
        log.info("cancelReason is " + cancelReason);

        try {
            UserOrder userOrder = userOrderService.getObjectById(id);
            if (null == userOrder) {
                model.addAttribute("code", -2116);
                return "/common/success";
            }else if (!userOrder.getStoreId().equals(storeId)) {
                model.addAttribute("code", -10);
                return "/common/success";
            }

            //判断订单接单状态-只有是已经接单未完成状态才能取消
            log.info("order accept status is " + userOrder.getAcceptStatus());
            log.info("order order status is " + userOrder.getOrderStatus());
            if (!userOrder.getOrderStatus().equals(UserOrder.ORDER_STATUS_FINISH)) {
                userOrder.setOrderStatus(UserOrder.ORDER_STATUS_CANCEL);
                userOrder.setCancelReason(cancelReason);
            } else {
                log.info("order status is " + userOrder.getOrderStatus());
                model.addAttribute("code", -2122);
                return "/common/success";
            }

            Store store = storeService.getObjectById(userOrder.getStoreId());

            String resultJson = "";
            switch (userOrder.getPlatform()) {
                case WaimaiConstents.platform_meitian:
                    if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                        //美团2007表示其他原因
                        log.info("meituan ERP cancel order");
                        resultJson=WaimaiEPRUtil.takeoutOrderCancelRequest(store.getMtAppAuthToken(), userOrder.getPlatformOrderId(), cancelReason, "2007");
                    }else {
                        //TODO
                        log.info("meituan WTO cancel order");
                        //品牌接入方式
                    }
                    break;
                case WaimaiConstents.platform_baidu:
                    //TODO
                    break;
                case WaimaiConstents.platform_ele:
                    //TODO
                    break;
                default:
                    break;
            }

            if (requestResult(resultJson)) {
                userOrderService.update(userOrder);
            } else {
                JSONObject jsonObject = new JSONObject(resultJson);
                model.addAttribute("code", -1000);
                model.addAttribute("message", jsonObject.getJSONObject("error").get("message"));
                return "/common/result";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userOrder error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * EPR 取消订单推送接收
     *
     * @param developerId EPR开发id
     * @param ePoiId      门店id
     */
    @RequestMapping(value = "/a/order/cancel", method = RequestMethod.POST)
    public String cancelUserOrderJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, String developerId, String ePoiId, String sign, String orderCancel) throws Exception {

        log.info("cancel order message: cancel===> developerId is " + developerId + " ,ePoiId is " + ePoiId + " ,orderCancel is " + orderCancel + " ,sign is " + sign);
        //心跳检测空包处理
        if (null == developerId) {
            log.info("is heartbeat");
            model.addAttribute("message", "OK");
            return "/common/callbackSuccess";
        }


        try {
            JSONObject orderCancelJson = new JSONObject(orderCancel);
            String platformOrderId = orderCancelJson.get("orderId").toString();
            String reason = orderCancelJson.get("reason").toString();
            log.info("platformOrderId is " + platformOrderId + " , reason is " + reason);

            Long userOrderId = userOrderService.getUserOrderIdByPlatformOrderId(platformOrderId);
            UserOrder userOrder = userOrderService.getObjectById(userOrderId);

            userOrder.setCancelReason(reason);
            userOrder.setOrderStatus(UserOrder.ORDER_STATUS_CANCEL);
            userOrderService.update(userOrder);
            log.error(" cancel order success, userOrderId is " + userOrderId);
            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" cancel order error");
            model.addAttribute("code", -1);

        }

        return "/common/callbackSuccess";
    }


    /**
     * 标记订单发票开具状态
     *
     * @param id 订单id
     */
    @RequestMapping(value = "/a/u/order/invoice/{id}", method = RequestMethod.PUT)
    public String updateUserOrderInvoiceStatus(HttpServletRequest request,
                                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get /a/order/{id}");
        log.info("get data : id= " + id);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        try {
            UserOrder userOrder = userOrderService.getObjectById(id);
            log.info("get userOrder data is " + userOrder);
            if (null == userOrder) {
                model.addAttribute("code", -2116);
                return "/common/success";
            }else if (!userOrder.getStoreId().equals(storeId)){
                model.addAttribute("code", -10);
                return "/common/success";
            } else if (DataUtils.isNotNullOrEmpty(userOrder.getInvoiceMark()) && userOrder.getInvoiceMark().equals(UserOrder.INVOICE_MARK_TRUE)) {
                model.addAttribute("code", -2117);
                return "/common/success";
            }
            log.info("The order invoice is not marked");
            //更改订单发票为已标记
            userOrder.setInvoiceMark(UserOrder.INVOICE_MARK_TRUE);
            userOrder.setUpdateBy(Long.valueOf(role.getUserId()));
            userOrderService.update(userOrder);
            log.info("Order invoice flag is successful");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userOrder error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 接收美团推送的订单
     *
     * @param developerId ERP厂商入驻新美大餐饮平台得到的唯一身份表示
     * @param ePoiId      erp方门店id 最大长度100
     * @param sign        数字签名
     * @param order       订单详情数据
     */

    @RequestMapping(value = "/a/waimai/order", method = RequestMethod.POST)
    public String addUserOrderJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model,
                                   Integer developerId, Long ePoiId, String sign, String order
    ) throws Exception {
        log.info("There is a new order push ,developerId=" + developerId + " ,ePoiId=" + ePoiId + " ,sign=" + sign);
        log.info("order is " + order);
        try {
            Store store = storeService.getObjectById(ePoiId);
            if (null == store) {
                log.info(" store does not exist,id is " + ePoiId);
                model.addAttribute("message", "error");
                return "/common/callbackSuccess";
            } else {
                log.info(" store num is " + store.getStoreNum());
            }
            UserOrder userOrder = CoverUtil.orderEPRCover2UserOrder(order, store.getTrademarkId());
            userOrder.setCreateBy(0L);
            userOrder.setUpdateBy(0L);
            log.info("user order is " + userOrder);
            //根据门店是否设置自动接单进行订单处理;否则未接订单超过10单则自动取消
            //自动接单的逻辑
            Long id = null;
            if (store.getAutoOrders().equals(Store.AUTO_ORDER)) {
                log.info("auto accept order start");
                userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_FINISH);
                userOrder.setAcceptAt(System.currentTimeMillis());

                WaimaiEPRUtil.takeoutOrderConfirmRequest(store.getMtAppAuthToken(),userOrder.getPlatformOrderId());


                //发起众包配送
                startZbShipping(userOrder.getPlatformOrderId().toString(),ePoiId);
            } else {
                //非自动接单的逻辑
                log.info("Non-auto accept order start");
                List<Long> ids = userOrderService.getUserOrderIdsByStoreIdAcceptStatus(ePoiId, UserOrder.ACCEPT_STATUS_WAIT, 0, Integer.MAX_VALUE);
                log.info("this store acceptStatus=1 ids size is " + ids.size());
                if (ids.size() >= 10) {
                    userOrder.setOrderStatus(UserOrder.ORDER_STATUS_CANCEL);
                    //取消訂單
                    WaimaiEPRUtil.takeoutOrderCancelRequest(store.getMtAppAuthToken(), userOrder.getPlatformOrderId(), "2008", "店铺太忙");
                }else {
                    userOrder.setAcceptStatus(UserOrder.ACCEPT_STATUS_WAIT);
                    userOrder.setOrderStatus(UserOrder.ORDER_STATUS_UNDONE);
                }
            }
            id = userOrderService.insert(userOrder);
            log.info("insert order success ,id is " + id);
            //将美团订单里的菜品购买信息入库存储
            Gson gson = new Gson();
            List<OrderDetailEPR> orderDetailEPRS = gson.fromJson(userOrder.getDetail(), new TypeToken<List<OrderDetailEPR>>() {}.getType());
            log.info("orderDetailEPRS size is " + orderDetailEPRS.size());
            List<FoodOrderRelation> foodOrderRelationList = CoverUtil.orderDetailErpToFoodOrderRelationList(orderDetailEPRS, ePoiId, store.getTrademarkId(), id);
            foodOrderRelationService.insertList(foodOrderRelationList);
            log.info("insert food order success,size is " + foodOrderRelationList.size());
            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userOrder error ");
            model.addAttribute("code", -1);
        }
        return "/common/callbackSuccess";
    }


    /**
     * EPR 订单完成接收
     *
     * @param developerId EPR开发id
     * @param ePoiId      门店id
     */
    @RequestMapping(value = "/a/order/final", method = RequestMethod.POST)
    public String finalUserOrderJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, String developerId, Long ePoiId, String sign, String order) throws Exception {

        log.info("final order message: final===> developerId is " + developerId + " ,ePoiId is " + ePoiId + " ,order is " + order + " ,sign is " + sign);
        //心跳检测空包处理
        if (null == developerId) {
            log.info("is heartbeat");
            model.addAttribute("message", "OK");
            return "/common/callbackSuccess";
        }


        try {
            UserOrder userOrder = CoverUtil.orderEPRCover2UserOrder(order, ePoiId);
            log.info("user order is " + userOrder);
            //修改数据库里该订单的状态为完成
            Long oid = userOrderService.getUserOrderIdByPlatformOrderId(userOrder.getPlatformOrderId().toString());
            UserOrder oUserOrder = userOrderService.getObjectById(oid);
            if (null == oUserOrder) {
                log.info("order does not exist");
            } else {
                log.info(" final order id is " + oid);
                //设置订单状态为结束，userOrder返回的数据已经处理完成，所以直接用
                oUserOrder.setOrderStatus(userOrder.getOrderStatus());
                //设置订单结束时间
                oUserOrder.setEndAt(userOrder.getEndAt());
                userOrderService.update(oUserOrder);
            }
            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" final order error");
            model.addAttribute("code", -1);

        }
        return "/common/callbackSuccess";
    }


    /**
     * EPR 订单确认的回调
     *
     * @param developerId EPR开发id
     * @param ePoiId      门店id
     */
    @RequestMapping(value = "/a/order/accept", method = RequestMethod.POST)
    public String acceptUserOrderJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, String developerId, Long ePoiId, String sign, String order) throws Exception {

        log.info("accept order message: accept callback ===> developerId is " + developerId + " ,ePoiId is " + ePoiId + " ,order is " + order + " ,sign is " + sign);
        //心跳检测空包处理
        if (null == developerId) {
            log.info("is heartbeat");
            model.addAttribute("message", "OK");
            return "/common/callbackSuccess";
        }

        try {
            UserOrder userOrder = CoverUtil.orderEPRCover2UserOrder(order, ePoiId);
            log.info("user order is " + userOrder);
            Long oid = userOrderService.getUserOrderIdByPlatformOrderId(userOrder.getPlatformOrderId().toString());
            UserOrder oUserOrder = userOrderService.getObjectById(oid);
            if (null == oUserOrder) {
                log.info("order does not exist");
            } else {
                log.info(" accept order id is " + oid);
                if (oUserOrder.getAcceptStatus().equals(UserOrder.ACCEPT_STATUS_WAIT)) {
                    //设置订单状态为接收，userOrder返回的数据已经处理完成，所以直接用
                    oUserOrder.setOrderStatus(userOrder.getAcceptStatus());
                    //设置订单接收时间
                    oUserOrder.setAcceptAt(userOrder.getAcceptAt());
                    oUserOrder.setCreateBy(0L);
                    oUserOrder.setUpdateBy(0L);
                    userOrderService.update(oUserOrder);
                    log.info("update order accept status success");
                } else {
                    log.info(" order has been received ");
                }
                //用户信息入库
                List<Long> ids = userService.getUserIdsByMobile(userOrder.getMobile(), 0, 2);
                //用户如果存在，判断在美团是否存在，不存在则更新。
                //用户不存在则新增。
                if (ids.size() > 0) {
                    log.info("old user's order");
                    User user = userService.getObjectById(ids.get(0));
                    if (!QueryUtil.inPlatform(user.getPlatform(), "meituan")) {
                        log.info("meituan new users");
                        user.setPlatform(QueryUtil.updatePlatformStr(WaimaiConstents.platform_meitian, 1, user.getPlatform()));
                    }
                } else {
                    log.info("new user's order");
                    User user = new User();
                    user.setJoinAt(System.currentTimeMillis());
                    user.setMobile(userOrder.getMobile());
                    user.setName(userOrder.getUserName());
                    user.setPlatform(WaimaiConstents.platform_meitian);
                    user.setAddress(userOrder.getDeliveryAddress());
                    user.setCreateBy(0L);
                    user.setUpdateBy(0L);
                    Long id = userService.insert(user);
                    log.info("user insert success, id is " + id);
                }
            }

            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" accept order error");
            model.addAttribute("code", -1);

        }
        return "/common/callbackSuccess";
    }


    /**
     * EPR 发起众包配送
     *
     * @param orderIds 订单号
     * @param storeId 门店id
     */
    private void startZbShipping( String orderIds, Long storeId) throws Exception {
        log.info("shipping:  ===> orderIds is " + orderIds);
        try {
            //获取订单信息
            List<Long> oids = userOrderService.getUserOrderIdByPlatformOrderIds(orderIds, 0, Integer.MAX_VALUE);
            List<UserOrder> userOrders = userOrderService.getObjectsByIds(oids);
            Store store = storeService.getObjectById(storeId);
            //查询订单配送费
            log.info("=====查询众包配送费用====");
            String result = WaimaiEPRUtil.takeoutOrderZbShippingFeeQueryRequest(store.getMtAppAuthToken(), orderIds);
            log.info("result is " + result);
            if (WaimaiEPRUtil.checkResultForArray(result)) {
                List<ZbShippingFee> zbShippingFees = CoverUtil.Cover2ZbShippingFee(WaimaiEPRUtil.getJsonResultByKey(result, "data", "array"));
                for (ZbShippingFee zbShippingFee : zbShippingFees) {
                    Double zbShipping = zbShippingFee.getShippingFee();
                    log.info("zbShipping is " + zbShipping);
                    /**
                     * 预下单时的配送费和查询的配送费用不一致的时候，需要加配送费,不加小费输入0.0
                     *一致的时候调用预下单接口
                     * */
                    log.info("=====众包预下单接口====");
                    result = WaimaiEPRUtil.takeoutOrderZbDispatchPrepareRequest(store.getMtAppAuthToken(), zbShippingFee.getOrderId(), zbShipping, 0.0);
                    log.info("result is " + result);
                    //预下单成功后，平台会根据费用是否变化返回信息，若费用无变化，将等待起手接单
                    //成功会返会data：ok或者OK
                    if (WaimaiEPRUtil.getJsonResultByKey(result, "data", "string").equals("ok") || WaimaiEPRUtil.getJsonResultByKey(result, "data", "string").equals("OK")) {
                        log.info("=====等待骑手接单，如果骑手一直未接单，可调用增加小费接口=====");
                        //下面是返回失败的情况，根据code码和msg判断异常情况，1是
                    } else if (WaimaiEPRUtil.getJsonResultByKey(result, "data", "string").equals("ng")) {
                        ZbPrepareDispatch zbPrepareDispatch = CoverUtil.JSONStringCover2Model(WaimaiEPRUtil.getJsonResultByKey(result, "data", "string"), ZbPrepareDispatch.class);
                        log.info("error msg is " + zbPrepareDispatch.getMsg());
                        log.info("The new_shipping_fee is " + zbPrepareDispatch.getNew_shipping_fee());
                        //费用发生变化，再查一次费用，确定后调用确定下单接口
                        if (zbPrepareDispatch.getCode().equals(ZbPrepareDispatch.Price_Changes)) {
                            //用返回最新的配送费调用确认下单接口
                            log.info("=====众包确认下单====");
                            result = WaimaiEPRUtil.takeoutOrderZbDispatchConfirmRequest(store.getMtAppAuthToken(), zbShippingFee.getOrderId(), 0.0);
                            log.info("result is " + result);
                        }
                    }
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" accept order error");
        }
    }


    /**
     * EPR 配送状态改变回调
     *
     * @param developerId EPR开发id
     * @param ePoiId      门店id
     */
    @RequestMapping(value = "/a/delivery/status", method = RequestMethod.POST)
    public String deliveryStatusCallback(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, String developerId, Long ePoiId, String sign, String shippingStatus) throws Exception {

        log.info("delivery status message: delivery callback ===> developerId is " + developerId + " ,ePoiId is " + ePoiId + " ,shippingStatus is " + shippingStatus + " ,sign is " + sign);
        //心跳检测空包处理
        if (null == developerId) {
            log.info("is heartbeat");
            model.addAttribute("message", "OK");
            return "/common/callbackSuccess";
        }
        try {
            ShippingStatus shippingStatusModel = CoverUtil.JSONStringCover2Model(shippingStatus, ShippingStatus.class);

            String platformOrderId = shippingStatusModel.getOrderId().toString();
            Integer status = shippingStatusModel.getShippingStatus();
            String dispatcherName = shippingStatusModel.getDispatcherName();
            String dispatcherMobile = shippingStatusModel.getDispatcherMobile();

            Long id = userOrderService.getUserOrderIdByPlatformOrderId(platformOrderId);
            UserOrder userOrder = userOrderService.getObjectById(id);

            String result = "";
            //必须是最新状态才接收-100为取消配送
            //没有骑手接单，取消配送的时候，加小费再发起配送.每次加1元
            log.info("status is  " + status);
            if (status.equals(100)) {
                log.info("====无骑手接单，增加1元小费====");
                Store store = storeService.getObjectById(ePoiId);
                result = WaimaiEPRUtil.takeoutOrderZbDispatchTipUpdateRequest(store.getMtAppAuthToken(),shippingStatusModel.getOrderId(),userOrder.getDeliveryFee().doubleValue(),1.00);
                log.info("result is " + result);
            } else if (status > userOrder.getShippingStatus()) {
                userOrder.setShippingStatus(status);
                userOrder.setCourierMobile(dispatcherMobile);
                userOrder.setCourierName(dispatcherName);
                userOrderService.update(userOrder);
            }
            log.info("user order is " + userOrder);

            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" accept order error");
            model.addAttribute("code", -1);

        }
        return "/common/callbackSuccess";
    }

    /**
     * EPR 退款流程回调
     *
     * @param developerId EPR开发id
     * @param ePoiId      门店id
     */
    @RequestMapping(value = "/a/refund/message", method = RequestMethod.POST)
    public String refundMessageCallback(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, String developerId, Long ePoiId, String sign, String orderRefund) throws Exception {

        log.info("refund  message: delivery callback ===> developerId is " + developerId + " ,ePoiId is " + ePoiId + " ,orderRefund is " + orderRefund + " ,sign is " + sign);
        //心跳检测空包处理
        if (null == developerId) {
            log.info("is heartbeat");
            model.addAttribute("message", "OK");
            return "/common/callbackSuccess";
        }
        try {
            Gson gson = new Gson();
            OrderRefundErp orderRefundErp = gson.fromJson(orderRefund, OrderRefundErp.class);
            Long oId = userOrderService.getUserOrderIdByPlatformOrderId(orderRefundErp.getOrderId().toString());
            UserOrder userOrder = userOrderService.getObjectById(oId);
            log.info("refund order id is "+oId);
            switch (orderRefundErp.getNotifyType()) {
                case OrderRefundErp.REFUND_APPLY:
                    log.info("apply a refund");
//                    userOrder.setOrderStatus(UserOrder.);
                    break;
                case OrderRefundErp.REFUND_AGREE:
                    log.info("agree a refund");
                    break;
                case OrderRefundErp.REFUND_REJECT:
                    log.info("reject a refund");
                    break;

                case OrderRefundErp.REFUND_CANCEL_REFUND:
                    log.info("user cancel a refund");
                    break;

                case OrderRefundErp.REFUND_CANCEL_COMPLAINT:
                    log.info("user cancel a complaint");

                default:
                    break;

            }
            model.addAttribute("message", "OK");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" accept order error");
            model.addAttribute("code", -1);

        }
        return "/common/callbackSuccess";
    }

}

 