package com.ptteng.onway.admin.controller;

import com.ptteng.onway.admin.unit.DynamicUtil;
import com.ptteng.onway.platform.model.Role;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.model.User;
import com.ptteng.onway.platform.model.UserStatistics;
import com.ptteng.onway.platform.service.StoreService;
import com.ptteng.onway.platform.service.TemplateTestService;
import com.ptteng.onway.platform.service.TrademarkService;
import com.ptteng.onway.platform.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * User  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);

	@Autowired
	private UserService userService;
	@Autowired
	private TemplateTestService templateTestService;
	@Autowired
	private StoreService storeService;
	@Autowired
	private TrademarkService trademarkService;








	/**
	 *  外卖用户列表
	 * @param page 页码
	 * @param size 每页数据
	 * @param timeStart 开始时间
	 * @param timeEnd 结束时间
	 * @param name 名
	 * @param platform 平台
	 */

	@RequestMapping(value = "a/u/user/list", method = RequestMethod.GET)
	public String getUserList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page,Integer size,Long timeStart,Long timeEnd,String mobile,String name,String platform) throws Exception {
		log.info("get /user/list");
		log.info("params : page is " + page + " size is " + size + " timeStart is " + timeStart+ " timeEnd is " + timeEnd+ " mobile is " + mobile+ " name is " + name+ " platform is " + platform);

		if (page == null) {
			page = 1;
		}
		if (size == null || size == 0) {
			size = 20;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Map<String,Object> param = DynamicUtil.getUserList(timeStart,timeEnd,mobile,name,platform);
			List<Long> ids =userService.getIdsByDynamicCondition(User.class,param,start,size);
			List<Long> totalIds = userService.getIdsByDynamicCondition(User.class,param,0,Integer.MAX_VALUE);
			List<User> userList = userService.getObjectsByIds(ids);

			log.info("get user data size is " + ids.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",totalIds.size());
			model.addAttribute("userList", userList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage(),t);
			log.error("get user error");
			model.addAttribute("code", -100000);
		}
		model.addAttribute("size",size);
		model.addAttribute("page",page);




		return "/onway-platform-service/user/json/userListJson";
	}
    

	/**
	 *  新增用户
	 * @param user 页码
	 */
	@RequestMapping(value = "/a/user", method = RequestMethod.POST)
	public String addUserJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, User user) throws Exception {
		
		log.info("insert user : user= " + user);
		if (DataUtils.isNullOrEmpty(user.getName())){
			model.addAttribute("code", -3000);
			return "/common/success";
		}
		if (DataUtils.isNullOrEmpty(user.getMobile())){
			model.addAttribute("code", -3002);
			return "/common/success";
		}
		if (DataUtils.isNullOrEmpty(user.getPlatform())){
			model.addAttribute("code", -3004);
			return "/common/success";
		}
		try {
			/*
			***判断堂食用户：
			***调用对方提供的接口，查询mobile是否存在，根据返回结果设置会员身份：存在则为堂食用户，再根据参数设置是否是会员；不存在则非堂食用户
			***判断新用户：
			***根据订单平台和mobile查库，如果存在说明是老用户，否则为新用户，下次再下单查表，把这个用户设置为老用户
			* */
			log.info("user mobile is " + user.getMobile());
			List<Long> ids = userService.getUserIdsByMobile(user.getMobile(),0,1);
			if (CollectionUtils.isNotEmpty(ids)) {
				//手机号存在，判断他为堂食用户
				log.info("The mobile is in use");
				model.addAttribute("code", -3003);
				return "/common/success";
			}

			user.setId(null);
			user.setJoinAt(System.currentTimeMillis());
			Long id = userService.insert(user);

			model.addAttribute("code", 0);
			model.addAttribute("id", id);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add user error ");
			model.addAttribute("code", -1);
		}

		return "/common/insertSuccess";
	}


	@RequestMapping(value = "/a/u/user/statistics",method = RequestMethod.GET)
	public String getUserStatistics (HttpServletRequest request , HttpServletResponse response, ModelMap model , Long
									 timeStart ,Long timeEnd,Long trademarkId ){
		log.info("get /a/user/statistics");
		log.info("get userStatistics by:timeStart = " + timeStart + " ,timeEnd = "+timeEnd);
		Role role = (Role) request.getAttribute("role");
		Long storeId = role.getStoreId();

		if (null == storeId) {
			model.addAttribute("code",-2101);
			return "common/success";
		}

		try {

			Store store = storeService.getObjectById(storeId);
			if (null == store) {
				model.addAttribute("code",-2301);
				return "common/success";
			}else {
				log.info("store is " + store);
				if ( null==trademarkId) {
					trademarkId = store.getTrademarkId();
				}
			}
			log.info("store userStatisticsList start");
			//统计品牌订单数据
			List<UserStatistics> trademarkUserStatisticsList = templateTestService.getUserStatisticsByTimeAndTrademarkId(timeStart, timeEnd,trademarkId);
			log.info("store trademarkUserStatisticsList is" + trademarkUserStatisticsList);

			//统计门店订单数据
			List<UserStatistics> storeUserStatisticsList = templateTestService.getUserStatisticsByTimeAndStoreId(timeStart, timeEnd, storeId,trademarkId);
			log.info("store storeUserStatistics is" + storeUserStatisticsList);


			model.addAttribute("code", 0);
			model.addAttribute("storeUserStatisticsList", storeUserStatisticsList);
			model.addAttribute("trademarkUserStatisticsList", trademarkUserStatisticsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userOrder error");
			model.addAttribute("code", -1);
		}


			return "/onway-platform-service/user/json/userStatisticsList";
		}


	
}

