package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.onway.admin.unit.*;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.model.mtERP.DishesEPR;
import com.ptteng.onway.platform.model.mtERP.SkusEPR;
import com.ptteng.onway.platform.service.*;
import com.qding.common.util.json.GsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * SynRecord  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SynRecordController {
    private static final Log log = LogFactory.getLog(SynRecordController.class);

    @Autowired
    private SynRecordService synRecordService;

    @Autowired
    private StoreService storeService;
    @Autowired
    private FoodTypeRelationService foodTypeRelationService;
    @Autowired
    private FoodService foodService;
    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private EvaluateOrderRelationService evaluateOrderRelationService;
    @Autowired
    private FoodSolidService foodSolidService;
    @Autowired
    private GroupFoodSortService groupFoodSortService;

    @Autowired
    private FoodSpecRelationService foodSpecRelationService;
    @Autowired
    private BusinessHoursService businessHoursService;
    /**
     * 同步监控列表
     *
     * @param page      页码
     * @param size      每页数据
     * @param platform  外卖渠道
     * @param synType   同步类型
     * @param status    同步状态
     * @param timeStart 同步时间开始
     * @param timeEnd   同步时间结束
     */
    @RequestMapping(value = "/a/u/synchronize/record", method = RequestMethod.GET)
    public String getSynRecordList(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Integer page, Integer size, String platform, String synType, String status, Long timeStart, Long timeEnd) throws Exception {
        log.info("get /a/synchronize/record: page is " + page + " ,size is " + size + " ,platform is " + platform + " ,synType is " + synType + " ,status is " + status + " ,timeStart is " + timeStart + " ,timeEnd is " + timeEnd);

        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {

            Map<String, Object> param = DynamicUtil.getSynchronizeList(platform, synType, status, timeStart, timeEnd);
            List<Long> ids = synRecordService.getIdsByDynamicCondition(SynRecord.class, param, start, size);
            Integer total = synRecordService.getIdsByDynamicCondition(SynRecord.class, param, 0, Integer.MAX_VALUE).size();
            List<SynRecord> synRecordList = synRecordService.getObjectsByIds(ids);
            log.info("get synRecordList size is " + synRecordList.size());


            //门店、品牌信息
            List<Long> storeIds = storeService.getStoreIds(0, Integer.MAX_VALUE);
            List<Store> storeList = storeService.getObjectsByIds(storeIds);
            Map<Long, String> storeNameMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"), Store.class.getDeclaredField("name"), storeList);


            //门店、品牌信息
            List<Long> trademarkIds = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE);
            List<Trademark> trademarkList = trademarkService.getObjectsByIds(trademarkIds);
            Map<Long, String> trademarkNameMap = MyListUtil.convert2Map(Trademark.class.getDeclaredField("id"), Trademark.class.getDeclaredField("name"), trademarkList);


            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("storeNameMap", storeNameMap);
            model.addAttribute("trademarkNameMap", trademarkNameMap);

            model.addAttribute("synRecordList", synRecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get synRecord error ");
            model.addAttribute("code", -1);
        }


        return "/onway-platform-service/synRecord/json/synRecordListJson";
    }

    /**
     * 执行同步
     *
     * @param platform 平台
     * @param type 1菜品同步
     */
    @RequestMapping(value = "/a/u/synchronize", method = RequestMethod.PUT)
    public String getSynRecordJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, String platform, Integer type)
            throws Exception {
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("/a/synchronize: storeId= " + storeId + " ,platform is " + platform+" ,type is "+type );
        if (null == storeId) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }
        if (null == platform) {
            model.addAttribute("code", -2102);
            return "/common/success";
        }
        if (null == type) {
            model.addAttribute("code", -2304);
            return "/common/success";
        }
        try {
            Store store = storeService.getObjectById(storeId);

            //门店餐别信息
            List<Long> mealTypeIds = businessHoursService.getBusinessHoursIdsByTargetIdAndStatus(storeId, BusinessHours.OPEN, 0, Integer.MAX_VALUE);
            List<BusinessHours> businessHoursList = businessHoursService.getObjectsByIds(mealTypeIds);
            Map<Integer, BusinessHours> businessHoursMap = MyListUtil.convert2Map(BusinessHours.class.getDeclaredField("mealType"), businessHoursList);


            String result = "";
            String synType = "";
            SynRecord synRecord = new SynRecord();
            switch (type) {
                case SynRecord.SYN_TYPE_DISH:
                    //获取门店可售清单

                    List<Long> solidIds = foodSolidService.getFoodSolidIdsByStoreNum(role.getStoreNum(), 0, Integer.MAX_VALUE);
                    List<FoodSolid> foodSolidList = foodSolidService.getObjectsByIds(solidIds);
                    List<String> foodNumList = MyListUtil.getList(FoodSolid.class.getDeclaredField("foodNum"), foodSolidList);
                    Map<String, FoodSolid> foodSolidMap = MyListUtil.convert2Map(FoodSolid.class.getDeclaredField("foodNum"), foodSolidList);
                    log.info("foodSolidMap is"  + foodSolidMap );
                    log.info("foodNumList size is " + foodNumList.size());
                    //获取可售菜品信息
                    Map<String, Object> params = DynamicUtil.getFoodIdsByStoreNumAndStatus(role.getStoreNum(), null);
                    List<Long> foodIds = foodService.getIdsByDynamicCondition(Food.class, params, 0, Integer.MAX_VALUE);
                    List<Food> foodList = foodService.getObjectsByIds(foodIds);
                    log.info("foodList size is " + foodList.size());
                    //获取排序菜品在类型下的排序信息
                    Map<String, Object> paramsGroupFoodSort = DynamicUtil.getGroupFoodSortIdsByStoreNumAndFoodNumList(role.getStoreNum(),foodNumList);
                    List<Long> groupFoodSortIds = groupFoodSortService.getIdsByDynamicCondition(GroupFoodSort.class, paramsGroupFoodSort, 0, Integer.MAX_VALUE);
                    List<GroupFoodSort> groupFoodSortList = groupFoodSortService.getObjectsByIds(groupFoodSortIds);
                    Map<String,GroupFoodSort> groupFoodSortMap = MyListUtil.convert2Map(GroupFoodSort.class.getDeclaredField("foodNum"), groupFoodSortList);

                    log.info("groupFoodSortList size is " + groupFoodSortList.size());

                    //获取菜品类型信息
                    List<Long> foodTypeIds = foodTypeRelationService.getFoodTypeRelationIdsByStoreId(storeId,0,Integer.MAX_VALUE);
                    List<FoodTypeRelation> foodTypeRelationList = foodTypeRelationService.getObjectsByIds(foodTypeIds);
                    Map foodTypeMap = MyListUtil.convert2Map(FoodTypeRelation.class.getDeclaredField("typeNum"), FoodTypeRelation.class.getDeclaredField("name"), foodTypeRelationList);

                    //获取菜品的规格信息
                    //获取可售菜品信息
                    Map<String, Object> paramsFoodSpec = DynamicUtil.getFoodSpecListByTargetIds(foodIds);
                    List<Long> foodSpecIds = foodSpecRelationService.getIdsByDynamicCondition(FoodSpecRelation.class, paramsFoodSpec, 0, Integer.MAX_VALUE);
                    List<FoodSpecRelation> foodSpecRelationList = foodSpecRelationService.getObjectsByIds(foodSpecIds);
                    Map<Long, List<FoodSpecRelation>> foodSpecRelationMap = MyListUtil.convert2ListMap(FoodSpecRelation.class.getDeclaredField("targetId"), foodSpecRelationList);

                    List<DishesEPR> dishesEPRList =new ArrayList<>();
                    for (Food food:foodList) {

                        List<SkusEPR> skusEPRS = CoverUtil.foodSpecsCover2SkusEPRList(foodSpecRelationMap.get(food.getId()),foodSolidMap.get(food.getFoodNum()),businessHoursMap);
                        DishesEPR dishesEPR =CoverUtil.foodCover2DishesEPR(food,foodTypeMap.get(foodSolidMap.get(food.getFoodNum()).getGroupNum()).toString(),skusEPRS,foodSolidMap.get(food.getFoodNum()),groupFoodSortMap.get(food.getFoodNum()),storeId);
                        dishesEPRList.add(dishesEPR);
                    }

                    // 准备接收返回Json
                    log.info("GsonUtil.toJson(dishesEPRList) is " + GsonUtil.toJson(dishesEPRList));
                    result = WaimaiEPRUtil.takeoutDishBatchUpload(store.getMtAppAuthToken(), GsonUtil.toJson(dishesEPRList),store.getId().toString());
                    log.info("result is " +result);
                    synType = "菜品" ;
                    break;
                case SynRecord.SYN_TYPE_STOCK:
//                    synRecord.setSynType(SynRecord.SYN_TYPE_STOCK);
//                    synType = "库存" ;
                    break;
                case SynRecord.SYN_TYPE_EVALUATION:
                    /**
                    **美团评价处理，美团这里没有返回时间、订单数据
                     * 根据美团的评价id与库里存储的美团最新评价的id比对，判断是否为新数据入库
                     * 如果一次数据量不满20条，说明后面已经没有数据；
                    * */
                    //1.查找最近的一条评价数据读取第三方评价id
                    List<Long> ids = evaluateOrderRelationService.getEvaluateOrderRelationIdsByStoreIdPlatform(storeId,platform,0,1);
                    Long platformEvaId = 0L;
                    log.info("ids size is " +ids.size());
                    if (CollectionUtils.isNotEmpty(ids)) {
                        EvaluateOrderRelation evaluateOrderRelation = evaluateOrderRelationService.getObjectById(ids.get(0));
                        platformEvaId = evaluateOrderRelation.getPlatformEvaId();
                    }
                    log.info("last platformEvaId " +platformEvaId);

                    Integer offset = 0;
                    //2.请求门店评价数据-时间节点为0点到现在，不满20条就不用再执行了，否则重复执行拉取所有数据
                    List<EvaluateOrderRelation> evaluateOrderRelationList = new ArrayList<>();
                    while (true) {

                        result =WaimaiEPRUtil.takeoutPoiQueryReviewList(store.getMtAppAuthToken(),store.getId().toString(),TimeUtil.getTimesTodayMorningInMillis(),System.currentTimeMillis(),offset,20);

                        if (WaimaiEPRUtil.checkResultForArray(result)){
                            evaluateOrderRelationList.addAll(CoverUtil.EPRJsonStrCover2EvaluateOrderRelationList(WaimaiEPRUtil.getJsonResultByKey(result,"data","array"),storeId,platformEvaId));

                        }
                        //不满20调终止循环，否则累加查询起始位置
                        if (evaluateOrderRelationList.size()<20) {
                            evaluateOrderRelationService.insertList(evaluateOrderRelationList);
                            log.info("insert evaluate list success ,size is " +evaluateOrderRelationList.size());
                            break;
                        }else {
                            offset+=20;
                        }
                    }

                    synType = "评价" ;
                    break;
                case SynRecord.SYN_TYPE_USER:
//                    synRecord.setSynType(SynRecord.SYN_TYPE_USER);
//                    synType = "用户" ;
                    break;
                default:
                    break;
            }



            synRecord.setPlatform(platform);
            synRecord.setSynType(type);
            synRecord.setStoreId(storeId);
            synRecord.setTrademarkId(store.getTrademarkId());
            synRecord.setTrademarkNum(store.getTrademarkNum());
            if (WaimaiEPRUtil.checkResultForArray(result)) {
                synRecord.setStatus(SynRecord.SYN_STATUS_SUCCESS);
                log.info("synchronize success !");
            }else {
                log.info("synchronize error !");
                synRecord.setStatus(SynRecord.SYN_STATUS_ERROR);
                synRecord.setErrorMsg(result);
                //发送异常邮件
                String returnString = "";
                try {
                    returnString = mailUtil.sendSMSMail("lishaobo@ptteng.com","test",synType,result);
                } catch (Exception e) {
                    log.error(e.getMessage());
                }

                log.info("邮件发送返回值：" + returnString);
            }

            Long id = synRecordService.insert(synRecord);
            log.info("get synRecord data is " + synRecord);
            model.addAttribute("id", id);
            model.addAttribute("code", 0);
            model.addAttribute("synRecord", synRecord);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            //捕获异常结果发送邮件
            Store store = storeService.getObjectById(storeId);

            Long trademarkId ;
            String trademarkNum ;

            if (null != store) {
                trademarkId = store.getTrademarkId();
                trademarkNum = store.getTrademarkNum();
            }else {
                trademarkId = -1L;
                trademarkNum = "-1";
            }
            SynRecord synRecord = new SynRecord();
            synRecord.setErrorMsg(t.toString());
            synRecord.setStatus(SynRecord.SYN_STATUS_ERROR);
            synRecord.setPlatform(platform);
            log.info("synchronize error !");
            String synType = "";
            String returnString = "";
            switch (type) {
                case SynRecord.SYN_TYPE_DISH:
                    synRecord.setSynType(SynRecord.SYN_TYPE_DISH);
                    synType = "菜品" ;
                    break;
                case SynRecord.SYN_TYPE_STOCK:
                    synRecord.setSynType(SynRecord.SYN_TYPE_STOCK);
                    synType = "库存" ;
                    break;
                case SynRecord.SYN_TYPE_EVALUATION:
                    synRecord.setSynType(SynRecord.SYN_TYPE_EVALUATION);
                    synType = "评价" ;
                    break;
                case SynRecord.SYN_TYPE_USER:
                    synRecord.setSynType(SynRecord.SYN_TYPE_USER);
                    synType = "用户" ;
                    break;
                    default:
                        break;
            }
            synRecord.setStoreId(storeId);
            synRecord.setTrademarkId(trademarkId);
            synRecord.setTrademarkNum(trademarkNum);
            Long id = synRecordService.insert(synRecord);
            //发送异常邮件
            try {
                returnString = mailUtil.sendSMSMail("lishaobo@ptteng.com","test",synType,t.toString());
            } catch (Exception e) {
                log.error(e.getMessage());
            }

            log.info("邮件发送返回值：" + returnString);



            model.addAttribute("code", -1);
            model.addAttribute("id", id);
        }

        return "/common/insertSuccess";
    }

}

