package com.ptteng.onway.admin.controller;


import com.ptteng.onway.admin.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.FoodTypeRelation;
import com.ptteng.onway.platform.model.Role;
import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.service.FoodTypeRelationService;
import com.ptteng.onway.platform.service.StoreService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * FoodTypeRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class FoodTypeRelationController {
    private static final Log log = LogFactory.getLog(FoodTypeRelationController.class);

    @Autowired
    private FoodTypeRelationService foodTypeRelationService;

    @Autowired
    private StoreService storeService;


    /**
     * 外卖类型列表
     *
     * @param storeId     门店id
     * @param trademarkId 品牌id
     */
    @RequestMapping(value = "/a/u/food/type/list", method = RequestMethod.GET)
    public String getFoodTypeRelationIdsByStoreIdJsonList(HttpServletRequest request,
                                                          HttpServletResponse response, ModelMap model, Long storeId, Long trademarkId) throws Exception {

        log.info("get /a/foodType/list : storeId= " + storeId + " , trademarkId=" + trademarkId);

        try {

            List<Long> ids = foodTypeRelationService.getFoodTypeRelationIds( 0, Integer.MAX_VALUE);
            log.info("get countFoodTypeRelationIdsByStoreId size is " + ids.size());

            List<FoodTypeRelation> foodTypeRelationList = foodTypeRelationService.getObjectsByIds(ids);
            log.info("get foodTypeRelation data is " + foodTypeRelationList.size());

            Integer total = ids.size();
            log.info("get foodTypeRelation count is " + total);

            model.addAttribute("code", 0);


            model.addAttribute("total", total);

            model.addAttribute("foodTypeRelationList", foodTypeRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get foodTypeRelation list error");
            // for test
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/foodTypeRelation/json/foodTypeRelationListJson";
    }

//
//    /**
//     * 更新外卖类型
//     *
//     * @param foodType 门店id
//     *                 storeId 和 trademarkId 应该是在token里取信息，暂无无
//     */
//    @RequestMapping(value = "/a/u/food/group/{groupNum}", method = RequestMethod.PUT)
//    public String updateFoodTypeRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
//                                             FoodTypeRelation foodType, @PathVariable String groupNum) throws Exception {
//
//        log.info("update foodTypeRelation : foodTypeRelation= " + foodType);
//
//        try {
//            Long id = foodTypeRelationService.getFoodTypeRelationIdByTypeNum(groupNum);
//            FoodTypeRelation foodTypeRelation = foodTypeRelationService.getObjectById(id);
////            Store store=storeService.getObjectById(foodTypeRelation.getStoreId());
////            String appAuthToken=store.getMtAppAuthToken();
//            if (DataUtils.isNotNullOrEmpty(foodType.getName())) {
//                //设置旧名字
//                foodTypeRelation.setOldName(foodTypeRelation.getName());
//                foodTypeRelation.setName(foodType.getName());
//            }
//            if (DataUtils.isNotNullOrEmpty(foodType.getGroupRank())) {
//                foodTypeRelation.setGroupRank(foodType.getGroupRank());
//            }
//
//
//            if (null == foodType.getLevel()) {
//                model.addAttribute("code", -2517);
//                return "/common/success";
//            } else if ( foodType.getLevel()>1) {
//                if (null == foodType.getParentNum()) {
//                    model.addAttribute("code", -2517);
//                    return "/common/success";
//                } else {
//                    id = foodTypeRelationService.getFoodTypeRelationIdByTypeNum(foodType.getTypeNum());
//                    if (id == null) {
//                        model.addAttribute("code", -2523);
//                        return "/common/success";
//                    }
//                }
//            }
//
//
//
//            foodTypeRelationService.update(foodTypeRelation);
////            String resultJson= WaimaiEPRUtil.takeoutDishCatUpdate(appAuthToken,foodTypeRelation,foodTypeRelation.getOldName());
////            log.info("resultJson is"+resultJson);
//
//            model.addAttribute("code", 0);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("update foodTypeRelation error,id is  " + foodType.getId());
//            model.addAttribute("code", -6003);
//
//        }
//
//        return "/common/success";
//    }


    /**
     * 新增修改外卖类型
     *
     * @param foodType 外卖类型
     *
     */

    @RequestMapping(value = "/a/u/food/group", method = RequestMethod.POST)
    public String addFoodTypeRelationJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, FoodTypeRelation foodType) throws Exception {

        log.info("update food group : foodType= " + foodType);
        Role role = (Role) request.getAttribute("role");
        if (!role.getIdentity().equals(Role.STORE_MANAGER)) {
            model.addAttribute("code", -10);
            return "/common/success";
        }


        if (null == foodType.getName()) {
            model.addAttribute("code", -2506);
            return "/common/success";
        }
        if (null == foodType.getTypeNum()) {
            model.addAttribute("code", -2519);
            return "/common/success";
        }
        if (null == foodType.getGroupRank()) {
            model.addAttribute("code", -2517);
            return "/common/success";
        }


        try {
            if (null == foodType.getLevel()) {
                model.addAttribute("code", -2517);
                return "/common/success";
            } else if ( foodType.getLevel()>1) {
                if (null == foodType.getParentNum()) {
                    model.addAttribute("code", -2517);
                    return "/common/success";
                } else {
                    Long pid = foodTypeRelationService.getFoodTypeRelationIdByTypeNum(foodType.getTypeNum());
                    if (pid == null) {
                        model.addAttribute("code", -2523);
                        return "/common/success";
                    }
                }
            }

            Long nid = foodTypeRelationService.getFoodTypeRelationIdByName(foodType.getName());
            log.info("get id by name ,name is " + foodType.getName()+" ,id is "+nid);
            Long id = foodTypeRelationService.getFoodTypeRelationIdByTypeNum(foodType.getTypeNum());
            log.info("get id by typeNum ,typeNum is " + foodType.getTypeNum()+" ,id is "+id);
            if (DataUtils.isNotNullOrEmpty(nid) && !nid.equals(id)) {
                model.addAttribute("code", -2507);
                return "/common/success";
            }

            if(DataUtils.isNotNullOrEmpty(id)) {
                log.info("update food food type,id is " + id);
                FoodTypeRelation oFoodType = foodTypeRelationService.getObjectById(id);
                foodType.setCreateBy(oFoodType.getCreateBy());
                foodType.setCreateAt(oFoodType.getCreateAt());
                foodType.setUpdateBy(Long.valueOf(role.getUserId()));
                foodType.setId(oFoodType.getId());
                foodType.setStoreId(oFoodType.getStoreId());
                foodTypeRelationService.update(foodType);
                log.info("update success ,id is "+id);
            }else {
                log.info("add new food type ");
                foodType.setId(null);
                foodType.setCreateBy(Long.valueOf(role.getUserId()));
                foodType.setUpdateBy(Long.valueOf(role.getUserId()));
                foodType.setStoreId(role.getStoreId());
                Long result = foodTypeRelationService.insert(foodType);
                log.info("add success ,id is "+result);
                model.addAttribute("id", result);
            }


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add foodTypeRelation error ");
            model.addAttribute("code", -6002);
        }

        return "/common/insertSuccess";
    }


    /**
     * 删除菜品类型
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/dish/group/{id}", method = RequestMethod.DELETE)
    public String deleteFoodTypeRelationJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete FoodTypeRelation : id= " + id);
        try {
            FoodTypeRelation foodTypeRelation=foodTypeRelationService.getObjectById(id);
            Store store=storeService.getObjectById(foodTypeRelation.getStoreId());
            String appAuthToken=store.getMtAppAuthToken();
            String resultJson=WaimaiEPRUtil.takeoutDishCatDetele(appAuthToken,foodTypeRelation);
            log.info("resultJson is"+resultJson);
            if (WaimaiEPRUtil.checkResult(resultJson)) {
                foodTypeRelationService.delete(id);
                model.addAttribute("id", id);
                model.addAttribute("code", 0);
            } else {
                JSONObject jsonObject = new JSONObject(resultJson);
                model.addAttribute("code", -1000);
                model.addAttribute("message", jsonObject.getJSONObject("error").get("message"));
                return "/common/result";
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete introduce error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * show 删除ERP平台菜品类，下面的菜品也删除
     * @param name 菜品名
     * @return java.lang.String
     * @exception Exception 异常信息
     * @author lishaobo
     * @date    2018/1/20
     */


    @RequestMapping(value = "/a/u/foodType", method = RequestMethod.PUT)
    public String clearFood (HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,String name)
            throws Exception {


        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();
        log.info("addGroupGoodSort : storeId= " + storeId);
        try {
            Store store = storeService.getObjectById(storeId);
            String result =  WaimaiEPRUtil.deleteCat(store.getMtAppAuthToken(),name);


            model.addAttribute("code",0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addGroupGoodSort error ");
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }
}

