package com.ptteng.onway.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.onway.admin.constents.WaimaiConstents;
import com.ptteng.onway.admin.unit.DynamicUtil;
import com.ptteng.onway.admin.unit.WaimaiEPRUtil;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * EvaluateOrderRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class EvaluateOrderRelationController {
    private static final Log log = LogFactory.getLog(EvaluateOrderRelationController.class);

    @Autowired
    private EvaluateOrderRelationService evaluateOrderRelationService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private TrademarkService trademarkService;
    @Autowired
    private TemplateTestService templateTestService;

    /**
     * 评论列表
     *
     * @param timeStart  下单时间开始
     * @param timeEnd    下单结束
     * @param platformOrderNum   订单号
     * @param mobile     手机号
     * @param platform   外卖渠道
     * @param orderScore 订单评价星级
     */

    @RequestMapping(value = "/a/u/evaluate/list", method = RequestMethod.GET)
    public String getEvaluateOrderRelationList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, String platformOrderNum, String mobile,
            String platform, String orderScore, Integer page, Integer size) throws Exception {

        log.info("get /a/evaluate/list :timeStart =" + timeStart + " ,timeEnd = " + timeEnd + " ,orderNum = "
                + platformOrderNum + " ,mobile = " + mobile + " ,platform = " + platform + " ,orderScore = "
                + orderScore);

        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();

        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("page is " + page + " ,size is " + size);

        try {
            Store store = storeService.getObjectById(storeId);
            Long trademarkId = store.getTrademarkId();
            Integer total = 0;

            //美团ERP评价无订单、时间，单独处理
            if (DataUtils.isNotNullOrEmpty(platform) && platform.equals(WaimaiConstents.platform_meitian)) {
                Map<String, Object> param = DynamicUtil.getEvaluateListByMeituan(orderScore, storeId, trademarkId);
                List<Long> ids = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class, param,
                        start, size);
                List<EvaluateOrderRelation> evaluateOrderRelationList = evaluateOrderRelationService.getObjectsByIds(ids);

                List<Long> idsTotal = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class,
                        param, 0, Integer.MAX_VALUE);
                total = idsTotal.size();

                model.addAttribute("evaluateOrderRelationList", evaluateOrderRelationList);
            }else {
                log.info("get ele/baidu eva list");
                Map<String, Object> param = DynamicUtil.getEvaluateList(timeStart, timeEnd, platformOrderNum, mobile,
                        platform, orderScore, storeId, trademarkId);
                List<Long> ids = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class, param,
                        start, size);
                List<EvaluateOrderRelation> evaluateOrderRelationList = evaluateOrderRelationService.getObjectsByIds(ids);

                List<Long> idsTotal = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class,
                        param, 0, Integer.MAX_VALUE);
                total = idsTotal.size();
                //查订单
                List<Long> oids = new ArrayList<>();
                for (EvaluateOrderRelation evaluateOrderRelation : evaluateOrderRelationList) {
                    oids.add(evaluateOrderRelation.getOrderId());
                }
                List<UserOrder> orderList = userOrderService.getObjectsByIds(oids);
                Map<Long, UserOrder> orderMap = new HashMap<>();
                for (UserOrder userOrder : orderList) {
                    orderMap.put(userOrder.getId(), userOrder);
                }
                model.addAttribute("evaluateOrderRelationList", evaluateOrderRelationList);
                model.addAttribute("orders", orderMap);


            }



            //设置品牌、门店名
            Trademark trademark = trademarkService.getObjectById(trademarkId);
            model.addAttribute("total", total);
            model.addAttribute("store", store);
            model.addAttribute("trademark", trademark);

            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/evaluateOrderRelation/json/evaluateOrderRelationListJson";
    }

    @RequestMapping(value = "/a/u/evaluate/list/excel", method = RequestMethod.GET)
    public String getEvaluateOrderRelationListExcel(HttpServletRequest request, HttpServletResponse response,
            ModelMap model, Long timeStart, Long timeEnd, String orderNum,
            String mobile, String platform, String score, Integer page, Integer size) throws Exception {

        log.info("get /a/evaluate/list :timeStart =" + timeStart + " ,timeEnd = " + timeEnd + " ,orderNum = " + orderNum
                + " ,mobile = " + mobile + " ,platform = " + platform + " ,star = " + score);
        Role role = (Role) request.getAttribute("role");

        Long storeId = role.getStoreId();

        page = 1;
        size = 999999;
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("page is " + page + " ,size is " + size);
        try {
            Store store = storeService.getObjectById(storeId);
            Long trademarkId = store.getTrademarkId();

            Map<String, Object> param = DynamicUtil.getEvaluateList(timeStart, timeEnd, orderNum, mobile, platform,
                    score, storeId, trademarkId);
            List<Long> ids = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class, param,
                    start, size);
            List<EvaluateOrderRelation> evaluateOrderRelationList = evaluateOrderRelationService.getObjectsByIds(ids);

            List<Long> idsTotal = evaluateOrderRelationService.getIdsByDynamicCondition(EvaluateOrderRelation.class,
                    param, 0, Integer.MAX_VALUE);
            Integer total = idsTotal.size();
            //查订单
            List<Long> oids = new ArrayList<>();
            for (EvaluateOrderRelation evaluateOrderRelation : evaluateOrderRelationList) {
                oids.add(evaluateOrderRelation.getOrderId());
            }
            List<UserOrder> orderList = userOrderService.getObjectsByIds(oids);
            Map<Long, UserOrder> orderMap = new HashMap<>();
            for (UserOrder userOrder : orderList) {
                orderMap.put(userOrder.getId(), userOrder);
            }

            //设置品牌、门店名
            //门店ids
            List<Long> sids = storeService.getStoreIds(0, Integer.MAX_VALUE);
            List<Store> stores = storeService.getObjectsByIds(sids);
            log.info("stores size is " + stores.size());
            Map<Long, String> storeMap = MyListUtil.convert2Map(Store.class.getDeclaredField("id"),
                    Store.class.getDeclaredField("name"), stores);
            //品牌ids
            List<Long> tids = trademarkService.getTrademarkIds(0, Integer.MAX_VALUE);
            List<Trademark> trademarks = trademarkService.getObjectsByIds(tids);
            log.info("trademarks size is " + trademarks.size());
            Map<Long, String> trademarkMap = MyListUtil.convert2Map(Trademark.class.getDeclaredField("id"),
                    Trademark.class.getDeclaredField("name"), trademarks);

            model.addAttribute("total", total);
            model.addAttribute("stores", storeMap);
            model.addAttribute("trademarks", trademarkMap);
            model.addAttribute("orders", orderMap);
            model.addAttribute("evaluateOrderRelationList", evaluateOrderRelationList);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/evaluateOrderRelation/json/evaluateOrderRelationListJson";
    }

    /**
     * 评论详情
     *
     * @param id 评论id
     */
    @RequestMapping(value = "/a/u/evaluate/{id}", method = RequestMethod.GET)
    public String getEvaluateOrderRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("get /a/evaluateOrderRelation/" + id);
        try {
            EvaluateOrderRelation evaluateOrderRelation = evaluateOrderRelationService.getObjectById(id);
            if (null == evaluateOrderRelation) {
                model.addAttribute("code", -2405);
                return "/common/success";
            }
            log.info("get evaluateOrderRelation data is " + evaluateOrderRelation);

            model.addAttribute("code", 0);

            model.addAttribute("evaluateOrderRelation", evaluateOrderRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get evaluateOrderRelation error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/onway-platform-service/evaluateOrderRelation/json/evaluateOrderRelationDetailJson";
    }

    /**
     * 回复评价
     *
     * @param id    评价id
     * @param reply 回复内容
     */
    @RequestMapping(value = "/a/u/evaluate/reply/{id}", method = RequestMethod.PUT)
    public String updateEvaluateOrderRelationJson(HttpServletRequest request, HttpServletResponse response,
            ModelMap model, @PathVariable Long id, String reply) throws Exception {

        log.info("put /a/evaluateOrderRelation/" + id + " , reply is " + reply);
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();

        if (DataUtils.isNullOrEmpty(reply)) {
            model.addAttribute("code", -2404);
            return "common/success";
        }
        try {

            EvaluateOrderRelation evaluateOrderRelation = evaluateOrderRelationService.getObjectById(id);
            Store store = storeService.getObjectById(storeId);
            if (null == evaluateOrderRelation) {
                model.addAttribute("code", -2405);
                return "common/success";
            }else if (!evaluateOrderRelation.getStoreId().equals(storeId)){
                model.addAttribute("code", -10);
                return "common/success";
            }
            UserOrder userOrder = userOrderService.getObjectById(evaluateOrderRelation.getOrderId());
            switch (userOrder.getPlatform()) {
                case WaimaiConstents.platform_meitian:
                    if (store.getMtConnectionMethod().equals(Store.CONNECTION_ERP)) {
                        //TODO
                        log.info("meituan ERP 回复评价");
                        //品牌接入方式
                        WaimaiEPRUtil.takeoutPoiAddReply(store.getMtAppAuthToken(), evaluateOrderRelation.getPlatformEvaId(), storeId.toString(), reply);
                    }else {
                        //TODO
                        log.info("meituan ERP 回复评价");
                        //品牌接入方式
                    }
                    break;
                case WaimaiConstents.platform_baidu:
                    //TODO
                    break;
                case WaimaiConstents.platform_ele:
                    //TODO
                    break;
                default:
                    break;
            }

            evaluateOrderRelation.setBusinessReply(reply);
            evaluateOrderRelation.setReplyAt(System.currentTimeMillis());
            evaluateOrderRelation.setUpdateBy(Long.valueOf(role.getUserId()));
            evaluateOrderRelationService.update(evaluateOrderRelation);

            model.addAttribute("code", 0);

            model.addAttribute("evaluateOrderRelation", evaluateOrderRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update evaluateOrderRelation error,id is  " + id);
            model.addAttribute("code", -1);

        }
        return "/common/success";
    }

    /**
     * 评价数据统计
     * @param timeStart   下单时间开始
     * @param timeEnd     下单时间结束
     */

    @RequestMapping(value = "/a/u/evaluate/statistics", method = RequestMethod.GET)
    public String getStoreOrderList(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Integer page, Integer size) throws Exception {
        log.info("get /a/evaluate/statistics");
        log.info("get evaluateStatistics by:timeStart = " + timeStart + " ,timeEnd = " + timeEnd );

        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();

        if (null == storeId) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }

        try {
            Store store = storeService.getObjectById(storeId);
            if (null == store) {
                model.addAttribute("code", -2301);
                return "/common/success";
            }
            Long trademarkId = store.getTrademarkId();

            //门店统计
            List<EvaluateStatistics> storeEvaluateStatisticsList = templateTestService.getEvaluateStatisticsByTimeAndStoreId(timeStart, timeEnd, trademarkId, storeId);
            log.info("storeEvaluateStatisticsList is" + storeEvaluateStatisticsList);
            //品牌统计
            List<EvaluateStatistics> trademarkEvaluateStatisticsList = templateTestService.getEvaluateStatisticsByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);
            log.info("trademarkEvaluateStatisticsList is" + trademarkEvaluateStatisticsList);
            model.addAttribute("code", 0);
            model.addAttribute("storeEvaluateStatisticsList", storeEvaluateStatisticsList);
            model.addAttribute("trademarkEvaluateStatisticsList", trademarkEvaluateStatisticsList);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }


        return "/onway-platform-service/evaluateOrderRelation/json/evaluateStatisticsList";
    }

    //Excel
    @RequestMapping(value = "/a/u/evaluate/statistics/excel", method = RequestMethod.GET)
    public String getStoreOrderListExcel(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long timeStart, Long timeEnd, Integer page, Integer size) throws Exception {
        log.info("get /a/evaluate/statistics/excel");
        log.info("get evaluateStatistics by:timeStart = " + timeStart + " ,timeEnd = " + timeEnd );
        Role role = (Role) request.getAttribute("role");
        Long storeId = role.getStoreId();


        if (null == storeId) {
            model.addAttribute("code", -2101);
            return "/common/success";
        }

        try {
            Store store = storeService.getObjectById(storeId);
            if (null == store) {
                model.addAttribute("code", -2301);
                return "/common/success";
            }

             Long trademarkId = store.getTrademarkId();

            //门店统计
            List<EvaluateStatistics> storeEvaluateStatisticsList = templateTestService.getEvaluateStatisticsByTimeAndStoreId(timeStart, timeEnd, trademarkId, storeId);
            log.info("storeEvaluateStatisticsList is" + storeEvaluateStatisticsList);
            //品牌统计
            List<EvaluateStatistics> trademarkEvaluateStatisticsList = templateTestService.getEvaluateStatisticsByTimeAndTrademarkId(timeStart, timeEnd, trademarkId);
            log.info("trademarkEvaluateStatisticsList is" + trademarkEvaluateStatisticsList);
            model.addAttribute("code", 0);
            model.addAttribute("storeEvaluateStatisticsList", storeEvaluateStatisticsList);
            model.addAttribute("trademarkEvaluateStatisticsList", trademarkEvaluateStatisticsList);

        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet");
        Row header_row = sheet.createRow(0);
        //品牌统计
        String headers[] = new String[]{"序号", "品牌名称", "外卖订单数", "评价单数", "评价率", "五星评价", "四星评价", "三星评价", "二星评价", "一星评价"};
        for (int i = 0; i < headers.length; i++) {
            HSSFCell cell = (HSSFCell) header_row.createCell(i);
            cell.setCellValue(headers[i]);
        }
        log.info(trademarkEvaluateStatisticsList);
        for (int i = 0; i < trademarkEvaluateStatisticsList.size(); i++) {
            Row rose = sheet.createRow(i + 1);
            for (int j = 0; j < headers.length; j++) {
                EvaluateStatistics EvaluateStatistics = trademarkEvaluateStatisticsList.get(i);
                HSSFCell cell0 = (HSSFCell) rose.createCell(0);
                cell0.setCellValue(i + 1);
                HSSFCell cell1 = (HSSFCell) rose.createCell(1);
                cell1.setCellValue(EvaluateStatistics.getTrademarkName());
                HSSFCell cell2 = (HSSFCell) rose.createCell(2);
                cell2.setCellValue(EvaluateStatistics.getOrderCount());
                HSSFCell cell3 = (HSSFCell) rose.createCell(3);
                cell3.setCellValue(EvaluateStatistics.getEvaluateCount());
                HSSFCell cell4 = (HSSFCell) rose.createCell(4);
                NumberFormat num = NumberFormat.getPercentInstance();
                num.setMaximumIntegerDigits(3);
                num.setMaximumFractionDigits(2);
                Double rate = Double.parseDouble(EvaluateStatistics.getEvaluateRate());
                cell4.setCellValue(num.format(rate));
                HSSFCell cell5 = (HSSFCell) rose.createCell(5);
                cell5.setCellValue(EvaluateStatistics.getFiveCount());
                HSSFCell cell6 = (HSSFCell) rose.createCell(6);
                cell6.setCellValue(EvaluateStatistics.getFourCount());
                HSSFCell cell7 = (HSSFCell) rose.createCell(7);
                cell7.setCellValue(EvaluateStatistics.getThreeCount());
                HSSFCell cell8 = (HSSFCell) rose.createCell(8);
                cell8.setCellValue(EvaluateStatistics.getTwoCount());
                HSSFCell cell9 = (HSSFCell) rose.createCell(9);
                cell9.setCellValue(EvaluateStatistics.getOneCount());
            }

        }
        //门店统计
            String headersSec[] = new String[]{"序号", "门店名称", "外卖订单数", "评价单数", "评价率", "五星评价", "四星评价", "三星评价", "二星评价", "一星评价"};
            log.info(storeEvaluateStatisticsList);
            for (int i = 0; i < storeEvaluateStatisticsList.size(); i++) {
                Row rose = sheet.createRow(i + 2 + trademarkEvaluateStatisticsList.size());
                Row rose2 = sheet.createRow(i + 1 + trademarkEvaluateStatisticsList.size());
                HSSFCell cell0s = (HSSFCell) rose2.createCell(0);
                cell0s.setCellValue("序号");
                HSSFCell cell1s = (HSSFCell) rose2.createCell(1);
                cell1s.setCellValue("门店名称");
                HSSFCell cell2s = (HSSFCell) rose2.createCell(2);
                cell2s.setCellValue("外卖订单数");
                HSSFCell cell3s = (HSSFCell) rose2.createCell(3);
                cell3s.setCellValue("评价单数");
                HSSFCell cell4s = (HSSFCell) rose2.createCell(4);
                cell4s.setCellValue("评价率");
                HSSFCell cell5s = (HSSFCell) rose2.createCell(5);
                cell5s.setCellValue("五星评价");
                HSSFCell cell6s = (HSSFCell) rose2.createCell(6);
                cell6s.setCellValue("四星评价");
                HSSFCell cell7s = (HSSFCell) rose2.createCell(7);
                cell7s.setCellValue("三星评价");
                HSSFCell cell8s = (HSSFCell) rose2.createCell(8);
                cell8s.setCellValue("二星评价");
                HSSFCell cell9s = (HSSFCell) rose2.createCell(9);
                cell9s.setCellValue("一星评价");
                for (int j = 0; j <  headersSec.length; j++) {
                    EvaluateStatistics EvaluateStatistics = storeEvaluateStatisticsList.get(i);
                    HSSFCell cell0 = (HSSFCell) rose.createCell(0);
                    cell0.setCellValue(i + 1);
                    HSSFCell cell1 = (HSSFCell) rose.createCell(1);
                    cell1.setCellValue(EvaluateStatistics.getStoreName());
                    HSSFCell cell2 = (HSSFCell) rose.createCell(2);
                    cell2.setCellValue(EvaluateStatistics.getOrderCount());
                    HSSFCell cell3 = (HSSFCell) rose.createCell(3);
                    cell3.setCellValue(EvaluateStatistics.getEvaluateCount());
                    HSSFCell cell4 = (HSSFCell) rose.createCell(4);
                    NumberFormat num = NumberFormat.getPercentInstance();
                    num.setMaximumIntegerDigits(3);
                    num.setMaximumFractionDigits(2);
                    Double rate = Double.parseDouble(EvaluateStatistics.getEvaluateRate());
                    cell4.setCellValue(num.format(rate));
                    HSSFCell cell5 = (HSSFCell) rose.createCell(5);
                    cell5.setCellValue(EvaluateStatistics.getFiveCount());
                    HSSFCell cell6 = (HSSFCell) rose.createCell(6);
                    cell6.setCellValue(EvaluateStatistics.getFourCount());
                    HSSFCell cell7 = (HSSFCell) rose.createCell(7);
                    cell7.setCellValue(EvaluateStatistics.getThreeCount());
                    HSSFCell cell8 = (HSSFCell) rose.createCell(8);
                    cell8.setCellValue(EvaluateStatistics.getTwoCount());
                    HSSFCell cell9 = (HSSFCell) rose.createCell(9);
                    cell9.setCellValue(EvaluateStatistics.getOneCount());
                }

            }
        log.info("success");
        Long excelDate = System.currentTimeMillis();
        String url = "/data/webs/onway-admin-web/excel/评价管理" + excelDate + ".xls";
        FileOutputStream output = new FileOutputStream(url);
        url = "/exceldownload/评价管理" + excelDate + ".xls";
        wb.write(output);
        output.flush();
        model.addAttribute("code", 0);
        model.addAttribute("url", url);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userOrder error");
            model.addAttribute("code", -1);
        }


        return "/common/url";
    }



}
