-- ----------------------------
-- Table structure for `patient`
-- ----------------------------
-- DROP TABLE IF EXISTS `patient`;
CREATE TABLE `patient` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `img` varchar(300)    COMMENT '头像',  
    `pinyin` varchar(100)    COMMENT '姓名拼音',  
    `name` varchar(100)    COMMENT '姓名',  
    `birth` varchar(100)    COMMENT '出生年月日',  
    `introduction` text    COMMENT '介绍',  
    `id_no` varchar(100)    COMMENT '身份证号',  
    `did` bigint(20)    COMMENT '医师ID',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `train`
-- ----------------------------
-- DROP TABLE IF EXISTS `train`;
CREATE TABLE `train` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pid` bigint(20) NOT NULL   COMMENT '患者ID',  
    `sensitivity` int(2) NOT NULL   COMMENT '敏感度',  
    `hardness` int(2) NOT NULL   COMMENT '硬度',  
    `duration` int(8) NOT NULL   COMMENT '时长',  
    `blood_flow` varchar(100) NOT NULL   COMMENT '血流量',  
    `train_at` bigint(20) NOT NULL   COMMENT '训练时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `daily`
-- ----------------------------
-- DROP TABLE IF EXISTS `daily`;
CREATE TABLE `daily` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pid` bigint(20) NOT NULL   COMMENT '患者ID',  
    `sensitivity` varchar(100)    COMMENT '日均敏感度',  
    `hardness` varchar(100)    COMMENT '日均硬度',  
    `duration` varchar(100)    COMMENT '总时长',  
    `train_time` bigint(20)    COMMENT '训练时间',  
    `count` int(2)    COMMENT '当天完成次数',  
    `status` int(2)    COMMENT '今天是否切换方案(0:没有,1:有)',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `apply`
-- ----------------------------
-- DROP TABLE IF EXISTS `apply`;
CREATE TABLE `apply` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pid` bigint(20) NOT NULL   COMMENT '患者ID',  
    `did` bigint(20) NOT NULL   COMMENT '医师ID',  
    `status` int(2) NOT NULL   COMMENT '申请状态',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `comment`
-- ----------------------------
-- DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pid` bigint(20) NOT NULL   COMMENT '患者ID',  
    `did` bigint(20) NOT NULL   COMMENT '医师ID',  
    `comment` text NOT NULL   COMMENT '评论',  
    `comment_at` bigint(20) NOT NULL   COMMENT '评论时间',  
    `star` int(2) NOT NULL   COMMENT '打星',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `message`
-- ----------------------------
-- DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',  
    `status` int(2)    COMMENT '详细状态(0:未读,1:已读)',  
    `send_at` bigint(20)    COMMENT '发送时间',  
    `type` int(2) NOT NULL   COMMENT '通知类型',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `pid` bigint(20)    COMMENT '患者ID',  
    `did` bigint(20)    COMMENT '医师ID',  
    `patient_name` varchar(30)    COMMENT '患者姓名',  
    `doctor_name` varchar(30)    COMMENT '医师姓名',  
    `pay_no` varchar(100)    COMMENT '第三方流水号',  
    `orders_no` varchar(30)    COMMENT '交易流水号',  
    `product` varchar(100)    COMMENT '商品名称',  
    `amount` varchar(30) NOT NULL   COMMENT '订单金额',  
    `type` int(2)    COMMENT '交易类型',  
    `status` int(2)    COMMENT '交易状态(-1：订单失效；0：付款失败；1：付款成功；2：待付款)',  
    `way` int(2)    COMMENT '第三方平台种类',  
    `pay_at` bigint NOT NULL   COMMENT '支付时间',  
    `order_at` bigint(20)    COMMENT '订单时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `doctor`
-- ----------------------------
-- DROP TABLE IF EXISTS `doctor`;
CREATE TABLE `doctor` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `img` varchar(300)    COMMENT '头像',  
    `pinyin` varchar(100)    COMMENT '姓名拼音',  
    `name` varchar(100)    COMMENT '姓名',  
    `introduction` text    COMMENT '介绍',  
    `id_no` varchar(100)    COMMENT '身份证号',  
    `cid` bigint(20)    COMMENT '所在城市',  
    `average` int(2)    COMMENT '平均打星',  
    `income` varchar(100)    COMMENT '收入',  
    `certificate_back` varchar(300)    COMMENT '医师资格证照片背面',  
    `certificate` varchar(300)    COMMENT '医师资格证照片正面',  
    `status` int(2)    COMMENT '认证状态',  
    `apply` bigint(20)    COMMENT '认证申请时间',  
    `refuse` varchar(100)    COMMENT '拒绝理由',  
    `hid` bigint(20)    COMMENT '合作医院',  
    `qualifications` varchar(200)    COMMENT '医师资格证号',  
    `position` varchar(50)    COMMENT '职称',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `template`
-- ----------------------------
-- DROP TABLE IF EXISTS `template`;
CREATE TABLE `template` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(100)    COMMENT '方案名称',  
    `did` bigint(20) NOT NULL   COMMENT '医师ID',  
    `duration` varchar(100)    COMMENT '时长',  
    `price` varchar(50)    COMMENT '价格',  
    `count` bigint(20)    COMMENT '使用人数',  
    `probe` varchar(50)    COMMENT '探头',  
    `strength` varchar(50)    COMMENT '强度',  
    `interval` varchar(50)    COMMENT '间隔',  
    `treatment` varchar(50)    COMMENT '疗程',  
    `template_at` bigint(20)    COMMENT '模板创建时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `program_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `program_relation`;
CREATE TABLE `program_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(100)    COMMENT '方案名称',  
    `pid` bigint(20)    COMMENT '患者ID',  
    `did` bigint(20) NOT NULL   COMMENT '医师ID',  
    `duration` varchar(100)    COMMENT '时长',  
    `price` varchar(50)    COMMENT '价格',  
    `count` bigint(20)    COMMENT '使用人数',  
    `probe` varchar(50)    COMMENT '探头',  
    `strength` varchar(50)    COMMENT '强度',  
    `interval` varchar(50)    COMMENT '间隔',  
    `conclusion` varchar(300)    COMMENT '诊断结论',  
    `status` int(2)    COMMENT '方案状态',  
    `buy_at` bigint(20)    COMMENT '购买时间',  
    `treatment` varchar(50)    COMMENT '疗程',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `hospital`
-- ----------------------------
-- DROP TABLE IF EXISTS `hospital`;
CREATE TABLE `hospital` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(100) NOT NULL   COMMENT '医院名称',  
    `pinyin` varchar(100) NOT NULL   COMMENT '名称拼音',  
    `grade` int(2) NOT NULL   COMMENT '医院等级',  
    `province` varchar(50) NOT NULL   COMMENT '省',  
    `city` varchar(50) NOT NULL   COMMENT '市',  
    `address` varchar(50) NOT NULL   COMMENT '地址',  
    `image` varchar(100) NOT NULL   COMMENT '地址',  
    `status` int(2) NOT NULL   COMMENT '状态',  
    `cid` bigint(20) NOT NULL   COMMENT '城市ID',  
    `total` bigint(20) NOT NULL   COMMENT '医院医师总数',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `sms`
-- ----------------------------
-- DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `message` varchar(100) NOT NULL   COMMENT '信息',  
    `type` varchar(20) NOT NULL   COMMENT '验证码类型',  
    `mobile` varchar(100) NOT NULL   COMMENT '手机号',  
    `send_at` bigint(20) NOT NULL   COMMENT '发送时间',  
    `type_send_at` bigint(20) NOT NULL   COMMENT '类型发送时间',  
    `count` int(11)    COMMENT '发送次数',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `city`
-- ----------------------------
-- DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(100) NOT NULL   COMMENT '城市名',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '手机号',  
    `pwd` varchar(300) NOT NULL   COMMENT '密码',  
    `status` int(2)    COMMENT '账户状态(0:正常,1:冻结)',  
    `token` varchar(300)    COMMENT '令牌',  
    `cid` bigint(20)    COMMENT '城市ID',  
    `last_time` bigint(20)    COMMENT '上次登录时间',  
    `type` int(2) NOT NULL   COMMENT '登录客户端类型(0:患者端,1:医师端)',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `equipment`
-- ----------------------------
-- DROP TABLE IF EXISTS `equipment`;
CREATE TABLE `equipment` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `model` varchar(100)    COMMENT '机型',  
    `version` varchar(100)    COMMENT '版本号',  
    `os` varchar(50)    COMMENT '操作系统',  
    `device_token` varchar(100)    COMMENT '安卓iOS设备唯一号',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `equipment_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `equipment_relation`;
CREATE TABLE `equipment_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20)    COMMENT '用户ID',  
    `eid` bigint(20)    COMMENT '设备ID',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `bank`
-- ----------------------------
-- DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100) NOT NULL   COMMENT '手机号',  
    `bank_code` varchar(200)    COMMENT '',  
    `bank_name` varchar(200)    COMMENT '银行名称',  
    `logo` varchar(200)    COMMENT 'logo',  
    `withdrawal_code` varchar(50)    COMMENT '撤销',  
    `pay_code` varchar(50)    COMMENT '支付',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `card`
-- ----------------------------
-- DROP TABLE IF EXISTS `card`;
CREATE TABLE `card` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20)    COMMENT '用户ID',  
    `bank_id` bigint(20)    COMMENT '银行卡ID',  
    `type` int(1)    COMMENT '',  
    `card_no` varchar(50)    COMMENT '银行卡号',  
    `mobile` varchar(30)    COMMENT '手机号',  
    `first` int(1)    COMMENT '第几张银行卡',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





